/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.draw9patch.ui;

import com.android.ide.eclipse.adt.AdtPlugin;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

public class StatusPanel
extends Composite
implements KeyListener {
    public static final int SCALE_MIN = 2;
    public static final int SCALE_MAX = 6;
    public static final int ZOOM_MIN = 100;
    public static final int ZOOM_MAX = 800;
    public static final int PADDING_TOP = 12;
    public static final int PADDING_RIGHT = 0;
    public static final int PADDING_BOTTOM = 5;
    public static final int PADDING_LEFT = 10;
    public static final int MIN_WIDTH = 800;
    private Button mShowLock = null;
    private Button mShowPatches = null;
    private Button mShowBadPatches = null;
    private Button mShowContent = null;
    private Label mHelpLabel = null;
    private Label mXPosLabel = null;
    private Label mYPosLabel = null;
    private ZoomControl mZoomControl = null;
    private ZoomControl mScaleControl = null;
    private StatusChangedListener mListener = null;

    public void setStatusChangedListener(StatusChangedListener l) {
        this.mListener = l;
    }

    public void setHelpText(String text) {
        Point size = this.getSize();
        if (800 < size.x) {
            this.mHelpLabel.setText(text);
            this.mHelpLabel.setVisible(true);
        } else {
            this.mHelpLabel.setText("N/A");
            this.mHelpLabel.setVisible(false);
        }
    }

    public void setPosition(int x, int y) {
        this.mXPosLabel.setText(String.format("X:  %4d px", x));
        this.mYPosLabel.setText(String.format("Y:  %4d px", y));
    }

    public StatusPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        Composite container = new Composite((Composite)this, 0);
        container.setLayout((Layout)new FormLayout());
        FormData innerForm = new FormData();
        innerForm.left = new FormAttachment(0, 10);
        innerForm.top = new FormAttachment(0, 12);
        innerForm.right = new FormAttachment(100, 0);
        innerForm.bottom = new FormAttachment(100, -5);
        container.setLayoutData((Object)innerForm);
        this.buildPosition(container);
        Composite zoomPanels = new Composite(container, 0);
        zoomPanels.setLayout((Layout)new GridLayout(3, false));
        this.buildZoomControl(zoomPanels);
        this.buildScaleControl(zoomPanels);
        Composite checkPanel = new Composite(container, 0);
        checkPanel.setLayout((Layout)new GridLayout(2, false));
        FormData checkPanelForm = new FormData();
        checkPanelForm.left = new FormAttachment((Control)zoomPanels, 0);
        checkPanelForm.bottom = new FormAttachment(100, -5);
        checkPanel.setLayoutData((Object)checkPanelForm);
        this.buildCheckboxes(checkPanel);
        this.mHelpLabel = new Label(container, 65);
        this.mHelpLabel.setBackground(new Color((Device)AdtPlugin.getDisplay(), 255, 255, 255));
        FormData hintForm = new FormData();
        hintForm.left = new FormAttachment((Control)checkPanel, 5);
        hintForm.right = new FormAttachment((Control)this.mXPosLabel, -10);
        hintForm.top = new FormAttachment(12);
        hintForm.bottom = new FormAttachment(100, -5);
        this.mHelpLabel.setLayoutData((Object)hintForm);
        container.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent event) {
                StatusPanel.this.setHelpText("Press Shift to erase pixels. Press Control to draw layout bounds.");
            }

            public void controlMoved(ControlEvent event) {
            }
        });
    }

    private void buildPosition(Composite parent) {
        this.mXPosLabel = new Label(parent, 0);
        this.mYPosLabel = new Label(parent, 0);
        this.mXPosLabel.setText(String.format("X:  %4d px", 1000));
        this.mYPosLabel.setText(String.format("Y:  %4d px", 1000));
        FormData bottomRight = new FormData();
        bottomRight.bottom = new FormAttachment(100, 0);
        bottomRight.right = new FormAttachment(100, 0);
        this.mYPosLabel.setLayoutData((Object)bottomRight);
        FormData aboveYPosLabel = new FormData();
        aboveYPosLabel.bottom = new FormAttachment((Control)this.mYPosLabel);
        aboveYPosLabel.right = new FormAttachment(100, 0);
        this.mXPosLabel.setLayoutData((Object)aboveYPosLabel);
    }

    private void buildScaleControl(Composite parent) {
        this.mScaleControl = new ZoomControl(parent);
        this.mScaleControl.maxLabel.setText("6x");
        this.mScaleControl.minLabel.setText("2x");
        this.mScaleControl.scale.setMinimum(2);
        this.mScaleControl.scale.setMaximum(6);
        this.mScaleControl.scale.setSelection(2);
        this.mScaleControl.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                super.widgetSelected(event);
                if (StatusPanel.this.mListener != null) {
                    Scale scale = (Scale)event.widget;
                    StatusPanel.this.mListener.scaleChanged(scale.getSelection());
                }
            }
        });
    }

    private void buildZoomControl(Composite parent) {
        this.mZoomControl = new ZoomControl(parent);
        this.mZoomControl.maxLabel.setText("800%");
        this.mZoomControl.minLabel.setText("100%");
        this.mZoomControl.scale.setMinimum(100);
        this.mZoomControl.scale.setMaximum(700);
        this.mZoomControl.scale.setSelection(400);
        this.mZoomControl.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                super.widgetSelected(event);
                if (StatusPanel.this.mListener != null) {
                    Scale scale = (Scale)event.widget;
                    StatusPanel.this.mListener.zoomChanged(scale.getSelection() + 100);
                }
            }
        });
    }

    private void buildCheckboxes(Composite parent) {
        this.mShowLock = new Button(parent, 32);
        this.mShowLock.setText("show Lock");
        this.mShowLock.setSelection(true);
        this.mShowLock.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                super.widgetSelected(event);
                if (StatusPanel.this.mListener != null) {
                    StatusPanel.this.mListener.lockVisibilityChanged(StatusPanel.this.mShowLock.getSelection());
                }
            }
        });
        this.mShowPatches = new Button(parent, 32);
        this.mShowPatches.setText("show Patches");
        this.mShowPatches.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                super.widgetSelected(event);
                if (StatusPanel.this.mListener != null) {
                    StatusPanel.this.mListener.patchesVisibilityChanged(StatusPanel.this.mShowPatches.getSelection());
                }
            }
        });
        this.mShowBadPatches = new Button(parent, 32);
        this.mShowBadPatches.setText("show Bad patches");
        this.mShowBadPatches.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                super.widgetSelected(event);
                if (StatusPanel.this.mListener != null) {
                    StatusPanel.this.mListener.badPatchesVisibilityChanged(StatusPanel.this.mShowBadPatches.getSelection());
                }
            }
        });
        this.mShowContent = new Button(parent, 32);
        this.mShowContent.setText("show Contents");
        this.mShowContent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                super.widgetSelected(event);
                if (StatusPanel.this.mListener != null) {
                    StatusPanel.this.mListener.contentAreaVisibilityChanged(StatusPanel.this.mShowContent.getSelection());
                }
            }
        });
    }

    public void keyPressed(KeyEvent event) {
        switch (event.character) {
            case 'c': {
                this.mShowContent.setSelection(!this.mShowContent.getSelection());
                if (this.mListener == null) break;
                this.mListener.contentAreaVisibilityChanged(this.mShowContent.getSelection());
                break;
            }
            case 'l': {
                this.mShowLock.setSelection(!this.mShowLock.getSelection());
                if (this.mListener == null) break;
                this.mListener.lockVisibilityChanged(this.mShowLock.getSelection());
                break;
            }
            case 'p': {
                this.mShowPatches.setSelection(!this.mShowPatches.getSelection());
                if (this.mListener == null) break;
                this.mListener.patchesVisibilityChanged(this.mShowPatches.getSelection());
                break;
            }
            case 'b': {
                this.mShowBadPatches.setSelection(!this.mShowBadPatches.getSelection());
                if (this.mListener == null) break;
                this.mListener.badPatchesVisibilityChanged(this.mShowBadPatches.getSelection());
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public static interface StatusChangedListener {
        public void zoomChanged(int var1);

        public void scaleChanged(int var1);

        public void lockVisibilityChanged(boolean var1);

        public void patchesVisibilityChanged(boolean var1);

        public void badPatchesVisibilityChanged(boolean var1);

        public void contentAreaVisibilityChanged(boolean var1);
    }

    private static class ZoomControl {
        private Label minLabel;
        private Label maxLabel;
        Scale scale;

        public ZoomControl(Composite composite) {
            this.minLabel = new Label(composite, 131072);
            this.scale = new Scale(composite, 256);
            this.maxLabel = new Label(composite, 16384);
        }
    }
}

