/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.ui.ConfigurationSelector;
import com.android.resources.ResourceFolderType;
import com.android.sdkuilib.ui.GridDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class LayoutCreatorDialog
extends GridDialog {
    private ConfigurationSelector mSelector;
    private Composite mStatusComposite;
    private Label mStatusLabel;
    private Label mStatusImage;
    private final FolderConfiguration mConfig = new FolderConfiguration();
    private final String mFileName;

    public LayoutCreatorDialog(Shell parentShell, String fileName, FolderConfiguration config) {
        super(parentShell, 1, false);
        this.mFileName = fileName;
        this.mConfig.set(config);
    }

    public void createDialogContent(Composite parent) {
        new Label(parent, 0).setText(String.format("Configuration for the alternate version of %1$s", this.mFileName));
        this.mSelector = new ConfigurationSelector(parent, ConfigurationSelector.SelectorMode.CONFIG_ONLY);
        this.mSelector.setConfiguration(this.mConfig);
        this.mSelector.getConfiguration(this.mConfig);
        GridData gd = new GridData();
        gd.widthHint = 600;
        gd.heightHint = 250;
        this.mSelector.setLayoutData(gd);
        this.mSelector.setOnChangeListener(new Runnable(){

            @Override
            public void run() {
                ConfigurationSelector.ConfigurationState state = LayoutCreatorDialog.this.mSelector.getState();
                switch (state) {
                    case OK: {
                        LayoutCreatorDialog.this.mSelector.getConfiguration(LayoutCreatorDialog.this.mConfig);
                        LayoutCreatorDialog.this.resetStatus();
                        LayoutCreatorDialog.this.mStatusImage.setImage(null);
                        LayoutCreatorDialog.this.getButton(0).setEnabled(true);
                        break;
                    }
                    case INVALID_CONFIG: {
                        ResourceQualifier invalidQualifier = LayoutCreatorDialog.this.mSelector.getInvalidQualifier();
                        LayoutCreatorDialog.this.mStatusLabel.setText(String.format("Invalid Configuration: %1$s has no filter set.", invalidQualifier.getName()));
                        LayoutCreatorDialog.this.mStatusImage.setImage(IconFactory.getInstance().getIcon("warning"));
                        LayoutCreatorDialog.this.getButton(0).setEnabled(false);
                        break;
                    }
                    case REGION_WITHOUT_LANGUAGE: {
                        LayoutCreatorDialog.this.mStatusLabel.setText("The Region qualifier requires the Language qualifier.");
                        LayoutCreatorDialog.this.mStatusImage.setImage(IconFactory.getInstance().getIcon("warning"));
                        LayoutCreatorDialog.this.getButton(0).setEnabled(false);
                    }
                }
                LayoutCreatorDialog.this.mStatusComposite.layout();
            }
        });
        this.mStatusComposite = new Composite(parent, 0);
        this.mStatusComposite.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout(2, false);
        this.mStatusComposite.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mStatusImage = new Label(this.mStatusComposite, 0);
        this.mStatusLabel = new Label(this.mStatusComposite, 0);
        this.mStatusLabel.setLayoutData((Object)new GridData(768));
        this.resetStatus();
    }

    public void getConfiguration(FolderConfiguration config) {
        config.set(this.mConfig);
    }

    private void resetStatus() {
        String displayString = Dialog.shortenText((String)String.format("New File: res/%1$s/%2$s", this.mConfig.getFolderName(ResourceFolderType.LAYOUT), this.mFileName), (Control)this.mStatusLabel);
        this.mStatusLabel.setText(displayString);
    }
}

