/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.SdkConstants;
import com.android.annotations.Nullable;
import com.android.ide.common.api.Rect;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasTransform;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.Overlay;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SwtUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class ImageOverlay
extends Overlay
implements IImageFactory {
    private static final boolean PRESCALE = SdkConstants.CURRENT_PLATFORM == 1 && !Boolean.getBoolean("adt.noprescale");
    private Image mImage;
    private Image mPreScaledImage;
    private boolean mShowDropShadow;
    private SoftReference<BufferedImage> mAwtImage = new SoftReference<Object>(null);
    private BufferedImage mAwtImageStrongRef;
    private LayoutCanvas mCanvas;
    private CanvasTransform mVScale;
    private CanvasTransform mHScale;

    public ImageOverlay(LayoutCanvas canvas, CanvasTransform hScale, CanvasTransform vScale) {
        this.mCanvas = canvas;
        this.mHScale = hScale;
        this.mVScale = vScale;
    }

    @Override
    public void create(Device device) {
        super.create(device);
    }

    @Override
    public void dispose() {
        if (this.mImage != null) {
            this.mImage.dispose();
            this.mImage = null;
        }
        if (this.mPreScaledImage != null) {
            this.mPreScaledImage.dispose();
            this.mPreScaledImage = null;
        }
    }

    public synchronized Image setImage(BufferedImage awtImage, boolean isAlphaChannelImage) {
        this.mShowDropShadow = !isAlphaChannelImage;
        BufferedImage oldAwtImage = this.mAwtImage.get();
        if (awtImage != oldAwtImage || awtImage == null) {
            this.mAwtImage.clear();
            this.mAwtImageStrongRef = null;
            if (this.mImage != null) {
                this.mImage.dispose();
            }
            this.mImage = awtImage == null ? null : SwtUtils.convertToSwt((Device)this.mCanvas.getDisplay(), awtImage, isAlphaChannelImage, -1);
        } else {
            assert (awtImage instanceof SwtReadyBufferedImage);
            if (isAlphaChannelImage) {
                if (this.mImage != null) {
                    this.mImage.dispose();
                }
                this.mImage = SwtUtils.convertToSwt((Device)this.mCanvas.getDisplay(), awtImage, true, -1);
            } else {
                Image prev = this.mImage;
                this.mImage = ((SwtReadyBufferedImage)awtImage).getSwtImage();
                if (prev != this.mImage && prev != null) {
                    prev.dispose();
                }
            }
        }
        if (this.mPreScaledImage != null) {
            this.mPreScaledImage.dispose();
            this.mPreScaledImage = null;
        }
        return this.mImage;
    }

    public Image getImage() {
        return this.mImage;
    }

    @Nullable
    BufferedImage getAwtImage() {
        BufferedImage awtImage = this.mAwtImage.get();
        if (awtImage == null && this.mImage != null) {
            awtImage = SwtUtils.convertToAwt(this.mImage);
        }
        return awtImage;
    }

    public boolean getShowDropShadow() {
        return this.mShowDropShadow;
    }

    @Override
    public synchronized void paint(GC gc) {
        if (this.mImage != null) {
            boolean valid = this.mCanvas.getViewHierarchy().isValid();
            this.mCanvas.ensureZoomed();
            if (!valid) {
                this.gc_setAlpha(gc, 128);
            }
            CanvasTransform hi = this.mHScale;
            CanvasTransform vi = this.mVScale;
            BufferedImage awtImage = this.mAwtImage.get();
            if (PRESCALE && awtImage != null) {
                int imageWidth;
                int n = this.mPreScaledImage == null ? 0 : (imageWidth = this.mPreScaledImage.getImageData().width - (this.mShowDropShadow ? 20 : 0));
                if (this.mPreScaledImage == null || imageWidth != hi.getScaledImgSize()) {
                    BufferedImage scaledAwtImage;
                    double xScale = (double)hi.getScaledImgSize() / (double)awtImage.getWidth();
                    double yScale = (double)vi.getScaledImgSize() / (double)awtImage.getHeight();
                    if (xScale == 1.0 && yScale == 1.0) {
                        scaledAwtImage = awtImage;
                        if (this.mShowDropShadow) {
                            scaledAwtImage = ImageUtils.createRectangularDropShadow(awtImage);
                        }
                    } else if (this.mShowDropShadow) {
                        scaledAwtImage = ImageUtils.scale(awtImage, xScale, yScale, 20, 20);
                        ImageUtils.drawRectangleShadow(scaledAwtImage, 0, 0, scaledAwtImage.getWidth() - 20, scaledAwtImage.getHeight() - 20);
                    } else {
                        scaledAwtImage = ImageUtils.scale(awtImage, xScale, yScale);
                    }
                    if (this.mPreScaledImage != null && !this.mPreScaledImage.isDisposed()) {
                        this.mPreScaledImage.dispose();
                    }
                    this.mPreScaledImage = SwtUtils.convertToSwt((Device)this.mCanvas.getDisplay(), scaledAwtImage, true, -1);
                }
                if (this.mPreScaledImage != null) {
                    gc.drawImage(this.mPreScaledImage, hi.translate(0), vi.translate(0));
                }
                return;
            }
            int oldAlias = -2;
            if (hi.getScale() < 1.0) {
                oldAlias = this.gc_setAntialias(gc, 1);
            }
            int srcX = 0;
            int srcY = 0;
            int srcWidth = hi.getImgSize();
            int srcHeight = vi.getImgSize();
            int destX = hi.translate(0);
            int destY = vi.translate(0);
            int destWidth = hi.getScaledImgSize();
            int destHeight = vi.getScaledImgSize();
            gc.drawImage(this.mImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight);
            if (this.mShowDropShadow) {
                SwtUtils.drawRectangleShadow(gc, destX, destY, destWidth, destHeight);
            }
            if (oldAlias != -2) {
                this.gc_setAntialias(gc, oldAlias);
            }
            if (!valid) {
                this.gc_setAlpha(gc, 255);
            }
        }
    }

    private boolean gc_setAlpha(GC gc, int alpha) {
        try {
            gc.setAlpha(alpha);
            return true;
        }
        catch (SWTException sWTException) {
            return false;
        }
    }

    private int gc_setAntialias(GC gc, int alias) {
        try {
            int old = gc.getAntialias();
            gc.setAntialias(alias);
            return old;
        }
        catch (SWTException sWTException) {
            return -2;
        }
    }

    public BufferedImage getImage(int w, int h) {
        BufferedImage awtImage = this.mAwtImage.get();
        if (awtImage == null || awtImage.getWidth() != w || awtImage.getHeight() != h) {
            this.mAwtImage.clear();
            awtImage = SwtReadyBufferedImage.createImage(w, h, this.getDevice());
            this.mAwtImage = new SoftReference<BufferedImage>(awtImage);
            if (PRESCALE) {
                this.mAwtImageStrongRef = awtImage;
            }
        }
        return awtImage;
    }

    public Rect getImageBounds() {
        if (this.mImage == null) {
            return null;
        }
        return new Rect(0, 0, this.mImage.getImageData().width, this.mImage.getImageData().height);
    }

    private static final class SwtReadyBufferedImage
    extends BufferedImage {
        private final ImageData mImageData;
        private final Device mDevice;

        private SwtReadyBufferedImage(int width, int height, ImageData imageData, Device device) {
            super(width, height, 2);
            this.mImageData = imageData;
            this.mDevice = device;
        }

        private Image getSwtImage() {
            WritableRaster raster = this.getRaster();
            int[] imageDataBuffer = ((DataBufferInt)raster.getDataBuffer()).getData();
            this.mImageData.setPixels(0, 0, imageDataBuffer.length, imageDataBuffer, 0);
            return new Image(this.mDevice, this.mImageData);
        }

        private static SwtReadyBufferedImage createImage(int w, int h, Device device) {
            ImageData imageData = new ImageData(w, h, 32, new PaletteData(0xFF0000, 65280, 255));
            SwtReadyBufferedImage swtReadyImage = new SwtReadyBufferedImage(w, h, imageData, device);
            return swtReadyImage;
        }
    }
}

