/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.common.api.INode;
import com.android.ide.common.api.InsertType;
import com.android.ide.common.layout.BaseLayoutRule;
import com.android.ide.common.layout.GridLayoutRule;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DynamicContextMenu;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.IncludeFinder;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.MoveGesture;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.OutlineDragListener;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.OutlineDropListener;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionItem;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionManager;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SimpleElement;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SimpleXmlTransfer;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.NodeProxy;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.PropertySheetPage;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.wb.core.controls.SelfOrientingSashForm;
import org.eclipse.wb.internal.core.editor.structure.IPage;
import org.eclipse.wb.internal.core.editor.structure.PageSiteComposite;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OutlinePage
extends ContentOutlinePage
implements INullSelectionListener,
IPage {
    private static final String LABEL_SEPARATOR = " - ";
    private static final int LABEL_MAX_WIDTH = 50;
    private final GraphicalEditorPart mGraphicalEditorPart;
    private final RootWrapper mRootWrapper = new RootWrapper();
    private MenuManager mMenuManager;
    private Composite mControl;
    private PropertySheetPage mPropertySheet;
    private PageSiteComposite mPropertySheetComposite;
    private boolean mShowPropertySheet;
    private boolean mShowHeader;
    private boolean mIgnoreSelection;
    private boolean mActive = true;
    private final Action mTreeSelectAllAction = new Action(){

        public void run() {
            OutlinePage.this.getTreeViewer().getTree().selectAll();
            OutlinePage.this.fireSelectionChanged(OutlinePage.this.getSelection());
        }

        public String getId() {
            return ActionFactory.SELECT_ALL.getId();
        }
    };
    private Action mMoveUpAction = new Action("Move Up\t-", IconFactory.getInstance().getImageDescriptor("up")){

        public String getId() {
            return "adt.outline.moveup";
        }

        public boolean isEnabled() {
            return OutlinePage.this.canMove(false);
        }

        public void run() {
            OutlinePage.this.move(false);
        }
    };
    private Action mMoveDownAction = new Action("Move Down\t+", IconFactory.getInstance().getImageDescriptor("down")){

        public String getId() {
            return "adt.outline.movedown";
        }

        public boolean isEnabled() {
            return OutlinePage.this.canMove(true);
        }

        public void run() {
            OutlinePage.this.move(true);
        }
    };
    private boolean mPressInPropSheet;

    public OutlinePage(GraphicalEditorPart graphicalEditorPart) {
        this.mGraphicalEditorPart = graphicalEditorPart;
    }

    public Control getControl() {
        return this.mControl;
    }

    void setActive(boolean active) {
        if (active != this.mActive) {
            this.mActive = active;
            assert (this.mControl != null);
            if (active) {
                this.getSite().getPage().addSelectionListener((ISelectionListener)this);
                this.setModel(this.mGraphicalEditorPart.getCanvasControl().getViewHierarchy().getRoot());
            } else {
                this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
                this.mRootWrapper.setRoot(null);
                if (this.mPropertySheet != null) {
                    this.mPropertySheet.selectionChanged(null, (ISelection)TreeSelection.EMPTY);
                }
            }
        }
    }

    public void refreshIcons() {
        Tree tree;
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && (tree = treeViewer.getTree()) != null && !tree.isDisposed()) {
            treeViewer.refresh();
        }
    }

    public void setShowHeader(boolean show) {
        this.mShowHeader = show;
    }

    public void setShowPropertySheet(boolean show) {
        if (show != this.mShowPropertySheet) {
            this.mShowPropertySheet = show;
            if (this.mControl == null) {
                return;
            }
            if (show && this.mPropertySheet == null) {
                this.createPropertySheet();
            } else if (!show) {
                this.mPropertySheetComposite.dispose();
                this.mPropertySheetComposite = null;
                this.mPropertySheet.dispose();
                this.mPropertySheet = null;
            }
            this.mControl.layout();
        }
    }

    public void createControl(Composite parent) {
        this.mControl = new SelfOrientingSashForm(parent, 512);
        if (this.mShowHeader) {
            PageSiteComposite mOutlineComposite = new PageSiteComposite(this.mControl, 2048);
            mOutlineComposite.setTitleText("Outline");
            mOutlineComposite.setTitleImage(IconFactory.getInstance().getIcon("components_view"));
            mOutlineComposite.setPage(new IPage(){

                public void createControl(Composite outlineParent) {
                    OutlinePage.this.createOutline(outlineParent);
                }

                public void dispose() {
                }

                public Control getControl() {
                    return OutlinePage.this.getTreeViewer().getTree();
                }

                public void setToolBar(IToolBarManager toolBarManager) {
                    OutlinePage.this.makeContributions(null, toolBarManager, null);
                    toolBarManager.update(false);
                }

                public void setFocus() {
                    this.getControl().setFocus();
                }
            });
        } else {
            this.createOutline(this.mControl);
        }
        if (this.mShowPropertySheet) {
            this.createPropertySheet();
        }
    }

    private void createOutline(Composite parent) {
        if (AdtUtils.isEclipse4()) {
            Text text = new Text(parent, 0){

                public boolean setFocus() {
                    return true;
                }

                protected void checkSubclass() {
                }
            };
            text.setVisible(false);
        }
        super.createControl(parent);
        TreeViewer tv = this.getTreeViewer();
        tv.setAutoExpandLevel(2);
        tv.setContentProvider((IContentProvider)new ContentProvider());
        tv.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        tv.setInput((Object)this.mRootWrapper);
        tv.expandToLevel((Object)this.mRootWrapper.getRoot(), 2);
        int supportedOperations = 3;
        Transfer[] transfers = new Transfer[]{SimpleXmlTransfer.getInstance()};
        tv.addDropSupport(supportedOperations, transfers, (DropTargetListener)new OutlineDropListener(this, tv));
        tv.addDragSupport(supportedOperations, transfers, (DragSourceListener)new OutlineDragListener(this, tv));
        tv.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                UiViewElementNode key;
                if (element instanceof CanvasViewInfo && (key = ((CanvasViewInfo)element).getUiViewNode()) != null) {
                    return key.hashCode();
                }
                if (element != null) {
                    return element.hashCode();
                }
                return 0;
            }

            public boolean equals(Object a, Object b) {
                if (a instanceof CanvasViewInfo && b instanceof CanvasViewInfo) {
                    UiViewElementNode keyA = ((CanvasViewInfo)a).getUiViewNode();
                    UiViewElementNode keyB = ((CanvasViewInfo)b).getUiViewNode();
                    if (keyA != null) {
                        return keyA.equals(keyB);
                    }
                }
                if (a != null) {
                    return a.equals(b);
                }
                return false;
            }
        });
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CanvasViewInfo vi;
                TreeItem[] selection = OutlinePage.this.getTreeViewer().getTree().getSelection();
                if (selection.length > 0 && (vi = OutlinePage.getViewInfo(selection[0].getData())) != null) {
                    LayoutCanvas canvas = OutlinePage.this.mGraphicalEditorPart.getCanvasControl();
                    canvas.show(vi);
                }
            }
        });
        this.setupContextMenu();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OutlinePage.this.dispose();
            }
        });
        Tree tree = tv.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '-') {
                    if (OutlinePage.this.mMoveUpAction.isEnabled()) {
                        OutlinePage.this.mMoveUpAction.run();
                    }
                } else if (e.character == '+' && OutlinePage.this.mMoveDownAction.isEnabled()) {
                    OutlinePage.this.mMoveDownAction.run();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.setupTooltip();
    }

    private void createPropertySheet() {
        this.mPropertySheetComposite = new PageSiteComposite(this.mControl, 2048);
        this.mPropertySheetComposite.setTitleText("Properties");
        this.mPropertySheetComposite.setTitleImage(IconFactory.getInstance().getIcon("properties_view"));
        this.mPropertySheet = new PropertySheetPage(this.mGraphicalEditorPart);
        this.mPropertySheetComposite.setPage((IPage)this.mPropertySheet);
        if (AdtUtils.isEclipse4()) {
            this.mPropertySheet.getControl().addMouseListener(new MouseListener(){

                public void mouseDown(MouseEvent e) {
                    OutlinePage.this.mPressInPropSheet = true;
                }

                public void mouseUp(MouseEvent e) {
                    OutlinePage.this.mPressInPropSheet = false;
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
        }
    }

    public void setFocus() {
        if (!this.mPressInPropSheet) {
            super.setFocus();
        }
    }

    public void dispose() {
        this.mRootWrapper.setRoot(null);
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
        if (this.mPropertySheet != null) {
            this.mPropertySheet.dispose();
            this.mPropertySheet = null;
        }
    }

    public void setModel(CanvasViewInfo rootViewInfo) {
        if (!this.mActive) {
            return;
        }
        this.mRootWrapper.setRoot(rootViewInfo);
        TreeViewer tv = this.getTreeViewer();
        if (tv != null && !tv.getTree().isDisposed()) {
            Object[] expanded = tv.getExpandedElements();
            tv.refresh();
            tv.setExpandedElements(expanded);
            tv.expandToLevel((Object)rootViewInfo, 2);
        }
    }

    public ISelection getSelection() {
        return super.getSelection();
    }

    public void setSelection(ISelection selection) {
        if (selection == null) {
            selection = TreeSelection.EMPTY;
        }
        if (selection.equals(TreeSelection.EMPTY)) {
            return;
        }
        super.setSelection(selection);
        TreeViewer tv = this.getTreeViewer();
        if (tv == null || !(selection instanceof ITreeSelection) || selection.isEmpty()) {
            return;
        }
        ITreeSelection treeSel = (ITreeSelection)selection;
        TreePath[] treePathArray = treeSel.getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath p = treePathArray[n2];
            tv.expandToLevel((Object)p, 1);
            ++n2;
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        super.fireSelectionChanged(selection);
        if (this.mPropertySheet != null && !this.mIgnoreSelection) {
            this.mPropertySheet.selectionChanged(null, selection);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        LayoutEditorDelegate delegate;
        if (this.mIgnoreSelection) {
            return;
        }
        if (part instanceof IEditorPart && (delegate = LayoutEditorDelegate.fromEditor((IEditorPart)part)) != null) {
            try {
                this.mIgnoreSelection = true;
                this.setSelection(selection);
                if (this.mPropertySheet != null) {
                    this.mPropertySheet.selectionChanged(part, selection);
                }
            }
            finally {
                this.mIgnoreSelection = false;
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.mIgnoreSelection) {
            super.selectionChanged(event);
        }
    }

    static CanvasViewInfo getViewInfo(Object viewData) {
        if (viewData instanceof RootWrapper) {
            return ((RootWrapper)viewData).getRoot();
        }
        if (viewData instanceof CanvasViewInfo) {
            return (CanvasViewInfo)viewData;
        }
        return null;
    }

    private void setupContextMenu() {
        this.mMenuManager = new MenuManager();
        this.mMenuManager.removeAll();
        this.mMenuManager.add((IAction)this.mMoveUpAction);
        this.mMenuManager.add((IAction)this.mMoveDownAction);
        this.mMenuManager.add((IContributionItem)new Separator());
        this.mMenuManager.add((IAction)new SelectionManager.SelectionMenu(this.mGraphicalEditorPart));
        this.mMenuManager.add((IContributionItem)new Separator());
        this.mMenuManager.add((IAction)new DelegateAction("canvas_action_" + ActionFactory.CUT.getId()));
        this.mMenuManager.add((IAction)new DelegateAction("canvas_action_" + ActionFactory.COPY.getId()));
        this.mMenuManager.add((IAction)new DelegateAction("canvas_action_" + ActionFactory.PASTE.getId()));
        this.mMenuManager.add((IContributionItem)new Separator());
        this.mMenuManager.add((IAction)new DelegateAction("canvas_action_" + ActionFactory.DELETE.getId()));
        this.mMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] iContributionItemArray = manager.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction action;
                    IContributionItem contrib = iContributionItemArray[n2];
                    if (contrib instanceof ActionContributionItem && (action = ((ActionContributionItem)contrib).getAction()) instanceof DelegateAction) {
                        ((DelegateAction)action).updateFromEditorPart(OutlinePage.this.mGraphicalEditorPart);
                    }
                    ++n2;
                }
            }
        });
        new DynamicContextMenu(this.mGraphicalEditorPart.getEditorDelegate(), this.mGraphicalEditorPart.getCanvasControl(), this.mMenuManager);
        this.getTreeViewer().getTree().setMenu(this.mMenuManager.createContextMenu(this.getControl()));
        this.getTreeViewer().getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                OutlinePage.this.mMenuManager.update("enabled");
            }
        });
    }

    GraphicalEditorPart getEditor() {
        return this.mGraphicalEditorPart;
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        LayoutCanvas canvas = this.mGraphicalEditorPart.getCanvasControl();
        canvas.updateGlobalActions(actionBars);
        actionBars.setGlobalActionHandler(this.mTreeSelectAllAction.getId(), (IAction)this.mTreeSelectAllAction);
        actionBars.updateActionBars();
    }

    private boolean canMove(boolean forward) {
        CanvasViewInfo viewInfo = this.getSingleSelectedItem();
        if (viewInfo != null) {
            UiViewElementNode node = viewInfo.getUiViewNode();
            if (forward) {
                return OutlinePage.findNext(node) != null;
            }
            return OutlinePage.findPrevious(node) != null;
        }
        return false;
    }

    private void move(boolean forward) {
        CanvasViewInfo viewInfo = this.getSingleSelectedItem();
        if (viewInfo != null) {
            UiViewElementNode selected = viewInfo.getUiViewNode();
            final Pair<UiViewElementNode, Integer> target = forward ? OutlinePage.findNext(selected) : OutlinePage.findPrevious(selected);
            if (target != null) {
                final LayoutCanvas canvas = this.mGraphicalEditorPart.getCanvasControl();
                SelectionManager selectionManager = canvas.getSelectionManager();
                final ArrayList<SelectionItem> dragSelection = new ArrayList<SelectionItem>();
                dragSelection.add(selectionManager.createSelection(viewInfo));
                SelectionManager.sanitize(dragSelection);
                if (!dragSelection.isEmpty()) {
                    final SimpleElement[] elements = SelectionItem.getAsElements(dragSelection);
                    UiViewElementNode parentNode = (UiViewElementNode)target.getFirst();
                    final NodeProxy targetNode = canvas.getNodeFactory().create(parentNode);
                    HashSet<INode> children = new HashSet<INode>();
                    INode[] iNodeArray = targetNode.getChildren();
                    int n = iNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        INode node = iNodeArray[n2];
                        children.add(node);
                        ++n2;
                    }
                    String label = MoveGesture.computeUndoLabel(targetNode, elements, 2);
                    canvas.getEditorDelegate().getEditor().wrapUndoEditXmlModel(label, new Runnable(){

                        @Override
                        public void run() {
                            InsertType insertType = InsertType.MOVE_INTO;
                            if (((SelectionItem)dragSelection.get(0)).getNode().getParent() == targetNode) {
                                insertType = InsertType.MOVE_WITHIN;
                            }
                            canvas.getRulesEngine().setInsertType(insertType);
                            int index = (Integer)target.getSecond();
                            BaseLayoutRule.insertAt(targetNode, elements, false, index);
                            targetNode.applyPendingChanges();
                            canvas.getClipboardSupport().deleteSelection("Remove", dragSelection);
                        }
                    });
                    ArrayList<INode> added = new ArrayList<INode>();
                    INode[] iNodeArray2 = targetNode.getChildren();
                    int n3 = iNodeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        INode node = iNodeArray2[n4];
                        if (!children.contains(node)) {
                            added.add(node);
                        }
                        ++n4;
                    }
                    selectionManager.setOutlineSelection(added);
                }
            }
        }
    }

    private CanvasViewInfo getSingleSelectedItem() {
        TreeItem[] selection = this.getTreeViewer().getTree().getSelection();
        if (selection.length == 1) {
            return OutlinePage.getViewInfo(selection[0].getData());
        }
        return null;
    }

    static Pair<UiViewElementNode, Integer> findNext(UiViewElementNode node) {
        UiElementNode parent = node.getUiParent();
        if (parent == null) {
            return null;
        }
        UiElementNode next = node.getUiNextSibling();
        if (next != null) {
            if (DescriptorsUtils.canInsertChildren(next.getDescriptor(), null)) {
                return OutlinePage.getFirstPosition(next);
            }
            return OutlinePage.getPositionAfter(next);
        }
        next = parent.getUiNextSibling();
        if (next != null) {
            return OutlinePage.getPositionBefore(next);
        }
        UiElementNode grandParent = parent.getUiParent();
        if (grandParent != null) {
            return OutlinePage.getLastPosition(grandParent);
        }
        return null;
    }

    static Pair<UiViewElementNode, Integer> findPrevious(UiViewElementNode node) {
        UiElementNode prev = node.getUiPreviousSibling();
        if (prev != null) {
            List<UiElementNode> children;
            UiElementNode curr = prev;
            while ((children = curr.getUiChildren()).size() > 0) {
                curr = children.get(children.size() - 1);
            }
            if (DescriptorsUtils.canInsertChildren(curr.getDescriptor(), null)) {
                return OutlinePage.getFirstPosition(curr);
            }
            if (curr == prev) {
                return OutlinePage.getPositionBefore(curr);
            }
            return OutlinePage.getPositionAfter(curr);
        }
        return OutlinePage.getPositionBefore(node.getUiParent());
    }

    private static Pair<UiViewElementNode, Integer> getPositionBefore(UiElementNode node) {
        UiElementNode parent;
        if (node != null && (parent = node.getUiParent()) != null && parent instanceof UiViewElementNode) {
            return Pair.of((Object)((UiViewElementNode)parent), (Object)node.getUiSiblingIndex());
        }
        return null;
    }

    private static Pair<UiViewElementNode, Integer> getPositionAfter(UiElementNode node) {
        UiElementNode parent;
        if (node != null && (parent = node.getUiParent()) != null && parent instanceof UiViewElementNode) {
            return Pair.of((Object)((UiViewElementNode)parent), (Object)(node.getUiSiblingIndex() + 1));
        }
        return null;
    }

    private static Pair<UiViewElementNode, Integer> getFirstPosition(UiElementNode parent) {
        if (parent != null && parent instanceof UiViewElementNode) {
            return Pair.of((Object)((UiViewElementNode)parent), (Object)0);
        }
        return null;
    }

    private static Pair<UiViewElementNode, Integer> getLastPosition(UiElementNode parent) {
        if (parent != null && parent instanceof UiViewElementNode) {
            return Pair.of((Object)((UiViewElementNode)parent), (Object)parent.getUiChildren().size());
        }
        return null;
    }

    private static String truncate(String text, StyledString string) {
        int existingLength = string.length();
        if (text.length() + existingLength > 50) {
            int truncatedLength = 50 - existingLength - 3;
            if (truncatedLength > 0) {
                return String.format("%1$s...", text.substring(0, truncatedLength));
            }
            return "";
        }
        return text;
    }

    public void setToolBar(IToolBarManager toolBarManager) {
        this.makeContributions(null, toolBarManager, null);
        toolBarManager.update(false);
    }

    private void setupTooltip() {
        final Tree tree = this.getTreeViewer().getTree();
        Listener listener = new Listener(){
            Shell mTip = null;
            Label mLabel = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 12: {
                        if (this.mTip == null) break;
                        this.mTip.dispose();
                        this.mTip = null;
                        this.mLabel = null;
                        break;
                    }
                    case 32: {
                        CanvasViewInfo vi;
                        LayoutEditorDelegate editor;
                        IMarker marker;
                        if (this.mTip != null) {
                            this.mTip.dispose();
                            this.mTip = null;
                            this.mLabel = null;
                        }
                        String tooltip = null;
                        TreeItem item = tree.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        Rectangle rect = item.getBounds(0);
                        if (event.x - rect.x > 16) {
                            return;
                        }
                        Object data = item.getData();
                        if (data != null && data instanceof CanvasViewInfo && (marker = (editor = OutlinePage.this.mGraphicalEditorPart.getEditorDelegate()).getIssueForNode((vi = (CanvasViewInfo)data).getUiViewNode())) != null) {
                            tooltip = marker.getAttribute("message", null);
                        }
                        if (tooltip == null) break;
                        Shell shell = tree.getShell();
                        Display display = tree.getDisplay();
                        Color fg = display.getSystemColor(28);
                        Color bg = display.getSystemColor(29);
                        this.mTip = new Shell(shell, 540676);
                        this.mTip.setBackground(bg);
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 1;
                        layout.marginHeight = 1;
                        this.mTip.setLayout((Layout)layout);
                        this.mLabel = new Label((Composite)this.mTip, 64);
                        this.mLabel.setForeground(fg);
                        this.mLabel.setBackground(bg);
                        this.mLabel.setText(tooltip);
                        this.mLabel.addListener(7, (Listener)this);
                        this.mLabel.addListener(3, (Listener)this);
                        Point pt = tree.toDisplay(rect.x, rect.y + rect.height);
                        Rectangle displayBounds = display.getBounds();
                        int availableWidth = displayBounds.x + displayBounds.width - pt.x - 10;
                        if (availableWidth < 80) {
                            availableWidth = 80;
                        }
                        Point size = this.mTip.computeSize(-1, -1);
                        if (size.x > availableWidth) {
                            size = this.mTip.computeSize(availableWidth, -1);
                        }
                        this.mTip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.mTip.setVisible(true);
                    }
                }
            }
        };
        tree.addListener(12, listener);
        tree.addListener(1, listener);
        tree.addListener(5, listener);
        tree.addListener(32, listener);
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object element) {
            List<CanvasViewInfo> children;
            CanvasViewInfo root;
            if (element instanceof RootWrapper && (root = ((RootWrapper)element).getRoot()) != null) {
                return new Object[]{root};
            }
            if (element instanceof CanvasViewInfo && (children = ((CanvasViewInfo)element).getUniqueChildren()) != null) {
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof CanvasViewInfo) {
                return ((CanvasViewInfo)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            List<CanvasViewInfo> children;
            if (element instanceof CanvasViewInfo && (children = ((CanvasViewInfo)element).getChildren()) != null) {
                return children.size() > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class DelegateAction
    extends Action {
        private IAction mTargetAction;
        private final String mCanvasActionId;

        public DelegateAction(String canvasActionId) {
            super(canvasActionId);
            this.setId(canvasActionId);
            this.mCanvasActionId = canvasActionId;
        }

        public boolean isEnabled() {
            return this.mTargetAction == null ? false : this.mTargetAction.isEnabled();
        }

        public boolean isChecked() {
            return this.mTargetAction == null ? false : this.mTargetAction.isChecked();
        }

        public boolean isHandled() {
            return this.mTargetAction == null ? false : this.mTargetAction.isHandled();
        }

        public void run() {
            if (this.mTargetAction != null) {
                this.mTargetAction.run();
            }
            super.run();
        }

        public void updateFromEditorPart(GraphicalEditorPart editorPart) {
            LayoutCanvas canvas = editorPart == null ? null : editorPart.getCanvasControl();
            this.mTargetAction = canvas == null ? null : canvas.getAction(this.mCanvasActionId);
            if (this.mTargetAction != null) {
                this.setText(this.mTargetAction.getText());
                this.setId(this.mTargetAction.getId());
                this.setDescription(this.mTargetAction.getDescription());
                this.setImageDescriptor(this.mTargetAction.getImageDescriptor());
                this.setHoverImageDescriptor(this.mTargetAction.getHoverImageDescriptor());
                this.setDisabledImageDescriptor(this.mTargetAction.getDisabledImageDescriptor());
                this.setToolTipText(this.mTargetAction.getToolTipText());
                this.setActionDefinitionId(this.mTargetAction.getActionDefinitionId());
                this.setHelpListener(this.mTargetAction.getHelpListener());
                this.setAccelerator(this.mTargetAction.getAccelerator());
                this.setChecked(this.mTargetAction.isChecked());
                this.setEnabled(this.mTargetAction.isEnabled());
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class LabelProvider
    extends StyledCellLabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof CanvasViewInfo) {
                element = ((CanvasViewInfo)element).getUiViewNode();
            }
            if (element instanceof UiViewElementNode) {
                UiViewElementNode v = (UiViewElementNode)element;
                return v.getIcon();
            }
            return AdtPlugin.getAndroidLogo();
        }

        public void update(ViewerCell cell) {
            IncludeFinder.Reference includedWithin;
            Object element = cell.getElement();
            StyledString styledString = null;
            CanvasViewInfo vi = null;
            if (element instanceof CanvasViewInfo) {
                vi = (CanvasViewInfo)element;
                element = vi.getUiViewNode();
            }
            Image image = this.getImage(element);
            if (element instanceof UiElementNode) {
                UiElementNode node = (UiElementNode)element;
                styledString = node.getStyledDescription();
                Node xmlNode = node.getXmlNode();
                if (xmlNode instanceof Element) {
                    String src;
                    Element e = (Element)xmlNode;
                    if (GridLayoutRule.sDebugGridLayout) {
                        String namespace;
                        if (e.getNodeName().equals("GridLayout") || e.getParentNode() != null && e.getParentNode().getNodeName().equals("GridLayout")) {
                            namespace = "http://schemas.android.com/apk/res/android";
                        } else {
                            IProject project = OutlinePage.this.mGraphicalEditorPart.getProject();
                            ProjectState projectState = Sdk.getProjectState(project);
                            if (projectState != null && projectState.isLibrary()) {
                                namespace = "http://schemas.android.com/apk/res-auto";
                            } else {
                                ManifestInfo info = ManifestInfo.get(project);
                                namespace = "http://schemas.android.com/apk/res/" + info.getPackage();
                            }
                        }
                        if (e.getNodeName() != null && e.getNodeName().endsWith("GridLayout")) {
                            String columnCount;
                            String rowCount = e.getAttributeNS(namespace, "rowCount");
                            if (rowCount.length() == 0) {
                                rowCount = "?";
                            }
                            if ((columnCount = e.getAttributeNS(namespace, "columnCount")).length() == 0) {
                                columnCount = "?";
                            }
                            styledString.append(" - columnCount=", StyledString.QUALIFIER_STYLER);
                            styledString.append(columnCount, StyledString.QUALIFIER_STYLER);
                            styledString.append(", rowCount=", StyledString.QUALIFIER_STYLER);
                            styledString.append(rowCount, StyledString.QUALIFIER_STYLER);
                        } else if (e.getParentNode() != null && e.getParentNode().getNodeName() != null && e.getParentNode().getNodeName().endsWith("GridLayout")) {
                            String row = e.getAttributeNS(namespace, "layout_row");
                            if (row.length() == 0) {
                                row = "?";
                            }
                            StyledString.Styler colStyle = StyledString.QUALIFIER_STYLER;
                            String column = e.getAttributeNS(namespace, "layout_column");
                            if (column.length() == 0) {
                                column = "?";
                            } else {
                                String colCount = ((Element)e.getParentNode()).getAttributeNS(namespace, "columnCount");
                                if (colCount.length() > 0 && Integer.parseInt(colCount) <= Integer.parseInt(column)) {
                                    colStyle = StyledString.createColorRegistryStyler((String)"ERROR_COLOR", null);
                                }
                            }
                            String rowSpan = e.getAttributeNS(namespace, "layout_rowSpan");
                            String columnSpan = e.getAttributeNS(namespace, "layout_columnSpan");
                            if (rowSpan.length() == 0) {
                                rowSpan = "1";
                            }
                            if (columnSpan.length() == 0) {
                                columnSpan = "1";
                            }
                            styledString.append(" - cell (row=", StyledString.QUALIFIER_STYLER);
                            styledString.append(row, StyledString.QUALIFIER_STYLER);
                            styledString.append(',', StyledString.QUALIFIER_STYLER);
                            styledString.append("col=", colStyle);
                            styledString.append(column, colStyle);
                            styledString.append(')', colStyle);
                            styledString.append(", span=(", StyledString.QUALIFIER_STYLER);
                            styledString.append(columnSpan, StyledString.QUALIFIER_STYLER);
                            styledString.append(',', StyledString.QUALIFIER_STYLER);
                            styledString.append(rowSpan, StyledString.QUALIFIER_STYLER);
                            styledString.append(')', StyledString.QUALIFIER_STYLER);
                            String gravity = e.getAttributeNS(namespace, "layout_gravity");
                            if (gravity != null && gravity.length() > 0) {
                                styledString.append(" : ", StyledString.COUNTER_STYLER);
                                styledString.append(gravity, StyledString.COUNTER_STYLER);
                            }
                        }
                    }
                    if (e.hasAttributeNS("http://schemas.android.com/apk/res/android", "text")) {
                        String text = e.getAttributeNS("http://schemas.android.com/apk/res/android", "text");
                        if (text != null && text.length() > 0 && !text.contains(node.getDescriptor().getUiName())) {
                            String resolved;
                            if (text.charAt(0) == '@' && (resolved = OutlinePage.this.mGraphicalEditorPart.findString(text)) != null) {
                                text = resolved;
                            }
                            if (styledString.length() < 50 - OutlinePage.LABEL_SEPARATOR.length() - 2) {
                                styledString.append(OutlinePage.LABEL_SEPARATOR, StyledString.QUALIFIER_STYLER);
                                styledString.append('\"', StyledString.QUALIFIER_STYLER);
                                styledString.append(OutlinePage.truncate(text, styledString), StyledString.QUALIFIER_STYLER);
                                styledString.append('\"', StyledString.QUALIFIER_STYLER);
                            }
                        }
                    } else if (e.hasAttributeNS("http://schemas.android.com/apk/res/android", "src")) {
                        src = e.getAttributeNS("http://schemas.android.com/apk/res/android", "src");
                        if (src != null && src.length() > 0) {
                            if (src.startsWith("@drawable/")) {
                                src = src.substring("@drawable/".length());
                            }
                            styledString.append(OutlinePage.LABEL_SEPARATOR, StyledString.QUALIFIER_STYLER);
                            styledString.append(OutlinePage.truncate(src, styledString), StyledString.QUALIFIER_STYLER);
                        }
                    } else if (e.getTagName().equals("include") && (src = e.getAttribute("layout")) != null && src.length() > 0) {
                        if (src.startsWith("@layout/")) {
                            src = src.substring("@layout/".length());
                        }
                        styledString.append(OutlinePage.LABEL_SEPARATOR, StyledString.QUALIFIER_STYLER);
                        styledString.append(OutlinePage.truncate(src, styledString), StyledString.QUALIFIER_STYLER);
                    }
                }
            } else if (element == null && vi != null && (includedWithin = OutlinePage.this.mGraphicalEditorPart.getIncludedWithin()) != null) {
                styledString = new StyledString();
                styledString.append(includedWithin.getDisplayName(), StyledString.QUALIFIER_STYLER);
                image = IconFactory.getInstance().getIcon("include");
            }
            if (styledString == null) {
                styledString = new StyledString();
                styledString.append(element == null ? "(null)" : element.toString());
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(image);
            super.update(cell);
        }

        public boolean isLabelProperty(Object element, String property) {
            return super.isLabelProperty(element, property);
        }
    }

    private static class RootWrapper {
        private CanvasViewInfo mRoot;

        private RootWrapper() {
        }

        public void setRoot(CanvasViewInfo root) {
            this.mRoot = root;
        }

        public CanvasViewInfo getRoot() {
            return this.mRoot;
        }
    }
}

