/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.common.api.InsertType;
import com.android.ide.common.api.Rect;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationChooser;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.CustomViewDescriptorService;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.AccordionControl;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CustomViewFinder;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GlobalCanvasDragInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageControl;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.PreviewIconFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.RenderService;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SimpleElement;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SimpleXmlTransfer;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SwtUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.NodeFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.NodeProxy;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.PaletteMetadataDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.ViewMetadataRepository;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.Pair;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.internal.core.editor.structure.IPage;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PaletteControl
extends Composite {
    private GraphicalEditorPart mEditor;
    private Color mBackground;
    private Color mForeground;
    private static final String VALUE_ALPHABETICAL = "alpha";
    private static final String VALUE_NO_CATEGORIES = "nocat";
    private static final String VALUE_NO_AUTOCLOSE = "noauto";
    private final PreviewIconFactory mPreviewIconFactory = new PreviewIconFactory(this);
    private PaletteMode mPaletteMode = null;
    private boolean mAlphabetical;
    private boolean mCategories = true;
    private boolean mAutoClose = true;
    private AccordionControl mAccordion;
    private String mCurrentTheme;
    private String mCurrentDevice;
    private IAndroidTarget mCurrentTarget;
    private AndroidTargetData mCurrentTargetData;

    public PaletteControl(Composite parent, GraphicalEditorPart editor) {
        super(parent, 0);
        this.mEditor = editor;
    }

    private void loadPaletteMode() {
        String paletteModes = AdtPrefs.getPrefs().getPaletteModes();
        if (paletteModes.length() > 0) {
            String[] tokens = paletteModes.split(",");
            try {
                this.mPaletteMode = PaletteMode.valueOf(tokens[0]);
            }
            catch (Throwable throwable) {
                this.mPaletteMode = PaletteMode.values()[0];
            }
            this.mAlphabetical = paletteModes.contains(VALUE_ALPHABETICAL);
            this.mCategories = !paletteModes.contains(VALUE_NO_CATEGORIES);
            this.mAutoClose = !paletteModes.contains(VALUE_NO_AUTOCLOSE);
        } else {
            this.mPaletteMode = PaletteMode.SMALL_PREVIEW;
        }
    }

    private boolean getSavedAutoCloseMode() {
        return !AdtPrefs.getPrefs().getPaletteModes().contains(VALUE_NO_AUTOCLOSE);
    }

    private void savePaletteMode() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.mPaletteMode);
        if (this.mAlphabetical) {
            sb.append(',').append(VALUE_ALPHABETICAL);
        }
        if (!this.mCategories) {
            sb.append(',').append(VALUE_NO_CATEGORIES);
        }
        if (!this.mAutoClose) {
            sb.append(',').append(VALUE_NO_AUTOCLOSE);
        }
        AdtPrefs.getPrefs().setPaletteModes(sb.toString());
    }

    private void refreshPalette() {
        IAndroidTarget oldTarget = this.mCurrentTarget;
        this.mCurrentTarget = null;
        this.mCurrentTargetData = null;
        this.mCurrentTheme = null;
        this.mCurrentDevice = null;
        this.reloadPalette(oldTarget);
    }

    protected void checkSubclass() {
    }

    public void dispose() {
        if (this.mBackground != null) {
            this.mBackground.dispose();
            this.mBackground = null;
        }
        if (this.mForeground != null) {
            this.mForeground.dispose();
            this.mForeground = null;
        }
        super.dispose();
    }

    public IAndroidTarget getCurrentTarget() {
        return this.mCurrentTarget;
    }

    public String getCurrentTheme() {
        return this.mCurrentTheme;
    }

    public String getCurrentDevice() {
        return this.mCurrentDevice;
    }

    private boolean previewsAvailable() {
        LayoutLibrary layoutLibrary = this.mEditor.getLayoutLibrary();
        return layoutLibrary != null && layoutLibrary.supports(Capability.CUSTOM_BACKGROUND_COLOR);
    }

    public void reloadPalette(IAndroidTarget target) {
        AndroidTargetData targetData;
        ConfigurationChooser configChooser = this.mEditor.getConfigurationChooser();
        String theme = configChooser.getThemeName();
        String device = configChooser.getDeviceName();
        if (device == null) {
            return;
        }
        AndroidTargetData androidTargetData = targetData = target != null ? Sdk.getCurrent().getTargetData(target) : null;
        if (target == this.mCurrentTarget && targetData == this.mCurrentTargetData && this.mCurrentTheme != null && this.mCurrentTheme.equals(theme) && this.mCurrentDevice != null && this.mCurrentDevice.equals(device)) {
            return;
        }
        this.mCurrentTheme = theme;
        this.mCurrentTarget = target;
        this.mCurrentTargetData = targetData;
        this.mCurrentDevice = device;
        this.mPreviewIconFactory.reset();
        if (targetData == null) {
            return;
        }
        Set<String> expandedCategories = null;
        if (this.mAccordion != null && (expandedCategories = this.mAccordion.getExpandedCategories()).size() > 3) {
            expandedCategories = null;
        }
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (this.mPaletteMode == null) {
            this.loadPaletteMode();
            assert (this.mPaletteMode != null);
        }
        if (!this.previewsAvailable() && this.mPaletteMode.isPreview()) {
            this.mPaletteMode = PaletteMode.ICON_TEXT;
        }
        if (this.mPaletteMode.isPreview()) {
            RGB foreground;
            RGB background;
            if (this.mForeground != null) {
                this.mForeground.dispose();
                this.mForeground = null;
            }
            if (this.mBackground != null) {
                this.mBackground.dispose();
                this.mBackground = null;
            }
            if ((background = this.mPreviewIconFactory.getBackgroundColor()) != null) {
                this.mBackground = new Color((Device)this.getDisplay(), background);
            }
            if ((foreground = this.mPreviewIconFactory.getForegroundColor()) != null) {
                this.mForeground = new Color((Device)this.getDisplay(), foreground);
            }
        }
        List headers = Collections.emptyList();
        final HashMap<String, List> categoryToItems = new HashMap<String, List>();
        headers = new ArrayList();
        List<Pair<String, List<ViewElementDescriptor>>> paletteEntries = ViewMetadataRepository.get().getPaletteEntries(targetData, this.mAlphabetical, this.mCategories);
        for (Pair<String, List<ViewElementDescriptor>> pair : paletteEntries) {
            String category = (String)pair.getFirst();
            List categoryItems = (List)pair.getSecond();
            headers.add(category);
            categoryToItems.put(category, categoryItems);
        }
        headers.add("Custom & Library Views");
        if (expandedCategories == null && headers.size() > 0 || headers.size() == 1 || expandedCategories != null && expandedCategories.size() >= 1 && !headers.contains(expandedCategories.iterator().next().replace("&&", "&"))) {
            expandedCategories = Collections.singleton((String)headers.get(0));
        }
        boolean wrap = this.mPaletteMode.getWrap();
        boolean fillVertical = this.mPaletteMode != PaletteMode.ICON_ONLY;
        this.mAccordion = new AccordionControl(this, 0, headers, fillVertical, wrap, expandedCategories){

            @Override
            protected Composite createChildContainer(Composite parent, Object header, int style) {
                Composite composite;
                if (!$assertionsDisabled && categoryToItems == null) {
                    throw new AssertionError();
                }
                List list = (List)categoryToItems.get(header);
                if (list == null) {
                    if (!$assertionsDisabled && !header.equals("Custom & Library Views")) {
                        throw new AssertionError();
                    }
                    Composite wrapper = new Composite(parent, 0);
                    GridLayout gridLayout = new GridLayout(1, false);
                    gridLayout.marginHeight = 0;
                    gridLayout.marginWidth = 0;
                    gridLayout.verticalSpacing = 0;
                    gridLayout.horizontalSpacing = 0;
                    gridLayout.marginBottom = 3;
                    wrapper.setLayout((Layout)gridLayout);
                    if (PaletteControl.this.mPaletteMode.isPreview() && PaletteControl.this.mBackground != null) {
                        wrapper.setBackground(PaletteControl.this.mBackground);
                    }
                    composite = super.createChildContainer(wrapper, header, style);
                    if (PaletteControl.this.mPaletteMode.isPreview() && PaletteControl.this.mBackground != null) {
                        composite.setBackground(PaletteControl.this.mBackground);
                    }
                    composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
                    Button refreshButton = new Button(wrapper, 0x800008);
                    refreshButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
                    refreshButton.setText("Refresh");
                    refreshButton.setImage(IconFactory.getInstance().getIcon("refresh"));
                    refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            CustomViewFinder finder = CustomViewFinder.get(PaletteControl.this.mEditor.getProject());
                            finder.refresh(new ViewFinderListener(composite));
                        }
                    });
                    wrapper.layout(true);
                } else {
                    composite = super.createChildContainer(parent, header, style);
                    if (PaletteControl.this.mPaletteMode.isPreview() && PaletteControl.this.mBackground != null) {
                        composite.setBackground(PaletteControl.this.mBackground);
                    }
                }
                PaletteControl.this.addMenu((Control)composite);
                return composite;
            }

            @Override
            protected void createChildren(Composite parent, Object header) {
                if (!$assertionsDisabled && categoryToItems == null) {
                    throw new AssertionError();
                }
                List list = (List)categoryToItems.get(header);
                if (list == null) {
                    if (!$assertionsDisabled && !header.equals("Custom & Library Views")) {
                        throw new AssertionError();
                    }
                    PaletteControl.this.addCustomItems(parent);
                    return;
                }
                for (ViewElementDescriptor desc : list) {
                    PaletteControl.this.createItem(parent, desc);
                }
            }
        };
        this.addMenu((Control)this.mAccordion);
        for (CLabel headerLabel : this.mAccordion.getHeaderLabels()) {
            this.addMenu((Control)headerLabel);
        }
        this.setLayout((Layout)new FillLayout());
        if (this.mPaletteMode == PaletteMode.ICON_ONLY) {
            this.mAccordion.expandAll(true);
            this.mAccordion.setAutoClose(false);
        } else {
            this.mAccordion.setAutoClose(this.getSavedAutoCloseMode());
        }
        this.layout(true);
    }

    protected void addCustomItems(Composite parent) {
        CustomViewFinder finder = CustomViewFinder.get(this.mEditor.getProject());
        Collection<String> allViews = finder.getAllViews();
        if (allViews == null) {
            finder.refresh(new ViewFinderListener(parent));
            return;
        }
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        for (final String fqcn : allViews) {
            Control item;
            CustomViewDescriptorService service = CustomViewDescriptorService.getInstance();
            ViewElementDescriptor desc = service.getDescriptor(this.mEditor.getProject(), fqcn);
            if (desc == null || !((item = this.createItem(parent, desc)) instanceof IconTextItem)) continue;
            IconTextItem it = (IconTextItem)item;
            it.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    AdtPlugin.openJavaClass(PaletteControl.this.mEditor.getProject(), fqcn);
                }

                public void mouseDown(MouseEvent e) {
                    if ((e.stateMask & SWT.MOD1) != 0) {
                        AdtPlugin.openJavaClass(PaletteControl.this.mEditor.getProject(), fqcn);
                    }
                }
            });
        }
    }

    GraphicalEditorPart getEditor() {
        return this.mEditor;
    }

    private Control createItem(Composite parent, ViewElementDescriptor desc) {
        MouseTrackListener item = null;
        switch (this.mPaletteMode) {
            case PREVIEW: 
            case SMALL_PREVIEW: 
            case TINY_PREVIEW: {
                ImageDescriptor descriptor = this.mPreviewIconFactory.getImageDescriptor(desc);
                if (descriptor != null) {
                    Image image = descriptor.createImage();
                    ImageControl imageControl = new ImageControl(parent, 0, image);
                    if (this.mPaletteMode.isScaledPreview()) {
                        float scale = 1.0f;
                        if (this.mPaletteMode == PaletteMode.SMALL_PREVIEW) {
                            scale = 0.75f;
                        } else if (this.mPaletteMode == PaletteMode.TINY_PREVIEW) {
                            scale = 0.5f;
                        }
                        ConfigurationChooser chooser = this.mEditor.getConfigurationChooser();
                        int dpi = chooser.getConfiguration().getDensity().getDpiValue();
                        while (dpi > 160) {
                            scale /= 2.0f;
                            dpi /= 2;
                        }
                        imageControl.setScale(scale);
                    }
                    imageControl.setHoverColor(this.getDisplay().getSystemColor(1));
                    if (this.mBackground != null) {
                        imageControl.setBackground(this.mBackground);
                    }
                    String toolTip = desc.getUiName();
                    imageControl.setToolTipText(toolTip);
                    item = imageControl;
                    break;
                }
                item = new IconTextItem(parent, desc);
                if (this.mForeground == null) break;
                item.setForeground(this.mForeground);
                item.setBackground(this.mBackground);
                break;
            }
            case ICON_TEXT: {
                item = new IconTextItem(parent, desc);
                break;
            }
            case ICON_ONLY: {
                item = new ImageControl(parent, 0, desc.getGenericIcon());
                item.setToolTipText(desc.getUiName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Not yet implemented");
            }
        }
        final DragSource source = new DragSource((Control)item, 1);
        source.setTransfer(new Transfer[]{SimpleXmlTransfer.getInstance()});
        source.addDragListener((DragSourceListener)new DescDragSourceListener(desc));
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                source.dispose();
            }
        });
        this.addMenu((Control)item);
        return item;
    }

    private void addMenu(Control control) {
        control.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                PaletteControl.this.showMenu(e.x, e.y);
            }
        });
    }

    private void showMenu(int x, int y) {
        MenuManager manager = new MenuManager(){

            public boolean isDynamic() {
                return true;
            }
        };
        boolean previews = this.previewsAvailable();
        PaletteMode[] paletteModeArray = PaletteMode.values();
        int n = paletteModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PaletteMode mode = paletteModeArray[n2];
            if (!mode.isPreview() || previews) {
                manager.add((IAction)new PaletteModeAction(mode));
            }
            ++n2;
        }
        if (this.mPaletteMode.isPreview()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new ToggleViewOptionAction("Refresh Previews", 4, false));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ToggleViewOptionAction("Show Categories", 1, this.mCategories));
        manager.add((IAction)new ToggleViewOptionAction("Sort Alphabetically", 2, this.mAlphabetical));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ToggleViewOptionAction("Auto Close Previous", 3, this.mAutoClose));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ToggleViewOptionAction("Reset", 5, false));
        Menu menu = manager.createContextMenu((Control)this);
        menu.setLocation(x, y);
        menu.setVisible(true);
    }

    private class DescDragSourceListener
    implements DragSourceListener {
        private final ViewElementDescriptor mDesc;
        private SimpleElement[] mElements;
        private static final int MAX_RENDER_HEIGHT = 400;
        private static final int MAX_RENDER_WIDTH = 500;
        private static final int IMG_ALPHA = 128;
        private Image mImage;
        private Rectangle mImageLayoutBounds;
        private int mBaseline = -1;
        private boolean mIsPlaceholder;

        public DescDragSourceListener(ViewElementDescriptor desc) {
            this.mDesc = desc;
        }

        public void dragStart(DragSourceEvent e) {
            Rect bounds = null;
            Rect dragBounds = null;
            this.createDragImage(e);
            if (this.mImage != null && !this.mIsPlaceholder) {
                int width = this.mImageLayoutBounds.width;
                int height = this.mImageLayoutBounds.height;
                assert (this.mImageLayoutBounds.x == 0);
                assert (this.mImageLayoutBounds.y == 0);
                bounds = new Rect(0, 0, width, height);
                double scale = PaletteControl.this.mEditor.getCanvasControl().getScale();
                int scaledWidth = (int)(scale * (double)width);
                int scaledHeight = (int)(scale * (double)height);
                int x = -scaledWidth / 2;
                int y = -scaledHeight / 2;
                dragBounds = new Rect(x, y, scaledWidth, scaledHeight);
            }
            SimpleElement se = new SimpleElement(SimpleXmlTransfer.getFqcn(this.mDesc), null, bounds, null);
            if (this.mDesc instanceof PaletteMetadataDescriptor) {
                PaletteMetadataDescriptor pm = (PaletteMetadataDescriptor)this.mDesc;
                pm.initializeNew(se);
            }
            this.mElements = new SimpleElement[]{se};
            GlobalCanvasDragInfo dragInfo = GlobalCanvasDragInfo.getInstance();
            dragInfo.startDrag(this.mElements, null, null, null);
            dragInfo.setDragBounds(dragBounds);
            dragInfo.setDragBaseline(this.mBaseline);
            e.doit = true;
        }

        public void dragSetData(DragSourceEvent e) {
            if (SimpleXmlTransfer.getInstance().isSupportedType(e.dataType)) {
                e.data = this.mElements;
            }
        }

        public void dragFinished(DragSourceEvent e) {
            GlobalCanvasDragInfo.getInstance().stopDrag();
            this.mElements = null;
            if (this.mImage != null) {
                this.mImage.dispose();
                this.mImage = null;
            }
        }

        private void createDragImage(DragSourceEvent event) {
            this.mBaseline = -1;
            Pair<Image, Rectangle> preview = this.renderPreview();
            if (preview != null) {
                this.mImage = (Image)preview.getFirst();
                this.mImageLayoutBounds = (Rectangle)preview.getSecond();
            } else {
                this.mImage = null;
                this.mImageLayoutBounds = null;
            }
            boolean bl = this.mIsPlaceholder = this.mImage == null;
            if (this.mIsPlaceholder) {
                Control control = ((DragSource)event.widget).getControl();
                GC gc = new GC((Drawable)control);
                Point size = control.getSize();
                Display display = PaletteControl.this.getDisplay();
                Image image = new Image((Device)display, size.x, size.y);
                gc.copyArea(image, 0, 0);
                gc.dispose();
                BufferedImage awtImage = SwtUtils.convertToAwt(image);
                if (awtImage != null) {
                    awtImage = ImageUtils.createDropShadow(awtImage, 3, 0.7f, 0);
                    this.mImage = SwtUtils.convertToSwt((Device)display, awtImage, true, 128);
                } else {
                    ImageData data = image.getImageData();
                    data.alpha = 128;
                    this.mImage = new Image((Device)display, data);
                }
                image.dispose();
            }
            event.image = this.mImage;
            if (!this.mIsPlaceholder) {
                double scale = PaletteControl.this.mEditor.getCanvasControl().getScale();
                event.offsetX = (int)(scale * (double)this.mImageLayoutBounds.width / 2.0);
                event.offsetY = (int)(scale * (double)this.mImageLayoutBounds.height / 2.0);
            }
        }

        private Pair<Image, Rectangle> renderPreview() {
            LayoutCanvas canvas;
            UiDocumentNode model;
            GraphicalEditorPart editor;
            block22: {
                ViewMetadataRepository repository = ViewMetadataRepository.get();
                ViewMetadataRepository.RenderMode renderMode = repository.getRenderMode(this.mDesc.getFullClassName());
                if (renderMode == ViewMetadataRepository.RenderMode.SKIP) {
                    return null;
                }
                Document document = DomUtilities.createEmptyDocument();
                editor = PaletteControl.this.getEditor();
                LayoutEditorDelegate layoutEditorDelegate = editor.getEditorDelegate();
                String viewName = this.mDesc.getXmlLocalName();
                Element element = document.createElement(viewName);
                Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:android");
                attr.setValue("http://schemas.android.com/apk/res/android");
                element.getAttributes().setNamedItemNS(attr);
                element.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
                element.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_height", "wrap_content");
                element.setAttributeNS("http://schemas.android.com/apk/res/android", "text", DescriptorsUtils.getBasename(this.mDesc.getUiName()));
                if (this.mDesc instanceof PaletteMetadataDescriptor) {
                    PaletteMetadataDescriptor pm = (PaletteMetadataDescriptor)this.mDesc;
                    pm.initializeNew(element);
                }
                document.appendChild(element);
                AndroidTargetData data = layoutEditorDelegate.getEditor().getTargetData();
                DocumentDescriptor documentDescriptor = data == null ? new DocumentDescriptor("temp", null) : data.getLayoutDescriptors().getDescriptor();
                model = (UiDocumentNode)documentDescriptor.createUiNode();
                model.setEditor(layoutEditorDelegate.getEditor());
                model.setUnknownDescriptorProvider(editor.getModel().getUnknownDescriptorProvider());
                model.loadFromXmlNode(document);
                canvas = editor.getCanvasControl();
                NodeFactory nodeFactory = canvas.getNodeFactory();
                UiElementNode parent = model.getUiRoot();
                UiElementNode child = parent.getUiChildren().get(0);
                if (child instanceof UiViewElementNode) {
                    UiViewElementNode childUiNode = (UiViewElementNode)child;
                    NodeProxy childNode = nodeFactory.create(childUiNode);
                    layoutEditorDelegate.getEditor().setIgnoreXmlUpdate(true);
                    try {
                        try {
                            canvas.getRulesEngine().callCreateHooks(layoutEditorDelegate.getEditor(), null, childNode, InsertType.CREATE_PREVIEW);
                            childNode.applyPendingChanges();
                        }
                        catch (Throwable t) {
                            AdtPlugin.log(t, "Failed calling creation hooks for widget %1$s", viewName);
                            layoutEditorDelegate.getEditor().setIgnoreXmlUpdate(false);
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        layoutEditorDelegate.getEditor().setIgnoreXmlUpdate(false);
                        throw throwable;
                    }
                    layoutEditorDelegate.getEditor().setIgnoreXmlUpdate(false);
                }
            }
            Integer overrideBgColor = null;
            boolean hasTransparency = false;
            LayoutLibrary layoutLibrary = editor.getLayoutLibrary();
            if (layoutLibrary != null && layoutLibrary.supports(Capability.CUSTOM_BACKGROUND_COLOR)) {
                overrideBgColor = new Integer(0xFF0000);
            }
            RenderSession session = null;
            try {
                LayoutLog silentLogger = new LayoutLog();
                session = RenderService.create(editor).setModel(model).setMaxRenderSize(500, 400).setLog(silentLogger).setOverrideBgColor(overrideBgColor).setDecorations(false).createRenderSession();
            }
            catch (Throwable throwable) {
                return null;
            }
            if (session != null) {
                BufferedImage image;
                if (session.getResult().isSuccess() && (image = session.getImage()) != null) {
                    BufferedImage cropped;
                    Rect initialCrop = null;
                    ViewInfo viewInfo = null;
                    List viewInfoList = session.getRootViews();
                    if (viewInfoList != null && viewInfoList.size() > 0) {
                        viewInfo = (ViewInfo)viewInfoList.get(0);
                        this.mBaseline = viewInfo.getBaseLine();
                    }
                    if (viewInfo != null) {
                        int x1 = viewInfo.getLeft();
                        int x2 = viewInfo.getRight();
                        int y2 = viewInfo.getBottom();
                        int y1 = viewInfo.getTop();
                        initialCrop = new Rect(x1, y1, x2 - x1, y2 - y1);
                    }
                    if (hasTransparency) {
                        cropped = ImageUtils.cropBlank(image, initialCrop);
                    } else {
                        int edgeX = image.getWidth() - 1;
                        int edgeY = image.getHeight() - 1;
                        if (viewInfo != null) {
                            if (viewInfo.getRight() < image.getWidth() - 1) {
                                edgeX = viewInfo.getRight() + 1;
                            }
                            if (viewInfo.getBottom() < image.getHeight() - 1) {
                                edgeY = viewInfo.getBottom() + 1;
                            }
                        }
                        int edgeColor = image.getRGB(edgeX, edgeY);
                        cropped = ImageUtils.cropColor(image, edgeColor, initialCrop);
                    }
                    if (cropped != null) {
                        int width = initialCrop != null ? initialCrop.w : cropped.getWidth();
                        int height = initialCrop != null ? initialCrop.h : cropped.getHeight();
                        boolean needsContrast = hasTransparency && !ImageUtils.containsDarkPixels(cropped);
                        cropped = ImageUtils.createDropShadow(cropped, hasTransparency ? 3 : 5, !hasTransparency ? 0.6f : (needsContrast ? 0.8f : 0.7f), 0);
                        double scale = canvas.getScale();
                        if (scale != 1.0) {
                            cropped = ImageUtils.scale(cropped, scale, scale);
                        }
                        Display display = PaletteControl.this.getDisplay();
                        int alpha = !hasTransparency || !needsContrast ? 128 : -1;
                        Image swtImage = SwtUtils.convertToSwt((Device)display, cropped, true, alpha);
                        Rectangle imageBounds = new Rectangle(0, 0, width, height);
                        return Pair.of((Object)swtImage, (Object)imageBounds);
                    }
                }
                session.dispose();
            }
            return null;
        }

        private void dumpDocument(Document document) {
        }
    }

    private static class IconTextItem
    extends CLabel
    implements MouseTrackListener {
        private boolean mMouseIn = false;

        public IconTextItem(Composite parent, ViewElementDescriptor desc) {
            super(parent, 0);
            this.setText(desc.getUiName());
            this.setImage(desc.getGenericIcon());
            this.setToolTipText(desc.getTooltip());
            this.addMouseTrackListener(this);
        }

        public int getStyle() {
            int style = super.getStyle();
            if (this.mMouseIn) {
                style |= 4;
            }
            return style;
        }

        public void mouseEnter(MouseEvent e) {
            if (!this.mMouseIn) {
                this.mMouseIn = true;
                this.redraw();
            }
        }

        public void mouseExit(MouseEvent e) {
            if (this.mMouseIn) {
                this.mMouseIn = false;
                this.redraw();
            }
        }

        public void mouseHover(MouseEvent e) {
        }
    }

    private static enum PaletteMode {
        PREVIEW("Show Previews", true),
        SMALL_PREVIEW("Show Small Previews", true),
        TINY_PREVIEW("Show Tiny Previews", true),
        ICON_TEXT("Show Icon and Text", false),
        ICON_ONLY("Show Only Icons", true);

        private final String mActionLabel;
        private final boolean mWrap;

        private PaletteMode(String actionLabel, boolean wrap) {
            this.mActionLabel = actionLabel;
            this.mWrap = wrap;
        }

        public String getActionLabel() {
            return this.mActionLabel;
        }

        public boolean getWrap() {
            return this.mWrap;
        }

        public boolean isPreview() {
            return this == PREVIEW || this == SMALL_PREVIEW || this == TINY_PREVIEW;
        }

        public boolean isScaledPreview() {
            return this == SMALL_PREVIEW || this == TINY_PREVIEW;
        }
    }

    private class PaletteModeAction
    extends Action {
        private final PaletteMode mMode;

        PaletteModeAction(PaletteMode mode) {
            super(mode.getActionLabel(), 8);
            this.mMode = mode;
            boolean selected = this.mMode == PaletteControl.this.mPaletteMode;
            this.setChecked(selected);
            this.setEnabled(!selected);
        }

        public void run() {
            if (this.isEnabled()) {
                PaletteControl.this.mPaletteMode = this.mMode;
                PaletteControl.this.refreshPalette();
                PaletteControl.this.savePaletteMode();
            }
        }
    }

    static class PalettePage
    implements IPage {
        private final GraphicalEditorPart mEditorPart;
        private PaletteControl mControl;

        PalettePage(GraphicalEditorPart editor) {
            this.mEditorPart = editor;
        }

        public void createControl(Composite parent) {
            this.mControl = new PaletteControl(parent, this.mEditorPart);
        }

        public Control getControl() {
            return this.mControl;
        }

        public void dispose() {
            this.mControl.dispose();
        }

        public void setToolBar(IToolBarManager toolBarManager) {
        }

        void createToolbarItems(final ToolBar toolbar) {
            final ToolItem popupMenuItem = new ToolItem(toolbar, 8);
            popupMenuItem.setToolTipText("View Menu");
            popupMenuItem.setImage(IconFactory.getInstance().getIcon("view_menu"));
            popupMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Rectangle bounds = popupMenuItem.getBounds();
                    Point point = toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
                    PalettePage.this.mControl.showMenu(point.x, point.y);
                }
            });
        }

        public void setFocus() {
            this.mControl.setFocus();
        }
    }

    private class ToggleViewOptionAction
    extends Action {
        private final int mAction;
        static final int TOGGLE_CATEGORY = 1;
        static final int TOGGLE_ALPHABETICAL = 2;
        static final int TOGGLE_AUTO_CLOSE = 3;
        static final int REFRESH = 4;
        static final int RESET = 5;

        ToggleViewOptionAction(String title, int action, boolean checked) {
            super(title, action == 4 || action == 5 ? 1 : 2);
            this.mAction = action;
            if (checked) {
                this.setChecked(checked);
            }
        }

        public void run() {
            switch (this.mAction) {
                case 1: {
                    PaletteControl.this.mCategories = !PaletteControl.this.mCategories;
                    PaletteControl.this.refreshPalette();
                    break;
                }
                case 2: {
                    PaletteControl.this.mAlphabetical = !PaletteControl.this.mAlphabetical;
                    PaletteControl.this.refreshPalette();
                    break;
                }
                case 3: {
                    PaletteControl.this.mAutoClose = !PaletteControl.this.mAutoClose;
                    PaletteControl.this.mAccordion.setAutoClose(PaletteControl.this.mAutoClose);
                    break;
                }
                case 4: {
                    PaletteControl.this.mPreviewIconFactory.refresh();
                    PaletteControl.this.refreshPalette();
                    break;
                }
                case 5: {
                    PaletteControl.this.mAlphabetical = false;
                    PaletteControl.this.mCategories = true;
                    PaletteControl.this.mAutoClose = true;
                    PaletteControl.this.mPaletteMode = PaletteMode.SMALL_PREVIEW;
                    PaletteControl.this.refreshPalette();
                }
            }
            PaletteControl.this.savePaletteMode();
        }
    }

    private final class ViewFinderListener
    implements CustomViewFinder.Listener {
        private final Composite mParent;

        private ViewFinderListener(Composite parent) {
            this.mParent = parent;
        }

        @Override
        public void viewsUpdated(Collection<String> customViews, Collection<String> thirdPartyViews) {
            PaletteControl.this.addCustomItems(this.mParent);
            this.mParent.layout(true);
        }
    }
}

