/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Configuration;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationChooser;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationDescription;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Locale;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.NestedConfiguration;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageOverlay;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.IncludeFinder;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.RenderLogger;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.RenderPreviewManager;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.RenderPreviewMode;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.RenderService;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SwtUtils;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.resources.ResourceHelper;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.io.IFileWrapper;
import com.android.io.IAbstractFile;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Screen;
import com.android.utils.SdkUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Document;

public class RenderPreview
implements IJobChangeListener {
    static final boolean LARGE_SHADOWS = false;
    private static final boolean RENDER_ASYNC = false;
    private static final int HEADER_HEIGHT = 20;
    private static final boolean DUMP_RENDER_DIAGNOSTICS = false;
    private static final boolean DEBUG = false;
    private static final Image EDIT_ICON;
    private static final Image ZOOM_IN_ICON;
    private static final Image ZOOM_OUT_ICON;
    private static final Image CLOSE_ICON;
    private static final int EDIT_ICON_WIDTH;
    private static final int ZOOM_IN_ICON_WIDTH;
    private static final int ZOOM_OUT_ICON_WIDTH;
    private static final int CLOSE_ICON_WIDTH;
    @NonNull
    private Configuration mConfiguration;
    @NonNull
    private Configuration mAlternateConfiguration;
    @NonNull
    private final RenderPreviewManager mManager;
    @NonNull
    private final LayoutCanvas mCanvas;
    @NonNull
    private SoftReference<ResourceResolver> mResourceResolver = new SoftReference<Object>(null);
    @Nullable
    private Job mJob;
    @Nullable
    private Image mThumbnail;
    @Nullable
    private String mDisplayName;
    private int mWidth;
    private int mHeight;
    private int mX;
    private int mY;
    private int mTitleHeight;
    private double mScale = 1.0;
    private double mAspectRatio;
    @Nullable
    private IFile mAlternateInput;
    @Nullable
    private IncludeFinder.Reference mIncludedWithin;
    private boolean mActive;
    private String mError;
    private boolean mVisible;
    private int mDirty;
    @Nullable
    private ConfigurationDescription mDescription;
    static Comparator<RenderPreview> INCREASING_ASPECT_RATIO;
    static Comparator<RenderPreview> VISUAL_ORDER;

    static {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        IconFactory icons = IconFactory.getInstance();
        CLOSE_ICON = sharedImages.getImage("IMG_ETOOL_DELETE");
        EDIT_ICON = icons.getIcon("editPreview");
        ZOOM_IN_ICON = icons.getIcon("zoomplus");
        ZOOM_OUT_ICON = icons.getIcon("zoomminus");
        CLOSE_ICON_WIDTH = RenderPreview.CLOSE_ICON.getImageData().width;
        EDIT_ICON_WIDTH = RenderPreview.EDIT_ICON.getImageData().width;
        ZOOM_IN_ICON_WIDTH = RenderPreview.ZOOM_IN_ICON.getImageData().width;
        ZOOM_OUT_ICON_WIDTH = RenderPreview.ZOOM_OUT_ICON.getImageData().width;
        INCREASING_ASPECT_RATIO = new Comparator<RenderPreview>(){

            @Override
            public int compare(RenderPreview preview1, RenderPreview preview2) {
                return (int)Math.signum(preview1.mAspectRatio - preview2.mAspectRatio);
            }
        };
        VISUAL_ORDER = new Comparator<RenderPreview>(){

            @Override
            public int compare(RenderPreview preview1, RenderPreview preview2) {
                int delta = preview1.mY - preview2.mY;
                if (delta == 0) {
                    delta = preview1.mX - preview2.mX;
                }
                return delta;
            }
        };
    }

    private RenderPreview(@NonNull RenderPreviewManager manager, @NonNull LayoutCanvas canvas, @NonNull Configuration configuration) {
        this.mManager = manager;
        this.mCanvas = canvas;
        this.mConfiguration = configuration;
        this.updateSize();
        assert (this.mConfiguration.getDevice() != null && this.mConfiguration.getDeviceState() != null && this.mConfiguration.getLocale() != null && this.mConfiguration.getTarget() != null && this.mConfiguration.getTheme() != null && this.mConfiguration.getFullConfig() != null && this.mConfiguration.getFullConfig().getScreenSizeQualifier() != null) : this.mConfiguration;
    }

    public void setConfiguration(@NonNull Configuration configuration) {
        this.mConfiguration = configuration;
    }

    public double getScale() {
        return this.mScale;
    }

    public void setScale(double scale) {
        this.disposeThumbnail();
        this.mScale = scale;
    }

    public double getAspectRatio() {
        return this.mAspectRatio;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public void setActive(boolean active) {
        this.mActive = active;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public boolean isForked() {
        return this.mAlternateInput != null || this.mIncludedWithin != null;
    }

    @Nullable
    public IFile getAlternateInput() {
        if (this.mAlternateInput != null) {
            return this.mAlternateInput;
        }
        if (this.mIncludedWithin != null) {
            return this.mIncludedWithin.getFile();
        }
        return null;
    }

    int getArea() {
        return this.mWidth * this.mHeight;
    }

    public void setVisible(boolean visible) {
        if (visible != this.mVisible) {
            this.mVisible = visible;
            if (this.mVisible) {
                if (this.mDirty != 0) {
                    this.configurationChanged(this.mDirty);
                } else {
                    this.updateForkStatus();
                    this.mManager.scheduleRender(this);
                }
            } else {
                this.dispose();
            }
        }
    }

    void setPosition(int x, int y) {
        this.mX = x;
        this.mY = y;
    }

    int getX() {
        return this.mX;
    }

    int getY() {
        return this.mY;
    }

    private void updateForkStatus() {
        ConfigurationChooser chooser = this.mManager.getChooser();
        FolderConfiguration config = this.mConfiguration.getFullConfig();
        if (this.mAlternateInput != null && chooser.isBestMatchFor(this.mAlternateInput, config)) {
            return;
        }
        this.mAlternateInput = null;
        IFile editedFile = chooser.getEditedFile();
        if (editedFile != null && !chooser.isBestMatchFor(editedFile, config)) {
            ResourceFile best;
            ProjectResources resources = chooser.getResources();
            if (resources != null && (best = resources.getMatchingFile(editedFile.getName(), ResourceType.LAYOUT, config)) != null) {
                IAbstractFile file = best.getFile();
                if (file instanceof IFileWrapper) {
                    this.mAlternateInput = ((IFileWrapper)file).getIFile();
                } else if (file instanceof File) {
                    this.mAlternateInput = AdtUtils.fileToIFile((File)file);
                }
            }
            if (this.mAlternateInput != null) {
                this.mAlternateConfiguration = Configuration.create(this.mConfiguration, this.mAlternateInput);
            }
        }
    }

    @NonNull
    public static RenderPreview create(@NonNull RenderPreviewManager manager, @NonNull Configuration configuration) {
        LayoutCanvas canvas = manager.getCanvas();
        return new RenderPreview(manager, canvas, configuration);
    }

    public void dispose() {
        this.disposeThumbnail();
        if (this.mJob != null) {
            this.mJob.cancel();
            this.mJob = null;
        }
    }

    void disposeThumbnail() {
        if (this.mThumbnail != null) {
            this.mThumbnail.dispose();
            this.mThumbnail = null;
        }
    }

    @NonNull
    public String getDisplayName() {
        if (this.mDisplayName == null) {
            String displayName = this.getConfiguration().getDisplayName();
            if (displayName == null) {
                return "Original";
            }
            return displayName;
        }
        return this.mDisplayName;
    }

    public void setDisplayName(@NonNull String displayName) {
        this.mDisplayName = displayName;
    }

    public void setIncludedWithin(IncludeFinder.Reference includedWithin) {
        this.mIncludedWithin = includedWithin;
    }

    public void render(long delay) {
        Object job = this.mJob;
        if (job != null) {
            job.cancel();
        }
        job = new RenderJob();
        job.schedule(delay);
        job.addJobChangeListener((IJobChangeListener)this);
        this.mJob = job;
    }

    private void renderSync() {
        BufferedImage image;
        GraphicalEditorPart editor = this.mCanvas.getEditorDelegate().getGraphicalEditor();
        if (editor.getReadyLayoutLib(false) == null) {
            return;
        }
        this.disposeThumbnail();
        Configuration configuration = this.mAlternateInput != null && this.mAlternateConfiguration != null ? this.mAlternateConfiguration : this.mConfiguration;
        ResourceResolver resolver = this.getResourceResolver(configuration);
        RenderService renderService = RenderService.create(editor, configuration, resolver);
        if (this.mIncludedWithin != null) {
            renderService.setIncludedWithin(this.mIncludedWithin);
        }
        if (this.mAlternateInput != null) {
            Sdk sdk;
            IAndroidTarget target = editor.getRenderingTarget();
            AndroidTargetData data = null;
            if (target != null && (sdk = Sdk.getCurrent()) != null) {
                data = sdk.getTargetData(target);
            }
            DocumentDescriptor documentDescriptor = data == null ? new DocumentDescriptor("temp", null) : data.getLayoutDescriptors().getDescriptor();
            UiDocumentNode model = (UiDocumentNode)documentDescriptor.createUiNode();
            model.setEditor(this.mCanvas.getEditorDelegate().getEditor());
            model.setUnknownDescriptorProvider(editor.getModel().getUnknownDescriptorProvider());
            Document document = DomUtilities.getDocument(this.mAlternateInput);
            if (document == null) {
                this.mError = "No document";
                this.createErrorThumbnail();
                return;
            }
            model.loadFromXmlNode(document);
            renderService.setModel(model);
        } else {
            renderService.setModel(editor.getModel());
        }
        RenderLogger log = new RenderLogger(this.getDisplayName());
        renderService.setLog(log);
        RenderSession session = renderService.createRenderSession();
        Result render = session.render(1000L);
        if (render.isSuccess()) {
            this.mError = null;
        } else {
            this.mError = render.getErrorMessage();
            if (this.mError == null) {
                this.mError = "";
            }
        }
        if (render.getStatus() == Result.Status.ERROR_TIMEOUT) {
            return;
        }
        if (render.isSuccess() && (image = session.getImage()) != null) {
            this.createThumbnail(image);
        }
        if (this.mError != null) {
            this.createErrorThumbnail();
        }
    }

    private ResourceResolver getResourceResolver(Configuration configuration) {
        AndroidTargetData data;
        ResourceResolver resourceResolver = this.mResourceResolver.get();
        if (resourceResolver != null) {
            return resourceResolver;
        }
        GraphicalEditorPart graphicalEditor = this.mCanvas.getEditorDelegate().getGraphicalEditor();
        String theme = configuration.getTheme();
        if (theme == null) {
            return null;
        }
        Map configuredFrameworkRes = null;
        Map<ResourceType, Map<String, ResourceValue>> configuredProjectRes = null;
        FolderConfiguration config = configuration.getFullConfig();
        IAndroidTarget target = graphicalEditor.getRenderingTarget();
        ResourceRepository frameworkRes = null;
        if (target != null) {
            Sdk sdk = Sdk.getCurrent();
            if (sdk == null) {
                return null;
            }
            data = sdk.getTargetData(target);
            if (data == null) {
                return null;
            }
        } else {
            return null;
        }
        frameworkRes = data.getFrameworkResources();
        configuredFrameworkRes = frameworkRes.getConfiguredResources(config);
        assert (configuredFrameworkRes != null);
        ProjectResources projectRes = ResourceManager.getInstance().getProjectResources(graphicalEditor.getProject());
        configuredProjectRes = projectRes.getConfiguredResources(config);
        if (!theme.startsWith("@")) {
            theme = frameworkRes.hasResourceItem("@android:style/" + theme) ? "@android:style/" + theme : "@style/" + theme;
        }
        resourceResolver = ResourceResolver.create(configuredProjectRes, (Map)configuredFrameworkRes, (String)ResourceHelper.styleToTheme(theme), (boolean)ResourceHelper.isProjectStyle(theme));
        this.mResourceResolver = new SoftReference<ResourceResolver>(resourceResolver);
        return resourceResolver;
    }

    void createThumbnail(BufferedImage image) {
        int shadowSize;
        if (image == null) {
            this.mThumbnail = null;
            return;
        }
        ImageOverlay imageOverlay = this.mCanvas.getImageOverlay();
        boolean drawShadows = imageOverlay == null || imageOverlay.getShowDropShadow();
        double scale = (double)this.getWidth() / (double)image.getWidth();
        int n = shadowSize = drawShadows ? 10 : 0;
        if (scale < 1.0) {
            image = ImageUtils.scale(image, scale, scale, shadowSize, shadowSize);
            if (drawShadows) {
                ImageUtils.drawSmallRectangleShadow(image, 0, 0, image.getWidth() - shadowSize, image.getHeight() - shadowSize);
            }
        }
        this.mThumbnail = SwtUtils.convertToSwt((Device)this.mCanvas.getDisplay(), image, true, -1);
    }

    void createErrorThumbnail() {
        boolean drawShadows;
        int shadowSize = 10;
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage image = new BufferedImage(width + shadowSize, height + shadowSize, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(new Color(-262970));
        g.fillRect(0, 0, width, height);
        g.dispose();
        ImageOverlay imageOverlay = this.mCanvas.getImageOverlay();
        boolean bl = drawShadows = imageOverlay == null || imageOverlay.getShowDropShadow();
        if (drawShadows) {
            ImageUtils.drawSmallRectangleShadow(image, 0, 0, image.getWidth() - 10, image.getHeight() - 10);
        }
        this.mThumbnail = SwtUtils.convertToSwt((Device)this.mCanvas.getDisplay(), image, true, -1);
    }

    private static double getScale(int width, int height) {
        int maxWidth = RenderPreviewManager.getMaxWidth();
        int maxHeight = RenderPreviewManager.getMaxHeight();
        if (width > 0 && height > 0 && (width > maxWidth || height > maxHeight)) {
            if (width >= height) {
                return (double)maxWidth / (double)width;
            }
            return (double)maxHeight / (double)height;
        }
        return 1.0;
    }

    public int getWidth() {
        return (int)((double)this.mWidth * this.mScale * RenderPreviewManager.getScale());
    }

    public int getHeight() {
        return (int)((double)this.mHeight * this.mScale * RenderPreviewManager.getScale());
    }

    public boolean click(int x, int y) {
        if (y >= this.mTitleHeight && y < this.mTitleHeight + 20) {
            int left = 0;
            if (x <= (left += CLOSE_ICON_WIDTH)) {
                this.mManager.deletePreview(this);
                return true;
            }
            if (x <= (left += ZOOM_IN_ICON_WIDTH)) {
                this.mScale *= 2.0;
                if (Math.abs(this.mScale - 1.0) < 1.0E-4) {
                    this.mScale = 1.0;
                }
                this.render(0L);
                this.mManager.layout(true);
                this.mCanvas.redraw();
                return true;
            }
            if (x <= (left += ZOOM_OUT_ICON_WIDTH)) {
                this.mScale *= 0.5;
                if (Math.abs(this.mScale - 1.0) < 1.0E-4) {
                    this.mScale = 1.0;
                }
                this.render(0L);
                this.mManager.layout(true);
                this.mCanvas.redraw();
                return true;
            }
            if (x <= (left += EDIT_ICON_WIDTH)) {
                InputDialog d = new InputDialog(AdtPlugin.getShell(), "Rename Preview", "Name:", this.getDisplayName(), null);
                if (d.open() == 0) {
                    String newName = d.getValue();
                    this.mConfiguration.setDisplayName(newName);
                    if (this.mDescription != null) {
                        this.mManager.rename(this.mDescription, newName);
                    }
                    this.mCanvas.redraw();
                }
                return true;
            }
        }
        this.mManager.switchTo(this);
        return true;
    }

    void paint(GC gc, int x, int y) {
        int prevAlpha;
        ImageData data;
        this.mTitleHeight = this.paintTitle(gc, x, y, true);
        y += this.mTitleHeight;
        y += 2;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mThumbnail != null && this.mError == null) {
            gc.drawImage(this.mThumbnail, x, y);
            if (this.mActive) {
                int oldWidth = gc.getLineWidth();
                gc.setLineWidth(3);
                gc.setForeground(gc.getDevice().getSystemColor(26));
                gc.drawRectangle(x - 1, y - 1, width + 2, height + 2);
                gc.setLineWidth(oldWidth);
            }
        } else if (this.mError != null) {
            if (this.mThumbnail != null) {
                gc.drawImage(this.mThumbnail, x, y);
            } else {
                gc.setBackground(gc.getDevice().getSystemColor(23));
                gc.drawRectangle(x, y, width, height);
            }
            gc.setClipping(x, y, width, height);
            Image icon = IconFactory.getInstance().getIcon("renderError");
            data = icon.getImageData();
            prevAlpha = gc.getAlpha();
            int alpha = 96;
            if (this.mThumbnail != null) {
                alpha -= 32;
            }
            gc.setAlpha(alpha);
            gc.drawImage(icon, x + (width - data.width) / 2, y + (height - data.height) / 2);
            String msg = this.mError;
            Density density = this.mConfiguration.getDensity();
            if (density == Density.TV || density == Density.LOW) {
                msg = "Broken rendering library; unsupported DPI. Try using the SDK manager to get updated layout libraries.";
            }
            int charWidth = gc.getFontMetrics().getAverageCharWidth();
            int charsPerLine = (width - 10) / charWidth;
            msg = SdkUtils.wrap((String)msg, (int)charsPerLine, null);
            gc.setAlpha(255);
            gc.setForeground(gc.getDevice().getSystemColor(2));
            gc.drawText(msg, x + 5, y + 20, true);
            gc.setAlpha(prevAlpha);
            gc.setClipping(null);
        } else {
            gc.setBackground(gc.getDevice().getSystemColor(23));
            gc.drawRectangle(x, y, width, height);
            Image icon = IconFactory.getInstance().getIcon("refreshPreview");
            data = icon.getImageData();
            prevAlpha = gc.getAlpha();
            gc.setAlpha(96);
            gc.drawImage(icon, x + (width - data.width) / 2, y + (height - data.height) / 2);
            gc.setAlpha(prevAlpha);
        }
        if (this.mActive) {
            int left = x;
            int prevAlpha2 = gc.getAlpha();
            gc.setAlpha(208);
            org.eclipse.swt.graphics.Color bg = this.mCanvas.getDisplay().getSystemColor(1);
            gc.setBackground(bg);
            gc.fillRectangle(left, y, x + width - left, 20);
            gc.setAlpha(prevAlpha2);
            gc.drawImage(CLOSE_ICON, left, y += 2);
            gc.drawImage(ZOOM_IN_ICON, left += CLOSE_ICON_WIDTH, y);
            gc.drawImage(ZOOM_OUT_ICON, left += ZOOM_IN_ICON_WIDTH, y);
            gc.drawImage(EDIT_ICON, left += ZOOM_OUT_ICON_WIDTH, y);
            left += EDIT_ICON_WIDTH;
        }
    }

    private int paintTitle(GC gc, int x, int y, boolean showFile) {
        String displayName = this.getDisplayName();
        return this.paintTitle(gc, x, y, showFile, displayName);
    }

    int paintTitle(GC gc, int x, int y, boolean showFile, String displayName) {
        int flagHeight;
        int flagWidth;
        int titleHeight = 0;
        if (showFile && this.mIncludedWithin != null) {
            displayName = this.mManager.getMode() != RenderPreviewMode.INCLUDES ? "<include>" : null;
        }
        int width = this.getWidth();
        int labelTop = y + 1;
        gc.setClipping(x, labelTop, width, 100);
        int fontHeight = gc.getFontMetrics().getHeight();
        if (displayName != null && displayName.length() > 0) {
            gc.setForeground(gc.getDevice().getSystemColor(1));
            Point extent = gc.textExtent(displayName);
            int labelLeft = Math.max(x, x + (width - extent.x) / 2);
            Image icon = null;
            Locale locale = this.mConfiguration.getLocale();
            if (locale != null && (locale.hasLanguage() || locale.hasRegion()) && (!(this.mConfiguration instanceof NestedConfiguration) || ((NestedConfiguration)this.mConfiguration).isOverridingLocale())) {
                icon = locale.getFlagImage();
            }
            if (icon != null) {
                flagWidth = icon.getImageData().width;
                flagHeight = icon.getImageData().height;
                labelLeft = Math.max(x + flagWidth / 2, labelLeft);
                gc.drawImage(icon, labelLeft - flagWidth / 2 - 1, labelTop);
                gc.drawText(displayName, labelLeft += flagWidth / 2 + 1, labelTop - (extent.y - flagHeight) / 2, true);
            } else {
                gc.drawText(displayName, labelLeft, labelTop, true);
            }
            labelTop += extent.y;
            titleHeight += fontHeight;
        }
        if (showFile && (this.mAlternateInput != null || this.mIncludedWithin != null)) {
            IFile file = this.mAlternateInput != null ? this.mAlternateInput : this.mIncludedWithin.getFile();
            String fileName = String.valueOf(file.getParent().getName()) + File.separator + file.getName();
            Point extent = gc.textExtent(fileName);
            Image icon = IconFactory.getInstance().getIcon("android_file");
            flagWidth = icon.getImageData().width;
            flagHeight = icon.getImageData().height;
            int labelLeft = Math.max(x, x + (width - extent.x - flagWidth - 1) / 2);
            gc.drawImage(icon, labelLeft, labelTop);
            gc.setForeground(gc.getDevice().getSystemColor(15));
            gc.drawText(fileName, labelLeft += flagWidth + 1, labelTop -= (extent.y - flagHeight) / 2, true);
            titleHeight += Math.max(titleHeight, icon.getImageData().height);
        }
        gc.setClipping(null);
        return titleHeight;
    }

    public void configurationChanged(int flags) {
        if (!this.mVisible) {
            this.mDirty |= flags;
            return;
        }
        if ((flags & 0xFE) != 0) {
            this.mResourceResolver.clear();
            this.mConfiguration.syncFolderConfig();
            this.updateForkStatus();
            this.updateSize();
        }
        this.mDirty = 0;
        this.mManager.scheduleRender(this);
    }

    private void updateSize() {
        int screenHeight;
        int screenWidth;
        int y;
        com.android.sdklib.devices.Device device = this.mConfiguration.getDevice();
        if (device == null) {
            return;
        }
        Screen screen = device.getDefaultHardware().getScreen();
        if (screen == null) {
            return;
        }
        FolderConfiguration folderConfig = this.mConfiguration.getFullConfig();
        ScreenOrientationQualifier qualifier = folderConfig.getScreenOrientationQualifier();
        ScreenOrientation orientation = qualifier == null ? ScreenOrientation.PORTRAIT : qualifier.getValue();
        int x = screen.getXDimension();
        if (x > (y = screen.getYDimension())) {
            if (orientation == ScreenOrientation.LANDSCAPE) {
                screenWidth = x;
                screenHeight = y;
            } else {
                screenWidth = y;
                screenHeight = x;
            }
        } else if (orientation == ScreenOrientation.LANDSCAPE) {
            screenWidth = y;
            screenHeight = x;
        } else {
            screenWidth = x;
            screenHeight = y;
        }
        int width = RenderPreviewManager.getMaxWidth();
        int height = RenderPreviewManager.getMaxHeight();
        if (screenWidth > 0) {
            double scale = RenderPreview.getScale(screenWidth, screenHeight);
            width = (int)((double)screenWidth * scale);
            height = (int)((double)screenHeight * scale);
        }
        if (width != this.mWidth || height != this.mHeight) {
            this.mWidth = width;
            this.mHeight = height;
            Image thumbnail = this.mThumbnail;
            this.mThumbnail = null;
            if (thumbnail != null) {
                thumbnail.dispose();
            }
            if (this.mHeight != 0) {
                this.mAspectRatio = (double)this.mWidth / (double)this.mHeight;
            }
        }
    }

    @NonNull
    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        this.mJob = null;
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    public void setAlternateInput(@Nullable IFile file) {
        this.mAlternateInput = file;
    }

    public void setDescription(@Nullable ConfigurationDescription description) {
        this.mDescription = description;
    }

    @Nullable
    public ConfigurationDescription getDescription() {
        return this.mDescription;
    }

    public String toString() {
        return String.valueOf(this.getDisplayName()) + ':' + this.mConfiguration;
    }

    private final class AsyncRenderJob
    extends Job {
        public AsyncRenderJob() {
            super("RenderPreview");
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            RenderPreview.this.mJob = null;
            if (RenderPreview.this.mCanvas.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            RenderPreview.this.renderSync();
            RenderPreview.this.mCanvas.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RenderPreview.this.mCanvas.redraw();
                }
            });
            return Status.OK_STATUS;
        }
    }

    private final class RenderJob
    extends UIJob {
        public RenderJob() {
            super("RenderPreview");
            this.setSystem(true);
            this.setUser(false);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            RenderPreview.this.mJob = null;
            if (!RenderPreview.this.mCanvas.isDisposed()) {
                RenderPreview.this.renderSync();
                RenderPreview.this.mCanvas.redraw();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public Display getDisplay() {
            if (RenderPreview.this.mCanvas.isDisposed()) {
                return null;
            }
            return RenderPreview.this.mCanvas.getDisplay();
        }
    }
}

