/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.Margins;
import com.android.ide.common.api.Rect;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasTransform;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GCWrapper;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.Overlay;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionHandle;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionItem;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionManager;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SwtDrawingStyle;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SwtUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ViewHierarchy;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.NodeProxy;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.RulesEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.graphics.GC;

public class SelectionOverlay
extends Overlay {
    private final LayoutCanvas mCanvas;
    private boolean mHidden;

    public SelectionOverlay(LayoutCanvas canvas) {
        this.mCanvas = canvas;
    }

    public void setHidden(boolean hidden) {
        this.mHidden = hidden;
    }

    public void paint(SelectionManager selectionManager, GCWrapper gcWrapper, GC gc, RulesEngine rulesEngine) {
        if (this.mHidden) {
            return;
        }
        List<SelectionItem> selections = selectionManager.getSelections();
        int n = selections.size();
        if (n > 0) {
            NodeProxy node;
            ArrayList<NodeProxy> selectedNodes = new ArrayList<NodeProxy>();
            boolean isMultipleSelection = n > 1;
            for (SelectionItem s : selections) {
                NodeProxy node2;
                if (s.isRoot() || (node2 = s.getNode()) == null) continue;
                this.paintSelection(gcWrapper, gc, s, isMultipleSelection);
                selectedNodes.add(node2);
            }
            if (selectedNodes.size() > 0) {
                this.paintSelectionFeedback(gcWrapper, selectedNodes, rulesEngine);
            } else {
                CanvasViewInfo root = this.mCanvas.getViewHierarchy().getRoot();
                if (root != null) {
                    NodeProxy parent = this.mCanvas.getNodeFactory().create(root);
                    rulesEngine.callPaintSelectionFeedback(gcWrapper, parent, Collections.emptyList(), root.getViewObject());
                }
            }
            if (n == 1 && (node = selections.get(0).getNode()) != null) {
                this.paintHints(gcWrapper, node, rulesEngine);
            }
        } else {
            CanvasViewInfo root = this.mCanvas.getViewHierarchy().getRoot();
            if (root != null) {
                NodeProxy parent = this.mCanvas.getNodeFactory().create(root);
                rulesEngine.callPaintSelectionFeedback(gcWrapper, parent, Collections.emptyList(), root.getViewObject());
            }
        }
    }

    private void paintHints(GCWrapper gcWrapper, NodeProxy node, RulesEngine rulesEngine) {
        NodeProxy parentNode;
        List<String> infos;
        INode parent = node.getParent();
        if (parent instanceof NodeProxy && (infos = rulesEngine.callGetSelectionHint(parentNode = (NodeProxy)parent, node)) != null && infos.size() > 0) {
            int y;
            int x;
            gcWrapper.useStyle(DrawingStyle.HELP);
            Rect b = this.mCanvas.getImageOverlay().getImageBounds();
            if (b == null) {
                return;
            }
            double scale = this.mCanvas.getScale();
            if (b.w > b.h) {
                x = (int)((double)b.x + 3.0 / scale);
                y = (int)((double)(b.y + b.h) + 6.0 / scale);
            } else {
                x = (int)((double)(b.x + b.w) + 6.0 / scale);
                y = (int)((double)b.y + 3.0 / scale);
            }
            gcWrapper.drawBoxedStrings(x, y, infos);
        }
    }

    private void paintSelectionFeedback(GCWrapper gcWrapper, List<NodeProxy> nodes, RulesEngine rulesEngine) {
        HashSet<NodeProxy> parents = new HashSet<NodeProxy>();
        for (INode iNode : nodes) {
            INode parent = iNode.getParent();
            if (!(parent instanceof NodeProxy)) continue;
            NodeProxy parentNode = (NodeProxy)parent;
            parents.add(parentNode);
        }
        ViewHierarchy viewHierarchy = this.mCanvas.getViewHierarchy();
        for (INode iNode : parents) {
            ArrayList<INode> children = new ArrayList<INode>();
            for (INode iNode2 : nodes) {
                INode nodeParent = iNode2.getParent();
                if (nodeParent != iNode) continue;
                children.add(iNode2);
            }
            CanvasViewInfo canvasViewInfo = viewHierarchy.findViewInfoFor((NodeProxy)iNode);
            Object view = canvasViewInfo != null ? canvasViewInfo.getViewObject() : null;
            rulesEngine.callPaintSelectionFeedback(gcWrapper, (NodeProxy)iNode, children, view);
        }
    }

    private void paintSelection(IGraphics gc, GC swtGc, SelectionItem item, boolean isMultipleSelection) {
        CanvasViewInfo view = item.getViewInfo();
        if (view.isHidden()) {
            return;
        }
        NodeProxy selectedNode = item.getNode();
        Rect r = selectedNode.getBounds();
        if (!r.isValid()) {
            return;
        }
        gc.useStyle(DrawingStyle.SELECTION);
        Margins insets = this.mCanvas.getInsets(selectedNode.getFqcn());
        int x1 = r.x;
        int y1 = r.y;
        int x2 = r.x2() + 1;
        int y2 = r.y2() + 1;
        if (insets != null) {
            x1 += insets.left;
            x2 -= insets.right;
            y1 += insets.top;
            y2 -= insets.bottom;
        }
        gc.drawRect(x1, y1, x2, y2);
        List<CanvasViewInfo> siblings = view.getNodeSiblings();
        if (siblings != null) {
            for (CanvasViewInfo sibling : siblings) {
                if (sibling == view) continue;
                r = SwtUtils.toRect(sibling.getSelectionRect());
                gc.fillRect(r);
                gc.drawRect(r);
            }
        }
        CanvasTransform horizontalTransform = this.mCanvas.getHorizontalTransform();
        CanvasTransform verticalTransform = this.mCanvas.getVerticalTransform();
        int radius = 3;
        int doubleRadius = 2 * radius;
        for (SelectionHandle handle : item.getSelectionHandles()) {
            int cx = horizontalTransform.translate(handle.centerX);
            int cy = verticalTransform.translate(handle.centerY);
            SwtDrawingStyle style = SwtDrawingStyle.of(DrawingStyle.SELECTION);
            gc.setAlpha(style.getStrokeAlpha());
            swtGc.fillRectangle(cx - radius, cy - radius, doubleRadius, doubleRadius);
        }
    }
}

