/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gre;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.api.IAttributeInfo;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.INodeHandler;
import com.android.ide.common.api.Margins;
import com.android.ide.common.api.Rect;
import com.android.ide.common.resources.platform.AttributeInfo;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SimpleAttribute;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SwtUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ViewHierarchy;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.NodeFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.RulesEngine;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.project.SupportLibraryHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NodeProxy
implements INode {
    private static final Margins NO_MARGINS = new Margins(0, 0, 0, 0);
    private final UiViewElementNode mNode;
    private final Rect mBounds;
    private final NodeFactory mFactory;
    private Map<String, Map<String, String>> mPendingAttributes;

    NodeProxy(UiViewElementNode uiNode, Rectangle bounds, NodeFactory factory) {
        this.mNode = uiNode;
        this.mFactory = factory;
        this.mBounds = bounds == null ? new Rect() : SwtUtils.toRect(bounds);
    }

    @NonNull
    public Rect getBounds() {
        return this.mBounds;
    }

    @NonNull
    public Margins getMargins() {
        Margins margins;
        ViewHierarchy viewHierarchy = this.mFactory.getCanvas().getViewHierarchy();
        CanvasViewInfo view = viewHierarchy.findViewInfoFor(this);
        if (view != null && (margins = view.getMargins()) != null) {
            return margins;
        }
        return NO_MARGINS;
    }

    public int getBaseline() {
        ViewHierarchy viewHierarchy = this.mFactory.getCanvas().getViewHierarchy();
        CanvasViewInfo view = viewHierarchy.findViewInfoFor(this);
        if (view != null) {
            return view.getBaseline();
        }
        return -1;
    }

    void setBounds(Rectangle bounds) {
        SwtUtils.set(this.mBounds, bounds);
    }

    public UiViewElementNode getNode() {
        return this.mNode;
    }

    @NonNull
    public String getFqcn() {
        ElementDescriptor desc;
        if (this.mNode != null && (desc = this.mNode.getDescriptor()) instanceof ViewElementDescriptor) {
            return ((ViewElementDescriptor)desc).getFullClassName();
        }
        return "";
    }

    public INode getRoot() {
        if (this.mNode != null) {
            List<UiElementNode> children;
            UiElementNode p = this.mNode.getUiRoot();
            if (p instanceof UiDocumentNode && (children = p.getUiChildren()).size() > 0) {
                p = children.get(0);
            }
            while (p != null && !(p instanceof UiViewElementNode)) {
                p = p.getUiNextSibling();
            }
            if (p == this.mNode) {
                return this;
            }
            if (p instanceof UiViewElementNode) {
                return this.mFactory.create((UiViewElementNode)p);
            }
        }
        return null;
    }

    public INode getParent() {
        UiElementNode p;
        if (this.mNode != null && (p = this.mNode.getUiParent()) instanceof UiViewElementNode) {
            return this.mFactory.create((UiViewElementNode)p);
        }
        return null;
    }

    @NonNull
    public INode[] getChildren() {
        if (this.mNode != null) {
            List<UiElementNode> uiChildren = this.mNode.getUiChildren();
            ArrayList<NodeProxy> nodes = new ArrayList<NodeProxy>(uiChildren.size());
            for (UiElementNode uiChild : uiChildren) {
                if (!(uiChild instanceof UiViewElementNode)) continue;
                nodes.add(this.mFactory.create((UiViewElementNode)uiChild));
            }
            return nodes.toArray(new INode[nodes.size()]);
        }
        return new INode[0];
    }

    public void editXml(@NonNull String undoName, final @NonNull INodeHandler c) {
        AndroidXmlEditor editor = this.mNode.getEditor();
        if (editor != null) {
            editor.wrapUndoEditXmlModel(undoName, new Runnable(){

                @Override
                public void run() {
                    c.handle((INode)NodeProxy.this);
                    NodeProxy.this.applyPendingChanges();
                }
            });
        }
    }

    private void checkEditOK() {
        AndroidXmlEditor editor = this.mNode.getEditor();
        if (!editor.isEditXmlModelPending()) {
            throw new RuntimeException("Error: XML edit call without using INode.editXml!");
        }
    }

    @NonNull
    public INode appendChild(@NonNull String viewFqcn) {
        return this.insertOrAppend(viewFqcn, -1);
    }

    @NonNull
    public INode insertChildAt(@NonNull String viewFqcn, int index) {
        return this.insertOrAppend(viewFqcn, index);
    }

    public void removeChild(@NonNull INode node) {
        this.checkEditOK();
        ((NodeProxy)node).mNode.deleteXmlNode();
    }

    private INode insertOrAppend(String viewFqcn, int index) {
        UiElementNode uiNew;
        ViewElementDescriptor vd;
        IProject project;
        this.checkEditOK();
        AndroidXmlEditor editor = this.mNode.getEditor();
        if (editor != null && (project = editor.getProject()) != null) {
            viewFqcn = SupportLibraryHelper.getTagFor(project, viewFqcn);
        }
        if ((vd = this.getFqcnViewDescriptor(viewFqcn)) == null) {
            this.warnPrintf("Can't create a new %s element", viewFqcn);
            return null;
        }
        if (index == -1) {
            uiNew = this.mNode.appendNewUiChild(vd);
        } else {
            int n = this.mNode.getUiChildren().size();
            uiNew = index < 0 || index >= n ? this.mNode.appendNewUiChild(vd) : this.mNode.insertNewUiChild(index, vd);
        }
        RulesEngine engine = null;
        LayoutEditorDelegate delegate = LayoutEditorDelegate.fromEditor((IEditorPart)editor);
        if (delegate != null) {
            engine = delegate.getRulesEngine();
        }
        if (engine == null || engine.getInsertType().isCreate()) {
            DescriptorsUtils.setDefaultLayoutAttributes(uiNew, false);
        }
        Node xmlNode = uiNew.createXmlNode();
        if (!(uiNew instanceof UiViewElementNode) || xmlNode == null) {
            this.warnPrintf("Failed to create a new %s element", viewFqcn);
            throw new RuntimeException("XML node creation failed.");
        }
        UiViewElementNode uiNewView = (UiViewElementNode)uiNew;
        NodeProxy newNode = this.mFactory.create(uiNewView);
        if (engine != null) {
            engine.callCreateHooks(editor, this, newNode, null);
        }
        return newNode;
    }

    public boolean setAttribute(@Nullable String uri, @NonNull String name, @Nullable String value) {
        this.checkEditOK();
        UiAttributeNode attr = this.mNode.setAttributeValue(name, uri, value, true);
        if (uri == null) {
            uri = "";
        }
        Map<String, String> map = null;
        if (this.mPendingAttributes == null) {
            this.mPendingAttributes = new HashMap<String, Map<String, String>>(3);
        } else {
            map = this.mPendingAttributes.get(uri);
        }
        if (map == null) {
            map = new HashMap<String, String>();
            this.mPendingAttributes.put(uri, map);
        }
        map.put(name, value);
        return attr != null;
    }

    public String getStringAttr(@Nullable String uri, @NonNull String attrName) {
        Node attr;
        NamedNodeMap nodeAttributes;
        Node xmlNode;
        String value;
        Map<String, String> map;
        UiViewElementNode uiNode = this.mNode;
        if (attrName == null) {
            return null;
        }
        if (this.mPendingAttributes != null && (map = this.mPendingAttributes.get(uri == null ? "" : uri)) != null && (value = map.get(attrName)) != null) {
            return value;
        }
        if (uiNode.getXmlNode() != null && (xmlNode = uiNode.getXmlNode()) != null && (nodeAttributes = xmlNode.getAttributes()) != null && (attr = nodeAttributes.getNamedItemNS(uri, attrName)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public IAttributeInfo getAttributeInfo(@Nullable String uri, @NonNull String attrName) {
        UiViewElementNode uiNode = this.mNode;
        if (attrName == null) {
            return null;
        }
        AttributeDescriptor[] attributeDescriptorArray = ((UiElementNode)uiNode).getAttributeDescriptors();
        int n = attributeDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor desc = attributeDescriptorArray[n2];
            String dUri = desc.getNamespaceUri();
            String dName = desc.getXmlLocalName();
            if ((uri == null && dUri == null || uri != null && uri.equals(dUri)) && attrName.equals(dName)) {
                return desc.getAttributeInfo();
            }
            ++n2;
        }
        return null;
    }

    @NonNull
    public IAttributeInfo[] getDeclaredAttributes() {
        AttributeDescriptor[] descs = this.mNode.getAttributeDescriptors();
        int n = descs.length;
        IAttributeInfo[] infos = new AttributeInfo[n];
        int i = 0;
        while (i < n) {
            infos[i] = descs[i].getAttributeInfo();
            ++i;
        }
        return infos;
    }

    @NonNull
    public List<String> getAttributeSources() {
        ElementDescriptor descriptor = this.mNode.getDescriptor();
        if (descriptor instanceof ViewElementDescriptor) {
            return ((ViewElementDescriptor)descriptor).getAttributeSources();
        }
        return Collections.emptyList();
    }

    @NonNull
    public INode.IAttribute[] getLiveAttributes() {
        NamedNodeMap nodeAttributes;
        Node xmlNode;
        UiViewElementNode uiNode = this.mNode;
        if (uiNode.getXmlNode() != null && (xmlNode = uiNode.getXmlNode()) != null && (nodeAttributes = xmlNode.getAttributes()) != null) {
            int n = nodeAttributes.getLength();
            INode.IAttribute[] result = new INode.IAttribute[n];
            int i = 0;
            while (i < n) {
                Node attr = nodeAttributes.item(i);
                String uri = attr.getNamespaceURI();
                String name = attr.getLocalName();
                String value = attr.getNodeValue();
                result[i] = new SimpleAttribute(uri, name, value);
                ++i;
            }
            return result;
        }
        return new INode.IAttribute[0];
    }

    public String toString() {
        return "NodeProxy [node=" + this.mNode + ", bounds=" + this.mBounds + "]";
    }

    private ViewElementDescriptor getFqcnViewDescriptor(String fqcn) {
        LayoutEditorDelegate delegate = LayoutEditorDelegate.fromEditor((IEditorPart)this.mNode.getEditor());
        if (delegate != null) {
            return delegate.getFqcnViewDescriptor(fqcn);
        }
        return null;
    }

    private void warnPrintf(String msg, Object ... params) {
        AdtPlugin.printToConsole(this.mNode == null ? "" : this.mNode.getDescriptor().getXmlLocalName(), String.format(msg, params));
    }

    public boolean applyPendingChanges() {
        boolean modified = false;
        if (this.mPendingAttributes != null) {
            this.mNode.commitDirtyAttributesToXml();
            modified = true;
            this.mPendingAttributes = null;
        }
        INode[] iNodeArray = this.getChildren();
        int n = iNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            INode child = iNodeArray[n2];
            modified |= ((NodeProxy)child).applyPendingChanges();
            ++n2;
        }
        return modified;
    }
}

