/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.refactoring;

import com.android.annotations.NonNull;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.UnwrapWizard;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.VisualRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.VisualRefactoringWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UnwrapRefactoring
extends VisualRefactoring {
    private Element mContainer;

    UnwrapRefactoring(Map<String, String> arguments) {
        super(arguments);
    }

    public UnwrapRefactoring(IFile file, LayoutEditorDelegate delegate, ITextSelection selection, ITreeSelection treeSelection) {
        super(file, delegate, selection, treeSelection);
    }

    UnwrapRefactoring(List<Element> selectedElements, LayoutEditorDelegate editor) {
        super(selectedElements, editor);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            Node parent;
            boolean useParent;
            pm.beginTask("Checking preconditions...", 6);
            if (this.mSelectionStart == -1 || this.mSelectionEnd == -1) {
                status.addFatalError("No selection to wrap");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.mElements.size() == 0) {
                status.addFatalError("Nothing to unwrap");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            Element first = (Element)this.mElements.get(0);
            boolean bl = useParent = this.mElements.size() > 1;
            if (!useParent && DomUtilities.getChildren(first).size() == 0) {
                useParent = true;
            }
            if ((parent = first.getParentNode()) instanceof Document) {
                this.mContainer = first;
                List<Element> elements = DomUtilities.getChildren(this.mContainer);
                if (elements.size() == 0) {
                    status.addFatalError("Cannot remove container when it has no children");
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
            } else {
                this.mContainer = useParent && parent instanceof Element ? (Element)parent : first;
            }
            for (Element element : this.mElements) {
                if (element.getParentNode() == parent) continue;
                status.addFatalError("All unwrapped elements must share the same parent element");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.mContainer.getParentNode() instanceof Document && DomUtilities.getChildren(this.mContainer).size() > 1) {
                status.addFatalError("Cannot remove root: it has more than one child which would result in multiple new roots");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    @Override
    protected VisualRefactoring.VisualRefactoringDescriptor createDescriptor() {
        String comment = this.getName();
        return new Descriptor(this.mProject.getName(), comment, comment, this.createArgumentMap());
    }

    public String getName() {
        return "Remove Container";
    }

    @Override
    @NonNull
    protected List<Change> computeChanges(IProgressMonitor monitor) {
        List<Element> children;
        IFile file = this.mDelegate.getEditor().getInputFile();
        ArrayList<Change> changes = new ArrayList<Change>();
        if (file == null) {
            return changes;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        if (this.mContainer.getParentNode() instanceof Document) {
            List<Element> elements = DomUtilities.getChildren(this.mContainer);
            assert (elements.size() == 1);
            Element newRoot = elements.get(0);
            List<Attr> declarations = UnwrapRefactoring.findNamespaceAttributes(this.mContainer);
            for (Attr attribute : declarations) {
                if (!(attribute instanceof IndexedRegion)) continue;
                this.setAttribute(rootEdit, newRoot, attribute.getNamespaceURI(), attribute.getPrefix(), attribute.getLocalName(), attribute.getValue());
            }
        }
        if ((children = DomUtilities.getChildren(this.mContainer)).size() == 1) {
            List<Attr> layoutAttributes = this.findLayoutAttributes(this.mContainer);
            for (Attr attribute : layoutAttributes) {
                String name = attribute.getLocalName();
                if ((name.equals("layout_width") || name.equals("layout_height")) && !"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) continue;
            }
        }
        this.removeElementTags(rootEdit, this.mContainer, Collections.<Element>emptyList(), false);
        MultiTextEdit formatted = this.reformat(rootEdit, XmlFormatStyle.LAYOUT);
        if (formatted != null) {
            rootEdit = formatted;
        }
        TextFileChange change = new TextFileChange(file.getName(), file);
        change.setEdit((TextEdit)rootEdit);
        change.setTextType("xml");
        changes.add((Change)change);
        return changes;
    }

    @Override
    public VisualRefactoringWizard createWizard() {
        return new UnwrapWizard(this, this.mDelegate);
    }

    public static class Descriptor
    extends VisualRefactoring.VisualRefactoringDescriptor {
        public Descriptor(String project, String description, String comment, Map<String, String> arguments) {
            super("com.android.ide.eclipse.adt.refactoring.unwrap", project, description, comment, arguments);
        }

        @Override
        protected Refactoring createRefactoring(Map<String, String> args) {
            return new UnwrapRefactoring(args);
        }
    }
}

