/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.document.NodeContainer;
import org.w3c.dom.Node;

public class PasteAction
extends Action {
    private UiElementNode mUiNode;
    private final AndroidXmlEditor mEditor;
    private final Clipboard mClipboard;

    public PasteAction(AndroidXmlEditor editor, Clipboard clipboard, UiElementNode ui_node) {
        super("Paste");
        this.mEditor = editor;
        this.mClipboard = clipboard;
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.mUiNode = ui_node;
    }

    public void run() {
        super.run();
        final String data = (String)this.mClipboard.getContents((Transfer)TextTransfer.getInstance());
        if (data != null) {
            this.mEditor.wrapEditXmlModel(new Runnable(){

                @Override
                public void run() {
                    try {
                        IStructuredDocument sse_doc = PasteAction.this.mEditor.getStructuredDocument();
                        if (sse_doc != null) {
                            Node xml_node;
                            if (PasteAction.this.mUiNode.getDescriptor().hasChildren()) {
                                NodeContainer container;
                                IStructuredDocumentRegion start_tag;
                                if (PasteAction.this.mUiNode.getUiChildren().size() > 0 && (xml_node = PasteAction.this.mUiNode.getUiChildren().get(0).getXmlNode()) instanceof IndexedRegion) {
                                    IndexedRegion region = (IndexedRegion)xml_node;
                                    sse_doc.replace(region.getStartOffset(), 0, data);
                                    return;
                                }
                                xml_node = PasteAction.this.mUiNode.getXmlNode();
                                if (xml_node instanceof NodeContainer && (start_tag = (container = (NodeContainer)xml_node).getStartStructuredDocumentRegion()) != null) {
                                    sse_doc.replace(start_tag.getEndOffset(), 0, data);
                                    return;
                                }
                            }
                            if (!(PasteAction.this.mUiNode.getUiParent() instanceof UiDocumentNode) && (xml_node = PasteAction.this.mUiNode.getXmlNode()) instanceof IndexedRegion) {
                                IndexedRegion region = (IndexedRegion)xml_node;
                                sse_doc.replace(region.getEndOffset(), 0, data);
                            }
                        }
                    }
                    catch (BadLocationException e) {
                        AdtPlugin.log(e, "ParseAction failed for UI Node %2$s, content '%1$s'", PasteAction.this.mUiNode.getBreadcrumbTrailDescription(true), data);
                    }
                }
            });
        }
    }
}

