/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.SeparatorAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiTreeBlock;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiUpdateListener;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

class UiElementDetail
implements IDetailsPage {
    private SectionHelper.ManifestSectionPart mMasterPart;
    private Section mMasterSection;
    private UiElementNode mCurrentUiElementNode;
    private Composite mCurrentTable;
    private boolean mIsDirty;
    private IManagedForm mManagedForm;
    private final UiTreeBlock mTree;

    public UiElementDetail(UiTreeBlock tree) {
        this.mTree = tree;
        this.mMasterPart = this.mTree.getMasterPart();
        this.mManagedForm = this.mMasterPart.getManagedForm();
    }

    public void initialize(IManagedForm form) {
        this.mManagedForm = form;
    }

    public void createContents(Composite parent) {
        this.mMasterSection = this.createMasterSection(parent);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        ITreeSelection tree_selection;
        Object first;
        if (part == this.mMasterPart && !selection.isEmpty() && selection instanceof ITreeSelection && (first = (tree_selection = (ITreeSelection)selection).getFirstElement()) instanceof UiElementNode) {
            UiElementNode ui_node = (UiElementNode)first;
            this.createUiAttributeControls(this.mManagedForm, ui_node);
        }
    }

    public void commit(boolean onSave) {
        this.mTree.getEditor().wrapEditXmlModel(new Runnable(){

            @Override
            public void run() {
                try {
                    if (UiElementDetail.this.mCurrentUiElementNode != null) {
                        UiElementDetail.this.mCurrentUiElementNode.commit();
                    }
                    UiElementDetail.this.mIsDirty = false;
                }
                catch (Exception e) {
                    AdtPlugin.log(e, "Detail node failed to commit XML attribute!", new Object[0]);
                }
            }
        });
    }

    public void dispose() {
    }

    public boolean isDirty() {
        if (this.mCurrentUiElementNode != null && this.mCurrentUiElementNode.isDirty()) {
            this.markDirty();
        }
        return this.mIsDirty;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        if (this.mCurrentTable != null) {
            this.mCurrentTable.dispose();
            this.mCurrentTable = null;
        }
        this.mCurrentUiElementNode = null;
        this.mMasterSection.getParent().pack(true);
    }

    public void setFocus() {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    private Section createMasterSection(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.mManagedForm.getToolkit();
        Section section = toolkit.createSection(parent, 256);
        section.setLayoutData((Object)new TableWrapData(256, 16));
        return section;
    }

    private void createUiAttributeControls(final IManagedForm managedForm, final UiElementNode ui_node) {
        block15: {
            Composite masterTable;
            ElementDescriptor elem_desc = ui_node.getDescriptor();
            this.mMasterSection.setText(String.format("Attributes for %1$s", ui_node.getShortDescription()));
            if (this.mCurrentUiElementNode == ui_node) break block15;
            if (this.mIsDirty) {
                this.commit(false);
            }
            if (this.mCurrentTable != null) {
                this.mCurrentTable.dispose();
                this.mCurrentTable = null;
            }
            AttributeDescriptor[] attr_desc_list = ui_node.getAttributeDescriptors();
            boolean useSubsections = false;
            AttributeDescriptor[] attributeDescriptorArray = attr_desc_list;
            int n = attr_desc_list.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDescriptor attr_desc = attributeDescriptorArray[n2];
                if (attr_desc instanceof SeparatorAttributeDescriptor) {
                    useSubsections = true;
                    break;
                }
                ++n2;
            }
            FormToolkit toolkit = managedForm.getToolkit();
            this.mCurrentTable = masterTable = SectionHelper.createTableLayout((Composite)this.mMasterSection, toolkit, useSubsections ? 1 : 2);
            this.mCurrentUiElementNode = ui_node;
            if (elem_desc.getTooltip() != null) {
                String tooltip = Sdk.getCurrent() != null && Sdk.getCurrent().getDocumentationBaseUrl() != null ? DescriptorsUtils.formatFormText(elem_desc.getTooltip(), elem_desc, Sdk.getCurrent().getDocumentationBaseUrl()) : elem_desc.getTooltip();
                try {
                    FormText text = SectionHelper.createFormText(masterTable, toolkit, true, tooltip, true);
                    text.addHyperlinkListener(this.mTree.getEditor().createHyperlinkListener());
                    Image icon = elem_desc.getCustomizedIcon();
                    if (icon != null) {
                        text.setImage("image", icon);
                    }
                }
                catch (Exception e) {
                    AdtPlugin.log(e, "Malformed javadoc, rejected by FormText for node %1$s: '%2$s'", ui_node.getDescriptor().getXmlName(), tooltip);
                    tooltip = DescriptorsUtils.formatTooltip(elem_desc.getTooltip());
                    SectionHelper.createLabel(masterTable, toolkit, tooltip, tooltip);
                }
            }
            Composite table = useSubsections ? null : masterTable;
            AttributeDescriptor[] attributeDescriptorArray2 = attr_desc_list;
            int n3 = attr_desc_list.length;
            int icon = 0;
            while (icon < n3) {
                block16: {
                    UiAttributeNode ui_attr;
                    AttributeDescriptor attr_desc;
                    block17: {
                        attr_desc = attributeDescriptorArray2[icon];
                        if (attr_desc instanceof XmlnsAttributeDescriptor) break block16;
                        if (table != null && !(attr_desc instanceof SeparatorAttributeDescriptor)) break block17;
                        String title = null;
                        title = attr_desc instanceof SeparatorAttributeDescriptor ? attr_desc.getXmlLocalName() : String.format("Attributes from %1$s", elem_desc.getUiName());
                        table = this.createSubSectionTable(toolkit, masterTable, title);
                        if (attr_desc instanceof SeparatorAttributeDescriptor) break block16;
                    }
                    if ((ui_attr = ui_node.findUiAttribute(attr_desc)) != null) {
                        ui_attr.createUiControl(table, managedForm);
                        if (ui_attr.getCurrentValue() != null && ui_attr.getCurrentValue().length() > 0) {
                            ((Section)table.getParent()).setExpanded(true);
                        }
                    } else {
                        AdtPlugin.log(1, "Attribute %1$s not declared in node %2$s, ignored.", attr_desc.getXmlLocalName(), ui_node.getDescriptor().getXmlName());
                    }
                }
                ++icon;
            }
            final Composite unknownTable = this.createSubSectionTable(toolkit, masterTable, "Unknown XML Attributes");
            unknownTable.getParent().setVisible(false);
            final HashSet<UiAttributeNode> reference = new HashSet<UiAttributeNode>();
            final IUiUpdateListener updateListener = new IUiUpdateListener(){

                @Override
                public void uiElementNodeUpdated(UiElementNode uiNode, IUiUpdateListener.UiUpdateState state) {
                    if (state == IUiUpdateListener.UiUpdateState.ATTR_UPDATED) {
                        UiElementDetail.this.updateUnknownAttributesSection(uiNode, unknownTable, managedForm, reference);
                    }
                }
            };
            ui_node.addUpdateListener(updateListener);
            unknownTable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ui_node.removeUpdateListener(updateListener);
                }
            });
            this.updateUnknownAttributesSection(ui_node, unknownTable, managedForm, reference);
            this.mMasterSection.getParent().pack(true);
        }
    }

    private Composite createSubSectionTable(FormToolkit toolkit, Composite masterTable, String title) {
        int parentNumCol = ((TableWrapLayout)masterTable.getLayout()).numColumns;
        if (parentNumCol > 1) {
            masterTable = SectionHelper.createTableLayout(masterTable, toolkit, 1);
            TableWrapData twd = new TableWrapData(256);
            twd.maxWidth = 50;
            twd.colspan = parentNumCol;
            masterTable.setLayoutData((Object)twd);
        }
        Section section = toolkit.createSection(masterTable, 258);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                UiElementDetail.this.reflowMasterSection();
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        section.setText(title);
        section.setLayoutData((Object)new TableWrapData(256, 16));
        Composite table = SectionHelper.createTableLayout((Composite)section, toolkit, 2);
        return table;
    }

    private void reflowMasterSection() {
        Section c = this.mMasterSection;
        while (c != null) {
            if (c instanceof SharedScrolledComposite) {
                ((SharedScrolledComposite)c).reflow(true);
                break;
            }
            c = c.getParent();
        }
    }

    private void updateUnknownAttributesSection(UiElementNode ui_node, Composite unknownTable, IManagedForm managedForm, HashSet<UiAttributeNode> reference) {
        boolean has_differences;
        Collection<UiAttributeNode> ui_attrs = ui_node.getUnknownUiAttributes();
        Section section = (Section)unknownTable.getParent();
        boolean needs_reflow = false;
        if (ui_attrs.size() > 0 && !section.isVisible()) {
            section.setVisible(true);
            needs_reflow = true;
        }
        boolean bl = has_differences = ui_attrs.size() != reference.size();
        if (!has_differences) {
            for (UiAttributeNode ui_attr : ui_attrs) {
                if (reference.contains(ui_attr)) continue;
                has_differences = true;
                break;
            }
        }
        if (has_differences) {
            needs_reflow = true;
            reference.clear();
            Control[] controlArray = unknownTable.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            for (UiAttributeNode ui_attr : ui_attrs) {
                reference.add(ui_attr);
                ui_attr.createUiControl(unknownTable, managedForm);
                if (ui_attr.getCurrentValue() == null || ui_attr.getCurrentValue().length() <= 0) continue;
                section.setExpanded(true);
            }
        }
        if (needs_reflow) {
            this.reflowMasterSection();
        }
    }

    private void markDirty() {
        if (!this.mIsDirty) {
            this.mIsDirty = true;
            this.mManagedForm.dirtyStateChanged();
        }
    }
}

