/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.uimodel;

import com.android.ide.common.api.IAttributeInfo;
import com.android.ide.common.resources.platform.AttributeInfo;
import com.android.ide.common.xml.XmlAttributeSortOrder;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IUnknownDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.SeparatorAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.CustomViewDescriptorService;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiSettableAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiUpdateListener;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class UiElementNode
implements IPropertySource {
    private static String[] ID_PREFIXES = new String[]{"@android:id/", "@+id/", "@id/", "@+", "@"};
    private ElementDescriptor mDescriptor;
    private UiElementNode mUiParent;
    private AndroidXmlEditor mEditor;
    private Document mXmlDocument;
    private Node mXmlNode;
    private ArrayList<UiElementNode> mUiChildren;
    private HashMap<AttributeDescriptor, UiAttributeNode> mUiAttributes;
    private HashSet<UiAttributeNode> mUnknownUiAttributes;
    private List<UiElementNode> mReadOnlyUiChildren;
    private Collection<UiAttributeNode> mCachedAllUiAttributes;
    private Map<String, AttributeDescriptor> mCachedHiddenAttributes;
    private List<IUiUpdateListener> mUiUpdateListeners;
    private IUnknownDescriptorProvider mUnknownDescProvider;
    private boolean mHasError;
    private static List<NodeCreationListener> sListeners;

    public UiElementNode(ElementDescriptor elementDescriptor) {
        this.mDescriptor = elementDescriptor;
        this.clearContent();
    }

    public String toString() {
        return String.format("%s [desc: %s, parent: %s, children: %d]", this.getClass().getSimpleName(), this.mDescriptor, this.mUiParent != null ? this.mUiParent.toString() : "none", this.mUiChildren != null ? this.mUiChildren.size() : 0);
    }

    void clearContent() {
        this.mXmlNode = null;
        this.mXmlDocument = null;
        this.mEditor = null;
        this.clearAttributes();
        this.mReadOnlyUiChildren = null;
        if (this.mUiChildren == null) {
            this.mUiChildren = new ArrayList();
        } else {
            int i = this.mUiChildren.size() - 1;
            while (i >= 0) {
                this.removeUiChildAtIndex(i);
                --i;
            }
        }
    }

    private void clearAttributes() {
        this.mUiAttributes = null;
        this.mCachedAllUiAttributes = null;
        this.mCachedHiddenAttributes = null;
        this.mUnknownUiAttributes = new HashSet();
    }

    private HashMap<AttributeDescriptor, UiAttributeNode> getInternalUiAttributes() {
        if (this.mUiAttributes == null) {
            AttributeDescriptor[] attrList = this.getAttributeDescriptors();
            this.mUiAttributes = new HashMap(attrList.length);
            AttributeDescriptor[] attributeDescriptorArray = attrList;
            int n = attrList.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDescriptor desc = attributeDescriptorArray[n2];
                UiAttributeNode uiNode = desc.createUiNode(this);
                if (uiNode != null) {
                    this.mUiAttributes.put(desc, uiNode);
                }
                ++n2;
            }
        }
        return this.mUiAttributes;
    }

    public String getShortDescription() {
        String name = this.mDescriptor.getUiName();
        String attr = this.getDescAttribute();
        if (attr != null) {
            if (attr.contains(name)) {
                return attr;
            }
            return String.format("%1$s (%2$s)", attr, name);
        }
        return name;
    }

    private String getDescAttribute() {
        if (this.mXmlNode != null && this.mXmlNode instanceof Element && this.mXmlNode.hasAttributes()) {
            Element elem = (Element)this.mXmlNode;
            String attr = this._Element_getAttributeNS(elem, "http://schemas.android.com/apk/res/android", "name");
            if (attr == null || attr.length() == 0) {
                attr = this._Element_getAttributeNS(elem, "http://schemas.android.com/apk/res/android", "label");
            } else if (this.mXmlNode.getNodeName().equals("fragment")) {
                attr = attr.substring(attr.lastIndexOf(46) + 1);
            }
            if (attr == null || attr.length() == 0) {
                attr = this._Element_getAttributeNS(elem, "http://schemas.android.com/apk/res/android", "key");
            }
            if (attr == null || attr.length() == 0) {
                attr = this._Element_getAttributeNS(elem, null, "name");
            }
            if ((attr == null || attr.length() == 0) && (attr = this._Element_getAttributeNS(elem, "http://schemas.android.com/apk/res/android", "id")) != null && attr.length() > 0) {
                String[] stringArray = ID_PREFIXES;
                int n = ID_PREFIXES.length;
                int n2 = 0;
                while (n2 < n) {
                    String prefix = stringArray[n2];
                    if (attr.startsWith(prefix)) {
                        attr = attr.substring(prefix.length());
                        break;
                    }
                    ++n2;
                }
            }
            if (attr != null && attr.length() > 0) {
                return attr;
            }
        }
        return null;
    }

    public StyledString getStyledDescription() {
        Element element;
        String cls;
        String uiName = this.mDescriptor.getUiName();
        if ("view".equals(uiName) && this.mXmlNode instanceof Element && (cls = (element = (Element)this.mXmlNode).getAttribute("class")) != null) {
            uiName = cls.substring(cls.lastIndexOf(46) + 1);
        }
        StyledString styledString = new StyledString();
        String attr = this.getDescAttribute();
        if (attr != null) {
            if (attr.toLowerCase(Locale.US).indexOf(uiName.toLowerCase(Locale.US)) == -1) {
                styledString.append(attr);
                styledString.append(String.format(" (%1$s)", uiName), StyledString.DECORATIONS_STYLER);
            } else {
                styledString.append(attr);
            }
        }
        if (styledString.length() == 0) {
            styledString.append(uiName);
        }
        return styledString;
    }

    private String _Element_getAttributeNS(Element element, String namespaceURI, String localName) {
        try {
            return element.getAttributeNS(namespaceURI, localName);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getBreadcrumbTrailDescription(boolean includeRoot) {
        StringBuilder sb = new StringBuilder(this.getShortDescription());
        UiElementNode uiNode = this.getUiParent();
        while (uiNode != null) {
            if (!includeRoot && uiNode.getUiParent() == null) break;
            sb.insert(0, String.format("%1$s > ", uiNode.getShortDescription()));
            uiNode = uiNode.getUiParent();
        }
        return sb.toString();
    }

    public void setXmlDocument(Document xmlDoc) {
        if (this.mUiParent == null) {
            this.mXmlDocument = xmlDoc;
        } else {
            this.mUiParent.setXmlDocument(xmlDoc);
        }
    }

    public Document getXmlDocument() {
        if (this.mXmlDocument != null) {
            return this.mXmlDocument;
        }
        if (this.mUiParent != null) {
            return this.mUiParent.getXmlDocument();
        }
        return null;
    }

    public Node getXmlNode() {
        return this.mXmlNode;
    }

    public ElementDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    public AttributeDescriptor[] getAttributeDescriptors() {
        return this.mDescriptor.getAttributes();
    }

    private Map<String, AttributeDescriptor> getHiddenAttributeDescriptors() {
        if (this.mCachedHiddenAttributes == null) {
            this.mCachedHiddenAttributes = new HashMap<String, AttributeDescriptor>();
            AttributeDescriptor[] attributeDescriptorArray = this.getAttributeDescriptors();
            int n = attributeDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDescriptor attrDesc = attributeDescriptorArray[n2];
                if (attrDesc instanceof XmlnsAttributeDescriptor) {
                    this.mCachedHiddenAttributes.put(((XmlnsAttributeDescriptor)attrDesc).getXmlNsName(), attrDesc);
                }
                ++n2;
            }
        }
        return this.mCachedHiddenAttributes;
    }

    protected void setUiParent(UiElementNode parent) {
        this.mUiParent = parent;
        this.clearAttributes();
    }

    public UiElementNode getUiParent() {
        return this.mUiParent;
    }

    public UiElementNode getUiRoot() {
        UiElementNode root = this;
        while (root.mUiParent != null) {
            root = root.mUiParent;
        }
        return root;
    }

    public int getUiSiblingIndex() {
        if (this.mUiParent != null) {
            int index = 0;
            for (UiElementNode node : this.mUiParent.getUiChildren()) {
                if (node == this) break;
                ++index;
            }
            return index;
        }
        return 0;
    }

    public UiElementNode getUiPreviousSibling() {
        List<UiElementNode> childlist;
        if (this.mUiParent != null && (childlist = this.mUiParent.getUiChildren()) != null && childlist.size() > 1 && childlist.get(0) != this) {
            int index = childlist.indexOf(this);
            return index > 0 ? childlist.get(index - 1) : null;
        }
        return null;
    }

    public UiElementNode getUiNextSibling() {
        int size;
        List<UiElementNode> childlist;
        if (this.mUiParent != null && (childlist = this.mUiParent.getUiChildren()) != null && (size = childlist.size()) > 1 && childlist.get(size - 1) != this) {
            int index = childlist.indexOf(this);
            return index >= 0 && index < size - 1 ? childlist.get(index + 1) : null;
        }
        return null;
    }

    public void setEditor(AndroidXmlEditor editor) {
        if (this.mUiParent == null) {
            this.mEditor = editor;
        } else {
            this.mUiParent.setEditor(editor);
        }
    }

    public AndroidXmlEditor getEditor() {
        return this.mUiParent == null ? this.mEditor : this.mUiParent.getEditor();
    }

    public AndroidTargetData getAndroidTarget() {
        return this.getEditor().getTargetData();
    }

    public List<UiElementNode> getUiChildren() {
        if (this.mReadOnlyUiChildren == null) {
            this.mReadOnlyUiChildren = Collections.unmodifiableList(this.mUiChildren);
        }
        return this.mReadOnlyUiChildren;
    }

    public Collection<UiAttributeNode> getAllUiAttributes() {
        if (this.mCachedAllUiAttributes == null) {
            ArrayList<UiAttributeNode> allValues = new ArrayList<UiAttributeNode>(this.getInternalUiAttributes().values());
            allValues.addAll(this.mUnknownUiAttributes);
            this.mCachedAllUiAttributes = Collections.unmodifiableCollection(allValues);
        }
        return this.mCachedAllUiAttributes;
    }

    public Collection<UiAttributeNode> getUnknownUiAttributes() {
        return Collections.unmodifiableCollection(this.mUnknownUiAttributes);
    }

    public final void setHasError(boolean errorFlag) {
        this.mHasError = errorFlag;
    }

    public final boolean hasError() {
        if (this.mHasError) {
            return true;
        }
        for (UiAttributeNode attribute : this.getAllUiAttributes()) {
            if (!attribute.hasError()) continue;
            return true;
        }
        for (UiElementNode child : this.mUiChildren) {
            if (!child.hasError()) continue;
            return true;
        }
        return false;
    }

    public IUnknownDescriptorProvider getUnknownDescriptorProvider() {
        if (this.mUiParent != null) {
            return this.mUiParent.getUnknownDescriptorProvider();
        }
        if (this.mUnknownDescProvider == null) {
            this.mUnknownDescProvider = new IUnknownDescriptorProvider(){
                private final HashMap<String, ElementDescriptor> mMap = new HashMap();

                @Override
                public ElementDescriptor getDescriptor(String xmlLocalName) {
                    ElementDescriptor desc = this.mMap.get(xmlLocalName);
                    if (desc == null) {
                        desc = new ElementDescriptor(xmlLocalName);
                        this.mMap.put(xmlLocalName, desc);
                    }
                    return desc;
                }
            };
        }
        return this.mUnknownDescProvider;
    }

    public void setUnknownDescriptorProvider(IUnknownDescriptorProvider unknownDescProvider) {
        if (this.mUiParent == null) {
            this.mUnknownDescProvider = unknownDescProvider;
        } else {
            this.mUiParent.setUnknownDescriptorProvider(unknownDescProvider);
        }
    }

    public void addUpdateListener(IUiUpdateListener listener) {
        if (this.mUiUpdateListeners == null) {
            this.mUiUpdateListeners = new ArrayList<IUiUpdateListener>();
        }
        if (!this.mUiUpdateListeners.contains(listener)) {
            this.mUiUpdateListeners.add(listener);
        }
    }

    public void removeUpdateListener(IUiUpdateListener listener) {
        if (this.mUiUpdateListeners != null) {
            this.mUiUpdateListeners.remove(listener);
        }
    }

    public UiElementNode findUiChildNode(String path) {
        String[] items = path.split("/");
        UiElementNode uiNode = this;
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            boolean nextSegment = false;
            for (UiElementNode c : uiNode.mUiChildren) {
                if (!c.getDescriptor().getXmlName().equals(item)) continue;
                uiNode = c;
                nextSegment = true;
                break;
            }
            if (!nextSegment) {
                return null;
            }
            ++n2;
        }
        return uiNode;
    }

    public UiElementNode findXmlNode(Node xmlNode) {
        if (xmlNode == null) {
            return null;
        }
        if (this.getXmlNode() == xmlNode) {
            return this;
        }
        for (UiElementNode uiChild : this.mUiChildren) {
            UiElementNode found = uiChild.findXmlNode(xmlNode);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public UiAttributeNode findUiAttribute(AttributeDescriptor attrDesc) {
        return this.getInternalUiAttributes().get(attrDesc);
    }

    public boolean loadFromXmlNode(Node xmlNode) {
        boolean structureChanged = this.mXmlNode != xmlNode;
        this.mXmlNode = xmlNode;
        if (xmlNode != null) {
            this.updateAttributeList(xmlNode);
            this.invokeUiUpdateListeners((structureChanged |= this.updateElementList(xmlNode)) ? IUiUpdateListener.UiUpdateState.CHILDREN_CHANGED : IUiUpdateListener.UiUpdateState.ATTR_UPDATED);
        }
        return structureChanged;
    }

    public void reloadFromXmlNode(Node xmlNode) {
        AndroidXmlEditor editor = this.getEditor();
        this.clearContent();
        this.setEditor(editor);
        if (xmlNode != null) {
            this.setXmlDocument(xmlNode.getOwnerDocument());
        }
        this.loadFromXmlNode(xmlNode);
    }

    public Node prepareCommit() {
        if (this.getDescriptor().getMandatory() != ElementDescriptor.Mandatory.NOT_MANDATORY) {
            this.createXmlNode();
        }
        return this.getXmlNode();
    }

    public void commit() {
        for (UiAttributeNode uiAttr : this.getAllUiAttributes()) {
            uiAttr.commit();
        }
    }

    public boolean isDirty() {
        for (UiAttributeNode uiAttr : this.getAllUiAttributes()) {
            if (!uiAttr.isDirty()) continue;
            return true;
        }
        return false;
    }

    public Node createXmlNode() {
        String indent;
        if (this.mXmlNode != null) {
            return null;
        }
        Node parentXmlNode = null;
        if (this.mUiParent != null && (parentXmlNode = this.mUiParent.prepareCommit()) == null) {
            return null;
        }
        String elementName = this.getDescriptor().getXmlName();
        Document doc = this.getXmlDocument();
        if (doc == null) {
            throw new RuntimeException(String.format("Missing XML document for %1$s XML node.", elementName));
        }
        if (parentXmlNode == null) {
            parentXmlNode = doc;
        }
        this.mXmlNode = doc.createElement(elementName);
        if (!this.mDescriptor.hasChildren() && this.mXmlNode instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)this.mXmlNode;
            element.setEmptyTag(true);
        }
        Node xmlNextSibling = null;
        UiElementNode uiNextSibling = this.getUiNextSibling();
        if (uiNextSibling != null) {
            xmlNextSibling = uiNextSibling.getXmlNode();
        }
        Node previousTextNode = null;
        if (xmlNextSibling != null) {
            Node previousNode = xmlNextSibling.getPreviousSibling();
            if (previousNode != null && previousNode.getNodeType() == 3) {
                previousTextNode = previousNode;
            }
        } else {
            Node lastChild = parentXmlNode.getLastChild();
            if (lastChild != null && lastChild.getNodeType() == 3) {
                previousTextNode = lastChild;
            }
        }
        String insertAfter = null;
        boolean isFirstChild = this.getUiPreviousSibling() == null || parentXmlNode.getFirstChild() == null;
        AndroidXmlEditor editor = this.getEditor();
        String parentIndent = "";
        indent = isFirstChild ? ((indent = (parentIndent = editor.getIndent(parentXmlNode))).length() > 0 && indent.charAt(indent.length() - 1) == '\t' ? String.valueOf(indent) + '\t' : String.valueOf(indent) + "    ") : editor.getIndent(this.getUiPreviousSibling().getXmlNode());
        if (previousTextNode != null) {
            xmlNextSibling = previousTextNode;
        } else {
            insertAfter = parentIndent;
        }
        IStructuredDocument document = editor.getStructuredDocument();
        String newLine = document != null ? TextUtilities.getDefaultLineDelimiter((IDocument)document) : SdkUtils.getLineSeparator();
        Text indentNode = doc.createTextNode(String.valueOf(newLine) + indent);
        parentXmlNode.insertBefore(indentNode, xmlNextSibling);
        parentXmlNode.insertBefore(this.mXmlNode, xmlNextSibling);
        if (insertAfter != null) {
            Text sep = doc.createTextNode(String.valueOf(newLine) + insertAfter);
            parentXmlNode.insertBefore(sep, xmlNextSibling);
        }
        ArrayList<UiAttributeNode> addAttributes = new ArrayList<UiAttributeNode>();
        AttributeDescriptor[] attributeDescriptorArray = this.getAttributeDescriptors();
        int n = attributeDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor attrDesc = attributeDescriptorArray[n2];
            if (attrDesc instanceof XmlnsAttributeDescriptor) {
                XmlnsAttributeDescriptor desc = (XmlnsAttributeDescriptor)attrDesc;
                Attr attr = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", desc.getXmlNsName());
                attr.setValue(desc.getValue());
                attr.setPrefix(desc.getXmlNsPrefix());
                this.mXmlNode.getAttributes().setNamedItemNS(attr);
            } else {
                UiAttributeNode uiAttr = this.getInternalUiAttributes().get(attrDesc);
                String value = uiAttr.getCurrentValue();
                if (value != null && value.length() > 0) {
                    addAttributes.add(uiAttr);
                }
            }
            ++n2;
        }
        Collections.sort(addAttributes);
        for (UiAttributeNode node : addAttributes) {
            this.commitAttributeToXml(node, node.getCurrentValue());
            node.setDirty(false);
        }
        this.getEditor().scheduleNodeReformat(this, false);
        this.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.CREATED);
        this.fireNodeCreated(this, this.getUiSiblingIndex());
        return this.mXmlNode;
    }

    public Node deleteXmlNode() {
        if (this.mXmlNode == null) {
            return null;
        }
        int previousIndex = this.getUiSiblingIndex();
        Node oldXmlNode = this.mXmlNode;
        this.clearContent();
        Node xmlParent = oldXmlNode.getParentNode();
        if (xmlParent == null) {
            xmlParent = this.getXmlDocument();
        }
        Node previousSibling = oldXmlNode.getPreviousSibling();
        oldXmlNode = xmlParent.removeChild(oldXmlNode);
        if (previousSibling != null && previousSibling.getNodeType() == 3 && previousSibling.getNodeValue().trim().length() == 0) {
            xmlParent.removeChild(previousSibling);
        }
        this.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.DELETED);
        this.fireNodeDeleted(this, previousIndex);
        return oldXmlNode;
    }

    protected boolean updateElementList(Node xmlNode) {
        boolean structureChanged = false;
        boolean hasMandatoryLast = false;
        int uiIndex = 0;
        Node xmlChild = xmlNode.getFirstChild();
        while (xmlChild != null) {
            if (xmlChild.getNodeType() == 1) {
                String elementName = xmlChild.getNodeName();
                UiElementNode uiNode = null;
                CustomViewDescriptorService service = CustomViewDescriptorService.getInstance();
                if (this.mUiChildren.size() <= uiIndex) {
                    AndroidXmlEditor editor;
                    ElementDescriptor desc = this.mDescriptor.findChildrenDescriptor(elementName, false);
                    if (desc == null && elementName.indexOf(46) != -1 && (!elementName.startsWith("android.") || elementName.startsWith("android.support.")) && (editor = this.getEditor()) != null && editor.getProject() != null) {
                        desc = service.getDescriptor(editor.getProject(), elementName);
                    }
                    if (desc == null) {
                        IUnknownDescriptorProvider p = this.getUnknownDescriptorProvider();
                        desc = p.getDescriptor(elementName);
                    }
                    structureChanged = true;
                    uiNode = this.appendNewUiChild(desc);
                    ++uiIndex;
                } else {
                    UiElementNode uiChild;
                    int n = this.mUiChildren.size();
                    int j = uiIndex;
                    while (j < n) {
                        uiChild = this.mUiChildren.get(j);
                        if (uiChild.getXmlNode() != null && uiChild.getXmlNode() == xmlChild) {
                            if (j > uiIndex) {
                                this.mUiChildren.remove(j);
                                this.mUiChildren.add(uiIndex, uiChild);
                                structureChanged = true;
                            }
                            uiNode = uiChild;
                            ++uiIndex;
                            break;
                        }
                        ++j;
                    }
                    if (uiNode == null) {
                        j = uiIndex;
                        while (j < n) {
                            uiChild = this.mUiChildren.get(j);
                            if (uiChild.getXmlNode() == null && uiChild.getDescriptor().getMandatory() != ElementDescriptor.Mandatory.NOT_MANDATORY && uiChild.getDescriptor().getXmlName().equals(elementName)) {
                                if (j > uiIndex) {
                                    this.mUiChildren.remove(j);
                                    this.mUiChildren.add(uiIndex, uiChild);
                                }
                                uiChild.mXmlNode = xmlChild;
                                structureChanged = true;
                                uiNode = uiChild;
                                ++uiIndex;
                            }
                            ++j;
                        }
                    }
                    if (uiNode == null) {
                        AndroidXmlEditor editor;
                        ElementDescriptor desc = this.mDescriptor.findChildrenDescriptor(elementName, false);
                        if (desc == null && elementName.indexOf(46) != -1 && (!elementName.startsWith("android.") || elementName.startsWith("android.support.")) && (editor = this.getEditor()) != null && editor.getProject() != null) {
                            desc = service.getDescriptor(editor.getProject(), elementName);
                        }
                        if (desc == null) {
                            IUnknownDescriptorProvider p = this.getUnknownDescriptorProvider();
                            desc = p.getDescriptor(elementName);
                        } else {
                            structureChanged = true;
                            uiNode = this.insertNewUiChild(uiIndex, desc);
                            ++uiIndex;
                        }
                    }
                }
                if (uiNode != null) {
                    structureChanged |= uiNode.loadFromXmlNode(xmlChild);
                    hasMandatoryLast |= uiNode.getDescriptor().getMandatory() == ElementDescriptor.Mandatory.MANDATORY_LAST;
                }
            }
            xmlChild = xmlChild.getNextSibling();
        }
        int index = this.mUiChildren.size() - 1;
        while (index >= uiIndex) {
            structureChanged |= this.removeUiChildAtIndex(index);
            --index;
        }
        if (hasMandatoryLast) {
            int n;
            int index2 = n = this.mUiChildren.size() - 1;
            while (index2 >= 0) {
                UiElementNode uiChild = this.mUiChildren.get(index2);
                ElementDescriptor.Mandatory mand = uiChild.getDescriptor().getMandatory();
                if (mand == ElementDescriptor.Mandatory.MANDATORY_LAST && index2 < n) {
                    this.mUiChildren.remove(index2);
                    this.mUiChildren.add(uiChild);
                } else if (mand == ElementDescriptor.Mandatory.NOT_MANDATORY || uiChild.getXmlNode() != null) break;
                --index2;
            }
        }
        return structureChanged;
    }

    private boolean removeUiChildAtIndex(int uiIndex) {
        UiElementNode uiNode = this.mUiChildren.get(uiIndex);
        ElementDescriptor desc = uiNode.getDescriptor();
        try {
            if (uiNode.getDescriptor().getMandatory() != ElementDescriptor.Mandatory.NOT_MANDATORY) {
                boolean keepNode = true;
                for (UiElementNode child : this.mUiChildren) {
                    if (child == uiNode || child.getDescriptor() != desc) continue;
                    keepNode = false;
                    break;
                }
                if (keepNode) {
                    boolean xmlExists = uiNode.getXmlNode() != null;
                    uiNode.clearContent();
                    boolean bl = xmlExists;
                    return bl;
                }
            }
            this.mUiChildren.remove(uiIndex);
            return true;
        }
        finally {
            this.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.DELETED);
        }
    }

    public UiElementNode appendNewUiChild(ElementDescriptor descriptor) {
        UiElementNode uiNode = descriptor.createUiNode();
        this.mUiChildren.add(uiNode);
        uiNode.setUiParent(this);
        uiNode.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.CREATED);
        return uiNode;
    }

    public UiElementNode insertNewUiChild(int index, ElementDescriptor descriptor) {
        UiElementNode uiNode = descriptor.createUiNode();
        this.mUiChildren.add(index, uiNode);
        uiNode.setUiParent(this);
        uiNode.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.CREATED);
        return uiNode;
    }

    protected void updateAttributeList(Node xmlNode) {
        Node xmlAttr;
        NamedNodeMap xmlAttrMap = xmlNode.getAttributes();
        HashSet<Node> visited = new HashSet<Node>();
        for (UiAttributeNode uiAttr : this.getInternalUiAttributes().values()) {
            AttributeDescriptor desc = uiAttr.getDescriptor();
            if (desc instanceof SeparatorAttributeDescriptor) continue;
            xmlAttr = xmlAttrMap == null ? null : xmlAttrMap.getNamedItemNS(desc.getNamespaceUri(), desc.getXmlLocalName());
            uiAttr.updateValue(xmlAttr);
            visited.add(xmlAttr);
        }
        HashSet deleted = (HashSet)this.mUnknownUiAttributes.clone();
        Map<String, AttributeDescriptor> hiddenAttrDesc = this.getHiddenAttributeDescriptors();
        if (xmlAttrMap != null) {
            int i = 0;
            while (i < xmlAttrMap.getLength()) {
                String xmlFullName;
                xmlAttr = xmlAttrMap.item(i);
                if (!visited.contains(xmlAttr) && !hiddenAttrDesc.containsKey(xmlFullName = xmlAttr.getNodeName())) {
                    String xmlAttrLocalName = xmlAttr.getLocalName();
                    String xmlNsUri = xmlAttr.getNamespaceURI();
                    UiAttributeNode uiAttr = null;
                    for (UiAttributeNode a : this.mUnknownUiAttributes) {
                        String aLocalName = a.getDescriptor().getXmlLocalName();
                        String aNsUri = a.getDescriptor().getNamespaceUri();
                        if (!aLocalName.equals(xmlAttrLocalName) || aNsUri != xmlNsUri && (aNsUri == null || !aNsUri.equals(xmlNsUri))) continue;
                        uiAttr = a;
                        deleted.remove(a);
                        break;
                    }
                    if (uiAttr == null) {
                        uiAttr = this.addUnknownAttribute(xmlFullName, xmlAttrLocalName, xmlNsUri);
                    }
                    uiAttr.updateValue(xmlAttr);
                }
                ++i;
            }
            for (UiAttributeNode a : deleted) {
                this.mUnknownUiAttributes.remove(a);
                this.mCachedAllUiAttributes = null;
            }
        }
    }

    private UiAttributeNode addUnknownAttribute(String xmlFullName, String xmlAttrLocalName, String xmlNsUri) {
        TextAttributeDescriptor desc = new TextAttributeDescriptor(xmlAttrLocalName, xmlNsUri, new AttributeInfo(xmlAttrLocalName, IAttributeInfo.Format.STRING_SET));
        UiAttributeNode uiAttr = desc.createUiNode(this);
        this.mUnknownUiAttributes.add(uiAttr);
        this.mCachedAllUiAttributes = null;
        return uiAttr;
    }

    protected void invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState state) {
        if (this.mUiUpdateListeners != null) {
            for (IUiUpdateListener listener : this.mUiUpdateListeners) {
                try {
                    listener.uiElementNodeUpdated(this, state);
                }
                catch (Exception e) {
                    AdtPlugin.log(e, "UIElement Listener failed: %s, state=%s", this.getBreadcrumbTrailDescription(true), state.toString());
                }
            }
        }
    }

    public void setXmlNode(Node xmlNode) {
        this.mXmlNode = xmlNode;
    }

    public void refreshUi() {
        this.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.ATTR_UPDATED);
    }

    public boolean commitAttributeToXml(UiAttributeNode uiAttr, String newValue) {
        Node element = this.prepareCommit();
        if (element != null && uiAttr != null) {
            String attrLocalName = uiAttr.getDescriptor().getXmlLocalName();
            String attrNsUri = uiAttr.getDescriptor().getNamespaceUri();
            NamedNodeMap attrMap = element.getAttributes();
            if (newValue == null || newValue.length() == 0) {
                if (attrMap.getNamedItemNS(attrNsUri, attrLocalName) != null) {
                    attrMap.removeNamedItemNS(attrNsUri, attrLocalName);
                    return true;
                }
            } else {
                Document doc = element.getOwnerDocument();
                if (doc != null) {
                    Attr attr;
                    if (attrNsUri != null && attrNsUri.length() > 0) {
                        attr = (Attr)attrMap.getNamedItemNS(attrNsUri, attrLocalName);
                        if (attr == null) {
                            attr = doc.createAttributeNS(attrNsUri, attrLocalName);
                            attr.setPrefix(XmlUtils.lookupNamespacePrefix((Node)element, (String)attrNsUri));
                            attrMap.setNamedItemNS(attr);
                        }
                    } else {
                        attr = (Attr)attrMap.getNamedItem(attrLocalName);
                        if (attr == null) {
                            attr = doc.createAttribute(attrLocalName);
                            attrMap.setNamedItem(attr);
                        }
                    }
                    attr.setValue(newValue);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean commitDirtyAttributesToXml() {
        boolean result = false;
        ArrayList<UiAttributeNode> dirtyAttributes = new ArrayList<UiAttributeNode>();
        for (UiAttributeNode uiAttr : this.getAllUiAttributes()) {
            if (!uiAttr.isDirty()) continue;
            String value = uiAttr.getCurrentValue();
            if (value != null && value.length() > 0) {
                dirtyAttributes.add(uiAttr);
                continue;
            }
            result |= this.commitAttributeToXml(uiAttr, value);
            uiAttr.setDirty(false);
        }
        if (dirtyAttributes.size() > 0) {
            result = true;
            Collections.sort(dirtyAttributes);
            Node element = this.prepareCommit();
            if (element == null) {
                return result;
            }
            if (AdtPrefs.getPrefs().getFormatGuiXml() && this.getEditor().supportsFormatOnGuiEdit()) {
                for (UiAttributeNode uiAttribute : dirtyAttributes) {
                    this.commitAttributeToXml(uiAttribute, uiAttribute.getCurrentValue());
                    uiAttribute.setDirty(false);
                }
                return result;
            }
            AttributeDescriptor descriptor = ((UiAttributeNode)dirtyAttributes.get(0)).getDescriptor();
            String firstName = descriptor.getXmlLocalName();
            String firstNamePrefix = null;
            String namespaceUri = descriptor.getNamespaceUri();
            if (namespaceUri != null) {
                firstNamePrefix = XmlUtils.lookupNamespacePrefix((Node)element, (String)namespaceUri);
            }
            NamedNodeMap attributes = ((Element)element).getAttributes();
            ArrayList<Attr> move = new ArrayList<Attr>();
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                Attr attribute = (Attr)attributes.item(i);
                if (XmlAttributeSortOrder.compareAttributes((String)attribute.getPrefix(), (String)attribute.getLocalName(), (String)firstNamePrefix, (String)firstName) > 0) {
                    move.add(attribute);
                }
                ++i;
            }
            for (Attr attribute : move) {
                if (attribute.getNamespaceURI() != null) {
                    attributes.removeNamedItemNS(attribute.getNamespaceURI(), attribute.getLocalName());
                    continue;
                }
                attributes.removeNamedItem(attribute.getName());
            }
            int domAttributeIndex = 0;
            int domAttributeIndexMax = move.size();
            int uiAttributeIndex = 0;
            int uiAttributeIndexMax = dirtyAttributes.size();
            while (true) {
                int compare;
                UiAttributeNode uiAttribute;
                Attr domAttribute;
                if (uiAttributeIndex < uiAttributeIndexMax) {
                    if (domAttributeIndex < domAttributeIndexMax) {
                        domAttribute = (Attr)move.get(domAttributeIndex);
                        uiAttribute = (UiAttributeNode)dirtyAttributes.get(uiAttributeIndex);
                        String domAttributeName = domAttribute.getLocalName();
                        String uiAttributeName = uiAttribute.getDescriptor().getXmlLocalName();
                        compare = XmlAttributeSortOrder.compareAttributes((String)domAttributeName, (String)uiAttributeName);
                    } else {
                        compare = 1;
                        uiAttribute = (UiAttributeNode)dirtyAttributes.get(uiAttributeIndex);
                        domAttribute = null;
                    }
                } else {
                    if (domAttributeIndex >= domAttributeIndexMax) break;
                    compare = -1;
                    domAttribute = (Attr)move.get(domAttributeIndex);
                    uiAttribute = null;
                }
                if (compare < 0) {
                    if (domAttribute.getNamespaceURI() != null) {
                        attributes.setNamedItemNS(domAttribute);
                    } else {
                        attributes.setNamedItem(domAttribute);
                    }
                    ++domAttributeIndex;
                    continue;
                }
                assert (compare >= 0);
                if (compare == 0) {
                    ++domAttributeIndex;
                }
                this.commitAttributeToXml(uiAttribute, uiAttribute.getCurrentValue());
                uiAttribute.setDirty(false);
                ++uiAttributeIndex;
            }
        }
        return result;
    }

    public UiAttributeNode setAttributeValue(String attrXmlName, String attrNsUri, String value, boolean override) {
        if (value == null) {
            value = "";
        }
        this.getEditor().scheduleNodeReformat(this, true);
        UiAttributeNode uiAttr = this.setInternalAttrValue(this.getAllUiAttributes(), attrXmlName, attrNsUri, value, override);
        if (uiAttr != null) {
            return uiAttr;
        }
        this.addUnknownAttribute(attrXmlName, attrXmlName, attrNsUri);
        uiAttr = this.setInternalAttrValue(this.getAllUiAttributes(), attrXmlName, attrNsUri, value, override);
        return uiAttr;
    }

    private UiAttributeNode setInternalAttrValue(Collection<UiAttributeNode> attributes, String attrXmlName, String attrNsUri, String value, boolean override) {
        if (attrNsUri != null && attrNsUri.length() == 0) {
            attrNsUri = null;
        }
        for (UiAttributeNode uiAttr : attributes) {
            AttributeDescriptor uiDesc = uiAttr.getDescriptor();
            if (!uiDesc.getXmlLocalName().equals(attrXmlName) || (attrNsUri != null || uiDesc.getNamespaceUri() != null) && (attrNsUri == null || !attrNsUri.equals(uiDesc.getNamespaceUri()))) continue;
            if (!(uiAttr instanceof IUiSettableAttributeNode)) break;
            String current = uiAttr.getCurrentValue();
            if (!override && current != null && current.equals(value)) break;
            ((IUiSettableAttributeNode)((Object)uiAttr)).setCurrentValue(value);
            uiAttr.setDirty(true);
            return uiAttr;
        }
        return null;
    }

    public String getAttributeValue(String attrXmlName) {
        HashMap<AttributeDescriptor, UiAttributeNode> attributeMap = this.getInternalUiAttributes();
        for (Map.Entry<AttributeDescriptor, UiAttributeNode> entry : attributeMap.entrySet()) {
            AttributeDescriptor uiDesc = entry.getKey();
            if (!uiDesc.getXmlLocalName().equals(attrXmlName)) continue;
            UiAttributeNode uiAttr = entry.getValue();
            return uiAttr.getCurrentValue();
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> propDescs = new ArrayList<IPropertyDescriptor>();
        HashMap<AttributeDescriptor, UiAttributeNode> attributeMap = this.getInternalUiAttributes();
        Set<AttributeDescriptor> keys = attributeMap.keySet();
        for (AttributeDescriptor key : keys) {
            if (!(key instanceof IPropertyDescriptor)) continue;
            propDescs.add((IPropertyDescriptor)key);
        }
        for (UiAttributeNode unknownNode : this.mUnknownUiAttributes) {
            if (!(unknownNode.getDescriptor() instanceof IPropertyDescriptor)) continue;
            propDescs.add((IPropertyDescriptor)unknownNode.getDescriptor());
        }
        return propDescs.toArray(new IPropertyDescriptor[propDescs.size()]);
    }

    public Object getPropertyValue(Object id) {
        HashMap<AttributeDescriptor, UiAttributeNode> attributeMap = this.getInternalUiAttributes();
        UiAttributeNode attribute = attributeMap.get(id);
        if (attribute == null) {
            for (UiAttributeNode unknownAttr : this.mUnknownUiAttributes) {
                if (id != unknownAttr.getDescriptor()) continue;
                return unknownAttr;
            }
        }
        return attribute;
    }

    public boolean isPropertySet(Object id) {
        HashMap<AttributeDescriptor, UiAttributeNode> attributeMap = this.getInternalUiAttributes();
        UiAttributeNode attribute = attributeMap.get(id);
        if (attribute != null) {
            return attribute.getCurrentValue().length() > 0;
        }
        for (UiAttributeNode unknownAttr : this.mUnknownUiAttributes) {
            if (id != unknownAttr.getDescriptor()) continue;
            return unknownAttr.getCurrentValue().length() > 0;
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        HashMap<AttributeDescriptor, UiAttributeNode> attributeMap = this.getInternalUiAttributes();
        UiAttributeNode attribute = attributeMap.get(id);
        if (attribute != null) {
            return;
        }
        for (UiAttributeNode unknownAttr : this.mUnknownUiAttributes) {
            if (id != unknownAttr.getDescriptor()) continue;
            return;
        }
    }

    public void setPropertyValue(Object id, Object value) {
        HashMap<AttributeDescriptor, UiAttributeNode> attributeMap = this.getInternalUiAttributes();
        UiAttributeNode attribute = attributeMap.get(id);
        if (attribute == null) {
            for (UiAttributeNode unknownAttr : this.mUnknownUiAttributes) {
                if (id != unknownAttr.getDescriptor()) continue;
                attribute = unknownAttr;
                break;
            }
        }
        if (attribute != null) {
            String newValue;
            String oldValue = attribute.getCurrentValue();
            if (oldValue.equals(newValue = (String)value)) {
                return;
            }
            final UiAttributeNode fAttribute = attribute;
            AndroidXmlEditor editor = this.getEditor();
            editor.wrapEditXmlModel(new Runnable(){

                @Override
                public void run() {
                    UiElementNode.this.commitAttributeToXml(fAttribute, newValue);
                }
            });
        }
    }

    public boolean isAncestorOf(UiElementNode node) {
        node = node.getUiParent();
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.getUiParent();
        }
        return false;
    }

    public static UiElementNode getCommonAncestor(UiElementNode node1, UiElementNode node2) {
        while (node2 != null) {
            UiElementNode current = node1;
            while (current != null && current != node2) {
                current = current.getUiParent();
            }
            if (current == node2) {
                return current;
            }
            node2 = node2.getUiParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeCreated(UiElementNode newChild, int index) {
        if (sListeners == null) {
            return;
        }
        Class<UiElementNode> clazz = UiElementNode.class;
        synchronized (UiElementNode.class) {
            if (sListeners != null) {
                UiElementNode parent = newChild.getUiParent();
                for (NodeCreationListener listener : sListeners) {
                    listener.nodeCreated(parent, newChild, index);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeDeleted(UiElementNode oldChild, int index) {
        if (sListeners == null) {
            return;
        }
        Class<UiElementNode> clazz = UiElementNode.class;
        synchronized (UiElementNode.class) {
            if (sListeners != null) {
                UiElementNode parent = oldChild.getUiParent();
                for (NodeCreationListener listener : sListeners) {
                    listener.nodeDeleted(parent, oldChild, index);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNodeCreationListener(NodeCreationListener listener) {
        Class<UiElementNode> clazz = UiElementNode.class;
        synchronized (UiElementNode.class) {
            if (sListeners == null) {
                sListeners = new ArrayList<NodeCreationListener>(1);
            }
            sListeners.add(listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNodeCreationListener(NodeCreationListener listener) {
        Class<UiElementNode> clazz = UiElementNode.class;
        synchronized (UiElementNode.class) {
            sListeners.remove(listener);
            if (sListeners.size() == 0) {
                sListeners = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static interface NodeCreationListener {
        public void nodeCreated(UiElementNode var1, UiElementNode var2, int var3);

        public void nodeDeleted(UiElementNode var1, UiElementNode var2, int var3);
    }
}

