/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.uimodel;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ListAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAbstractTextAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class UiListAttributeNode
extends UiAbstractTextAttributeNode {
    protected Combo mCombo;

    public UiListAttributeNode(ListAttributeDescriptor attributeDescriptor, UiElementNode uiParent) {
        super(attributeDescriptor, uiParent);
    }

    @Override
    public final void createUiControl(Composite parent, IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        TextAttributeDescriptor desc = (TextAttributeDescriptor)this.getDescriptor();
        Label label = toolkit.createLabel(parent, desc.getUiName());
        label.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)label, DescriptorsUtils.formatTooltip(desc.getTooltip()));
        int style = 4;
        this.mCombo = new Combo(parent, style);
        TableWrapData twd = new TableWrapData(256, 32);
        twd.maxWidth = 100;
        this.mCombo.setLayoutData((Object)twd);
        this.fillCombo();
        this.setTextWidgetValue(this.getCurrentValue());
        this.mCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiListAttributeNode.this.onComboChange();
            }
        });
        this.mCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiListAttributeNode.this.onComboChange();
            }
        });
        this.mCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UiListAttributeNode.this.mCombo = null;
            }
        });
    }

    protected void fillCombo() {
        String[] values = this.getPossibleValues(null);
        if (values == null) {
            AdtPlugin.log(4, "FrameworkResourceManager did not provide values yet for %1$s", this.getDescriptor().getXmlLocalName());
        } else {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.mCombo.add(value);
                ++n2;
            }
        }
    }

    @Override
    public String[] getPossibleValues(String prefix) {
        UiElementNode uiNode;
        AndroidXmlEditor editor;
        AndroidTargetData data;
        AttributeDescriptor descriptor = this.getDescriptor();
        UiElementNode uiParent = this.getUiParent();
        String attr_name = descriptor.getXmlLocalName();
        String element_name = uiParent.getDescriptor().getXmlName();
        String nsPrefix = "";
        if ("http://schemas.android.com/apk/res/android".equals(descriptor.getNamespaceUri())) {
            nsPrefix = "android:";
        } else if ("http://www.w3.org/2000/xmlns/".equals(descriptor.getNamespaceUri())) {
            nsPrefix = "xmlns:";
        }
        attr_name = String.valueOf(nsPrefix) + attr_name;
        String[] values = null;
        if (descriptor instanceof ListAttributeDescriptor && ((ListAttributeDescriptor)descriptor).getValues() != null) {
            values = ((ListAttributeDescriptor)descriptor).getValues();
        }
        if (values == null && (data = (editor = (uiNode = this.getUiParent()).getEditor()).getTargetData()) != null) {
            UiElementNode greatGrandParentNode;
            UiElementNode grandParentNode = uiParent.getUiParent();
            String greatGrandParentNodeName = null;
            if (grandParentNode != null && (greatGrandParentNode = grandParentNode.getUiParent()) != null) {
                greatGrandParentNodeName = greatGrandParentNode.getDescriptor().getXmlName();
            }
            values = data.getAttributeValues(element_name, attr_name, greatGrandParentNodeName);
        }
        return values;
    }

    @Override
    public String getTextWidgetValue() {
        if (this.mCombo != null) {
            return this.mCombo.getText();
        }
        return null;
    }

    @Override
    public final boolean isValid() {
        return this.mCombo != null;
    }

    @Override
    public void setTextWidgetValue(String value) {
        if (this.mCombo != null) {
            this.mCombo.setText(value);
        }
    }

    private void onComboChange() {
        if (!(this.isInInternalTextModification() || this.isDirty() || this.mCombo == null || this.getCurrentValue() == null || this.mCombo.getText().equals(this.getCurrentValue()))) {
            this.setDirty(true);
        }
    }
}

