/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.CanceledException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.actions.AvdManagerAction;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunch;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchConfiguration;
import com.android.ide.eclipse.adt.internal.launch.AvdCompatibility;
import com.android.ide.eclipse.adt.internal.launch.DelayedLaunchInfo;
import com.android.ide.eclipse.adt.internal.launch.DeviceChoiceCache;
import com.android.ide.eclipse.adt.internal.launch.DeviceChooserDialog;
import com.android.ide.eclipse.adt.internal.launch.IAndroidLaunchAction;
import com.android.ide.eclipse.adt.internal.launch.ILaunchController;
import com.android.ide.eclipse.adt.internal.launch.LaunchConfigDelegate;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.project.ApkInstallManager;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.utils.NullLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public final class AndroidLaunchController
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IClientChangeListener,
ILaunchController {
    private static final String FLAG_AVD = "-avd";
    private static final String FLAG_NETDELAY = "-netdelay";
    private static final String FLAG_NETSPEED = "-netspeed";
    private static final String FLAG_WIPE_DATA = "-wipe-data";
    private static final String FLAG_NO_BOOT_ANIM = "-no-boot-anim";
    private static final HashMap<ILaunchConfiguration, Integer> sRunningAppMap;
    private static final Object sListLock;
    private final ArrayList<DelayedLaunchInfo> mWaitingForEmulatorLaunches = new ArrayList();
    private final ArrayList<DelayedLaunchInfo> mWaitingForReadyEmulatorList = new ArrayList();
    private final ArrayList<DelayedLaunchInfo> mWaitingForDebuggerApplications = new ArrayList();
    private final ArrayList<Client> mUnknownClientsWaitingForDebugger = new ArrayList();
    private static AndroidLaunchController sThis;

    static {
        sListLock = sRunningAppMap = new HashMap();
        sThis = new AndroidLaunchController();
    }

    private AndroidLaunchController() {
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    public static AndroidLaunchController getInstance() {
        return sThis;
    }

    public static void debugRunningApp(IProject project, int debugPort) {
        ILaunchConfiguration config = AndroidLaunchController.getLaunchConfig(project, "com.android.ide.eclipse.adt.debug.LaunchConfigType");
        if (config != null) {
            AndroidLaunchController.setPortLaunchConfigAssociation(config, debugPort);
            DebugUITools.launch((ILaunchConfiguration)config, (String)"debug");
        }
    }

    public static ILaunchConfiguration getLaunchConfig(IProject project, String launchTypeId) {
        String name;
        ILaunchConfigurationType configType;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration config = AndroidLaunchController.findConfig(manager, configType = manager.getLaunchConfigurationType(launchTypeId), name = project.getName());
        if (config == null) {
            ILaunchConfigurationWorkingCopy wc = null;
            try {
                wc = configType.newInstance(null, manager.generateLaunchConfigurationName(name));
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, name);
                wc.setAttribute("com.android.ide.eclipse.adt.action", 0);
                wc.setAttribute("com.android.ide.eclipse.adt.target", LaunchConfigDelegate.DEFAULT_TARGET_MODE.toString());
                wc.setAttribute("com.android.ide.eclipse.adt.avd", null);
                wc.setAttribute("com.android.ide.eclipse.adt.speed", 0);
                wc.setAttribute("com.android.ide.eclipse.adt.delay", 0);
                wc.setAttribute("com.android.ide.eclipse.adt.wipedata", false);
                wc.setAttribute("com.android.ide.eclipse.adt.nobootanim", false);
                IPreferenceStore store = AdtPlugin.getDefault().getPreferenceStore();
                String emuOptions = store.getString("com.android.ide.eclipse.adt.emuOptions");
                wc.setAttribute("com.android.ide.eclipse.adt.commandline", emuOptions);
                wc.setMappedResources(AndroidLaunchController.getResourcesToMap(project));
                return wc.doSave();
            }
            catch (CoreException e) {
                String msg = String.format("Failed to create a Launch config for project '%1$s': %2$s", project.getName(), e.getMessage());
                AdtPlugin.printErrorToConsole(project, new Object[]{msg});
                return null;
            }
        }
        return config;
    }

    public static IResource[] getResourcesToMap(IProject project) {
        ArrayList<Object> array = new ArrayList<Object>(2);
        array.add(project);
        IFile manifest = ProjectHelper.getManifest(project);
        if (manifest != null) {
            array.add(manifest);
        }
        return array.toArray(new IResource[array.size()]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(final IProject project, String mode, IFile apk, String packageName, String debugPackageName, Boolean debuggable, String requiredApiVersionNumber, IAndroidLaunchAction launchAction, AndroidLaunchConfiguration config, final AndroidLaunch launch, IProgressMonitor monitor) {
        block30: {
            block29: {
                block27: {
                    block28: {
                        message = String.format("Performing %1$s", new Object[]{launchAction.getLaunchDescription()});
                        AdtPlugin.printToConsole(project, new Object[]{message});
                        launchInfo = new DelayedLaunchInfo(project, packageName, debugPackageName, launchAction, apk, debuggable, requiredApiVersionNumber, launch, monitor);
                        launchInfo.setDebugMode(mode.equals("debug"));
                        currentSdk = Sdk.getCurrent();
                        avdManager = currentSdk.getAvdManager();
                        try {
                            avdManager.reloadAvds(NullLogger.getLogger());
                        }
                        catch (AndroidLocation.AndroidLocationException v0) {
                            config.mTargetMode = AndroidLaunchConfiguration.TargetMode.MANUAL;
                        }
                        projectTarget = currentSdk.getTarget(project);
                        mi = ManifestInfo.get(project);
                        minApiLevel = mi.getMinSdkVersion();
                        minApiCodeName = mi.getMinSdkCodeName();
                        minApiVersion = new AndroidVersion(minApiLevel, minApiCodeName);
                        response = new DeviceChooserDialog.DeviceChooserResponse();
                        devices = AndroidDebugBridge.getBridge().getDevices();
                        deviceUsedInLastLaunch = DeviceChoiceCache.get(launch.getLaunchConfiguration().getName());
                        if (deviceUsedInLastLaunch != null) {
                            response.setDeviceToUse(deviceUsedInLastLaunch);
                            this.continueLaunch(response, project, launch, launchInfo, config);
                            return;
                        }
                        if (config.mTargetMode != AndroidLaunchConfiguration.TargetMode.AUTO) break block27;
                        preferredAvd = null;
                        if (config.mAvdName != null) {
                            preferredAvd = avdManager.getAvd(config.mAvdName, true);
                        }
                        if (preferredAvd != null && (preferredAvdTarget = preferredAvd.getTarget()) != null && !preferredAvdTarget.getVersion().canRun(minApiVersion)) {
                            preferredAvd = null;
                            AdtPlugin.printErrorToConsole(project, new Object[]{String.format("Preferred AVD '%1$s' (API Level: %2$d) cannot run application with minApi %3$s. Looking for a compatible AVD...", new Object[]{config.mAvdName, preferredAvdTarget.getVersion().getApiLevel(), minApiVersion})});
                        }
                        if (preferredAvd == null) break block28;
                        var28_29 = devices;
                        var27_33 = devices.length;
                        var26_35 = 0;
                        if (true) ** GOTO lbl62
                    }
                    if (minApiCodeName == null || minApiLevel >= projectTarget.getVersion().getApiLevel()) break block29;
                    maxDist = projectTarget.getVersion().getApiLevel() - minApiLevel;
                    candidate = null;
                    var30_42 = currentSdk.getTargets();
                    deviceAvd = var30_42.length;
                    var28_30 = 0;
                    if (true) ** GOTO lbl73
                }
                if ((config.mTargetMode == AndroidLaunchConfiguration.TargetMode.ALL_DEVICES_AND_EMULATORS || config.mTargetMode == AndroidLaunchConfiguration.TargetMode.ALL_DEVICES || config.mTargetMode == AndroidLaunchConfiguration.TargetMode.ALL_EMULATORS) && "run".equals(mode)) {
                    includeDevices = config.mTargetMode != AndroidLaunchConfiguration.TargetMode.ALL_EMULATORS;
                    compatibleDevices = this.findCompatibleDevices(devices, minApiVersion, includeDevices, includeAvds = config.mTargetMode != AndroidLaunchConfiguration.TargetMode.ALL_DEVICES);
                    if (compatibleDevices.size() == 0) {
                        AdtPlugin.printErrorToConsole(project, new Object[]{"No active compatible AVD's or devices found. Relaunch this configuration after connecting a device or starting an AVD."});
                        this.stopLaunch(launchInfo);
                        return;
                    }
                    this.multiLaunch(launchInfo, compatibleDevices);
                    return;
                }
                break block30;
                do {
                    if ((deviceAvd = (d = var28_29[var26_35]).getAvdName()) != null && deviceAvd.equals(config.mAvdName)) {
                        response.setDeviceToUse(d);
                        AdtPlugin.printToConsole(project, new Object[]{String.format("Automatic Target Mode: Preferred AVD '%1$s' is available on emulator '%2$s'", new Object[]{config.mAvdName, d})});
                        this.continueLaunch(response, project, launch, launchInfo, config);
                        return;
                    }
                    ++var26_35;
lbl62:
                    // 2 sources

                } while (var26_35 < var27_33);
                response.setAvdToLaunch(preferredAvd);
                AdtPlugin.printToConsole(project, new Object[]{String.format("Automatic Target Mode: Preferred AVD '%1$s' is not available. Launching new emulator.", new Object[]{config.mAvdName})});
                this.continueLaunch(response, project, launch, launchInfo, config);
                return;
                do {
                    if ((target = var30_42[var28_30]).canRunOn(projectTarget) && (currDist = target.getVersion().getApiLevel() - minApiLevel) >= 0 && currDist < maxDist) {
                        maxDist = currDist;
                        candidate = target;
                        if (maxDist == 0) break;
                    }
                    ++var28_30;
lbl73:
                    // 2 sources

                } while (var28_30 < deviceAvd);
                if (candidate != null) {
                    projectTarget = candidate;
                }
            }
            compatibleRunningAvds = new HashMap<IDevice, AvdInfo>();
            hasDevice = false;
            var30_42 = devices;
            deviceAvd = devices.length;
            var28_30 = 0;
            while (var28_30 < deviceAvd) {
                d = var30_42[var28_30];
                deviceAvd = d.getAvdName();
                if (deviceAvd != null) {
                    info = avdManager.getAvd(deviceAvd, true);
                    if (AvdCompatibility.canRun(info, projectTarget, minApiVersion) == AvdCompatibility.Compatibility.YES) {
                        compatibleRunningAvds.put(d, info);
                    }
                } else if (projectTarget.isPlatform() && (deviceVersion = Sdk.getDeviceVersion(d)) != null && deviceVersion.canRun(projectTarget.getVersion())) {
                    compatibleRunningAvds.put(d, null);
                } else {
                    hasDevice = true;
                }
                ++var28_30;
            }
            if (!hasDevice && compatibleRunningAvds.size() == 0) {
                defaultAvd = this.findMatchingAvd(avdManager, projectTarget, minApiVersion);
                if (defaultAvd != null) {
                    response.setAvdToLaunch(defaultAvd);
                    AdtPlugin.printToConsole(project, new Object[]{String.format("Automatic Target Mode: launching new emulator with compatible AVD '%1$s'", new Object[]{defaultAvd.getName()})});
                    this.continueLaunch(response, project, launch, launchInfo, config);
                    return;
                }
                AdtPlugin.printToConsole(project, new Object[]{String.format("Failed to find an AVD compatible with target '%1$s'.", new Object[]{projectTarget.getName()})});
                display = AdtPlugin.getDisplay();
                searchAgain = new boolean[1];
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = display.getActiveShell();
                        if (MessageDialog.openQuestion((Shell)shell, (String)"Android AVD Error", (String)"No compatible targets were found. Do you wish to add a new Android Virtual Device?")) {
                            AvdManagerAction action = new AvdManagerAction();
                            action.run(null);
                            searchAgain[0] = true;
                        }
                    }
                });
                if (searchAgain[0]) {
                    defaultAvd = this.findMatchingAvd(avdManager, projectTarget, minApiVersion);
                    if (defaultAvd != null) {
                        response.setAvdToLaunch(defaultAvd);
                        AdtPlugin.printToConsole(project, new Object[]{String.format("Launching new emulator with compatible AVD '%1$s'", new Object[]{defaultAvd.getName()})});
                        this.continueLaunch(response, project, launch, launchInfo, config);
                        return;
                    }
                    AdtPlugin.printErrorToConsole(project, new Object[]{String.format("Still no compatible AVDs with target '%1$s': Aborting launch.", new Object[]{projectTarget.getName()})});
                    this.stopLaunch(launchInfo);
                }
            } else if (!hasDevice && compatibleRunningAvds.size() == 1) {
                e = compatibleRunningAvds.entrySet().iterator().next();
                response.setDeviceToUse((IDevice)e.getKey());
                avdInfo = (AvdInfo)e.getValue();
                message = avdInfo != null ? String.format("Automatic Target Mode: using existing emulator '%1$s' running compatible AVD '%2$s'", new Object[]{response.getDeviceToUse(), ((AvdInfo)e.getValue()).getName()}) : String.format("Automatic Target Mode: using device '%1$s'", new Object[]{response.getDeviceToUse()});
                AdtPlugin.printToConsole(project, new Object[]{message});
                this.continueLaunch(response, project, launch, launchInfo, config);
                return;
            }
            if (compatibleRunningAvds.size() >= 2) {
                message = "Automatic Target Mode: Several compatible targets. Please select a target device.";
            } else if (hasDevice) {
                message = "Automatic Target Mode: Unable to detect device compatibility. Please select a target device.";
            }
            AdtPlugin.printToConsole(project, new Object[]{message});
        }
        desiredProjectTarget = projectTarget;
        continueLaunch = new AtomicBoolean(false);
        AdtPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DeviceChooserDialog dialog = new DeviceChooserDialog(AdtPlugin.getShell(), response, launchInfo.getPackageName(), desiredProjectTarget, minApiVersion);
                    if (dialog.open() != 0) {
                        AdtPlugin.printErrorToConsole(project, new Object[]{"Launch canceled!"});
                        AndroidLaunchController.this.stopLaunch(launchInfo);
                        return;
                    }
                    DeviceChoiceCache.put(launch.getLaunchConfiguration().getName(), response);
                    continueLaunch.set(true);
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.getClass().getCanonicalName();
                    }
                    AdtPlugin.printErrorToConsole(project, new Object[]{String.format("Error during launch: %s", msg)});
                    AndroidLaunchController.this.stopLaunch(launchInfo);
                }
            }
        });
        if (continueLaunch.get() == false) return;
        this.continueLaunch(response, project, launch, launchInfo, config);
    }

    private Collection<IDevice> findCompatibleDevices(IDevice[] devices, AndroidVersion requiredVersion, boolean includeDevices, boolean includeAvds) {
        HashSet<IDevice> compatibleDevices = new HashSet<IDevice>(devices.length);
        AvdManager avdManager = Sdk.getCurrent().getAvdManager();
        IDevice[] iDeviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                boolean canRun;
                IDevice d;
                block10: {
                    block8: {
                        d = iDeviceArray[n2];
                        boolean isEmulator = d.isEmulator();
                        canRun = false;
                        if (!isEmulator) break block8;
                        if (!includeAvds) break block9;
                        AvdInfo avdInfo = avdManager.getAvd(d.getAvdName(), true);
                        if (avdInfo != null && avdInfo.getTarget() != null) {
                            canRun = avdInfo.getTarget().getVersion().canRun(requiredVersion);
                        }
                        break block10;
                    }
                    if (!includeDevices) break block9;
                    AndroidVersion deviceVersion = Sdk.getDeviceVersion(d);
                    if (deviceVersion != null) {
                        canRun = deviceVersion.canRun(requiredVersion);
                    }
                }
                if (canRun) {
                    compatibleDevices.add(d);
                }
            }
            ++n2;
        }
        return compatibleDevices;
    }

    private AvdInfo findMatchingAvd(AvdManager avdManager, IAndroidTarget projectTarget, AndroidVersion minApiVersion) {
        AvdInfo[] avds = avdManager.getValidAvds();
        AvdInfo bestAvd = null;
        AvdInfo[] avdInfoArray = avds;
        int n = avds.length;
        int n2 = 0;
        while (n2 < n) {
            AvdInfo avd = avdInfoArray[n2];
            if (AvdCompatibility.canRun(avd, projectTarget, minApiVersion) == AvdCompatibility.Compatibility.YES && (bestAvd == null || avd.getTarget().getVersion().getApiLevel() < bestAvd.getTarget().getVersion().getApiLevel())) {
                bestAvd = avd;
            }
            ++n2;
        }
        return bestAvd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void continueLaunch(DeviceChooserDialog.DeviceChooserResponse response, IProject project, AndroidLaunch launch, DelayedLaunchInfo launchInfo, AndroidLaunchConfiguration config) {
        if (response.getAvdToLaunch() != null) {
            Object object = sListLock;
            synchronized (object) {
                AvdInfo info = response.getAvdToLaunch();
                this.mWaitingForEmulatorLaunches.add(launchInfo);
                AdtPlugin.printToConsole(project, String.format("Launching a new emulator with Virtual Device '%1$s'", info.getName()));
                boolean status = this.launchEmulator(config, info);
                if (!status) {
                    AdtPlugin.displayError("Emulator Launch", "Couldn't launch the emulator! Make sure the SDK directory is properly setup and the emulator is not missing.");
                    this.mWaitingForEmulatorLaunches.remove(launchInfo);
                    AdtPlugin.printErrorToConsole(project, new Object[]{"Launch canceled!"});
                    this.stopLaunch(launchInfo);
                    return;
                }
                return;
            }
        }
        if (response.getDeviceToUse() != null) {
            launchInfo.setDevice(response.getDeviceToUse());
            this.simpleLaunch(launchInfo, launchInfo.getDevice());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getPortForConfig(ILaunchConfiguration launchConfig) {
        Object object = sListLock;
        synchronized (object) {
            Integer port = sRunningAppMap.get(launchConfig);
            if (port != null) {
                sRunningAppMap.remove(launchConfig);
                return port;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setPortLaunchConfigAssociation(ILaunchConfiguration launchConfig, int port) {
        Object object = sListLock;
        synchronized (object) {
            sRunningAppMap.put(launchConfig, port);
        }
    }

    private boolean checkBuildInfo(DelayedLaunchInfo launchInfo, IDevice device) {
        if (device != null) {
            String debuggableDevice;
            String deviceVersion = device.getProperty("ro.build.version.release");
            String deviceApiLevelString = device.getProperty("ro.build.version.sdk");
            String deviceCodeName = device.getProperty("ro.build.version.codename");
            int deviceApiLevel = -1;
            try {
                deviceApiLevel = Integer.parseInt(deviceApiLevelString);
            }
            catch (NumberFormatException numberFormatException) {}
            String requiredApiString = launchInfo.getRequiredApiVersionNumber();
            if (requiredApiString != null) {
                int requiredApi = -1;
                try {
                    requiredApi = Integer.parseInt(requiredApiString);
                }
                catch (NumberFormatException numberFormatException) {}
                if (requiredApi == -1) {
                    if (!requiredApiString.equals(deviceCodeName)) {
                        AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format("ERROR: Application requires a device running '%1$s'!", requiredApiString)});
                        return false;
                    }
                } else if (deviceApiLevel == -1) {
                    AdtPlugin.printToConsole(launchInfo.getProject(), "WARNING: Unknown device API version!");
                } else if (deviceApiLevel < requiredApi) {
                    String msg = String.format("ERROR: Application requires API version %1$d. Device API version is %2$d (Android %3$s).", requiredApi, deviceApiLevel, deviceVersion);
                    AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg});
                    return false;
                }
            } else {
                AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"WARNING: Application does not specify an API level requirement!"});
                if (deviceApiLevel == -1) {
                    AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"WARNING: Unknown device API version!"});
                } else {
                    AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format("Device API version is %1$d (Android %2$s)", deviceApiLevel, deviceVersion)});
                }
            }
            if (!device.isEmulator() && launchInfo.isDebugMode() && (debuggableDevice = device.getProperty("ro.debuggable")) != null && debuggableDevice.equals("0") && launchInfo.getDebuggable() == Boolean.FALSE) {
                String message = String.format("Application '%1$s' has its 'debuggable' attribute set to FALSE and cannot be debugged.", launchInfo.getPackageName());
                AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{message});
                launchInfo.setDebugMode(false);
            }
        }
        return true;
    }

    private boolean simpleLaunch(DelayedLaunchInfo launchInfo, IDevice device) {
        if (!this.doPreLaunchActions(launchInfo, device)) {
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Launch canceled!"});
            this.stopLaunch(launchInfo);
            return false;
        }
        this.launchApp(launchInfo, device);
        return true;
    }

    private boolean doPreLaunchActions(DelayedLaunchInfo launchInfo, IDevice device) {
        if (!this.checkBuildInfo(launchInfo, device)) {
            return false;
        }
        return this.syncApp(launchInfo, device);
    }

    private void multiLaunch(DelayedLaunchInfo launchInfo, Collection<IDevice> devices) {
        for (IDevice d : devices) {
            boolean success = this.doPreLaunchActions(launchInfo, d);
            if (success) continue;
            String deviceName = d.isEmulator() ? d.getAvdName() : d.getSerialNumber();
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Launch failed on device: " + deviceName});
        }
        this.doLaunchAction(launchInfo, devices);
        this.stopLaunch(launchInfo);
    }

    private boolean syncApp(DelayedLaunchInfo launchInfo, IDevice device) {
        boolean alreadyInstalled = ApkInstallManager.getInstance().isApplicationInstalled(launchInfo.getProject(), launchInfo.getPackageName(), device);
        if (alreadyInstalled) {
            AdtPlugin.printToConsole(launchInfo.getProject(), "Application already deployed. No need to reinstall.");
        } else if (!this.doSyncApp(launchInfo, device)) {
            return false;
        }
        for (DelayedLaunchInfo dependentLaunchInfo : this.getDependenciesLaunchInfo(launchInfo)) {
            String msg = String.format("Project dependency found, installing: %s", dependentLaunchInfo.getProject().getName());
            AdtPlugin.printToConsole(launchInfo.getProject(), msg);
            if (this.syncApp(dependentLaunchInfo, device)) continue;
            return false;
        }
        return true;
    }

    private boolean doSyncApp(DelayedLaunchInfo launchInfo, IDevice device) {
        IPath path = launchInfo.getPackageFile().getLocation();
        String fileName = path.lastSegment();
        try {
            String message = String.format("Uploading %1$s onto device '%2$s'", fileName, device.getSerialNumber());
            AdtPlugin.printToConsole(launchInfo.getProject(), message);
            String remotePackagePath = device.syncPackageToDevice(path.toOSString());
            boolean installResult = this.installPackage(launchInfo, remotePackagePath, device);
            device.removeRemotePackage(remotePackagePath);
            if (installResult) {
                ApkInstallManager.getInstance().registerInstallation(launchInfo.getProject(), launchInfo.getPackageName(), device);
            }
            return installResult;
        }
        catch (IOException e) {
            String msg = String.format("Failed to install %1$s on device '%2$s': %3$s", fileName, device.getSerialNumber(), e.getMessage());
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg, e});
        }
        catch (TimeoutException timeoutException) {
            String msg = String.format("Failed to install %1$s on device '%2$s': timeout", fileName, device.getSerialNumber());
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg});
        }
        catch (AdbCommandRejectedException e) {
            String msg = String.format("Failed to install %1$s on device '%2$s': adb rejected install command with: %3$s", fileName, device.getSerialNumber(), e.getMessage());
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg, e});
        }
        catch (CanceledException e) {
            if (e.wasCanceled()) {
                AdtPlugin.printToConsole(launchInfo.getProject(), String.format("Install of %1$s canceled", fileName));
            }
            String msg = String.format("Failed to install %1$s on device '%2$s': %3$s", fileName, device.getSerialNumber(), e.getMessage());
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg, e});
        }
        return false;
    }

    public List<DelayedLaunchInfo> getDependenciesLaunchInfo(DelayedLaunchInfo launchInfo) {
        List<IJavaProject> androidProjectList;
        IJavaProject javaProject;
        ArrayList<DelayedLaunchInfo> dependencies = new ArrayList<DelayedLaunchInfo>();
        try {
            javaProject = BaseProjectHelper.getJavaProject(launchInfo.getProject());
        }
        catch (CoreException e) {
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{e});
            return dependencies;
        }
        try {
            androidProjectList = ProjectHelper.getAndroidProjectDependencies(javaProject);
        }
        catch (JavaModelException e) {
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{e});
            return dependencies;
        }
        for (IJavaProject androidProject : androidProjectList) {
            IFile apk;
            ManifestData manifestData = AndroidManifestHelper.parseForData(androidProject.getProject());
            if (manifestData == null || (apk = ProjectHelper.getApplicationPackage(androidProject.getProject())) == null) continue;
            DelayedLaunchInfo delayedLaunchInfo = new DelayedLaunchInfo(androidProject.getProject(), manifestData.getPackage(), manifestData.getPackage(), launchInfo.getLaunchAction(), apk, manifestData.getDebuggable(), manifestData.getMinSdkVersionString(), launchInfo.getLaunch(), launchInfo.getMonitor());
            dependencies.add(delayedLaunchInfo);
        }
        return dependencies;
    }

    private boolean installPackage(DelayedLaunchInfo launchInfo, String remotePath, IDevice device) {
        String message = String.format("Installing %1$s...", launchInfo.getPackageFile().getName());
        AdtPlugin.printToConsole(launchInfo.getProject(), message);
        try {
            String result = this.doInstall(launchInfo, remotePath, device, true);
            return this.checkInstallResult(result, device, launchInfo, remotePath, DelayedLaunchInfo.InstallRetryMode.ALWAYS);
        }
        catch (Exception e) {
            String msg = String.format("Failed to install %1$s on device '%2$s!", launchInfo.getPackageFile().getName(), device.getSerialNumber());
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg, e.getMessage()});
            return false;
        }
    }

    private boolean checkInstallResult(String result, IDevice device, DelayedLaunchInfo launchInfo, String remotePath, DelayedLaunchInfo.InstallRetryMode retryMode) throws InstallException {
        if (result == null) {
            AdtPlugin.printToConsole(launchInfo.getProject(), "Success!");
            return true;
        }
        if (result.equals("INSTALL_FAILED_ALREADY_EXISTS")) {
            if (retryMode == DelayedLaunchInfo.InstallRetryMode.PROMPT) {
                boolean prompt = AdtPlugin.displayPrompt("Application Install", "A previous installation needs to be uninstalled before the new package can be installed.\nDo you want to uninstall?");
                if (prompt) {
                    retryMode = DelayedLaunchInfo.InstallRetryMode.ALWAYS;
                } else {
                    AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Installation error! The package already exists."});
                    return false;
                }
            }
            if (retryMode == DelayedLaunchInfo.InstallRetryMode.ALWAYS) {
                AdtPlugin.printToConsole(launchInfo.getProject(), "Application already exists. Attempting to re-install instead...");
                String res = this.doInstall(launchInfo, remotePath, device, true);
                return this.checkInstallResult(res, device, launchInfo, remotePath, DelayedLaunchInfo.InstallRetryMode.NEVER);
            }
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Installation error! The package already exists."});
        } else if (result.equals("INSTALL_FAILED_INVALID_APK")) {
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Installation failed due to invalid APK file!", "Please check logcat output for more details."});
        } else if (result.equals("INSTALL_FAILED_INVALID_URI")) {
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Installation failed due to invalid URI!", "Please check logcat output for more details."});
        } else if (result.equals("INSTALL_FAILED_COULDNT_COPY")) {
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format("Installation failed: Could not copy %1$s to its final location!", launchInfo.getPackageFile().getName()), "Please check logcat output for more details."});
        } else if (result.equals("INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES")) {
            boolean prompt;
            if (retryMode != DelayedLaunchInfo.InstallRetryMode.NEVER && (prompt = AdtPlugin.displayPrompt("Application Install", "Re-installation failed due to different application signatures. You must perform a full uninstall of the application. WARNING: This will remove the application data!\nDo you want to uninstall?"))) {
                this.doUninstall(device, launchInfo);
                String res = this.doInstall(launchInfo, remotePath, device, false);
                return this.checkInstallResult(res, device, launchInfo, remotePath, DelayedLaunchInfo.InstallRetryMode.NEVER);
            }
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Re-installation failed due to different application signatures.", "You must perform a full uninstall of the application. WARNING: This will remove the application data!", String.format("Please execute 'adb uninstall %1$s' in a shell.", launchInfo.getPackageName())});
        } else {
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format("Installation error: %1$s", result), "Please check logcat output for more details."});
        }
        return false;
    }

    private String doUninstall(IDevice device, DelayedLaunchInfo launchInfo) throws InstallException {
        try {
            return device.uninstallPackage(launchInfo.getPackageName());
        }
        catch (InstallException e) {
            String msg = String.format("Failed to uninstall %1$s: %2$s", launchInfo.getPackageName(), e.getMessage());
            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg});
            throw e;
        }
    }

    private String doInstall(DelayedLaunchInfo launchInfo, String remotePath, IDevice device, boolean reinstall) throws InstallException {
        return device.installRemotePackage(remotePath, reinstall, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchApp(DelayedLaunchInfo info, IDevice device) {
        if (info.isDebugMode()) {
            Object object = sListLock;
            synchronized (object) {
                if (!this.mWaitingForDebuggerApplications.contains(info)) {
                    this.mWaitingForDebuggerApplications.add(info);
                }
            }
        }
        if (this.doLaunchAction(info, device)) {
            if (!info.isDebugMode()) {
                this.stopLaunch(info);
            }
        } else {
            this.stopLaunch(info);
        }
    }

    private boolean doLaunchAction(DelayedLaunchInfo info, Collection<IDevice> devices) {
        boolean result = info.getLaunchAction().doLaunchAction(info, devices);
        for (IDevice d : devices) {
            DdmsPlugin.getDefault().startLogCatMonitor(d);
        }
        return result;
    }

    private boolean doLaunchAction(DelayedLaunchInfo info, IDevice device) {
        return this.doLaunchAction(info, Collections.singletonList(device));
    }

    private boolean launchEmulator(AndroidLaunchConfiguration config, AvdInfo avdToLaunch) {
        boolean needsWipeData;
        ArrayList<String> customArgs = new ArrayList<String>();
        boolean hasWipeData = false;
        if (config.mEmulatorCommandLine != null && config.mEmulatorCommandLine.length() > 0) {
            String[] segments;
            String[] stringArray = segments = config.mEmulatorCommandLine.split("\\s+");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.length() > 0) {
                    customArgs.add(s);
                    if (!hasWipeData && s.equals(FLAG_WIPE_DATA)) {
                        hasWipeData = true;
                    }
                }
                ++n2;
            }
        }
        boolean bl = needsWipeData = config.mWipeData && !hasWipeData;
        if (needsWipeData && !AdtPlugin.displayPrompt("Android Launch", "Are you sure you want to wipe all user data when starting this emulator?")) {
            needsWipeData = false;
        }
        ArrayList<String> list = new ArrayList<String>();
        String path = AdtPlugin.getOsAbsoluteEmulator();
        list.add(path);
        list.add(FLAG_AVD);
        list.add(avdToLaunch.getName());
        if (config.mNetworkSpeed != null) {
            list.add(FLAG_NETSPEED);
            list.add(config.mNetworkSpeed);
        }
        if (config.mNetworkDelay != null) {
            list.add(FLAG_NETDELAY);
            list.add(config.mNetworkDelay);
        }
        if (needsWipeData) {
            list.add(FLAG_WIPE_DATA);
        }
        if (config.mNoBootAnim) {
            list.add(FLAG_NO_BOOT_ANIM);
        }
        list.addAll(customArgs);
        String[] command = list.toArray(new String[list.size()]);
        try {
            Process process = Runtime.getRuntime().exec(command);
            this.grabEmulatorOutput(process);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static ILaunchConfiguration findConfig(ILaunchManager manager, ILaunchConfigurationType type, String projectName) {
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(type);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectName)) {
                    return config;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)AdtPlugin.getShell(), (String)"Launch Error", (String)e.getStatus().getMessage());
        }
        return null;
    }

    public static boolean connectRemoteDebugger(int debugPort, AndroidLaunch launch, IProgressMonitor monitor) throws CoreException {
        int connectTimeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("hostname", "localhost");
        newMap.put("port", Integer.toString(debugPort));
        newMap.put("timeout", Integer.toString(connectTimeout));
        IVMConnector connector = JavaRuntime.getDefaultVMConnector();
        connector.connect(newMap, monitor, (ILaunch)launch);
        if (monitor.isCanceled()) {
            IDebugTarget[] debugTargets;
            IDebugTarget[] iDebugTargetArray = debugTargets = launch.getDebugTargets();
            int n = debugTargets.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget target = iDebugTargetArray[n2];
                if (target.canDisconnect()) {
                    target.disconnect();
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public static void launchRemoteDebugger(final int debugPort, final AndroidLaunch androidLaunch, final IProgressMonitor monitor) {
        new Thread("Debugger connection"){

            @Override
            public void run() {
                try {
                    AndroidLaunchController.connectRemoteDebugger(debugPort, androidLaunch, monitor);
                }
                catch (CoreException coreException) {
                    androidLaunch.stopLaunch();
                }
                monitor.done();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bridgeChanged(AndroidDebugBridge bridge) {
        String message = "adb server change: cancelling '%1$s'!";
        Object object = sListLock;
        synchronized (object) {
            for (DelayedLaunchInfo launchInfo : this.mWaitingForReadyEmulatorList) {
                AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format(message, launchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(launchInfo);
            }
            for (DelayedLaunchInfo launchInfo : this.mWaitingForDebuggerApplications) {
                AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format(message, launchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(launchInfo);
            }
            this.mWaitingForReadyEmulatorList.clear();
            this.mWaitingForDebuggerApplications.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceConnected(IDevice device) {
        Object object = sListLock;
        synchronized (object) {
            if (this.mWaitingForEmulatorLaunches.size() > 0) {
                DelayedLaunchInfo launchInfo = this.mWaitingForEmulatorLaunches.get(0);
                this.mWaitingForEmulatorLaunches.remove(0);
                launchInfo.setDevice(device);
                this.mWaitingForReadyEmulatorList.add(launchInfo);
                AdtPlugin.printToConsole(launchInfo.getProject(), String.format("New emulator found: %1$s", device.getSerialNumber()));
                AdtPlugin.printToConsole(launchInfo.getProject(), String.format("Waiting for HOME ('%1$s') to be launched...", AdtPlugin.getDefault().getPreferenceStore().getString("com.android.ide.eclipse.adt.homePackage")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDisconnected(IDevice device) {
        String message = "%1$s disconnected! Cancelling '%2$s'!";
        Object object = sListLock;
        synchronized (object) {
            ArrayList copyList = (ArrayList)this.mWaitingForReadyEmulatorList.clone();
            for (DelayedLaunchInfo launchInfo : copyList) {
                if (launchInfo.getDevice() != device) continue;
                AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format(message, device.getSerialNumber(), launchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(launchInfo);
            }
            copyList = (ArrayList)this.mWaitingForDebuggerApplications.clone();
            for (DelayedLaunchInfo launchInfo : copyList) {
                if (launchInfo.getDevice() != device) continue;
                AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format(message, device.getSerialNumber(), launchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(launchInfo);
            }
        }
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientChanged(final Client client, int changeMask) {
        Object applicationName;
        Object home;
        String applicationName2;
        boolean connectDebugger = false;
        if ((changeMask & 1) == 1 && (applicationName2 = client.getClientData().getClientDescription()) != null) {
            Object device;
            IPreferenceStore store = AdtPlugin.getDefault().getPreferenceStore();
            home = store.getString("com.android.ide.eclipse.adt.homePackage");
            if (((String)home).equals(applicationName2)) {
                device = client.getDevice();
                Object object = sListLock;
                synchronized (object) {
                    int i = 0;
                    while (i < this.mWaitingForReadyEmulatorList.size()) {
                        DelayedLaunchInfo launchInfo = this.mWaitingForReadyEmulatorList.get(i);
                        if (launchInfo.getDevice() == device) {
                            this.mWaitingForReadyEmulatorList.remove(i);
                            if (!this.checkBuildInfo(launchInfo, (IDevice)device)) {
                                AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Launch canceled!"});
                                this.stopLaunch(launchInfo);
                                return;
                            }
                            AdtPlugin.printToConsole(launchInfo.getProject(), String.format("HOME is up on device '%1$s'", device.getSerialNumber()));
                            if (this.syncApp(launchInfo, (IDevice)device)) {
                                this.launchApp(launchInfo, (IDevice)device);
                                break;
                            }
                            AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Launch canceled!"});
                            this.stopLaunch(launchInfo);
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (client.getClientData().getDebuggerConnectionStatus() == ClientData.DebuggerStatus.WAITING) {
                device = sListLock;
                synchronized (device) {
                    int index = this.mUnknownClientsWaitingForDebugger.indexOf(client);
                    if (index != -1) {
                        connectDebugger = true;
                        this.mUnknownClientsWaitingForDebugger.remove(client);
                    }
                }
            }
        }
        if ((changeMask & 2) == 2) {
            ClientData clientData = client.getClientData();
            applicationName = client.getClientData().getClientDescription();
            if (clientData.getDebuggerConnectionStatus() == ClientData.DebuggerStatus.WAITING) {
                if (applicationName == null) {
                    home = sListLock;
                    synchronized (home) {
                        this.mUnknownClientsWaitingForDebugger.add(client);
                    }
                    return;
                }
                connectDebugger = true;
            }
        }
        if (connectDebugger) {
            Log.d((String)"adt", (String)("Debugging " + client));
            applicationName2 = client.getClientData().getClientDescription();
            Log.d((String)"adt", (String)("App Name: " + applicationName2));
            applicationName = sListLock;
            synchronized (applicationName) {
                int i = 0;
                while (i < this.mWaitingForDebuggerApplications.size()) {
                    final DelayedLaunchInfo launchInfo = this.mWaitingForDebuggerApplications.get(i);
                    if (client.getDevice() == launchInfo.getDevice() && applicationName2.equals(launchInfo.getDebugPackageName())) {
                        this.mWaitingForDebuggerApplications.remove(i);
                        String msg = String.format("Attempting to connect debugger to '%1$s' on port %2$d", launchInfo.getDebugPackageName(), client.getDebuggerListenPort());
                        AdtPlugin.printToConsole(launchInfo.getProject(), msg);
                        new Thread("Debugger Connection"){

                            @Override
                            public void run() {
                                try {
                                    if (!AndroidLaunchController.connectRemoteDebugger(client.getDebuggerListenPort(), launchInfo.getLaunch(), launchInfo.getMonitor())) {
                                        return;
                                    }
                                }
                                catch (CoreException e) {
                                    AdtPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format("Launch error: %s", e.getMessage())});
                                    AndroidLaunchController.this.stopLaunch(launchInfo);
                                }
                                launchInfo.getMonitor().done();
                            }
                        }.start();
                        return;
                    }
                    ++i;
                }
            }
            IProject project = ProjectHelper.findAndroidProjectByAppName(applicationName2);
            if (project != null) {
                AndroidLaunchController.debugRunningApp(project, client.getDebuggerListenPort());
            }
        }
    }

    private void grabEmulatorOutput(final Process process) {
        new Thread(""){

            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream());
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        AdtPlugin.printErrorToConsole("Emulator", line);
                    }
                }
                catch (IOException iOException) {}
            }
        }.start();
        new Thread(""){

            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream());
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        AdtPlugin.printToConsole("Emulator", line);
                    }
                }
                catch (IOException iOException) {}
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLaunch(DelayedLaunchInfo launchInfo) {
        launchInfo.getLaunch().stopLaunch();
        Object object = sListLock;
        synchronized (object) {
            this.mWaitingForReadyEmulatorList.remove(launchInfo);
            this.mWaitingForDebuggerApplications.remove(launchInfo);
        }
    }
}

