/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.ActivityLaunchAction;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunch;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchConfiguration;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchController;
import com.android.ide.eclipse.adt.internal.launch.EmptyLaunchAction;
import com.android.ide.eclipse.adt.internal.launch.IAndroidLaunchAction;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class LaunchConfigDelegate
extends LaunchConfigurationDelegate {
    static final int INVALID_DEBUG_PORT = -1;
    public static final String ANDROID_LAUNCH_TYPE_ID = "com.android.ide.eclipse.adt.debug.LaunchConfigType";
    public static final String ATTR_TARGET_MODE = "com.android.ide.eclipse.adt.target";
    public static final AndroidLaunchConfiguration.TargetMode DEFAULT_TARGET_MODE = AndroidLaunchConfiguration.TargetMode.AUTO;
    public static final String ATTR_LAUNCH_ACTION = "com.android.ide.eclipse.adt.action";
    public static final int ACTION_DEFAULT = 0;
    public static final int ACTION_ACTIVITY = 1;
    public static final int ACTION_DO_NOTHING = 2;
    public static final int DEFAULT_LAUNCH_ACTION = 0;
    public static final String ATTR_ACTIVITY = "com.android.ide.eclipse.adt.activity";
    public static final String ATTR_AVD_NAME = "com.android.ide.eclipse.adt.avd";
    public static final String ATTR_SPEED = "com.android.ide.eclipse.adt.speed";
    public static final int DEFAULT_SPEED = 0;
    public static final String ATTR_DELAY = "com.android.ide.eclipse.adt.delay";
    public static final int DEFAULT_DELAY = 0;
    public static final String ATTR_COMMANDLINE = "com.android.ide.eclipse.adt.commandline";
    public static final String ATTR_WIPE_DATA = "com.android.ide.eclipse.adt.wipedata";
    public static final boolean DEFAULT_WIPE_DATA = false;
    public static final String ATTR_NO_BOOT_ANIM = "com.android.ide.eclipse.adt.nobootanim";
    public static final boolean DEFAULT_NO_BOOT_ANIM = false;
    public static final String ATTR_DEBUG_PORT = "com.android.ide.eclipse.adt.debugPort";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        int debugPort = AndroidLaunchController.getPortForConfig(configuration);
        IProject project = this.getProject(configuration);
        AndroidLaunch androidLaunch = null;
        if (!(launch instanceof AndroidLaunch)) {
            AdtPlugin.printErrorToConsole(project, new Object[]{"Wrong Launch Type!"});
            return;
        }
        androidLaunch = (AndroidLaunch)launch;
        if (debugPort != -1) {
            AndroidLaunchController.launchRemoteDebugger(debugPort, androidLaunch, monitor);
            return;
        }
        if (project == null) {
            AdtPlugin.printErrorToConsole("Couldn't get project object!", new Object[0]);
            androidLaunch.stopLaunch();
            return;
        }
        ProjectHelper.doFullIncrementalDebugBuild(project, monitor);
        if (ProjectHelper.hasError(project, true)) {
            AdtPlugin.displayError("Android Launch", "Your project contains error(s), please fix them before running your application.");
            return;
        }
        AdtPlugin.printToConsole(project, "------------------------------");
        AdtPlugin.printToConsole(project, "Android Launch!");
        if (!this.checkAndroidProject(project)) {
            AdtPlugin.printErrorToConsole(project, new Object[]{"Project is not an Android Project. Aborting!"});
            androidLaunch.stopLaunch();
            return;
        }
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null || !bridge.isConnected()) {
            try {
                int connections = -1;
                int restarts = -1;
                if (bridge != null) {
                    connections = bridge.getConnectionAttemptCount();
                    restarts = bridge.getRestartAttemptCount();
                }
                if (connections == -1 || restarts == -1) {
                    AdtPlugin.printErrorToConsole(project, new Object[]{"The connection to adb is down, and a severe error has occured.", "You must restart adb and Eclipse.", String.format("Please ensure that adb is correctly located at '%1$s' and can be executed.", AdtPlugin.getOsAbsoluteAdb())});
                    return;
                }
                if (restarts == 0) {
                    AdtPlugin.printErrorToConsole(project, new Object[]{"Connection with adb was interrupted.", String.format("%1$s attempts have been made to reconnect.", connections), "You may want to manually restart adb from the Devices view."});
                    return;
                }
                AdtPlugin.printErrorToConsole(project, new Object[]{"Connection with adb was interrupted, and attempts to reconnect have failed.", String.format("%1$s attempts have been made to restart adb.", restarts), "You may want to manually restart adb from the Devices view."});
                return;
            }
            finally {
                androidLaunch.stopLaunch();
            }
        }
        AdtPlugin.printToConsole(project, "adb is running normally.");
        AndroidLaunchConfiguration config = new AndroidLaunchConfiguration();
        config.set(configuration);
        AndroidLaunchController controller = AndroidLaunchController.getInstance();
        IFile applicationPackage = ProjectHelper.getApplicationPackage(project);
        if (applicationPackage == null) {
            androidLaunch.stopLaunch();
            return;
        }
        ManifestData manifestData = AndroidManifestHelper.parseForData(project);
        if (manifestData == null) {
            AdtPlugin.printErrorToConsole(project, new Object[]{"Failed to parse AndroidManifest: aborting!"});
            androidLaunch.stopLaunch();
            return;
        }
        this.doLaunch(configuration, mode, monitor, project, androidLaunch, config, controller, applicationPackage, manifestData);
    }

    protected void doLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor, IProject project, AndroidLaunch androidLaunch, AndroidLaunchConfiguration config, AndroidLaunchController controller, IFile applicationPackage, ManifestData manifestData) {
        String activityName = null;
        if (config.mLaunchAction == 1) {
            activityName = this.getActivityName(configuration);
            ManifestData.Activity[] activities = manifestData.getActivities();
            if (activities.length == 0) {
                AdtPlugin.printErrorToConsole(project, new Object[]{"The Manifest defines no activity!", "The launch will only sync the application package on the device!"});
                config.mLaunchAction = 2;
            } else if (activityName == null) {
                AdtPlugin.printErrorToConsole(project, new Object[]{"No activity specified! Getting the launcher activity."});
                ManifestData.Activity launcherActivity = manifestData.getLauncherActivity();
                if (launcherActivity != null) {
                    activityName = launcherActivity.getName();
                }
                if (activityName == null) {
                    this.revertToNoActionLaunch(project, config);
                }
            } else {
                boolean match = false;
                ManifestData.Activity[] activityArray = activities;
                int n = activities.length;
                int n2 = 0;
                while (n2 < n) {
                    ManifestData.Activity a = activityArray[n2];
                    if (a != null && a.getName().equals(activityName)) {
                        match = true;
                        break;
                    }
                    ++n2;
                }
                if (!match) {
                    AdtPlugin.printErrorToConsole(project, new Object[]{"The specified activity does not exist! Getting the launcher activity."});
                    ManifestData.Activity launcherActivity = manifestData.getLauncherActivity();
                    if (launcherActivity != null) {
                        activityName = launcherActivity.getName();
                    } else {
                        this.revertToNoActionLaunch(project, config);
                    }
                }
            }
        } else if (config.mLaunchAction == 0) {
            ManifestData.Activity launcherActivity = manifestData.getLauncherActivity();
            if (launcherActivity != null) {
                activityName = launcherActivity.getName();
            }
            if (activityName == null) {
                this.revertToNoActionLaunch(project, config);
            }
        }
        IAndroidLaunchAction launchAction = null;
        launchAction = config.mLaunchAction == 2 || activityName == null ? new EmptyLaunchAction() : new ActivityLaunchAction(activityName, controller);
        controller.launch(project, mode, applicationPackage, manifestData.getPackage(), manifestData.getPackage(), manifestData.getDebuggable(), manifestData.getMinSdkVersionString(), launchAction, config, androidLaunch, monitor);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new AndroidLaunch(configuration, mode, null);
    }

    private IProject getProject(ILaunchConfiguration configuration) {
        String projectName;
        try {
            projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getProject(projectName);
    }

    private boolean checkAndroidProject(IProject project) throws CoreException {
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            String msg = String.format("%1$s is not a Java project!", project.getName());
            AdtPlugin.displayError("Android Launch", msg);
            return false;
        }
        if (!project.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
            String msg = String.format("%1$s is not an Android project!", project.getName());
            AdtPlugin.displayError("Android Launch", msg);
            return false;
        }
        return true;
    }

    private String getActivityName(ILaunchConfiguration configuration) {
        String activityName;
        String empty = "";
        try {
            activityName = configuration.getAttribute(ATTR_ACTIVITY, empty);
        }
        catch (CoreException coreException) {
            return null;
        }
        return activityName != empty ? activityName : null;
    }

    private final void revertToNoActionLaunch(IProject project, AndroidLaunchConfiguration config) {
        AdtPlugin.printErrorToConsole(project, new Object[]{"No Launcher activity found!", "The launch will only sync the application package on the device!"});
        config.mLaunchAction = 2;
    }
}

