/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.annotations.NonNull;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.lint.GlobalLintConfiguration;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

class ProjectLintConfiguration
extends DefaultConfiguration {
    private boolean mFatalOnly;
    private static final QualifiedName CONFIGURATION_NAME = new QualifiedName("com.android.ide.eclipse.adt", "lintconfig");

    ProjectLintConfiguration(LintClient client, Project project, Configuration parent, boolean fatalOnly) {
        super(client, project, parent);
        this.mFatalOnly = fatalOnly;
    }

    private static ProjectLintConfiguration create(LintClient client, IProject project, Configuration parent, boolean fatalOnly) {
        File dir = AdtUtils.getAbsolutePath((IResource)project).toFile();
        Project lintProject = client.getProject(dir, dir);
        return new ProjectLintConfiguration(client, lintProject, parent, fatalOnly);
    }

    public static ProjectLintConfiguration get(LintClient client, IProject project, boolean fatalOnly) {
        if (fatalOnly) {
            return ProjectLintConfiguration.create(client, project, GlobalLintConfiguration.get(), true);
        }
        ProjectLintConfiguration configuration = null;
        try {
            Object value = project.getSessionProperty(CONFIGURATION_NAME);
            configuration = (ProjectLintConfiguration)((Object)value);
        }
        catch (CoreException coreException) {}
        if (configuration == null) {
            configuration = ProjectLintConfiguration.create(client, project, GlobalLintConfiguration.get(), false);
            try {
                project.setSessionProperty(CONFIGURATION_NAME, (Object)configuration);
            }
            catch (CoreException e) {
                AdtPlugin.log(e, "Can't store lint configuration", new Object[0]);
            }
        }
        return configuration;
    }

    @NonNull
    public Severity getSeverity(@NonNull Issue issue) {
        Severity severity = super.getSeverity(issue);
        if (this.mFatalOnly && severity != Severity.FATAL) {
            return Severity.IGNORE;
        }
        return severity;
    }
}

