/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ide.eclipse.adt.internal.resources.manager.GlobalProjectMonitor;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public final class ApkInstallManager {
    private static final ApkInstallManager sThis = new ApkInstallManager();
    private final HashSet<ApkInstall> mInstallList = new HashSet();
    private AndroidDebugBridge.IDebugBridgeChangeListener mDebugBridgeListener = new AndroidDebugBridge.IDebugBridgeChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bridgeChanged(AndroidDebugBridge bridge) {
            HashSet hashSet = ApkInstallManager.this.mInstallList;
            synchronized (hashSet) {
                ApkInstallManager.this.mInstallList.clear();
            }
        }
    };
    private AndroidDebugBridge.IDeviceChangeListener mDeviceChangeListener = new AndroidDebugBridge.IDeviceChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deviceDisconnected(IDevice device) {
            HashSet hashSet = ApkInstallManager.this.mInstallList;
            synchronized (hashSet) {
                Iterator iterator = ApkInstallManager.this.mInstallList.iterator();
                while (iterator.hasNext()) {
                    ApkInstall install = (ApkInstall)iterator.next();
                    if (install.device != device) continue;
                    iterator.remove();
                }
            }
        }

        public void deviceChanged(IDevice device, int changeMask) {
        }

        public void deviceConnected(IDevice device) {
        }
    };
    private GlobalProjectMonitor.IProjectListener mProjectListener = new GlobalProjectMonitor.IProjectListener(){

        @Override
        public void projectClosed(IProject project) {
            ApkInstallManager.this.resetInstallationFor(project);
        }

        @Override
        public void projectDeleted(IProject project) {
            ApkInstallManager.this.resetInstallationFor(project);
        }

        @Override
        public void projectOpened(IProject project) {
        }

        @Override
        public void projectOpenedWithWorkspace(IProject project) {
        }

        @Override
        public void allProjectsOpenedWithWorkspace() {
        }

        @Override
        public void projectRenamed(IProject project, IPath from) {
        }
    };

    public static ApkInstallManager getInstance() {
        return sThis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstallation(IProject project, String packageName, IDevice device) {
        HashSet<ApkInstall> hashSet = this.mInstallList;
        synchronized (hashSet) {
            this.mInstallList.add(new ApkInstall(project, packageName, device));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isApplicationInstalled(IProject project, String packageName, IDevice device) {
        HashSet<ApkInstall> hashSet = this.mInstallList;
        synchronized (hashSet) {
            block8: {
                ApkInstall found = null;
                for (ApkInstall install : this.mInstallList) {
                    if (!project.equals((Object)install.project) || !packageName.equals(install.packageName) || device != install.device) continue;
                    found = install;
                    break;
                }
                if (found == null) break block8;
                try {
                    PmReceiver receiver = new PmReceiver();
                    found.device.executeShellCommand("pm path " + packageName, (IShellOutputReceiver)receiver);
                    if (!receiver.foundPackage) {
                        this.mInstallList.remove(found);
                    }
                    return receiver.foundPackage;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInstallationFor(IProject project) {
        HashSet<ApkInstall> hashSet = this.mInstallList;
        synchronized (hashSet) {
            Iterator<ApkInstall> iterator = this.mInstallList.iterator();
            while (iterator.hasNext()) {
                ApkInstall install = iterator.next();
                if (!install.project.equals((Object)project)) continue;
                iterator.remove();
            }
        }
    }

    private ApkInstallManager() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.mDeviceChangeListener);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.mDebugBridgeListener);
        GlobalProjectMonitor.getMonitor().addProjectListener(this.mProjectListener);
    }

    private static final class ApkInstall {
        final IProject project;
        final String packageName;
        final IDevice device;

        public ApkInstall(IProject project, String packageName, IDevice device) {
            this.project = project;
            this.packageName = packageName;
            this.device = device;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ApkInstall) {
                ApkInstall apkObj = (ApkInstall)obj;
                return this.device == apkObj.device && this.project.equals((Object)apkObj.project) && this.packageName.equals(apkObj.packageName);
            }
            return false;
        }

        public int hashCode() {
            return (String.valueOf(this.device.getSerialNumber()) + this.project.getName() + this.packageName).hashCode();
        }
    }

    private static final class PmReceiver
    extends MultiLineReceiver {
        boolean foundPackage = false;

        private PmReceiver() {
        }

        public void processNewLines(String[] lines) {
            if (!this.foundPackage) {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.startsWith("package:/")) {
                        this.foundPackage = true;
                        break;
                    }
                    ++n2;
                }
            }
        }

        public boolean isCancelled() {
            return false;
        }
    }
}

