/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;

abstract class BaseClasspathContainerInitializer
extends ClasspathContainerInitializer {
    BaseClasspathContainerInitializer() {
    }

    protected static void processError(final IProject project, String errorMessage, final String markerType, boolean outputToConsole) {
        if (errorMessage != null) {
            if (outputToConsole) {
                AdtPlugin.printErrorToConsole(project, new Object[]{errorMessage});
            }
            try {
                BaseProjectHelper.markProject(project, markerType, errorMessage, 2, 2);
            }
            catch (CoreException coreException) {
                final String fmessage = errorMessage;
                Job markerJob = new Job("Android SDK: Resolving error markers"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            BaseProjectHelper.markProject(project, markerType, fmessage, 2, 2);
                        }
                        catch (CoreException e2) {
                            AdtPlugin.log(e2, null, new Object[0]);
                        }
                        return Status.OK_STATUS;
                    }
                };
                markerJob.setPriority(40);
                markerJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                markerJob.schedule();
            }
        } else {
            try {
                if (project.isAccessible()) {
                    project.deleteMarkers(markerType, true, 2);
                }
            }
            catch (CoreException coreException) {
                Job markerJob = new Job("Android SDK: Resolving error markers"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            if (project.isAccessible()) {
                                project.deleteMarkers(markerType, true, 2);
                            }
                        }
                        catch (CoreException e2) {
                            AdtPlugin.log(e2, null, new Object[0]);
                        }
                        return Status.OK_STATUS;
                    }
                };
                markerJob.setPriority(40);
                markerJob.schedule();
            }
        }
    }
}

