/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.core;

import com.android.annotations.NonNull;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.refactorings.core.RefactoringUtil;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.resources.ResourceFolderType;
import com.android.utils.SdkUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidTypeMoveParticipant
extends MoveParticipant {
    private IProject mProject;
    protected IFile mManifestFile;
    protected String mOldFqcn;
    protected String mNewFqcn;
    protected String mAppPackage;

    public String getName() {
        return "Android Type Move";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            IJavaProject javaProject = (IJavaProject)type.getAncestor(2);
            this.mProject = javaProject.getProject();
            IResource manifestResource = this.mProject.findMember("/AndroidManifest.xml");
            if (manifestResource == null || !manifestResource.exists() || !(manifestResource instanceof IFile)) {
                RefactoringUtil.logInfo("Invalid or missing the AndroidManifest.xml in the " + this.mProject.getName() + " project.");
                return false;
            }
            this.mManifestFile = (IFile)manifestResource;
            ManifestData manifestData = AndroidManifestHelper.parseForData(this.mManifestFile);
            if (manifestData == null) {
                return false;
            }
            this.mAppPackage = manifestData.getPackage();
            this.mOldFqcn = type.getFullyQualifiedName();
            Object destination = this.getArguments().getDestination();
            if (destination instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)destination;
                this.mNewFqcn = String.valueOf(packageFragment.getElementName()) + "." + type.getElementName();
            } else if (destination instanceof IResource) {
                try {
                    IPackageFragment[] fragments;
                    IPackageFragment[] iPackageFragmentArray = fragments = javaProject.getPackageFragments();
                    int n = fragments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragment fragment = iPackageFragmentArray[n2];
                        IResource resource = fragment.getResource();
                        if (resource.equals(destination)) {
                            this.mNewFqcn = String.valueOf(fragment.getElementName()) + '.' + type.getElementName();
                            break;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            return this.mOldFqcn != null && this.mNewFqcn != null;
        }
        return false;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm.isCanceled()) {
            return null;
        }
        if (!this.getArguments().getUpdateReferences()) {
            return null;
        }
        CompositeChange result = new CompositeChange(this.getName());
        result.markAsSynthetic();
        this.addManifestFileChanges(result);
        this.addLayoutFileChanges(this.mProject, result);
        ProjectState projectState = Sdk.getProjectState(this.mProject);
        if (projectState != null) {
            Collection<ProjectState> parentProjects = projectState.getFullParentProjects();
            for (ProjectState parentProject : parentProjects) {
                IProject project = parentProject.getProject();
                this.addLayoutFileChanges(project, result);
            }
        }
        return result.getChildren().length == 0 ? null : result;
    }

    private void addManifestFileChanges(CompositeChange result) {
        this.addXmlFileChanges(this.mManifestFile, result, true);
    }

    private void addLayoutFileChanges(IProject project, CompositeChange result) {
        try {
            IResource[] folders;
            IFolder resFolder = project.getFolder("res");
            IResource[] iResourceArray = folders = resFolder.members();
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                IResource folder = iResourceArray[n2];
                String folderName = folder.getName();
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
                if (folderType == ResourceFolderType.LAYOUT && folder instanceof IFolder) {
                    IResource[] files = ((IFolder)folder).members();
                    int i = 0;
                    while (i < files.length) {
                        IResource member = files[i];
                        if (member instanceof IFile && member.exists()) {
                            IFile file = (IFile)member;
                            String fileName = member.getName();
                            if (SdkUtils.endsWith((CharSequence)fileName, (CharSequence)".xml")) {
                                this.addXmlFileChanges(file, result, false);
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            RefactoringUtil.log(e);
        }
    }

    private boolean addXmlFileChanges(IFile file, CompositeChange changes, boolean isManifest) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = modelManager.getExistingModelForRead(file);
            if (model == null) {
                model = modelManager.getModelForRead(file);
            }
            if (model != null) {
                IStructuredDocument document = model.getStructuredDocument();
                if (model instanceof IDOMModel) {
                    IDOMModel domModel = (IDOMModel)model;
                    Element root = domModel.getDocument().getDocumentElement();
                    if (root != null) {
                        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                        if (isManifest) {
                            this.addManifestReplacements(edits, root, document);
                        } else {
                            this.addLayoutReplacements(edits, root, document);
                        }
                        if (!edits.isEmpty()) {
                            MultiTextEdit rootEdit = new MultiTextEdit();
                            rootEdit.addChildren(edits.toArray(new TextEdit[edits.size()]));
                            TextFileChange change = new TextFileChange(file.getName(), file);
                            change.setTextType("xml");
                            change.setEdit((TextEdit)rootEdit);
                            changes.add((Change)change);
                        }
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }

    private void addLayoutReplacements(@NonNull List<TextEdit> edits, @NonNull Element element, @NonNull IStructuredDocument document) {
        Attr classNode;
        int end;
        int start;
        String tag = element.getTagName();
        if (tag.equals(this.mOldFqcn)) {
            int start2 = RefactoringUtil.getTagNameRangeStart(element, (IDocument)document);
            if (start2 != -1) {
                int end2 = start2 + this.mOldFqcn.length();
                edits.add((TextEdit)new ReplaceEdit(start2, end2 - start2, this.mNewFqcn));
            }
        } else if (tag.equals("view")) {
            Attr classNode2 = element.getAttributeNode("class");
            if (classNode2 != null && classNode2.getValue().equals(this.mOldFqcn) && (start = RefactoringUtil.getAttributeValueRangeStart(classNode2, (IDocument)document)) != -1) {
                end = start + this.mOldFqcn.length();
                edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewFqcn));
            }
        } else if (tag.equals("fragment")) {
            Attr classNode3 = element.getAttributeNode("class");
            if (classNode3 == null) {
                classNode3 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            }
            if (classNode3 != null && classNode3.getValue().equals(this.mOldFqcn) && (start = RefactoringUtil.getAttributeValueRangeStart(classNode3, (IDocument)document)) != -1) {
                end = start + this.mOldFqcn.length();
                edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewFqcn));
            }
        } else if (element.hasAttributeNS("http://schemas.android.com/tools", "context") && (classNode = element.getAttributeNodeNS("http://schemas.android.com/tools", "context")) != null && classNode.getValue().equals(this.mOldFqcn) && (start = RefactoringUtil.getAttributeValueRangeStart(classNode, (IDocument)document)) != -1) {
            end = start + this.mOldFqcn.length();
            edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewFqcn));
        }
        NodeList children = element.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.addLayoutReplacements(edits, (Element)child, document);
            }
            ++i;
        }
    }

    private void addManifestReplacements(@NonNull List<TextEdit> edits, @NonNull Element element, @NonNull IStructuredDocument document) {
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        int n = attributes.getLength();
        while (i < n) {
            Attr attr = (Attr)attributes.item(i);
            if (RefactoringUtil.isManifestClassAttribute(attr)) {
                int start;
                String fqcn;
                String value = attr.getValue();
                if (value.equals(this.mOldFqcn)) {
                    int start2 = RefactoringUtil.getAttributeValueRangeStart(attr, (IDocument)document);
                    if (start2 != -1) {
                        int end = start2 + this.mOldFqcn.length();
                        edits.add((TextEdit)new ReplaceEdit(start2, end - start2, this.mNewFqcn));
                    }
                } else if (value.startsWith(".") && (fqcn = String.valueOf(this.mAppPackage) + value).equals(this.mOldFqcn) && (start = RefactoringUtil.getAttributeValueRangeStart(attr, (IDocument)document)) != -1) {
                    int end = start + value.length();
                    edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewFqcn));
                }
            }
            ++i;
        }
        NodeList children = element.getChildNodes();
        int i2 = 0;
        int n2 = children.getLength();
        while (i2 < n2) {
            Node child = children.item(i2);
            if (child.getNodeType() == 1) {
                this.addManifestReplacements(edits, (Element)child, document);
            }
            ++i2;
        }
    }
}

