/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.refactorings.core.RenameResourcePage;
import com.android.ide.eclipse.adt.internal.refactorings.core.RenameResourceProcessor;
import com.android.ide.eclipse.adt.internal.refactorings.core.RenameResult;
import com.android.resources.ResourceType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameRefactoringWizard;
import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;

public class RenameResourceWizard
extends RenameRefactoringWizard {
    private ResourceType mType;
    private boolean mCanClear;

    public RenameResourceWizard(@NonNull RenameRefactoring refactoring, @NonNull ResourceType type, boolean canClear) {
        super((Refactoring)refactoring, "Rename Resource", "Enter the new name for this resource", JavaPluginImages.DESC_WIZBAN_REFACTOR_FIELD, "org.eclipse.jdt.ui.rename_field_wizard_page_context");
        this.mType = type;
        this.mCanClear = canClear;
    }

    protected void addUserInputPages() {
        RenameRefactoring refactoring = (RenameRefactoring)this.getRefactoring();
        RenameResourceProcessor processor = (RenameResourceProcessor)refactoring.getProcessor();
        String name = processor.getNewName();
        this.addPage((IWizardPage)new RenameResourcePage(this.mType, name, this.mCanClear));
    }

    public static RenameResult renameResource(@NonNull Shell shell, @NonNull IProject project, @NonNull ResourceType type, @NonNull String currentName, @Nullable String newName, boolean canClear) {
        try {
            RenameResourceProcessor processor = new RenameResourceProcessor(project, type, currentName, newName);
            RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
            if (!refactoring.isApplicable()) {
                return RenameResult.unavailable();
            }
            if (!RenameResourceWizard.show(refactoring, processor, shell, type, canClear)) {
                return RenameResult.canceled();
            }
            return RenameResult.name(processor.getNewName());
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
            return RenameResult.unavailable();
        }
    }

    private static boolean show(@NonNull RenameRefactoring refactoring, @NonNull RenameResourceProcessor processor, @NonNull Shell parent, @NonNull ResourceType type, boolean canClear) throws CoreException {
        RefactoringSaveHelper saveHelper;
        block6: {
            int result;
            block5: {
                saveHelper = new RefactoringSaveHelper(4);
                if (!saveHelper.saveEditors(parent)) {
                    return false;
                }
                try {
                    RenameResourceWizard wizard = new RenameResourceWizard(refactoring, type, canClear);
                    RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                    String dialogTitle = wizard.getDefaultPageTitle();
                    result = operation.run(parent, dialogTitle == null ? "" : dialogTitle);
                    RefactoringStatus status = operation.getInitialConditionCheckingStatus();
                    if (!status.hasFatalError()) break block5;
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            if (result != 1025 && result != 1) break block6;
            saveHelper.triggerIncrementalBuild();
            return false;
        }
        saveHelper.saveEditors(parent);
        return true;
    }
}

