/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.extractstring;

import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ReferenceAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.EnabledTextEditGroup;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringDescriptor;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ReplaceStringsVisitor;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.XmlStringFileHelper;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.w3c.dom.Node;

public class ExtractStringRefactoring
extends Refactoring {
    private final Mode mMode;
    private String mXmlAttributeName;
    private final IFile mFile;
    private final IEditorPart mEditor;
    private final IProject mProject;
    private final int mSelectionStart;
    private final int mSelectionEnd;
    private ICompilationUnit mUnit;
    private String mTokenString;
    private String mXmlStringId;
    private String mXmlStringValue;
    private String mTargetXmlFileWsPath;
    private boolean mReplaceAllJava;
    private boolean mReplaceAllXml;
    private ArrayList<Change> mChanges;
    private XmlStringFileHelper mXmlHelper = new XmlStringFileHelper();
    private static final String KEY_MODE = "mode";
    private static final String KEY_FILE = "file";
    private static final String KEY_PROJECT = "proj";
    private static final String KEY_SEL_START = "sel-start";
    private static final String KEY_SEL_END = "sel-end";
    private static final String KEY_TOK_ESC = "tok-esc";
    private static final String KEY_XML_ATTR_NAME = "xml-attr-name";
    private static final String KEY_RPLC_ALL_JAVA = "rplc-all-java";
    private static final String KEY_RPLC_ALL_XML = "rplc-all-xml";

    public ExtractStringRefactoring(Map<String, String> arguments) throws NullPointerException {
        this.mReplaceAllJava = Boolean.parseBoolean(arguments.get(KEY_RPLC_ALL_JAVA));
        this.mReplaceAllXml = Boolean.parseBoolean(arguments.get(KEY_RPLC_ALL_XML));
        this.mMode = Mode.valueOf(arguments.get(KEY_MODE));
        IPath path = Path.fromPortableString((String)arguments.get(KEY_PROJECT));
        this.mProject = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (this.mMode == Mode.EDIT_SOURCE) {
            path = Path.fromPortableString((String)arguments.get(KEY_FILE));
            this.mFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            this.mSelectionStart = Integer.parseInt(arguments.get(KEY_SEL_START));
            this.mSelectionEnd = Integer.parseInt(arguments.get(KEY_SEL_END));
            this.mTokenString = arguments.get(KEY_TOK_ESC);
            this.mXmlAttributeName = arguments.get(KEY_XML_ATTR_NAME);
        } else {
            this.mFile = null;
            this.mSelectionEnd = -1;
            this.mSelectionStart = -1;
            this.mTokenString = null;
            this.mXmlAttributeName = null;
        }
        this.mEditor = null;
    }

    private Map<String, String> createArgumentMap() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put(KEY_RPLC_ALL_JAVA, Boolean.toString(this.mReplaceAllJava));
        args.put(KEY_RPLC_ALL_XML, Boolean.toString(this.mReplaceAllXml));
        args.put(KEY_MODE, this.mMode.name());
        args.put(KEY_PROJECT, this.mProject.getFullPath().toPortableString());
        if (this.mMode == Mode.EDIT_SOURCE) {
            args.put(KEY_FILE, this.mFile.getFullPath().toPortableString());
            args.put(KEY_SEL_START, Integer.toString(this.mSelectionStart));
            args.put(KEY_SEL_END, Integer.toString(this.mSelectionEnd));
            args.put(KEY_TOK_ESC, this.mTokenString);
            args.put(KEY_XML_ATTR_NAME, this.mXmlAttributeName);
        }
        return args;
    }

    public ExtractStringRefactoring(IFile file, IEditorPart editor, ITextSelection selection) {
        this.mMode = Mode.EDIT_SOURCE;
        this.mFile = file;
        this.mEditor = editor;
        this.mProject = file.getProject();
        this.mSelectionStart = selection.getOffset();
        this.mSelectionEnd = this.mSelectionStart + Math.max(0, selection.getLength() - 1);
    }

    public ExtractStringRefactoring(IProject project, boolean enforceNew) {
        this.mMode = enforceNew ? Mode.SELECT_NEW_ID : Mode.SELECT_ID;
        this.mFile = null;
        this.mEditor = null;
        this.mProject = project;
        this.mSelectionEnd = -1;
        this.mSelectionStart = -1;
    }

    public void setNewStringId(String newStringId) {
        this.mXmlStringId = newStringId;
    }

    public void setNewStringValue(String newStringValue) {
        this.mXmlStringValue = newStringValue;
    }

    public void setTargetFile(String targetXmlFileWsPath) {
        this.mTargetXmlFileWsPath = targetXmlFileWsPath;
    }

    public void setReplaceAllJava(boolean replaceAllJava) {
        this.mReplaceAllJava = replaceAllJava;
    }

    public void setReplaceAllXml(boolean replaceAllXml) {
        this.mReplaceAllXml = replaceAllXml;
    }

    public String getName() {
        if (this.mMode == Mode.SELECT_ID) {
            return "Create or Use Android String";
        }
        if (this.mMode == Mode.SELECT_NEW_ID) {
            return "Create New Android String";
        }
        return "Extract Android String";
    }

    public Mode getMode() {
        return this.mMode;
    }

    public String getTokenString() {
        return this.mTokenString;
    }

    public String getXmlStringId() {
        return this.mXmlStringId;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        this.mUnit = null;
        this.mTokenString = null;
        status = new RefactoringStatus();
        try {
            block14: {
                monitor.beginTask("Checking preconditions...", 6);
                if (this.mMode != Mode.EDIT_SOURCE) {
                    monitor.worked(6);
                    var5_3 = status;
                    return var5_3;
                }
                if (!this.checkSourceFile(this.mFile, status, monitor)) {
                    var5_4 = status;
                    return var5_4;
                }
                this.mUnit = JavaCore.createCompilationUnitFrom((IFile)this.mFile);
                if (this.mUnit.isReadOnly()) {
                    status.addFatalError("The file is read-only, please make it writeable first.");
                    var5_5 = status;
                    return var5_5;
                }
                if (this.findSelectionInJavaUnit(this.mUnit, status, monitor)) ** GOTO lbl-1000
                var5_6 = status;
                return var5_6;
lbl-1000:
                // 1 sources

                {
                    if (this.mUnit == null) break block14;
                    monitor.worked(1);
                    var5_7 = status;
                    return var5_7;
                }
            }
            if (this.mFile != null && "xml".equals(this.mFile.getFileExtension()) && ((path = this.mFile.getFullPath()).segmentCount() == 4 && path.segment(1).equalsIgnoreCase("res") || path.segmentCount() == 2 && path.segment(1).equalsIgnoreCase("AndroidManifest.xml")) && !this.findSelectionInXmlFile(this.mFile, status, monitor)) {
                var5_8 = status;
                return var5_8;
            }
            if (status.isOK() != false) return status;
            status.addFatalError("Selection must be inside a Java source or an Android Layout XML file.");
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private boolean findSelectionInJavaUnit(ICompilationUnit unit, RefactoringStatus status, IProgressMonitor monitor) {
        block16: {
            try {
                IBuffer buffer = unit.getBuffer();
                IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                scanner.setSource(buffer.getCharacters());
                monitor.worked(1);
                int token = scanner.getNextToken();
                while (token != 158) {
                    if (scanner.getCurrentTokenStartPosition() <= this.mSelectionStart && scanner.getCurrentTokenEndPosition() >= this.mSelectionEnd) {
                        if (token == 45) {
                            this.mTokenString = new String(scanner.getCurrentTokenSource());
                        }
                    } else if (scanner.getCurrentTokenStartPosition() <= this.mSelectionEnd) {
                        token = scanner.getNextToken();
                        continue;
                    }
                    break;
                }
            }
            catch (JavaModelException javaModelException) {
                monitor.worked(1);
                break block16;
            }
            catch (InvalidInputException invalidInputException) {
                try {
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    monitor.worked(1);
                }
            }
            monitor.worked(1);
        }
        if (this.mTokenString != null) {
            this.mTokenString = ExtractStringRefactoring.unquoteAttrValue(this.mTokenString);
            if (this.mTokenString.length() == 0) {
                this.mTokenString = null;
            }
        }
        if (this.mTokenString == null) {
            status.addFatalError("Please select a Java string literal.");
        }
        monitor.worked(1);
        return status.isOK();
    }

    private boolean findSelectionInXmlFile(IFile file, RefactoringStatus status, IProgressMonitor monitor) {
        block26: {
            try {
                IStructuredModel smodel;
                block21: {
                    String currAttrName;
                    Node node;
                    AndroidXmlEditor editor;
                    block24: {
                        boolean bl;
                        block25: {
                            block22: {
                                boolean bl2;
                                block23: {
                                    if (!(this.mEditor instanceof AndroidXmlEditor)) {
                                        status.addFatalError("Only the Android XML Editor is currently supported.");
                                        boolean bl3 = status.isOK();
                                        return bl3;
                                    }
                                    editor = (AndroidXmlEditor)this.mEditor;
                                    smodel = null;
                                    node = null;
                                    currAttrName = null;
                                    smodel = editor.getModelForRead();
                                    if (smodel == null) break block21;
                                    int offset = this.mSelectionStart;
                                    while (offset >= 0 && node == null) {
                                        node = (Node)smodel.getIndexedRegion(offset);
                                        --offset;
                                    }
                                    if (node != null) break block22;
                                    status.addFatalError("The selection does not match any element in the XML document.");
                                    bl2 = status.isOK();
                                    if (smodel == null) break block23;
                                    smodel.releaseFromRead();
                                }
                                return bl2;
                            }
                            if (node.getNodeType() == 1) break block24;
                            status.addFatalError("The selection is not inside an actual XML element.");
                            bl = status.isOK();
                            if (smodel == null) break block25;
                            smodel.releaseFromRead();
                        }
                        return bl;
                    }
                    try {
                        try {
                            int selStart;
                            IStructuredDocumentRegion region;
                            IStructuredDocument sdoc = smodel.getStructuredDocument();
                            if (sdoc != null && (region = sdoc.getRegionAtCharacterOffset(selStart = this.mSelectionStart)) != null && "XML_TAG_NAME".equals(region.getType())) {
                                currAttrName = this.findSelectionInRegion(region, selStart);
                                if (this.mTokenString == null) {
                                    status.addFatalError("The selection is not inside an actual XML attribute value.");
                                }
                            }
                            if (this.mTokenString != null && node != null && currAttrName != null) {
                                this.validateSelectedAttribute(editor, node, currAttrName, status);
                            } else {
                                this.mTokenString = null;
                            }
                        }
                        catch (Throwable t) {
                            status.addFatalError(String.format("XML parsing error: %1$s", t.getMessage()));
                            if (smodel != null) {
                                smodel.releaseFromRead();
                            }
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        if (smodel != null) {
                            smodel.releaseFromRead();
                        }
                        throw throwable;
                    }
                }
                if (smodel != null) {
                    smodel.releaseFromRead();
                }
            }
            finally {
                monitor.worked(1);
            }
        }
        return status.isOK();
    }

    private String findSelectionInRegion(IStructuredDocumentRegion region, int selStart) {
        String currAttrName = null;
        int startInRegion = selStart - region.getStartOffset();
        int nb = region.getNumberOfRegions();
        ITextRegionList list = region.getRegions();
        String currAttrValue = null;
        int i = 0;
        while (i < nb) {
            ITextRegion subRegion = list.get(i);
            String type = subRegion.getType();
            if ("XML_TAG_ATTRIBUTE_NAME".equals(type)) {
                currAttrName = region.getText(subRegion);
                if (subRegion.getStart() <= startInRegion && startInRegion < subRegion.getTextEnd() && i <= nb - 3 && "XML_TAG_ATTRIBUTE_EQUALS".equals(list.get(i + 1).getType()) && "XML_TAG_ATTRIBUTE_VALUE".equals(type = (subRegion = list.get(i + 2)).getType())) {
                    currAttrValue = region.getText(subRegion);
                }
            } else if (subRegion.getStart() <= startInRegion && startInRegion < subRegion.getTextEnd() && "XML_TAG_ATTRIBUTE_VALUE".equals(type)) {
                currAttrValue = region.getText(subRegion);
            }
            if (currAttrValue != null) {
                String text = currAttrValue;
                if ((text = ExtractStringRefactoring.unquoteAttrValue(text)).length() <= 0 || currAttrName == null) break;
                this.mTokenString = text;
                break;
            }
            ++i;
        }
        return currAttrName;
    }

    static String unquoteAttrValue(String attrValue) {
        int len = attrValue.length();
        int len1 = len - 1;
        if (len >= 2 && attrValue.charAt(0) == '\"' && attrValue.charAt(len1) == '\"') {
            attrValue = attrValue.substring(1, len1);
        } else if (len >= 2 && attrValue.charAt(0) == '\'' && attrValue.charAt(len1) == '\'') {
            attrValue = attrValue.substring(1, len1);
        }
        return attrValue;
    }

    private void validateSelectedAttribute(AndroidXmlEditor editor, Node node, String attrName, RefactoringStatus status) {
        UiElementNode rootUiNode = editor.getUiRootNode();
        UiElementNode currentUiNode = rootUiNode == null ? null : rootUiNode.findXmlNode(node);
        ReferenceAttributeDescriptor attrDesc = null;
        if (currentUiNode != null) {
            String name = attrName;
            int pos = name.indexOf(58);
            if (pos > 0 && pos < name.length() - 1) {
                name = name.substring(pos + 1);
            }
            for (UiAttributeNode attrNode : currentUiNode.getAllUiAttributes()) {
                if (!attrNode.getDescriptor().getXmlLocalName().equals(name)) continue;
                AttributeDescriptor desc = attrNode.getDescriptor();
                if (!(desc instanceof ReferenceAttributeDescriptor)) break;
                attrDesc = (ReferenceAttributeDescriptor)desc;
                break;
            }
        }
        if (attrDesc != null && (attrDesc.getResourceType() == null || attrDesc.getResourceType() == ResourceType.STRING)) {
            if (this.mTokenString != null && this.mTokenString.startsWith("@")) {
                int pos2;
                int pos1 = 0;
                if (this.mTokenString.length() > 1 && this.mTokenString.charAt(1) == '+') {
                    ++pos1;
                }
                if ((pos2 = this.mTokenString.indexOf(47)) > pos1) {
                    String kind = this.mTokenString.substring(pos1 + 1, pos2);
                    if (ResourceType.STRING.getName().equals(kind)) {
                        this.mTokenString = null;
                        status.addFatalError(String.format("The attribute %1$s already contains a %2$s reference.", attrName, kind));
                    }
                }
            }
            if (this.mTokenString != null) {
                this.mXmlAttributeName = attrName;
            }
        } else {
            this.mTokenString = null;
            status.addFatalError(String.format("The attribute %1$s does not accept a string reference.", attrName));
        }
    }

    private boolean checkSourceFile(IFile file, RefactoringStatus status, IProgressMonitor monitor) {
        if (!file.isSynchronized(0)) {
            status.addFatalError("The file is not synchronized. Please save it first.");
            return false;
        }
        monitor.worked(1);
        ResourceAttributes resAttr = file.getResourceAttributes();
        if (resAttr == null || resAttr.isReadOnly()) {
            status.addFatalError("The file is read-only, please make it writeable first.");
            return false;
        }
        monitor.worked(1);
        return true;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            Change change;
            monitor.beginTask("Checking post-conditions...", 5);
            if (this.mXmlStringId == null || this.mXmlStringId.length() <= 0) {
                status.addFatalError("Missing replacement string ID");
            } else if (this.mTargetXmlFileWsPath == null || this.mTargetXmlFileWsPath.length() <= 0) {
                status.addFatalError("Missing target xml file path");
            }
            monitor.worked(1);
            IResource targetXml = this.getTargetXmlResource(this.mTargetXmlFileWsPath);
            if (targetXml != null) {
                if (targetXml.getType() != 1) {
                    status.addFatalError(String.format("XML file '%1$s' is not a file.", this.mTargetXmlFileWsPath));
                } else {
                    ResourceAttributes attr = targetXml.getResourceAttributes();
                    if (attr != null && attr.isReadOnly()) {
                        status.addFatalError(String.format("XML file '%1$s' is read-only.", this.mTargetXmlFileWsPath));
                    }
                }
            }
            monitor.worked(1);
            if (status.hasError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            this.mChanges = new ArrayList();
            if (!this.mXmlStringValue.equals(this.mXmlHelper.valueOfStringId(this.mProject, this.mTargetXmlFileWsPath, this.mXmlStringId)) && (change = this.createXmlChanges((IFile)targetXml, this.mXmlStringId, this.mXmlStringValue, status, SubMonitor.convert((IProgressMonitor)monitor, (int)1))) != null) {
                this.mChanges.add(change);
            }
            if (status.hasError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.mMode == Mode.EDIT_SOURCE) {
                List<Change> changes = null;
                if (this.mXmlAttributeName != null) {
                    changes = this.computeXmlSourceChanges(this.mFile, this.mXmlStringId, this.mTokenString, this.mXmlAttributeName, true, status, monitor);
                } else if (this.mUnit != null) {
                    changes = this.computeJavaChanges(this.mUnit, this.mXmlStringId, this.mTokenString, status, SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                }
                if (changes != null) {
                    this.mChanges.addAll(changes);
                }
            }
            if (this.mReplaceAllJava) {
                String currentIdentifier = this.mUnit != null ? this.mUnit.getHandleIdentifier() : "";
                SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                for (ICompilationUnit unit : this.findAllJavaUnits()) {
                    List<Change> changes;
                    ResourceAttributes attrs;
                    IResource resource;
                    if (unit == null || !unit.exists() || (resource = unit.getResource()) == null || resource.isDerived() || currentIdentifier.equals(unit.getHandleIdentifier()) || (attrs = resource.getResourceAttributes()) != null && attrs.isReadOnly() || (changes = this.computeJavaChanges(unit, this.mXmlStringId, this.mTokenString, status, SubMonitor.convert((IProgressMonitor)submon, (int)1))) == null) continue;
                    this.mChanges.addAll(changes);
                }
            }
            if (this.mReplaceAllXml) {
                SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                for (IFile xmlFile : this.findAllResXmlFiles()) {
                    List<Change> changes;
                    if (xmlFile == null || (changes = this.computeXmlSourceChanges(xmlFile, this.mXmlStringId, this.mTokenString, this.mXmlAttributeName, false, status, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)submon, (int)1))) == null) continue;
                    this.mChanges.addAll(changes);
                }
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private Iterable<IFile> findAllResXmlFiles() {
        return new Iterable<IFile>(){

            @Override
            public Iterator<IFile> iterator() {
                return new Iterator<IFile>(){
                    final Queue<IFile> mFiles = new LinkedList<IFile>();
                    final Queue<IResource> mFolders = new LinkedList<IResource>();
                    IPath mFilterPath1 = null;
                    IPath mFilterPath2 = null;
                    {
                        IFolder f;
                        IResource man;
                        IResource filterRes = ExtractStringRefactoring.this.mProject.findMember(ExtractStringRefactoring.this.mTargetXmlFileWsPath);
                        if (filterRes != null) {
                            this.mFilterPath1 = filterRes.getFullPath();
                        }
                        if (ExtractStringRefactoring.this.mFile != null) {
                            this.mFilterPath2 = ExtractStringRefactoring.this.mFile.getFullPath();
                        }
                        if ((man = ExtractStringRefactoring.this.mProject.findMember("AndroidManifest.xml")).exists() && man instanceof IFile && !man.equals((Object)ExtractStringRefactoring.this.mFile)) {
                            this.mFiles.add((IFile)man);
                        }
                        if ((f = ExtractStringRefactoring.this.mProject.getFolder("/res")).exists()) {
                            try {
                                this.mFolders.addAll(Arrays.asList(f.members(4)));
                            }
                            catch (CoreException coreException) {}
                        }
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public boolean hasNext() {
                        if (this.mFiles.isEmpty()) ** GOTO lbl11
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            res = this.mFolders.poll();
                            if (!res.exists() || !(res instanceof IFolder)) continue;
                            f = (IFolder)res;
                            try {
                                this.getFileList(f);
                                if (this.mFiles.isEmpty()) continue;
                                return true;
                            }
                            catch (CoreException v0) {}
lbl11:
                            // 4 sources

                            ** while (!this.mFolders.isEmpty())
                        }
lbl12:
                        // 1 sources

                        return false;
                    }

                    private void getFileList(IFolder folder) throws CoreException {
                        IResource[] iResourceArray = folder.members(4);
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFile file;
                            IResource res = iResourceArray[n2];
                            if (res.exists() && !res.isDerived() && res instanceof IFile && "xml".equals((file = (IFile)res).getFileExtension())) {
                                IPath p = file.getFullPath();
                                if (!(this.mFilterPath1 != null && this.mFilterPath1.equals((Object)p) || this.mFilterPath2 != null && this.mFilterPath2.equals((Object)p))) {
                                    this.mFiles.add(file);
                                }
                            }
                            ++n2;
                        }
                    }

                    @Override
                    public IFile next() {
                        IFile file = this.mFiles.poll();
                        this.hasNext();
                        return file;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("This iterator does not support removal");
                    }
                };
            }
        };
    }

    private Change createXmlChanges(IFile targetXml, String xmlStringId, String tokenString, RefactoringStatus status, SubMonitor monitor) {
        TextFileChange xmlChange = new TextFileChange(this.getName(), targetXml);
        xmlChange.setTextType("xml");
        String error = "";
        TextEdit edit = null;
        TextEditGroup editGroup = null;
        try {
            if (!targetXml.exists()) {
                targetXml = null;
            }
            edit = this.createXmlReplaceEdit(targetXml, xmlStringId, tokenString, status, SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        }
        catch (IOException e) {
            error = e.toString();
        }
        catch (CoreException e) {
            error = e.toString();
        }
        if (edit == null) {
            status.addFatalError(String.format("Failed to modify file %1$s%2$s", targetXml == null ? "" : targetXml.getFullPath(), error == null ? "" : ": " + error));
            return null;
        }
        editGroup = new TextEditGroup(targetXml == null ? "Create <string> in new XML file" : "Insert <string> in XML file", edit);
        xmlChange.setEdit(edit);
        xmlChange.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)xmlChange, editGroup));
        monitor.worked(1);
        return xmlChange;
    }

    private TextEdit createXmlReplaceEdit(IFile file, String xmlStringId, String tokenString, RefactoringStatus status, SubMonitor monitor) throws IOException, CoreException {
        IModelManager modelMan = StructuredModelManager.getModelManager();
        IStructuredModel smodel = null;
        tokenString = ValueXmlHelper.escapeResourceString((String)tokenString);
        try {
            IStructuredDocumentRegion lastReg;
            IStructuredDocument sdoc = null;
            boolean checkTopElement = true;
            boolean replaceStringContent = false;
            boolean hasPiXml = false;
            int newResStart = 0;
            int newResLength = 0;
            String lineSep = "\n";
            if (file != null) {
                smodel = modelMan.getExistingModelForRead(file);
                sdoc = smodel != null ? smodel.getStructuredDocument() : (file.exists() ? modelMan.createStructuredDocumentFor(file) : modelMan.createNewStructuredDocumentFor(file));
            }
            if (sdoc == null && file != null) {
                sdoc = modelMan.createStructuredDocumentFor(file);
            }
            if (sdoc != null) {
                String wsBefore = "";
                String lastWs = null;
                lineSep = sdoc.getLineDelimiter();
                if (lineSep == null || lineSep.length() == 0) {
                    lineSep = "\n";
                }
                IStructuredDocumentRegion[] iStructuredDocumentRegionArray = sdoc.getStructuredDocumentRegions();
                int n = iStructuredDocumentRegionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITextRegionList list;
                    int nb;
                    IStructuredDocumentRegion regions = iStructuredDocumentRegionArray[n2];
                    String type = regions.getType();
                    if ("XML_CONTENT".equals(type)) {
                        if (replaceStringContent) {
                            ReplaceEdit replaceEdit = new ReplaceEdit(regions.getStartOffset(), regions.getLength(), tokenString);
                            return replaceEdit;
                        }
                        lastWs = regions.getFullText();
                    } else if ("XML_PI_OPEN".equals(type) && !hasPiXml) {
                        nb = regions.getNumberOfRegions();
                        list = regions.getRegions();
                        int i = 0;
                        while (i < nb) {
                            String name;
                            ITextRegion region = list.get(i);
                            type = region.getType();
                            if ("XML_TAG_NAME".equals(type) && "xml".equals(name = regions.getText(region))) {
                                hasPiXml = true;
                                break;
                            }
                            ++i;
                        }
                    } else if ("XML_TAG_NAME".equals(type)) {
                        nb = regions.getNumberOfRegions();
                        list = regions.getRegions();
                        String name = null;
                        String attrName = null;
                        String attrValue = null;
                        boolean isEmptyTag = false;
                        boolean isCloseTag = false;
                        int i = 0;
                        while (i < nb) {
                            ITextRegion region = list.get(i);
                            type = region.getType();
                            if ("XML_END_TAG_OPEN".equals(type)) {
                                isCloseTag = true;
                            } else if ("XML_EMPTY_TAG_CLOSE".equals(type)) {
                                isEmptyTag = true;
                            } else if ("XML_TAG_NAME".equals(type)) {
                                name = regions.getText(region);
                            } else if ("XML_TAG_ATTRIBUTE_NAME".equals(type) && "string".equals(name)) {
                                attrName = regions.getText(region);
                            } else if ("XML_TAG_ATTRIBUTE_VALUE".equals(type) && "name".equals(attrName) && (attrValue = regions.getText(region)) != null && ExtractStringRefactoring.unquoteAttrValue(attrValue).equals(xmlStringId)) {
                                replaceStringContent = true;
                            }
                            ++i;
                        }
                        if (checkTopElement) {
                            checkTopElement = false;
                            if (!"resources".equals(name)) {
                                status.addFatalError(String.format("XML file lacks a <resource> tag: %1$s", this.mTargetXmlFileWsPath));
                                return null;
                            }
                            if (isEmptyTag) {
                                newResStart = regions.getStartOffset();
                                newResLength = regions.getLength();
                            }
                        }
                        if ("resources".equals(name)) {
                            if (isCloseTag) {
                                IStructuredDocumentRegion previous;
                                StringBuilder content = new StringBuilder();
                                content.append(wsBefore).append("<string name=\"").append(xmlStringId).append("\">").append(tokenString).append("</string>");
                                IStructuredDocumentRegion insertBeforeReg = regions;
                                while ((previous = insertBeforeReg.getPrevious()) != null && "XML_CONTENT".equals(previous.getType()) && previous.getText().trim().length() == 0) {
                                    insertBeforeReg = previous;
                                }
                                if (insertBeforeReg == regions) {
                                    content.append(lineSep);
                                }
                                InsertEdit insertEdit = new InsertEdit(insertBeforeReg.getStartOffset(), content.toString());
                                return insertEdit;
                            }
                        } else if (!isCloseTag) {
                            wsBefore = lastWs;
                        }
                    }
                    ++n2;
                }
            }
            StringBuilder content = new StringBuilder();
            if (!hasPiXml) {
                content.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                content.append(lineSep);
            } else if (newResLength == 0 && sdoc != null && (lastReg = sdoc.getLastStructuredDocumentRegion()) != null && lastReg.getText().indexOf(10) == -1) {
                content.append('\n');
            }
            content.append("<resources>").append(lineSep);
            content.append("    <string name=\"").append(xmlStringId).append("\">").append(tokenString).append("</string>").append(lineSep);
            content.append("</resources>").append(lineSep);
            if (newResLength > 0) {
                ReplaceEdit replaceEdit = new ReplaceEdit(newResStart, newResLength, content.toString());
                return replaceEdit;
            }
            int offset = sdoc == null ? 0 : sdoc.getLength();
            InsertEdit insertEdit = new InsertEdit(offset, content.toString());
            return insertEdit;
        }
        catch (IOException e) {
            throw e;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Throwable t) {
            status.addFatalError(String.format("XML replace error: %1$s", t.getMessage()));
        }
        finally {
            if (smodel != null) {
                smodel.releaseFromRead();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private List<Change> computeXmlSourceChanges(IFile sourceFile, String xmlStringId, String tokenString, String xmlAttrName, boolean allConfigurations, RefactoringStatus status, IProgressMonitor monitor) {
        if (!sourceFile.exists()) {
            status.addFatalError(String.format("XML file '%1$s' does not exist.", new Object[]{sourceFile.getFullPath().toOSString()}));
            return null;
        }
        if (!(ExtractStringRefactoring.$assertionsDisabled || tokenString != null && tokenString.length() > 0)) {
            throw new AssertionError();
        }
        if (tokenString == null || tokenString.length() == 0) {
            return null;
        }
        files = new HashSet<IFile>();
        files.add(sourceFile);
        if (allConfigurations && "xml".equals(sourceFile.getFileExtension()) && (path = sourceFile.getFullPath()).segmentCount() == 4 && path.segment(1).equals("res")) {
            project = sourceFile.getProject();
            filename = path.segment(3);
            initialTypeName = path.segment(2);
            type = ResourceFolderType.getFolderType((String)initialTypeName);
            res = sourceFile.getParent().getParent();
            if (type != null && res != null && res.getType() == 2) {
                try {
                    var18_15 = res.members();
                    var17_17 = var18_15.length;
                    var16_19 = 0;
                    while (var16_19 < var17_17) {
                        r = var18_15[var16_19];
                        if (r != null && r.getType() == 2 && !(name = r.getName()).equals(initialTypeName) && type.equals((Object)(t = ResourceFolderType.getFolderType((String)name))) && (f = project.findMember(p = res.getProjectRelativePath().append(name).append(filename))) != null && f instanceof IFile) {
                            files.add((IFile)f);
                        }
                        ++var16_19;
                    }
                }
                catch (CoreException v0) {}
            }
        }
        subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)Math.min(1, files.size()));
        changes = new ArrayList<Change>();
        modelManager = StructuredModelManager.getModelManager();
        for (IFile file : files) {
            block34: {
                block36: {
                    block35: {
                        block32: {
                            block33: {
                                smodel = null;
                                multiEdit = null;
                                xmlChange = null;
                                editGroups = null;
                                sdoc = null;
                                smodel = modelManager.getExistingModelForRead(file);
                                sdoc = smodel != null ? smodel.getStructuredDocument() : (file.exists() != false ? modelManager.createStructuredDocumentFor(file) : modelManager.createNewStructuredDocumentFor(file));
                                if (sdoc != null) break block32;
                                status.addFatalError("XML structured document not found");
                                if (smodel == null) break block33;
                                smodel.releaseFromRead();
                            }
                            if (multiEdit != null && xmlChange != null && editGroups != null && multiEdit.hasChildren()) {
                                xmlChange.setEdit((TextEdit)multiEdit);
                                for (TextEditGroup group : editGroups) {
                                    xmlChange.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)xmlChange, group));
                                }
                                changes.add((Change)xmlChange);
                            }
                            subMonitor.worked(1);
                            continue;
                        }
                        try {
                            try {
                                multiEdit = new MultiTextEdit();
                                editGroups = new ArrayList<TextEditGroup>();
                                xmlChange = new TextFileChange(this.getName(), file);
                                xmlChange.setTextType("xml");
                                quotedReplacement = this.quotedAttrValue("@string/" + xmlStringId);
                                var23_28 = sdoc.getStructuredDocumentRegions();
                                var22_27 = var23_28.length;
                                var21_25 = 0;
                                while (var21_25 < var22_27) {
                                    regions = var23_28[var21_25];
                                    if ("XML_TAG_NAME".equals(regions.getType())) {
                                        nb = regions.getNumberOfRegions();
                                        list = regions.getRegions();
                                        lastAttrName = null;
                                        i = 0;
                                        while (i < nb) {
                                            subRegion = list.get(i);
                                            type = subRegion.getType();
                                            if ("XML_TAG_ATTRIBUTE_NAME".equals(type)) {
                                                lastAttrName = regions.getText(subRegion);
                                            } else if ("XML_TAG_ATTRIBUTE_VALUE".equals(type)) {
                                                text = regions.getText(subRegion);
                                                if (tokenString.equals(text = ExtractStringRefactoring.unquoteAttrValue(text)) && (xmlAttrName == null || xmlAttrName.equals(lastAttrName))) {
                                                    edit = new ReplaceEdit(regions.getStartOffset() + subRegion.getStart(), subRegion.getTextLength(), quotedReplacement);
                                                    editGroup = new TextEditGroup("Replace attribute string by ID", (TextEdit)edit);
                                                    multiEdit.addChild((TextEdit)edit);
                                                    editGroups.add(editGroup);
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                    ++var21_25;
                                }
                                break block34;
                            }
                            catch (Throwable t) {
                                status.addFatalError(String.format("XML refactoring error: %1$s", new Object[]{t.getMessage()}));
                                if (smodel != null) {
                                    smodel.releaseFromRead();
                                }
                                if (multiEdit == null || xmlChange == null || editGroups == null || !multiEdit.hasChildren()) break block35;
                                xmlChange.setEdit((TextEdit)multiEdit);
                                ** for (group : editGroups)
                            }
                        }
                        catch (Throwable var33_40) {
                            if (smodel != null) {
                                smodel.releaseFromRead();
                            }
                            if (multiEdit == null || xmlChange == null || editGroups == null || !multiEdit.hasChildren()) break block36;
                            xmlChange.setEdit(multiEdit);
                            ** for (group : editGroups)
                        }
lbl-1000:
                        // 1 sources

                        {
                            xmlChange.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)xmlChange, group));
                            continue;
                        }
lbl103:
                        // 1 sources

                        changes.add((Change)xmlChange);
                    }
                    subMonitor.worked(1);
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        xmlChange.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)xmlChange, group));
                        continue;
                    }
lbl116:
                    // 1 sources

                    changes.add((Change)xmlChange);
                }
                subMonitor.worked(1);
                throw var33_40;
            }
            if (smodel != null) {
                smodel.releaseFromRead();
            }
            if (multiEdit != null && xmlChange != null && editGroups != null && multiEdit.hasChildren()) {
                xmlChange.setEdit((TextEdit)multiEdit);
                for (TextEditGroup group : editGroups) {
                    xmlChange.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)xmlChange, group));
                }
                changes.add((Change)xmlChange);
            }
            subMonitor.worked(1);
        }
        if (changes.size() > 0) {
            return changes;
        }
        return null;
    }

    private String quotedAttrValue(String attrValue) {
        if (attrValue.indexOf(34) == -1) {
            return String.valueOf('\"') + attrValue + '\"';
        }
        if (attrValue.indexOf(39) == -1) {
            return String.valueOf('\'') + attrValue + '\'';
        }
        attrValue = attrValue.replace("\"", "&quot;");
        return String.valueOf('\"') + attrValue + '\"';
    }

    private Iterable<ICompilationUnit> findAllJavaUnits() {
        final IJavaProject javaProject = JavaCore.create((IProject)this.mProject);
        return new Iterable<ICompilationUnit>(){

            @Override
            public Iterator<ICompilationUnit> iterator() {
                return new Iterator<ICompilationUnit>(javaProject){
                    final Queue<ICompilationUnit> mUnits = new LinkedList<ICompilationUnit>();
                    final Queue<IPackageFragment> mFragments = new LinkedList<IPackageFragment>();
                    {
                        try {
                            IPackageFragment[] tmpFrags = iJavaProject.getPackageFragments();
                            if (tmpFrags != null && tmpFrags.length > 0) {
                                this.mFragments.addAll(Arrays.asList(tmpFrags));
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public boolean hasNext() {
                        if (this.mUnits.isEmpty()) ** GOTO lbl10
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            try {
                                fragment = this.mFragments.poll();
                                if (fragment.getKind() != 1 || (tmpUnits = fragment.getCompilationUnits()) == null || tmpUnits.length <= 0) continue;
                                this.mUnits.addAll(Arrays.asList(tmpUnits));
                                return true;
                            }
                            catch (JavaModelException v0) {}
lbl10:
                            // 3 sources

                            ** while (!this.mFragments.isEmpty())
                        }
lbl11:
                        // 1 sources

                        return false;
                    }

                    @Override
                    public ICompilationUnit next() {
                        ICompilationUnit unit = this.mUnits.poll();
                        this.hasNext();
                        return unit;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("This iterator does not support removal");
                    }
                };
            }
        };
    }

    private List<Change> computeJavaChanges(ICompilationUnit unit, String xmlStringId, String tokenString, RefactoringStatus status, SubMonitor monitor) {
        assert (tokenString != null && tokenString.length() > 0);
        if (tokenString == null || tokenString.length() == 0) {
            return null;
        }
        String packageName = null;
        String error = null;
        IResource manifestFile = this.mProject.findMember("AndroidManifest.xml");
        if (manifestFile == null || manifestFile.getType() != 1) {
            error = "File not found";
        } else {
            ManifestData manifestData = AndroidManifestHelper.parseForData((IFile)manifestFile);
            if (manifestData == null) {
                error = "Invalid content";
            } else {
                packageName = manifestData.getPackage();
                if (packageName == null) {
                    error = "Missing package definition";
                }
            }
        }
        if (error != null) {
            status.addFatalError(String.format("Failed to parse file %1$s: %2$s.", manifestFile == null ? "" : manifestFile.getFullPath(), error));
            return null;
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        TextFileChange change = new TextFileChange(this.getName(), (IFile)unit.getResource());
        change.setTextType("java");
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(unit.getJavaProject());
        parser.setSource(unit);
        parser.setResolveBindings(true);
        ASTNode node = parser.createAST((IProgressMonitor)monitor.newChild(1));
        if (!(node instanceof CompilationUnit)) {
            status.addFatalError(String.format("Internal error: ASTNode class %s", node.getClass()));
            return null;
        }
        ImportRewrite importRewrite = ImportRewrite.create((CompilationUnit)((CompilationUnit)node), (boolean)true);
        String Rqualifier = String.valueOf(packageName) + ".R";
        Rqualifier = importRewrite.addImport(Rqualifier);
        AST ast = node.getAST();
        ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
        ArrayList<TextEditGroup> astEditGroups = new ArrayList<TextEditGroup>();
        ReplaceStringsVisitor visitor = new ReplaceStringsVisitor(ast, astRewrite, astEditGroups, tokenString, Rqualifier, xmlStringId);
        node.accept((ASTVisitor)visitor);
        try {
            MultiTextEdit edit = new MultiTextEdit();
            TextEdit subEdit = importRewrite.rewriteImports((IProgressMonitor)monitor.newChild(1));
            if (subEdit.hasChildren()) {
                edit.addChild(subEdit);
            }
            if ((subEdit = astRewrite.rewriteAST()).hasChildren()) {
                edit.addChild(subEdit);
            }
            if (edit.hasChildren()) {
                change.setEdit((TextEdit)edit);
                for (TextEditGroup editGroup : astEditGroups) {
                    TextEditChangeGroup group = new TextEditChangeGroup((TextChange)change, editGroup);
                    if (editGroup instanceof EnabledTextEditGroup) {
                        group.setEnabled(((EnabledTextEditGroup)editGroup).isEnabled());
                    }
                    change.addTextEditChangeGroup(group);
                }
                changes.add((Change)change);
            }
            monitor.worked(1);
            if (changes.size() > 0) {
                return changes;
            }
        }
        catch (CoreException e) {
            status.addFatalError(e.getMessage());
        }
        return null;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("Applying changes...", 1);
            CompositeChange change = new CompositeChange(this.getName(), this.mChanges.toArray(new Change[this.mChanges.size()])){

                public ChangeDescriptor getDescriptor() {
                    String comment = String.format("Extracts string '%1$s' into R.string.%2$s", ExtractStringRefactoring.this.mTokenString, ExtractStringRefactoring.this.mXmlStringId);
                    ExtractStringDescriptor desc = new ExtractStringDescriptor(ExtractStringRefactoring.this.mProject.getName(), comment, comment, ExtractStringRefactoring.this.createArgumentMap());
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)desc);
                }
            };
            monitor.worked(1);
            CompositeChange compositeChange = change;
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    private IResource getTargetXmlResource(String xmlFileWsPath) {
        IFile resource = this.mProject.getFile(xmlFileWsPath);
        return resource;
    }

    public static enum Mode {
        EDIT_SOURCE,
        SELECT_ID,
        SELECT_NEW_ID;

    }
}

