/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageUtils;
import com.android.ide.eclipse.adt.internal.resources.ResourceHelper;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.IInputValidator;

public class ResourceNameValidator
implements IInputValidator {
    private Set<String> mExisting;
    private boolean mUnique = true;
    private boolean mExist;
    private boolean mIsFileType;
    private boolean mIsImageType;
    private boolean mAllowXmlExtension;

    private ResourceNameValidator(boolean allowXmlExtension, Set<String> existing, boolean isFileType, boolean isImageType) {
        this.mAllowXmlExtension = allowXmlExtension;
        this.mExisting = existing;
        this.mIsFileType = isFileType;
        this.mIsImageType = isImageType;
    }

    public ResourceNameValidator unique() {
        this.mUnique = true;
        this.mExist = false;
        return this;
    }

    public ResourceNameValidator exist() {
        this.mExist = true;
        this.mUnique = false;
        return this;
    }

    public String isValid(String newText) {
        block21: {
            block20: {
                block19: {
                    if (newText != null && newText.trim().length() != 0) break block19;
                    return "Enter a new name";
                }
                if (this.mAllowXmlExtension && newText.endsWith(".xml")) {
                    newText = newText.substring(0, newText.length() - ".xml".length());
                }
                if (this.mAllowXmlExtension && this.mIsImageType && ImageUtils.hasImageExtension(newText)) {
                    newText = newText.substring(0, newText.lastIndexOf(46));
                }
                if (!this.mIsFileType) {
                    newText = newText.replace('.', '_');
                }
                if (newText.indexOf(46) == -1 || newText.endsWith(".xml")) break block20;
                if (this.mIsImageType) {
                    return "The filename must end with .xml or .png";
                }
                return "The filename must end with .xml";
            }
            if (Character.isJavaIdentifierStart(newText.charAt(0))) break block21;
            return "The resource name must begin with a character";
        }
        try {
            String level;
            IStatus validIdentifier;
            int i = 1;
            int n = newText.length();
            while (i < n) {
                char c = newText.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) {
                    return String.format("'%1$c' is not a valid resource name character", Character.valueOf(c));
                }
                ++i;
            }
            if (this.mIsFileType) {
                char first = newText.charAt(0);
                if (first < 'a' || first > 'z') {
                    return String.format("File-based resource names must start with a lowercase letter.", new Object[0]);
                }
                int i2 = 0;
                int n2 = newText.length();
                while (i2 < n2) {
                    char c = newText.charAt(i2);
                    if (!(c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_')) {
                        return String.format("File-based resource names must contain only lowercase a-z, 0-9, or _.", new Object[0]);
                    }
                    ++i2;
                }
            }
            if (!(validIdentifier = JavaConventions.validateIdentifier((String)newText, (String)(level = "1.5"), (String)level)).isOK()) {
                return String.format("%1$s is not a valid name (reserved Java keyword)", newText);
            }
            if (this.mExisting != null && (this.mUnique || this.mExist)) {
                boolean exists = this.mExisting.contains(newText);
                if (this.mUnique && exists) {
                    return String.format("%1$s already exists", newText);
                }
                if (this.mExist && !exists) {
                    return String.format("%1$s does not exist", newText);
                }
            }
            return null;
        }
        catch (Exception e) {
            AdtPlugin.log(e, "Validation failed: %s", e.toString());
            return "";
        }
    }

    public static ResourceNameValidator create(boolean allowXmlExtension, ResourceFolderType type) {
        boolean isFileType = type != ResourceFolderType.VALUES;
        return new ResourceNameValidator(allowXmlExtension, null, isFileType, type == ResourceFolderType.DRAWABLE);
    }

    public static ResourceNameValidator create(boolean allowXmlExtension, Set<String> existing, ResourceType type) {
        boolean isFileType = ResourceHelper.isFileBasedResourceType(type);
        return new ResourceNameValidator(allowXmlExtension, existing, isFileType, type == ResourceType.DRAWABLE).unique();
    }

    public static ResourceNameValidator create(boolean allowXmlExtension, @Nullable IProject project, @NonNull ResourceType type) {
        HashSet<String> existing = null;
        if (project != null) {
            existing = new HashSet<String>();
            ResourceManager manager = ResourceManager.getInstance();
            ProjectResources projectResources = manager.getProjectResources(project);
            Collection items = projectResources.getResourceItemsOfType(type);
            for (ResourceItem item : items) {
                existing.add(item.getName());
            }
        }
        boolean isFileType = ResourceHelper.isFileBasedResourceType(type);
        return new ResourceNameValidator(allowXmlExtension, existing, isFileType, type == ResourceType.DRAWABLE);
    }
}

