/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.common.resources.FrameworkResources;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceFolder;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ScanningContext;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.resources.ResourceHelper;
import com.android.ide.eclipse.adt.internal.resources.manager.CompiledResourcesMonitor;
import com.android.ide.eclipse.adt.internal.resources.manager.GlobalProjectMonitor;
import com.android.ide.eclipse.adt.internal.resources.manager.IdeScanningContext;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.io.IFileWrapper;
import com.android.ide.eclipse.adt.io.IFolderWrapper;
import com.android.io.FolderWrapper;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;

public final class ResourceManager {
    public static final boolean DEBUG = false;
    private static final ResourceManager sThis = new ResourceManager();
    private final Map<IProject, ProjectResources> mMap = new HashMap<IProject, ProjectResources>();
    private final ArrayList<IResourceListener> mListeners = new ArrayList();
    private final GlobalProjectMonitor.IProjectListener mProjectListener = new GlobalProjectMonitor.IProjectListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void projectClosed(IProject project) {
            Map map = ResourceManager.this.mMap;
            synchronized (map) {
                ResourceManager.this.mMap.remove(project);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void projectDeleted(IProject project) {
            Map map = ResourceManager.this.mMap;
            synchronized (map) {
                ResourceManager.this.mMap.remove(project);
            }
        }

        @Override
        public void projectOpened(IProject project) {
            ResourceManager.this.createProject(project);
        }

        @Override
        public void projectOpenedWithWorkspace(IProject project) {
            ResourceManager.this.createProject(project);
        }

        @Override
        public void allProjectsOpenedWithWorkspace() {
        }

        @Override
        public void projectRenamed(IProject project, IPath from) {
        }
    };
    private final GlobalProjectMonitor.IRawDeltaListener mRawDeltaListener = new GlobalProjectMonitor.IRawDeltaListener(){

        @Override
        public void visitDelta(IResourceDelta workspaceDelta) {
            IResourceDelta[] projectDeltas;
            if (ResourceManager.isAutoBuilding()) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = projectDeltas = workspaceDelta.getAffectedChildren();
            int n = projectDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    IResourceDelta delta = iResourceDeltaArray[n2];
                    if (delta.getResource() instanceof IProject) {
                        IProject project;
                        block8: {
                            project = (IProject)delta.getResource();
                            try {
                                if (project.hasNature("com.android.ide.eclipse.adt.AndroidNature")) break block8;
                                break block9;
                            }
                            catch (CoreException coreException) {}
                        }
                        IdeScanningContext context = new IdeScanningContext(ResourceManager.this.getProjectResources(project), project, true);
                        ResourceManager.this.processDelta(delta, context);
                        Collection<IProject> projects = context.getAaptRequestedProjects();
                        if (projects != null) {
                            for (IProject p : projects) {
                                ResourceManager.markAaptRequested(p);
                            }
                        }
                    } else {
                        AdtPlugin.log(2, "Unexpected delta type: %1$s", delta.getResource().toString());
                    }
                }
                ++n2;
            }
        }
    };
    private static final QualifiedName NEED_AAPT = new QualifiedName("com.android.ide.eclipse.adt", "aapt");

    public static void setup(GlobalProjectMonitor monitor) {
        monitor.addProjectListener(ResourceManager.sThis.mProjectListener);
        monitor.addRawDeltaListener(ResourceManager.sThis.mRawDeltaListener);
        CompiledResourcesMonitor.setupMonitor(monitor);
    }

    public static ResourceManager getInstance() {
        return sThis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IResourceListener listener) {
        ArrayList<IResourceListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IResourceListener listener) {
        ArrayList<IResourceListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectResources getProjectResources(IProject project) {
        Map<IProject, ProjectResources> map = this.mMap;
        synchronized (map) {
            ProjectResources resources = this.mMap.get(project);
            if (resources == null) {
                resources = ProjectResources.create(project);
                this.mMap.put(project, resources);
            }
            return resources;
        }
    }

    public void processDelta(IResourceDelta delta, IdeScanningContext context) {
        this.doProcessDelta(delta, context);
        ResourceRepository repo = context.getRepository();
        if (repo != null) {
            repo.postUpdateCleanUp();
        }
    }

    private void doProcessDelta(IResourceDelta delta, IdeScanningContext context) {
        IResourceDelta[] children;
        int mask = 7;
        int kind = delta.getKind();
        if ((mask & kind) == 0) {
            return;
        }
        IResource r = delta.getResource();
        int type = r.getType();
        if (type == 1) {
            context.startScanning(r);
            this.updateFile((IFile)r, delta.getMarkerDeltas(), kind, context);
            context.finishScanning(r);
        } else if (type == 2) {
            this.updateFolder((IFolder)r, kind, context);
        }
        IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            this.processDelta(child, context);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFolder(IFolder folder, int kind, IdeScanningContext context) {
        IProject project = folder.getProject();
        try {
            if (!project.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            return;
        }
        switch (kind) {
            case 1: {
                ProjectResources resources;
                IPath path = folder.getFullPath();
                if (path.segmentCount() != 3 || !this.isInResFolder(path)) break;
                Map<IProject, ProjectResources> map = this.mMap;
                synchronized (map) {
                    resources = this.mMap.get(project);
                    if (resources == null) {
                        resources = ProjectResources.create(project);
                        this.mMap.put(project, resources);
                    }
                }
                ResourceFolder newFolder = resources.processFolder(new IFolderWrapper(folder));
                if (newFolder == null) break;
                this.notifyListenerOnFolderChange(project, newFolder, kind);
                break;
            }
            case 4: {
                ResourceFolder resFolder;
                ProjectResources resources;
                Map<IProject, ProjectResources> newFolder = this.mMap;
                synchronized (newFolder) {
                    resources = this.mMap.get(folder.getProject());
                }
                if (resources == null || (resFolder = resources.getResourceFolder(folder)) == null) break;
                this.notifyListenerOnFolderChange(project, resFolder, kind);
                break;
            }
            case 2: {
                ProjectResources resources;
                Map<IProject, ProjectResources> resFolder = this.mMap;
                synchronized (resFolder) {
                    resources = this.mMap.get(folder.getProject());
                }
                if (resources == null) break;
                ResourceFolderType type = ResourceFolderType.getFolderType((String)folder.getName());
                context.startScanning((IResource)folder);
                ResourceFolder removedFolder = resources.removeFolder(type, new IFolderWrapper(folder), context);
                context.finishScanning((IResource)folder);
                if (removedFolder == null) break;
                this.notifyListenerOnFolderChange(project, removedFolder, kind);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFile(IFile file, IMarkerDelta[] markerDeltas, int kind, ScanningContext context) {
        ResourceFolder folder;
        IContainer container;
        ProjectResources resources;
        IProject project = file.getProject();
        try {
            if (!project.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            return;
        }
        Map<IProject, ProjectResources> map = this.mMap;
        synchronized (map) {
            resources = this.mMap.get(project);
        }
        if (resources == null) {
            return;
        }
        IPath path = file.getFullPath();
        if ((path.segmentCount() == 4 || path.segmentCount() == 5) && this.isInResFolder(path) && (container = file.getParent()) instanceof IFolder && (folder = resources.getResourceFolder((IFolder)container)) != null) {
            ResourceFile resFile = folder.processFile((IAbstractFile)new IFileWrapper(file), ResourceHelper.getResourceDeltaKind(kind), context);
            this.notifyListenerOnFileChange(project, resFile, kind);
        }
    }

    public ResourceFolder getResourceFolder(IFile file) {
        IContainer container = file.getParent();
        if (container.getType() == 2) {
            IFolder parent = (IFolder)container;
            IProject project = file.getProject();
            ProjectResources resources = this.getProjectResources(project);
            if (resources != null) {
                return resources.getResourceFolder(parent);
            }
        }
        return null;
    }

    public ResourceFolder getResourceFolder(IFolder folder) {
        IProject project = folder.getProject();
        ProjectResources resources = this.getProjectResources(project);
        if (resources != null) {
            return resources.getResourceFolder(folder);
        }
        return null;
    }

    public ResourceRepository loadFrameworkResources(IAndroidTarget androidTarget) {
        String osResourcesPath = androidTarget.getPath(11);
        FolderWrapper frameworkRes = new FolderWrapper(osResourcesPath);
        if (frameworkRes.exists()) {
            FrameworkResources resources = new FrameworkResources((IAbstractFolder)frameworkRes);
            resources.loadResources();
            resources.loadPublicResources((ILogger)AdtPlugin.getDefault());
            return resources;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProject(IProject project) {
        if (project.isOpen()) {
            Map<IProject, ProjectResources> map = this.mMap;
            synchronized (map) {
                ProjectResources projectResources = this.mMap.get(project);
                if (projectResources == null) {
                    projectResources = ProjectResources.create(project);
                    this.mMap.put(project, projectResources);
                }
            }
        }
    }

    private boolean isInResFolder(IPath path) {
        return "res".equalsIgnoreCase(path.segment(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenerOnFolderChange(IProject project, ResourceFolder folder, int eventType) {
        ArrayList<IResourceListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (IResourceListener listener : this.mListeners) {
                try {
                    listener.folderChanged(project, folder, eventType);
                }
                catch (Throwable t) {
                    AdtPlugin.log(t, "Failed to execute ResourceManager.IResouceListener.folderChanged()", new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenerOnFileChange(IProject project, ResourceFile file, int eventType) {
        ArrayList<IResourceListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (IResourceListener listener : this.mListeners) {
                try {
                    listener.fileChanged(project, file, eventType);
                }
                catch (Throwable t) {
                    AdtPlugin.log(t, "Failed to execute ResourceManager.IResouceListener.fileChanged()", new Object[0]);
                }
            }
        }
    }

    private ResourceManager() {
    }

    private String getKindString(int kind) {
        return Integer.toString(kind);
    }

    public static boolean isAutoBuilding() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    public static void markAaptRequested(IProject project) {
        try {
            String needsAapt = Boolean.TRUE.toString();
            project.setPersistentProperty(NEED_AAPT, needsAapt);
            ProjectState state = Sdk.getProjectState(project);
            if (state.isLibrary()) {
                for (ProjectState parent : state.getFullParentProjects()) {
                    IProject parentProject = parent.getProject();
                    if (!parentProject.isOpen()) continue;
                    parentProject.setPersistentProperty(NEED_AAPT, needsAapt);
                }
            }
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
    }

    public static void clearAaptRequest(IProject project) {
        try {
            project.setPersistentProperty(NEED_AAPT, null);
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
    }

    public static boolean isAaptRequested(IProject project) {
        try {
            String b = project.getPersistentProperty(NEED_AAPT);
            return b != null && Boolean.valueOf(b) != false;
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
            return false;
        }
    }

    public static interface IResourceListener {
        public void fileChanged(IProject var1, ResourceFile var2, int var3);

        public void folderChanged(IProject var1, ResourceFolder var2, int var3);
    }
}

