/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.ui;

import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ResourceLabelProvider
implements ILabelProvider,
ITableLabelProvider {
    private Image mWarningImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_WARN_TSK").createImage();

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.mWarningImage.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ResourceItem item;
        if (columnIndex == 1 && element instanceof ResourceItem && !(item = (ResourceItem)element).hasDefault()) {
            return this.mWarningImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (element instanceof ResourceType) {
                    return ((ResourceType)element).getDisplayName();
                }
                if (element instanceof ResourceItem) {
                    return ((ResourceItem)element).getName();
                }
                if (!(element instanceof ResourceFile)) break;
                return ((ResourceFile)element).getFolder().getConfiguration().toDisplayString();
            }
            case 1: {
                if (element instanceof ResourceItem) {
                    ResourceItem item = (ResourceItem)element;
                    if (item.isDeclaredInline()) {
                        return "Declared inline";
                    }
                    int count = item.getAlternateCount();
                    if (count > 0) {
                        if (item.hasDefault()) {
                            ++count;
                        }
                        return String.format("%1$d version(s)", count);
                    }
                }
                return null;
            }
        }
        return null;
    }
}

