/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.exportgradle;

import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ExportMessages;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.GradleModule;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ProjectSetupBuilder;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConfirmationPage
extends WizardPage {
    private final ProjectSetupBuilder mBuilder;
    private TableViewer mTableViewer;
    private Label mModuleDescription1;
    private Label mModuleDescription2;
    private Label mModuleDescription3;
    private Label mProjectRootLabel;
    private Label mProjectRootWarning;
    private List<IJavaProject> mOverrideProjects;
    private boolean mOverrideWarning;
    private Button mForceOverride;

    public ConfirmationPage(ProjectSetupBuilder builder) {
        super("ConfirmationPage");
        this.mBuilder = builder;
        this.setPageComplete(false);
        this.setTitle(ExportMessages.PageTitle);
        this.setDescription(ExportMessages.PageDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        Label title = new Label(workArea, 0);
        title.setText("Please review the export options.");
        Group group = new Group(workArea, 0);
        group.setText("Project root");
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0, true, false));
        this.mProjectRootLabel = new Label((Composite)group, 0);
        this.mProjectRootLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.mProjectRootWarning = new Label((Composite)group, 0);
        this.mProjectRootWarning.setLayoutData((Object)new GridData(4, 0, true, false));
        Group group2 = new Group(workArea, 0);
        group2.setText("Exported Modules");
        group2.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        group2.setLayoutData((Object)data);
        data.heightHint = 300;
        Table table = new Table((Composite)group2, 2816);
        this.mTableViewer = new TableViewer(table);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ProjectSetupBuilder) {
                    ProjectSetupBuilder builder = (ProjectSetupBuilder)inputElement;
                    Collection<GradleModule> modules = builder.getModules();
                    Object[] array = new Object[modules.size()];
                    int i = 0;
                    for (GradleModule module : modules) {
                        array[i++] = module.getJavaProject();
                    }
                    return array;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider(){

            protected String decorateText(String input, Object element) {
                if (element instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)element;
                    StringBuilder sb = new StringBuilder(input);
                    if (!ConfirmationPage.this.mBuilder.isOriginalProject(javaProject)) {
                        sb.append('*');
                    }
                    if (ConfirmationPage.this.mOverrideProjects.contains(javaProject)) {
                        sb.append(" (1 warning)");
                    }
                    return sb.toString();
                }
                return input;
            }
        });
        this.mTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof IJavaProject) {
                    GradleModule module = ConfirmationPage.this.mBuilder.getModule((IJavaProject)firstElement);
                    if (ConfirmationPage.this.mBuilder.getOriginalModules().contains(module)) {
                        ConfirmationPage.this.mModuleDescription1.setText("Exported because selected in previous page.");
                    } else {
                        List<GradleModule> list = ConfirmationPage.this.mBuilder.getShortestDependencyTo(module);
                        StringBuilder sb = new StringBuilder();
                        for (GradleModule m : list) {
                            if (sb.length() > 0) {
                                sb.append(" > ");
                            }
                            sb.append(m.getJavaProject().getProject().getName());
                        }
                        ConfirmationPage.this.mModuleDescription1.setText("Dependency chain: " + sb);
                    }
                    ConfirmationPage.this.mModuleDescription2.setText("Path: " + module.getPath());
                    if (ConfirmationPage.this.mOverrideProjects.contains(module.getJavaProject())) {
                        ConfirmationPage.this.mModuleDescription3.setText("WARNING: build.gradle already exists for this project");
                    } else {
                        ConfirmationPage.this.mModuleDescription3.setText("");
                    }
                } else {
                    ConfirmationPage.this.mModuleDescription1.setText("");
                    ConfirmationPage.this.mModuleDescription2.setText("");
                    ConfirmationPage.this.mModuleDescription3.setText("");
                }
            }
        });
        this.mModuleDescription1 = new Label((Composite)group2, 0);
        this.mModuleDescription1.setLayoutData((Object)new GridData(4, 0, true, false));
        this.mModuleDescription2 = new Label((Composite)group2, 0);
        this.mModuleDescription2.setLayoutData((Object)new GridData(4, 0, true, false));
        this.mModuleDescription3 = new Label((Composite)group2, 0);
        this.mModuleDescription3.setLayoutData((Object)new GridData(4, 0, true, false));
        this.mForceOverride = new Button(workArea, 32);
        this.mForceOverride.setLayoutData((Object)new GridData(4, 0, true, false));
        this.mForceOverride.setText("Force overriding of existing files");
        this.mForceOverride.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfirmationPage.this.updateEnablement();
            }
        });
        this.setControl((Control)workArea);
        Dialog.applyDialogFont((Control)parent);
    }

    private void computeOverride(String commonRoot) {
        this.mOverrideProjects = Lists.newArrayList();
        for (GradleModule module : this.mBuilder.getModules()) {
            if (!new File(module.getProject().getLocation().toFile(), "build.gradle").exists()) continue;
            this.mOverrideProjects.add(module.getJavaProject());
        }
        boolean settingsFile = new File(commonRoot, "settings.gradle").exists();
        boolean buildFile = new File(commonRoot, "build.gradle").exists();
        if (settingsFile && buildFile) {
            this.mProjectRootWarning.setText("WARNING: build.gradle/settings.gradle already exists at this location.");
        } else if (settingsFile) {
            this.mProjectRootWarning.setText("WARNING: settings.gradle already exists at this location.");
        } else if (buildFile) {
            this.mProjectRootWarning.setText("WARNING: build.gradle already exists at this location.");
        }
        this.mOverrideWarning = this.mOverrideProjects.size() > 0 || settingsFile || buildFile;
    }

    private void updateEnablement() {
        if (this.mOverrideWarning && !this.mForceOverride.getSelection()) {
            this.setErrorMessage("Enable overriding of existing files before clicking Finish");
            this.mBuilder.setCanGenerate(false);
        } else {
            this.setErrorMessage(null);
            this.mBuilder.setCanGenerate(true);
        }
        this.setPageComplete(false);
        this.getContainer().updateButtons();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mProjectRootWarning.setText("");
            String commonRoot = this.mBuilder.getCommonRoot().toOSString();
            this.computeOverride(commonRoot);
            this.mProjectRootLabel.setText(commonRoot);
            this.mTableViewer.setInput((Object)this.mBuilder);
            this.mTableViewer.getTable().setFocus();
            this.mBuilder.setCanFinish(false);
            this.mBuilder.setCanGenerate(true);
            this.updateEnablement();
        }
    }
}

