/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newproject;

import com.android.SdkConstants;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.wizards.newproject.ImportPage;
import com.android.ide.eclipse.adt.internal.wizards.newproject.NewProjectCreator;
import com.android.ide.eclipse.adt.internal.wizards.newproject.NewProjectWizardState;
import java.io.File;
import org.eclipse.jdt.ui.actions.OpenJavaPerspectiveAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ImportProjectWizard
extends Wizard
implements INewWizard {
    private static final String PROJECT_LOGO_LARGE = "icons/android-64.png";
    private NewProjectWizardState mValues;
    private ImportPage mImportPage;
    private IStructuredSelection mSelection;

    public void addPages() {
        this.mValues = new NewProjectWizardState(NewProjectWizardState.Mode.ANY);
        this.mImportPage = new ImportPage(this.mValues);
        if (this.mSelection != null) {
            this.mImportPage.init(this.mSelection, AdtUtils.getActivePart());
        }
        this.addPage((IWizardPage)this.mImportPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mSelection = selection;
        this.setHelpAvailable(false);
        ImageDescriptor desc = AdtPlugin.getImageDescriptor(PROJECT_LOGO_LARGE);
        this.setDefaultPageImageDescriptor(desc);
        AdtPlugin.getDefault().refreshSdk();
    }

    public boolean performFinish() {
        File file = new File(AdtPlugin.getOsSdkFolder(), String.valueOf(SdkConstants.OS_SDK_TOOLS_LIB_FOLDER) + File.separator + "proguard-project.txt");
        if (!file.exists()) {
            AdtPlugin.displayError("Tools Out of Date?", String.format("It looks like you do not have the latest version of the SDK Tools installed. Make sure you update via the SDK Manager first. (Could not find %1$s)", file.getPath()));
            return false;
        }
        NewProjectCreator creator = new NewProjectCreator(this.mValues, (IRunnableContext)this.getContainer());
        if (!creator.createAndroidProjects()) {
            return false;
        }
        OpenJavaPerspectiveAction action = new OpenJavaPerspectiveAction();
        action.run();
        return true;
    }
}

