/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newproject;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.formatting.EclipseXmlFormatPreferences;
import com.android.ide.eclipse.adt.internal.editors.formatting.EclipseXmlPrettyPrinter;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.project.AndroidNature;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.newproject.FileStoreAdapter;
import com.android.ide.eclipse.adt.internal.wizards.newproject.ImportedProject;
import com.android.ide.eclipse.adt.internal.wizards.newproject.NewProjectWizardState;
import com.android.io.StreamException;
import com.android.resources.Density;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewProjectCreator {
    private static final String PARAM_SDK_TOOLS_DIR = "ANDROID_SDK_TOOLS";
    private static final String PARAM_ACTIVITY = "ACTIVITY_NAME";
    private static final String PARAM_APPLICATION = "APPLICATION_NAME";
    private static final String PARAM_PACKAGE = "PACKAGE";
    private static final String PARAM_IMPORT_RESOURCE_CLASS = "IMPORT_RESOURCE_CLASS";
    private static final String PARAM_PROJECT = "PROJECT_NAME";
    private static final String PARAM_STRING_NAME = "STRING_NAME";
    private static final String PARAM_STRING_CONTENT = "STRING_CONTENT";
    private static final String PARAM_IS_NEW_PROJECT = "IS_NEW_PROJECT";
    private static final String PARAM_SAMPLE_LOCATION = "SAMPLE_LOCATION";
    private static final String PARAM_SOURCE = "SOURCE";
    private static final String PARAM_SRC_FOLDER = "SRC_FOLDER";
    private static final String PARAM_SDK_TARGET = "SDK_TARGET";
    private static final String PARAM_IS_LIBRARY = "IS_LIBRARY";
    private static final String PARAM_MIN_SDK_VERSION = "MIN_SDK_VERSION";
    private static final String PARAM_TEST_TARGET_PACKAGE = "TEST_TARGET_PCKG";
    private static final String PARAM_TARGET_SELF = "TARGET_SELF";
    private static final String PARAM_TARGET_MAIN = "TARGET_MAIN";
    private static final String PARAM_TARGET_EXISTING = "TARGET_EXISTING";
    private static final String PARAM_REFERENCE_PROJECT = "REFERENCE_PROJECT";
    private static final String PH_ACTIVITIES = "ACTIVITIES";
    private static final String PH_USES_SDK = "USES-SDK";
    private static final String PH_INTENT_FILTERS = "INTENT_FILTERS";
    private static final String PH_STRINGS = "STRINGS";
    private static final String PH_TEST_USES_LIBRARY = "TEST-USES-LIBRARY";
    private static final String PH_TEST_INSTRUMENTATION = "TEST-INSTRUMENTATION";
    private static final String BIN_DIRECTORY = "bin/";
    private static final String BIN_CLASSES_DIRECTORY = "bin/classes/";
    private static final String RES_DIRECTORY = "res/";
    private static final String ASSETS_DIRECTORY = "assets/";
    private static final String DRAWABLE_DIRECTORY = "drawable/";
    private static final String DRAWABLE_XHDPI_DIRECTORY = "drawable-" + Density.XHIGH.getResourceValue() + "/";
    private static final String DRAWABLE_HDPI_DIRECTORY = "drawable-" + Density.HIGH.getResourceValue() + "/";
    private static final String DRAWABLE_MDPI_DIRECTORY = "drawable-" + Density.MEDIUM.getResourceValue() + "/";
    private static final String DRAWABLE_LDPI_DIRECTORY = "drawable-" + Density.LOW.getResourceValue() + "/";
    private static final String LAYOUT_DIRECTORY = "layout/";
    private static final String VALUES_DIRECTORY = "values/";
    private static final String GEN_SRC_DIRECTORY = "gen/";
    private static final String TEMPLATES_DIRECTORY = "templates/";
    private static final String TEMPLATE_MANIFEST = "templates/AndroidManifest.template";
    private static final String TEMPLATE_ACTIVITIES = "templates/activity.template";
    private static final String TEMPLATE_USES_SDK = "templates/uses-sdk.template";
    private static final String TEMPLATE_INTENT_LAUNCHER = "templates/launcher_intent_filter.template";
    private static final String TEMPLATE_TEST_USES_LIBRARY = "templates/test_uses-library.template";
    private static final String TEMPLATE_TEST_INSTRUMENTATION = "templates/test_instrumentation.template";
    private static final String TEMPLATE_STRINGS = "templates/strings.template";
    private static final String TEMPLATE_STRING = "templates/string.template";
    private static final String PROJECT_ICON = "ic_launcher.png";
    private static final String ICON_XHDPI = "ic_launcher_xhdpi.png";
    private static final String ICON_HDPI = "ic_launcher_hdpi.png";
    private static final String ICON_MDPI = "ic_launcher_mdpi.png";
    private static final String ICON_LDPI = "ic_launcher_ldpi.png";
    private static final String STRINGS_FILE = "strings.xml";
    private static final String STRING_RSRC_PREFIX = "@string/";
    private static final String STRING_APP_NAME = "app_name";
    private static final String STRING_HELLO_WORLD = "hello";
    private static final String[] DEFAULT_DIRECTORIES = new String[]{"bin/", "bin/classes/", "res/", "assets/"};
    private static final String[] RES_DIRECTORIES = new String[]{"drawable/", "layout/", "values/"};
    private static final String[] RES_DENSITY_ENABLED_DIRECTORIES = new String[]{DRAWABLE_XHDPI_DIRECTORY, DRAWABLE_HDPI_DIRECTORY, DRAWABLE_MDPI_DIRECTORY, DRAWABLE_LDPI_DIRECTORY, "layout/", "values/"};
    private static final String JAVA_ACTIVITY_TEMPLATE = "java_file.template";
    private static final String LAYOUT_TEMPLATE = "layout.template";
    private static final String MAIN_LAYOUT_XML = "main.xml";
    private final NewProjectWizardState mValues;
    private final IRunnableContext mRunnableContext;

    public NewProjectCreator(NewProjectWizardState values, IRunnableContext runnableContext) {
        this.mValues = values;
        this.mRunnableContext = runnableContext;
    }

    private boolean validateNewProjectLocationIsEmpty(IPath destination) {
        File f = new File(destination.toOSString());
        if (f.isDirectory() && f.list().length > 0) {
            return AdtPlugin.displayPrompt("New Android Project", "You are going to create a new Android Project in an existing, non-empty, directory. Are you sure you want to proceed?");
        }
        return true;
    }

    public boolean createAndroidProjects() {
        if (this.mValues.importProjects != null && !this.mValues.importProjects.isEmpty()) {
            return this.importProjects();
        }
        final ProjectInfo mainData = this.collectMainPageInfo();
        final ProjectInfo testData = this.collectTestPageInfo();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                NewProjectCreator.this.createProjectAsync(monitor, mainData, testData, null, true);
            }
        };
        this.runAsyncOperation(op);
        return true;
    }

    public boolean createJavaProjects() {
        if (this.mValues.importProjects != null && !this.mValues.importProjects.isEmpty()) {
            return this.importProjects();
        }
        final ProjectInfo mainData = this.collectMainPageInfo();
        final ProjectInfo testData = this.collectTestPageInfo();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                NewProjectCreator.this.createProjectAsync(monitor, mainData, testData, null, false);
            }
        };
        this.runAsyncOperation(op);
        return true;
    }

    private boolean importProjects() {
        assert (this.mValues.importProjects != null && !this.mValues.importProjects.isEmpty());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final ArrayList<ProjectInfo> projectData = new ArrayList<ProjectInfo>();
        for (ImportedProject p : this.mValues.importProjects) {
            ManifestData manifest = p.getManifest();
            if (manifest == null) continue;
            String packageName = manifest.getPackage();
            String projectName = p.getProjectName();
            String minSdk = manifest.getMinSdkVersionString();
            IProject project = workspace.getRoot().getProject(projectName);
            IProjectDescription description = workspace.newProjectDescription(project.getName());
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put(PARAM_PROJECT, projectName);
            parameters.put(PARAM_PACKAGE, packageName);
            parameters.put(PARAM_SDK_TOOLS_DIR, AdtPlugin.getOsSdkToolsFolder());
            parameters.put(PARAM_IS_NEW_PROJECT, Boolean.FALSE);
            parameters.put(PARAM_SRC_FOLDER, "src");
            parameters.put(PARAM_SDK_TARGET, p.getTarget());
            parameters.put(PARAM_MIN_SDK_VERSION, minSdk);
            parameters.put(PARAM_APPLICATION, "@string/app_name");
            HashMap<String, String> dictionary = new HashMap<String, String>();
            dictionary.put(STRING_APP_NAME, this.mValues.applicationName);
            if (this.mValues.copyIntoWorkspace) {
                parameters.put(PARAM_SOURCE, p.getLocation());
            } else {
                description.setLocation((IPath)new Path(p.getLocation().getPath()));
            }
            projectData.add(new ProjectInfo(project, description, parameters, dictionary));
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                NewProjectCreator.this.createProjectAsync(monitor, null, null, projectData, true);
            }
        };
        this.runAsyncOperation(op);
        return true;
    }

    private ProjectInfo collectMainPageInfo() {
        if (this.mValues.mode == NewProjectWizardState.Mode.TEST) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.mValues.projectName);
        IProjectDescription description = workspace.newProjectDescription(project.getName());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(PARAM_PROJECT, this.mValues.projectName);
        parameters.put(PARAM_PACKAGE, this.mValues.packageName);
        parameters.put(PARAM_APPLICATION, "@string/app_name");
        parameters.put(PARAM_SDK_TOOLS_DIR, AdtPlugin.getOsSdkToolsFolder());
        parameters.put(PARAM_IS_NEW_PROJECT, this.mValues.mode == NewProjectWizardState.Mode.ANY && !this.mValues.useExisting);
        parameters.put(PARAM_SAMPLE_LOCATION, this.mValues.chosenSample);
        parameters.put(PARAM_SRC_FOLDER, this.mValues.sourceFolder);
        parameters.put(PARAM_SDK_TARGET, this.mValues.target);
        parameters.put(PARAM_MIN_SDK_VERSION, this.mValues.minSdk);
        if (this.mValues.createActivity) {
            parameters.put(PARAM_ACTIVITY, this.mValues.activityName);
        }
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put(STRING_APP_NAME, this.mValues.applicationName);
        Path path = new Path(this.mValues.projectLocation.getPath());
        IPath defaultLocation = Platform.getLocation();
        if (!(this.mValues.useDefaultLocation && !this.mValues.useExisting || defaultLocation.isPrefixOf((IPath)path))) {
            description.setLocation((IPath)path);
        }
        if (!(this.mValues.mode != NewProjectWizardState.Mode.ANY || this.mValues.useExisting || this.mValues.useDefaultLocation || this.validateNewProjectLocationIsEmpty((IPath)path))) {
            return null;
        }
        return new ProjectInfo(project, description, parameters, dictionary);
    }

    private ProjectInfo collectTestPageInfo() {
        String testedPkg;
        if (this.mValues.mode != NewProjectWizardState.Mode.TEST && !this.mValues.createPairProject) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = this.mValues.mode == NewProjectWizardState.Mode.TEST ? this.mValues.projectName : this.mValues.testProjectName;
        IProject project = workspace.getRoot().getProject(projectName);
        IProjectDescription description = workspace.newProjectDescription(project.getName());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String pkg = this.mValues.mode == NewProjectWizardState.Mode.TEST ? this.mValues.packageName : this.mValues.testPackageName;
        parameters.put(PARAM_PACKAGE, pkg);
        parameters.put(PARAM_APPLICATION, "@string/app_name");
        parameters.put(PARAM_SDK_TOOLS_DIR, AdtPlugin.getOsSdkToolsFolder());
        parameters.put(PARAM_IS_NEW_PROJECT, !this.mValues.useExisting);
        parameters.put(PARAM_SRC_FOLDER, this.mValues.sourceFolder);
        parameters.put(PARAM_SDK_TARGET, this.mValues.target);
        parameters.put(PARAM_MIN_SDK_VERSION, this.mValues.minSdk);
        String string = testedPkg = this.mValues.createPairProject ? this.mValues.packageName : this.mValues.testTargetPackageName;
        if (testedPkg == null) {
            assert (this.mValues.testingSelf);
            testedPkg = pkg;
        }
        parameters.put(PARAM_TEST_TARGET_PACKAGE, testedPkg);
        if (this.mValues.testingSelf) {
            parameters.put(PARAM_TARGET_SELF, true);
        } else {
            parameters.put(PARAM_TARGET_EXISTING, true);
            parameters.put(PARAM_REFERENCE_PROJECT, this.mValues.testedProject);
        }
        if (this.mValues.createPairProject) {
            parameters.put(PARAM_TARGET_MAIN, true);
        }
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put(STRING_APP_NAME, this.mValues.testApplicationName);
        Path path = new Path(this.mValues.projectLocation.getPath());
        path = path.removeLastSegments(1).append(this.mValues.testProjectName);
        IPath defaultLocation = Platform.getLocation();
        if (!(this.mValues.useDefaultLocation && !this.mValues.useExisting || path.equals((Object)defaultLocation))) {
            description.setLocation((IPath)path);
        }
        if (!(this.mValues.useExisting || this.mValues.useDefaultLocation || this.validateNewProjectLocationIsEmpty((IPath)path))) {
            return null;
        }
        return new ProjectInfo(project, description, parameters, dictionary);
    }

    /*
     * Unable to fully structure code
     */
    private void runAsyncOperation(WorkspaceModifyOperation op) {
        block9: {
            block8: {
                try {
                    this.mRunnableContext.run(true, true, (IRunnableWithProgress)op);
                }
                catch (InvocationTargetException e) {
                    AdtPlugin.log(e, "New Project Wizard failed", new Object[0]);
                    t = e.getTargetException();
                    if (t instanceof CoreException) {
                        core = (CoreException)t;
                        if (core.getStatus().getCode() == 275) {
                            MessageDialog.openError((Shell)AdtPlugin.getShell(), (String)"Error", (String)"Error: Case Variant Exists");
                        } else {
                            ErrorDialog.openError((Shell)AdtPlugin.getShell(), (String)"Error", (String)core.getMessage(), (IStatus)core.getStatus());
                        }
                        break block8;
                    }
                    msg = t.getMessage();
                    t1 = t;
                    ** while (msg == null && t1.getCause() != null)
                }
lbl-1000:
                // 1 sources

                {
                    msg = t1.getMessage();
                    t1 = t1.getCause();
                    continue;
                }
lbl21:
                // 1 sources

                if (msg == null) {
                    msg = t.toString();
                }
                MessageDialog.openError((Shell)AdtPlugin.getShell(), (String)"Error", (String)msg);
            }
            e.printStackTrace();
            break block9;
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void createProjectAsync(IProgressMonitor monitor, ProjectInfo mainData, ProjectInfo testData, List<ProjectInfo> importData, boolean isAndroidProject) throws InvocationTargetException {
        monitor.beginTask("Create Android Project", 100);
        try {
            try {
                IProject mainProject = null;
                if (mainData != null && (mainProject = this.createEclipseProject((IProgressMonitor)new SubProgressMonitor(monitor, 50), mainData.getProject(), mainData.getDescription(), mainData.getParameters(), mainData.getDictionary(), null, isAndroidProject)) != null) {
                    IJavaProject javaProject = JavaCore.create((IProject)mainProject);
                    Display.getDefault().syncExec((Runnable)new WorksetAdder(javaProject, this.mValues.workingSets));
                }
                if (testData != null) {
                    IProject testProject;
                    Map<String, Object> parameters = testData.getParameters();
                    if (parameters.containsKey(PARAM_TARGET_MAIN) && mainProject != null) {
                        parameters.put(PARAM_REFERENCE_PROJECT, mainProject);
                    }
                    if ((testProject = this.createEclipseProject((IProgressMonitor)new SubProgressMonitor(monitor, 50), testData.getProject(), testData.getDescription(), parameters, testData.getDictionary(), null, isAndroidProject)) != null) {
                        IJavaProject javaProject = JavaCore.create((IProject)testProject);
                        Display.getDefault().syncExec((Runnable)new WorksetAdder(javaProject, this.mValues.workingSets));
                    }
                }
                if (importData != null) {
                    for (final ProjectInfo data : importData) {
                        IProject project;
                        ProjectPopulator projectPopulator = null;
                        if (this.mValues.copyIntoWorkspace) {
                            projectPopulator = new ProjectPopulator(){

                                @Override
                                public void populate(IProject project) {
                                    IFileSystem fileSystem = EFS.getLocalFileSystem();
                                    File source = (File)data.getParameters().get(NewProjectCreator.PARAM_SOURCE);
                                    ReadWriteFileStore sourceDir = new ReadWriteFileStore(fileSystem.getStore(source.toURI()));
                                    ReadWriteFileStore destDir = new ReadWriteFileStore(fileSystem.getStore(AdtUtils.getAbsolutePath((IResource)project)));
                                    try {
                                        sourceDir.copy(destDir, 2, null);
                                    }
                                    catch (CoreException e) {
                                        AdtPlugin.log(e, null, new Object[0]);
                                    }
                                }
                            };
                        }
                        if ((project = this.createEclipseProject((IProgressMonitor)new SubProgressMonitor(monitor, 50), data.getProject(), data.getDescription(), data.getParameters(), data.getDictionary(), projectPopulator, isAndroidProject)) == null) continue;
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        Display.getDefault().syncExec((Runnable)new WorksetAdder(javaProject, this.mValues.workingSets));
                        ProjectHelper.enforcePreferredCompilerCompliance(javaProject);
                    }
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            catch (StreamException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private IProject createEclipseProject(@NonNull IProgressMonitor monitor, @NonNull IProject project, @NonNull IProjectDescription description, @NonNull Map<String, Object> parameters, @Nullable Map<String, String> dictionary, @Nullable ProjectPopulator projectPopulator, boolean isAndroidProject) throws CoreException, IOException, StreamException {
        ProjectState state;
        IProject refProject;
        File sampleDir;
        IAndroidTarget target = (IAndroidTarget)parameters.get(PARAM_SDK_TARGET);
        boolean legacy = isAndroidProject && target.getVersion().getApiLevel() < 4;
        project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        AndroidNature.setupProjectNatures(project, monitor, isAndroidProject);
        this.addDefaultDirectories(project, "/", DEFAULT_DIRECTORIES, monitor);
        String[] sourceFolders = isAndroidProject ? new String[]{(String)parameters.get(PARAM_SRC_FOLDER), GEN_SRC_DIRECTORY} : new String[]{(String)parameters.get(PARAM_SRC_FOLDER)};
        this.addDefaultDirectories(project, "/", sourceFolders, monitor);
        if (legacy) {
            this.addDefaultDirectories(project, RES_DIRECTORY, RES_DIRECTORIES, monitor);
        } else {
            this.addDefaultDirectories(project, RES_DIRECTORY, RES_DENSITY_ENABLED_DIRECTORIES, monitor);
        }
        if (projectPopulator != null) {
            try {
                projectPopulator.populate(project);
            }
            catch (InvocationTargetException ite) {
                AdtPlugin.log(ite, null, new Object[0]);
            }
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.setupSourceFolders(javaProject, sourceFolders, monitor);
        if (((Boolean)parameters.get(PARAM_IS_NEW_PROJECT)).booleanValue()) {
            this.addManifest(project, parameters, dictionary, monitor);
            this.addIcon(project, legacy, monitor);
            this.addSampleCode(project, sourceFolders[0], parameters, dictionary, monitor);
            if (dictionary != null && dictionary.size() > 0) {
                this.addStringDictionaryFile(project, dictionary, monitor);
            }
            File libFolder = new File((String)parameters.get(PARAM_SDK_TOOLS_DIR), "lib");
            NewProjectCreator.addLocalFile(project, new File(libFolder, "proguard-project.txt"), "proguard-project.txt", monitor);
            javaProject.setOutputLocation(project.getFolder(BIN_CLASSES_DIRECTORY).getFullPath(), monitor);
        }
        if ((sampleDir = (File)parameters.get(PARAM_SAMPLE_LOCATION)) != null) {
            this.copySampleCode(project, sampleDir, parameters, dictionary, monitor);
        }
        if (parameters.containsKey(PARAM_REFERENCE_PROJECT) && (refProject = (IProject)parameters.get(PARAM_REFERENCE_PROJECT)) != null) {
            IProjectDescription desc = project.getDescription();
            desc.setReferencedProjects(new IProject[]{refProject});
            project.setDescription(desc, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            IClasspathEntry entry = JavaCore.newProjectEntry((IPath)refProject.getFullPath(), (IAccessRule[])new IAccessRule[0], (boolean)false, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
            ProjectHelper.addEntryToClasspath(javaProject, entry);
        }
        if (isAndroidProject) {
            Sdk.getCurrent().initProject(project, target);
        }
        ProjectHelper.fixProject(project);
        Boolean isLibraryProject = (Boolean)parameters.get(PARAM_IS_LIBRARY);
        if (isLibraryProject != null && isLibraryProject.booleanValue() && Sdk.getCurrent() != null && project.isOpen() && (state = Sdk.getProjectState(project)) != null) {
            ProjectPropertiesWorkingCopy properties = state.getProperties().makeWorkingCopy();
            properties.setProperty("android.library", Boolean.TRUE.toString());
            try {
                properties.save();
                IResource projectProp = project.findMember("project.properties");
                if (projectProp != null) {
                    projectProp.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                String msg = String.format("Failed to save %1$s for project %2$s", "project.properties", project.getName());
                AdtPlugin.log(e, msg, new Object[0]);
            }
        }
        return project;
    }

    public static void create(@NonNull IProgressMonitor monitor, final @NonNull IProject project, @NonNull IAndroidTarget target, final @Nullable ProjectPopulator projectPopulator, boolean isLibrary, @NonNull String projectLocation, final @NonNull IWorkingSet[] workingSets) throws CoreException {
        NewProjectCreator creator = new NewProjectCreator(null, null);
        final Map dictionary = null;
        final HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(PARAM_SDK_TARGET, target);
        parameters.put(PARAM_SRC_FOLDER, "src");
        parameters.put(PARAM_IS_NEW_PROJECT, false);
        parameters.put(PARAM_SAMPLE_LOCATION, null);
        parameters.put(PARAM_IS_LIBRARY, isLibrary);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(project.getName());
        if (projectLocation != null) {
            Path path = new Path(projectLocation);
            Path parent = new Path(path.toFile().getParent());
            IPath workspaceLocation = Platform.getLocation();
            if (!workspaceLocation.equals((Object)parent)) {
                description.setLocation((IPath)path);
            }
        }
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor submonitor) throws CoreException {
                IJavaProject javaProject;
                try {
                    NewProjectCreator.this.createEclipseProject(submonitor, project, description, parameters, dictionary, projectPopulator, true);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", "Unexpected error while creating project", (Throwable)e));
                }
                catch (StreamException e) {
                    throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", "Unexpected error while creating project", (Throwable)e));
                }
                if (workingSets != null && workingSets.length > 0 && (javaProject = BaseProjectHelper.getJavaProject(project)) != null) {
                    Display.getDefault().syncExec((Runnable)new WorksetAdder(javaProject, workingSets));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(workspaceRunnable, monitor);
    }

    private void addDefaultDirectories(IProject project, String parentFolder, String[] folders, IProgressMonitor monitor) throws CoreException {
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder;
            String name = stringArray[n2];
            if (name.length() > 0 && !(folder = project.getFolder(String.valueOf(parentFolder) + name)).exists()) {
                folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            ++n2;
        }
    }

    private void addManifest(IProject project, Map<String, Object> parameters, Map<String, String> dictionary, IProgressMonitor monitor) throws CoreException, IOException {
        IFile file = project.getFile("AndroidManifest.xml");
        if (!file.exists()) {
            String manifestTemplate = AdtPlugin.readEmbeddedTextFile(TEMPLATE_MANIFEST);
            if ((manifestTemplate = this.replaceParameters(manifestTemplate, parameters)) == null) {
                AdtPlugin.logAndPrintError(null, "Create Project", "Failed to generate the Android manifest. Missing template %s", TEMPLATE_MANIFEST);
                return;
            }
            if (parameters.containsKey(PARAM_ACTIVITY)) {
                String activityTemplate = AdtPlugin.readEmbeddedTextFile(TEMPLATE_ACTIVITIES);
                String name = (String)parameters.get(PARAM_ACTIVITY);
                if (name.indexOf(46) == -1) {
                    parameters = new HashMap<String, Object>(parameters);
                    parameters.put(PARAM_ACTIVITY, "." + name);
                }
                String activities = this.replaceParameters(activityTemplate, parameters);
                String intent = AdtPlugin.readEmbeddedTextFile(TEMPLATE_INTENT_LAUNCHER);
                if (activities != null) {
                    if (intent != null) {
                        activities = activities.replaceAll(PH_INTENT_FILTERS, intent);
                    }
                    manifestTemplate = manifestTemplate.replaceAll(PH_ACTIVITIES, activities);
                }
            } else {
                manifestTemplate = manifestTemplate.replaceAll(PH_ACTIVITIES, "");
            }
            if (parameters.containsKey(PARAM_TEST_TARGET_PACKAGE)) {
                String instru;
                String usesLibrary = AdtPlugin.readEmbeddedTextFile(TEMPLATE_TEST_USES_LIBRARY);
                if (usesLibrary != null) {
                    manifestTemplate = manifestTemplate.replaceAll(PH_TEST_USES_LIBRARY, usesLibrary);
                }
                if ((instru = AdtPlugin.readEmbeddedTextFile(TEMPLATE_TEST_INSTRUMENTATION)) != null) {
                    manifestTemplate = manifestTemplate.replaceAll(PH_TEST_INSTRUMENTATION, instru);
                }
                manifestTemplate = this.replaceParameters(manifestTemplate, parameters);
            } else {
                manifestTemplate = manifestTemplate.replaceAll(PH_TEST_USES_LIBRARY, "");
                manifestTemplate = manifestTemplate.replaceAll(PH_TEST_INSTRUMENTATION, "");
            }
            String minSdkVersion = (String)parameters.get(PARAM_MIN_SDK_VERSION);
            if (minSdkVersion != null && minSdkVersion.length() > 0) {
                String usesSdkTemplate = AdtPlugin.readEmbeddedTextFile(TEMPLATE_USES_SDK);
                if (usesSdkTemplate != null) {
                    String usesSdk = this.replaceParameters(usesSdkTemplate, parameters);
                    manifestTemplate = manifestTemplate.replaceAll(PH_USES_SDK, usesSdk);
                }
            } else {
                manifestTemplate = manifestTemplate.replaceAll(PH_USES_SDK, "");
            }
            manifestTemplate = this.reformat(XmlFormatStyle.MANIFEST, manifestTemplate);
            ByteArrayInputStream stream = new ByteArrayInputStream(manifestTemplate.getBytes("UTF-8"));
            file.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void addStringDictionaryFile(IProject project, Map<String, String> strings, IProgressMonitor monitor) throws CoreException, IOException {
        IFile file = project.getFile("res//values//strings.xml");
        if (!file.exists()) {
            String stringDefinitionTemplate = AdtPlugin.readEmbeddedTextFile(TEMPLATE_STRINGS);
            String stringTemplate = AdtPlugin.readEmbeddedTextFile(TEMPLATE_STRING);
            Set<String> stringNames = strings.keySet();
            StringBuilder stringNodes = new StringBuilder();
            for (String key : stringNames) {
                String value = strings.get(key);
                value = ValueXmlHelper.escapeResourceString((String)value);
                String stringDef = stringTemplate.replace(PARAM_STRING_NAME, key);
                stringDef = stringDef.replace(PARAM_STRING_CONTENT, value);
                if (stringNodes.length() > 0) {
                    stringNodes.append('\n');
                }
                stringNodes.append(stringDef);
            }
            stringDefinitionTemplate = stringDefinitionTemplate.replace(PH_STRINGS, stringNodes.toString());
            stringDefinitionTemplate = this.reformat(XmlFormatStyle.RESOURCE, stringDefinitionTemplate);
            ByteArrayInputStream stream = new ByteArrayInputStream(stringDefinitionTemplate.getBytes("UTF-8"));
            file.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private String reformat(XmlFormatStyle style, String contents) {
        if (AdtPrefs.getPrefs().getUseCustomXmlFormatter()) {
            EclipseXmlFormatPreferences formatPrefs = EclipseXmlFormatPreferences.create();
            return EclipseXmlPrettyPrinter.prettyPrint(contents, formatPrefs, style, null);
        }
        return contents;
    }

    private void addIcon(IProject project, boolean legacy, IProgressMonitor monitor) throws CoreException {
        if (legacy) {
            IFile file = project.getFile("res//drawable//ic_launcher.png");
            if (!file.exists()) {
                this.addFile(file, AdtPlugin.readEmbeddedFile("templates/ic_launcher_mdpi.png"), monitor);
            }
        } else {
            IFile file = project.getFile("res//" + DRAWABLE_XHDPI_DIRECTORY + "/" + PROJECT_ICON);
            if (!file.exists()) {
                this.addFile(file, AdtPlugin.readEmbeddedFile("templates/ic_launcher_xhdpi.png"), monitor);
            }
            if (!(file = project.getFile("res//" + DRAWABLE_HDPI_DIRECTORY + "/" + PROJECT_ICON)).exists()) {
                this.addFile(file, AdtPlugin.readEmbeddedFile("templates/ic_launcher_hdpi.png"), monitor);
            }
            if (!(file = project.getFile("res//" + DRAWABLE_MDPI_DIRECTORY + "/" + PROJECT_ICON)).exists()) {
                this.addFile(file, AdtPlugin.readEmbeddedFile("templates/ic_launcher_mdpi.png"), monitor);
            }
            if (!(file = project.getFile("res//" + DRAWABLE_LDPI_DIRECTORY + "/" + PROJECT_ICON)).exists()) {
                this.addFile(file, AdtPlugin.readEmbeddedFile("templates/ic_launcher_ldpi.png"), monitor);
            }
        }
    }

    private void addFile(IFile dest, byte[] source, IProgressMonitor monitor) throws CoreException {
        if (source != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(source);
            dest.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void addSampleCode(IProject project, String sourceFolder, Map<String, Object> parameters, Map<String, String> dictionary, IProgressMonitor monitor) throws CoreException, IOException {
        String[] components;
        IFolder pkgFolder = project.getFolder(sourceFolder);
        String packageName = (String)parameters.get(PARAM_PACKAGE);
        String activityName = (String)parameters.get(PARAM_ACTIVITY);
        HashMap<String, Object> java_activity_parameters = new HashMap<String, Object>(parameters);
        java_activity_parameters.put(PARAM_IMPORT_RESOURCE_CLASS, "");
        if (activityName != null) {
            String resourcePackageClass = null;
            int lastDotIndex = activityName.lastIndexOf(46);
            if (lastDotIndex != -1) {
                if (lastDotIndex > 0) {
                    resourcePackageClass = String.valueOf(packageName) + '.' + "R";
                }
                packageName = activityName.startsWith(".") ? String.valueOf(packageName) + activityName.substring(0, lastDotIndex) : activityName.substring(0, lastDotIndex);
                activityName = activityName.substring(lastDotIndex + 1);
            }
            java_activity_parameters.put(PARAM_ACTIVITY, activityName);
            java_activity_parameters.put(PARAM_PACKAGE, packageName);
            if (resourcePackageClass != null) {
                String importResourceClass = "\nimport " + resourcePackageClass + ";";
                java_activity_parameters.put(PARAM_IMPORT_RESOURCE_CLASS, importResourceClass);
            }
        }
        String[] stringArray = components = packageName.split("\\.");
        int n = components.length;
        int importResourceClass = 0;
        while (importResourceClass < n) {
            String component = stringArray[importResourceClass];
            if (!(pkgFolder = pkgFolder.getFolder(component)).exists()) {
                pkgFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            ++importResourceClass;
        }
        if (activityName != null) {
            IFolder layoutfolder;
            String activityJava = String.valueOf(activityName) + ".java";
            IFile file = pkgFolder.getFile(activityJava);
            if (!file.exists()) {
                this.copyFile(JAVA_ACTIVITY_TEMPLATE, file, java_activity_parameters, monitor, false);
            }
            if (!(file = (layoutfolder = project.getFolder(RES_DIRECTORY).getFolder(LAYOUT_DIRECTORY)).getFile(MAIN_LAYOUT_XML)).exists()) {
                this.copyFile(LAYOUT_TEMPLATE, file, parameters, monitor, true);
                dictionary.put(STRING_HELLO_WORLD, String.format("Hello World, %1$s!", activityName));
            }
        }
    }

    private void copySampleCode(IProject project, File sampleDir, Map<String, Object> parameters, Map<String, String> dictionary, IProgressMonitor monitor) throws CoreException {
        IFileSystem fileSystem = EFS.getLocalFileSystem();
        ReadWriteFileStore sourceDir = new ReadWriteFileStore(fileSystem.getStore(sampleDir.toURI()));
        ReadWriteFileStore destDir = new ReadWriteFileStore(fileSystem.getStore(AdtUtils.getAbsolutePath((IResource)project)));
        sourceDir.copy(destDir, 2, null);
    }

    public static void addLocalFile(IProject project, File source, String destName, IProgressMonitor monitor) throws FileNotFoundException, CoreException {
        IFile dest = project.getFile(destName);
        if (!dest.exists()) {
            FileInputStream stream = new FileInputStream(source);
            dest.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void setupSourceFolders(IJavaProject javaProject, String[] sourceFolders, IProgressMonitor monitor) throws JavaModelException {
        IProject project = javaProject.getProject();
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        entries = this.removeSourceClasspath(entries, (IContainer)project);
        String[] stringArray = sourceFolders;
        int n = sourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceFolder = stringArray[n2];
            IFolder srcFolder = project.getFolder(sourceFolder);
            entries = this.removeSourceClasspath(entries, (IContainer)srcFolder);
            entries = ProjectHelper.addEntryToClasspath(entries, JavaCore.newSourceEntry((IPath)srcFolder.getFullPath()));
            ++n2;
        }
        javaProject.setRawClasspath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
    }

    private IClasspathEntry[] removeSourceClasspath(IClasspathEntry[] entries, IContainer folder) {
        if (folder == null) {
            return entries;
        }
        IClasspathEntry source = JavaCore.newSourceEntry((IPath)folder.getFullPath());
        int n = entries.length;
        int i = n - 1;
        while (i >= 0) {
            if (entries[i].equals(source)) {
                IClasspathEntry[] newEntries = new IClasspathEntry[n - 1];
                if (i > 0) {
                    System.arraycopy(entries, 0, newEntries, 0, i);
                }
                if (i < n - 1) {
                    System.arraycopy(entries, i + 1, newEntries, i, n - i - 1);
                }
                --n;
                entries = newEntries;
            }
            --i;
        }
        return entries;
    }

    private void copyFile(String resourceFilename, IFile destFile, Map<String, Object> parameters, IProgressMonitor monitor, boolean reformat) throws CoreException, IOException {
        XmlFormatStyle style;
        String template = AdtPlugin.readEmbeddedTextFile(TEMPLATES_DIRECTORY + resourceFilename);
        template = this.replaceParameters(template, parameters);
        if (reformat && (style = EclipseXmlPrettyPrinter.getForFile(destFile.getProjectRelativePath())) != null) {
            template = this.reformat(style, template);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(template.getBytes("UTF-8"));
        destFile.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
    }

    private String replaceParameters(String str, Map<String, Object> parameters) {
        if (parameters == null) {
            AdtPlugin.log(4, "NPW replace parameters: null parameter map. String: '%s'", str);
            return str;
        }
        if (str == null) {
            AdtPlugin.log(4, "NPW replace parameters: null template string", new Object[0]);
            return str;
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (entry == null || !(entry.getValue() instanceof String)) continue;
            Object value = entry.getValue();
            if (value == null) {
                AdtPlugin.log(4, "NPW replace parameters: null value for key '%s' in template '%s'", entry.getKey(), str);
                continue;
            }
            str = str.replaceAll(entry.getKey(), (String)value);
        }
        return str;
    }

    private static class ProjectInfo {
        private final IProject mProject;
        private final IProjectDescription mDescription;
        private final Map<String, Object> mParameters;
        private final HashMap<String, String> mDictionary;

        public ProjectInfo(IProject project, IProjectDescription description, Map<String, Object> parameters, HashMap<String, String> dictionary) {
            this.mProject = project;
            this.mDescription = description;
            this.mParameters = parameters;
            this.mDictionary = dictionary;
        }

        public IProject getProject() {
            return this.mProject;
        }

        public IProjectDescription getDescription() {
            return this.mDescription;
        }

        public Map<String, Object> getParameters() {
            return this.mParameters;
        }

        public HashMap<String, String> getDictionary() {
            return this.mDictionary;
        }
    }

    public static interface ProjectPopulator {
        public void populate(IProject var1) throws InvocationTargetException;
    }

    private static class ReadWriteFileStore
    extends FileStoreAdapter {
        public ReadWriteFileStore(IFileStore store) {
            super(store);
        }

        @Override
        public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
            IFileInfo info = super.fetchInfo(options, monitor);
            info.setAttribute(2, false);
            return info;
        }

        @Override
        public void putInfo(IFileInfo info, int options, IProgressMonitor storeMonitor) throws CoreException {
            info.setAttribute(2, false);
            super.putInfo(info, options, storeMonitor);
        }

        @Override
        @Deprecated
        public IFileStore getChild(IPath path) {
            IFileStore child = super.getChild(path);
            if (!(child instanceof ReadWriteFileStore)) {
                child = new ReadWriteFileStore(child);
            }
            return child;
        }

        @Override
        public IFileStore getChild(String name) {
            return new ReadWriteFileStore(super.getChild(name));
        }
    }

    private static class WorksetAdder
    implements Runnable {
        private final IJavaProject mProject;
        private final IWorkingSet[] mWorkingSets;

        private WorksetAdder(IJavaProject project, IWorkingSet[] workingSets) {
            this.mProject = project;
            this.mWorkingSets = workingSets;
        }

        @Override
        public void run() {
            if (this.mWorkingSets.length > 0 && this.mProject != null && this.mProject.exists()) {
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)this.mProject, this.mWorkingSets);
            }
        }
    }
}

