/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.templates;

import com.android.annotations.NonNull;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.wizards.templates.ActivityPage;
import com.android.ide.eclipse.adt.internal.wizards.templates.InstallDependencyPage;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewProjectWizardState;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewTemplatePage;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewTemplateWizardState;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateHandler;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateMetadata;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateWizard;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ui.IWorkbench;

public class NewActivityWizard
extends TemplateWizard {
    private NewTemplatePage mTemplatePage;
    private ActivityPage mActivityPage;
    private NewProjectWizardState mValues;
    private NewTemplateWizardState mActivityValues;
    protected boolean mOnlyActivities = true;

    @Override
    protected boolean shouldAddIconPage() {
        return this.mActivityValues.getIconState() != null;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(this.mOnlyActivities ? "New Activity" : "New Android Object");
        this.mValues = new NewProjectWizardState();
        this.mActivityPage = new ActivityPage(this.mValues, this.mOnlyActivities, false);
        this.mActivityValues = this.mValues.activityValues;
        List<IProject> projects = AdtUtils.getSelectedProjects((ISelection)selection);
        if (projects.size() == 1) {
            this.mActivityValues.project = projects.get(0);
        }
    }

    @Override
    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mActivityPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mActivityPage) {
            if (this.mTemplatePage == null) {
                Set<String> hidden = this.mActivityValues.hidden;
                hidden.add("packageName");
                hidden.add("minApi");
                hidden.add("minApiLevel");
                hidden.add("targetApi");
                hidden.add("buildApi");
                this.mTemplatePage = new NewTemplatePage(this.mActivityValues, true);
                this.addPage((IWizardPage)this.mTemplatePage);
            }
            return this.mTemplatePage;
        }
        if (page == this.mTemplatePage && this.shouldAddIconPage()) {
            WizardPage iconPage = this.getIconPage(this.mActivityValues.getIconState());
            this.mActivityValues.updateIconState(this.mTemplatePage.getEvaluator());
            return iconPage;
        }
        if (page == this.mTemplatePage || this.shouldAddIconPage() && page == this.getIconPage(this.mActivityValues.getIconState())) {
            TemplateMetadata template = this.mActivityValues.getTemplateHandler().getTemplate();
            if (template != null) {
                if (InstallDependencyPage.isInstalled(template.getDependencies())) {
                    return this.getPreviewPage(this.mActivityValues);
                }
                return this.getDependencyPage(template, true);
            }
        } else {
            TemplateMetadata template = this.mActivityValues.getTemplateHandler().getTemplate();
            if (template != null && page == this.getDependencyPage(template, false)) {
                return this.getPreviewPage(this.mActivityValues);
            }
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (this.mTemplatePage == null || !this.mTemplatePage.isPageComplete()) {
            return false;
        }
        return super.canFinish();
    }

    @Override
    @NonNull
    protected IProject getProject() {
        return this.mActivityValues.project;
    }

    @Override
    @NonNull
    protected List<String> getFilesToOpen() {
        TemplateHandler activityTemplate = this.mActivityValues.getTemplateHandler();
        return activityTemplate.getFilesToOpen();
    }

    @Override
    protected List<Change> computeChanges() {
        return this.mActivityValues.computeChanges();
    }

    public static class OtherWizard
    extends NewActivityWizard {
        public OtherWizard() {
            this.mOnlyActivities = false;
        }
    }
}

