/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.templates;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageControl;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectChooserHelper;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewTemplateWizardState;
import com.android.ide.eclipse.adt.internal.wizards.templates.Parameter;
import com.android.ide.eclipse.adt.internal.wizards.templates.StringEvaluator;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateMetadata;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NewTemplatePage
extends WizardPage
implements ModifyListener,
SelectionListener,
FocusListener {
    static final int WIZARD_PAGE_WIDTH = 600;
    private final NewTemplateWizardState mValues;
    private final boolean mChooseProject;
    private int mCustomMinSdk = -1;
    private int mCustomBuildApi = -1;
    private boolean mIgnore;
    private boolean mShown;
    private Control mFirst;
    private Map<String, ControlDecoration> mDecorations = new HashMap<String, ControlDecoration>();
    private Label mHelpIcon;
    private Label mTipLabel;
    private ImageControl mPreview;
    private Image mPreviewImage;
    private boolean mDisposePreviewImage;
    private ProjectChooserHelper.ProjectCombo mProjectButton;
    private StringEvaluator mEvaluator;
    private TemplateMetadata mShowingTemplate;

    NewTemplatePage(NewTemplateWizardState values, boolean chooseProject) {
        super("newTemplatePage");
        this.mValues = values;
        this.mChooseProject = chooseProject;
    }

    void setCustomMinSdk(int minSdk, int buildApi) {
        assert (!this.mChooseProject);
        this.mCustomMinSdk = minSdk;
        this.mCustomBuildApi = buildApi;
    }

    public void createControl(Composite parent2) {
        Composite parent = new Composite(parent2, 0);
        this.setControl((Control)parent);
        GridLayout parentLayout = new GridLayout(3, false);
        parentLayout.verticalSpacing = 0;
        parentLayout.marginWidth = 0;
        parentLayout.marginHeight = 0;
        parentLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)parentLayout);
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.widthHint = 600;
        label.setLayoutData((Object)data);
    }

    private void onEnter() {
        TemplateMetadata template = this.mValues.getTemplateHandler().getTemplate();
        if (template == this.mShowingTemplate) {
            return;
        }
        this.mShowingTemplate = template;
        Composite parent = (Composite)this.getControl();
        Control[] children = parent.getChildren();
        if (children.length > 0) {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            for (ControlDecoration decoration : this.mDecorations.values()) {
                decoration.dispose();
            }
            this.mDecorations.clear();
        }
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gl_container = new GridLayout(3, false);
        gl_container.horizontalSpacing = 10;
        container.setLayout((Layout)gl_container);
        if (this.mChooseProject) {
            String tooltip = "The Android Project where the new resource will be created.";
            Label projectLabel = new Label(container, 0);
            projectLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            projectLabel.setText("Project:");
            projectLabel.setToolTipText(tooltip);
            ProjectChooserHelper helper = new ProjectChooserHelper(this.getShell(), null);
            this.mProjectButton = new ProjectChooserHelper.ProjectCombo(helper, container, this.mValues.project);
            this.mProjectButton.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
            this.mProjectButton.setToolTipText(tooltip);
            this.mProjectButton.addSelectionListener(this);
        }
        this.mFirst = null;
        String thumb = null;
        if (template != null) {
            String description;
            thumb = template.getThumbnailPath();
            String title = template.getTitle();
            if (title != null && !title.isEmpty()) {
                this.setTitle(title);
            }
            if ((description = template.getDescription()) != null && !description.isEmpty()) {
                this.setDescription(description);
            }
            Map<String, String> defaults = this.mValues.defaults;
            HashSet<String> seen = null;
            if (LintUtils.assertionsEnabled()) {
                seen = new HashSet<String>();
            }
            List<Parameter> parameters = template.getParameters();
            block8: for (Parameter parameter : parameters) {
                Parameter.Type type = parameter.type;
                if (type == Parameter.Type.SEPARATOR) {
                    Label separator = new Label(container, 258);
                    separator.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
                    continue;
                }
                String id = parameter.id;
                assert (id != null && !id.isEmpty()) : "id";
                Object value = defaults.get(id);
                if (value == null) {
                    value = parameter.value;
                }
                String name = parameter.name;
                String help = parameter.help;
                assert (name != null && !name.isEmpty()) : "name";
                assert (seen != null && seen.add(id)) : id;
                if (this.mValues.hidden != null && this.mValues.hidden.contains(id)) continue;
                switch (type) {
                    case STRING: {
                        Label label = new Label(container, 0);
                        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
                        label.setText(name);
                        Text text = new Text(container, 2048);
                        text.setData((Object)parameter);
                        parameter.control = text;
                        if (parameter.constraints.contains((Object)Parameter.Constraint.EXISTS)) {
                            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                            Button button = new Button(container, 0x800000);
                            button.setData((Object)parameter);
                            button.setText("...");
                            button.addSelectionListener((SelectionListener)this);
                        } else {
                            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                        }
                        boolean hasValue = false;
                        if (value instanceof String) {
                            String stringValue = (String)value;
                            hasValue = !stringValue.isEmpty();
                            text.setText(stringValue);
                            this.mValues.parameters.put(id, value);
                        }
                        if (!hasValue) {
                            if (parameter.constraints.contains((Object)Parameter.Constraint.EMPTY)) {
                                text.setMessage("Optional");
                            } else if (parameter.constraints.contains((Object)Parameter.Constraint.NONEMPTY)) {
                                text.setMessage("Required");
                            }
                        }
                        text.addModifyListener((ModifyListener)this);
                        text.addFocusListener((FocusListener)this);
                        if (this.mFirst == null) {
                            this.mFirst = text;
                        }
                        if (help == null || help.isEmpty()) continue block8;
                        text.setToolTipText(help);
                        this.createFieldDecoration(id, (Control)text, help);
                        break;
                    }
                    case BOOLEAN: {
                        Label label = new Label(container, 0);
                        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
                        Button checkBox = new Button(container, 32);
                        checkBox.setText(name);
                        checkBox.setData((Object)parameter);
                        parameter.control = checkBox;
                        checkBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                        if (value instanceof Boolean) {
                            Boolean selected = (Boolean)value;
                            checkBox.setSelection(selected.booleanValue());
                            this.mValues.parameters.put(id, value);
                        }
                        checkBox.addSelectionListener((SelectionListener)this);
                        checkBox.addFocusListener((FocusListener)this);
                        if (this.mFirst == null) {
                            this.mFirst = checkBox;
                        }
                        if (help == null || help.isEmpty()) continue block8;
                        checkBox.setToolTipText(help);
                        this.createFieldDecoration(id, (Control)checkBox, help);
                        break;
                    }
                    case ENUM: {
                        Label label = new Label(container, 0);
                        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
                        label.setText(name);
                        Combo combo = NewTemplatePage.createOptionCombo(parameter, container, this.mValues.parameters, this, this);
                        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                        if (this.mFirst == null) {
                            this.mFirst = combo;
                        }
                        if (help == null || help.isEmpty()) continue block8;
                        this.createFieldDecoration(id, (Control)combo, help);
                        break;
                    }
                    case SEPARATOR: {
                        assert (false) : type;
                        continue block8;
                    }
                    default: {
                        assert (false) : type;
                        continue block8;
                    }
                }
            }
        }
        this.mPreview = new ImageControl(parent, 0, null);
        this.mPreview.setDisposeImage(false);
        GridData gd_mImage = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_mImage.widthHint = 220;
        this.mPreview.setLayoutData(gd_mImage);
        Label separator = new Label(parent, 258);
        GridData separatorData = new GridData(4, 128, true, false, 3, 1);
        separatorData.heightHint = 16;
        separator.setLayoutData((Object)separatorData);
        this.mHelpIcon = new Label(parent, 0);
        this.mHelpIcon.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        Image icon = IconFactory.getInstance().getIcon("quickfix");
        this.mHelpIcon.setImage(icon);
        this.mHelpIcon.setVisible(false);
        this.mTipLabel = new Label(parent, 64);
        this.mTipLabel.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.setPreview(thumb);
        parent.layout(true, true);
        parent.getParent().redraw();
    }

    @NonNull
    static Combo createOptionCombo(@NonNull Parameter parameter, @NonNull Composite container, @NonNull Map<String, Object> valueMap, @NonNull SelectionListener selectionListener, @NonNull FocusListener focusListener) {
        Combo combo = new Combo(container, 8);
        List<Element> options = parameter.getOptions();
        assert (options.size() > 0);
        int selected = 0;
        ArrayList ids = Lists.newArrayList();
        ArrayList minSdks = Lists.newArrayList();
        ArrayList minBuildApis = Lists.newArrayList();
        ArrayList labels = Lists.newArrayList();
        int i = 0;
        int n = options.size();
        while (i < n) {
            Element option = options.get(i);
            String optionId = option.getAttribute("id");
            assert (optionId != null && !optionId.isEmpty()) : "id";
            String isDefault = option.getAttribute("default");
            if (isDefault != null && !isDefault.isEmpty() && Boolean.valueOf(isDefault).booleanValue()) {
                selected = i;
            }
            NodeList childNodes = option.getChildNodes();
            assert (childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3);
            String optionLabel = childNodes.item(0).getNodeValue().trim();
            String minApiString = option.getAttribute("minApi");
            int minSdk = 1;
            if (minApiString != null && !minApiString.isEmpty()) {
                try {
                    minSdk = Integer.parseInt(minApiString);
                }
                catch (NumberFormatException nufe) {
                    AdtPlugin.log(nufe, null, new Object[0]);
                    minSdk = 1;
                }
            }
            String minBuildApiString = option.getAttribute("minBuildApi");
            int minBuildApi = 1;
            if (minBuildApiString != null && !minBuildApiString.isEmpty()) {
                try {
                    minBuildApi = Integer.parseInt(minBuildApiString);
                }
                catch (NumberFormatException nufe) {
                    AdtPlugin.log(nufe, null, new Object[0]);
                    minBuildApi = 1;
                }
            }
            minSdks.add(minSdk);
            minBuildApis.add(minBuildApi);
            ids.add(optionId);
            labels.add(optionLabel);
            ++i;
        }
        combo.setData((Object)parameter);
        parameter.control = combo;
        combo.setData("id", (Object)ids.toArray(new String[ids.size()]));
        combo.setData("minApi", (Object)minSdks.toArray(new Integer[minSdks.size()]));
        combo.setData("minBuildApi", (Object)minBuildApis.toArray(new Integer[minBuildApis.size()]));
        assert (labels.size() > 0);
        combo.setItems(labels.toArray(new String[labels.size()]));
        combo.select(selected);
        combo.addSelectionListener(selectionListener);
        combo.addFocusListener(focusListener);
        valueMap.put(parameter.id, ids.get(selected));
        if (parameter.help != null && !parameter.help.isEmpty()) {
            combo.setToolTipText(parameter.help);
        }
        return combo;
    }

    private void setPreview(String thumb) {
        Image oldImage = this.mPreviewImage;
        boolean dispose = this.mDisposePreviewImage;
        this.mPreviewImage = null;
        if (thumb == null || thumb.isEmpty()) {
            this.mPreviewImage = TemplateMetadata.getDefaultTemplateIcon();
            this.mDisposePreviewImage = false;
        } else {
            byte[] data = this.mValues.getTemplateHandler().readTemplateResource(thumb);
            if (data != null) {
                try {
                    this.mPreviewImage = new Image((Device)this.getControl().getDisplay(), (InputStream)new ByteArrayInputStream(data));
                    this.mDisposePreviewImage = true;
                }
                catch (Exception e) {
                    AdtPlugin.log(e, null, new Object[0]);
                }
            }
            if (this.mPreviewImage == null) {
                return;
            }
        }
        this.mPreview.setImage(this.mPreviewImage);
        this.mPreview.fitToWidth(200);
        if (oldImage != null && dispose) {
            oldImage.dispose();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.mPreviewImage != null && this.mDisposePreviewImage) {
            this.mDisposePreviewImage = false;
            this.mPreviewImage.dispose();
            this.mPreviewImage = null;
        }
    }

    private ControlDecoration createFieldDecoration(String id, Control control, String description) {
        ControlDecoration decoration = new ControlDecoration(control, 16384);
        decoration.setMarginWidth(2);
        FieldDecoration errorFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        decoration.setImage(errorFieldIndicator.getImage());
        decoration.setDescriptionText(description);
        control.setToolTipText(description);
        this.mDecorations.put(id, decoration);
        return decoration;
    }

    public boolean isPageComplete() {
        return this.mShown && super.isPageComplete();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.onEnter();
        }
        super.setVisible(visible);
        if (this.mFirst != null) {
            this.mFirst.setFocus();
        }
        if (visible) {
            this.mShown = true;
        }
        this.validatePage();
    }

    @Nullable
    static Parameter getParameter(Control control) {
        return (Parameter)control.getData();
    }

    @Nullable
    public StringEvaluator getEvaluator() {
        return this.mEvaluator;
    }

    private void validatePage() {
        int minSdk = this.getMinSdk();
        int buildApi = this.getBuildApi();
        IStatus status = this.mValues.getTemplateHandler().validateTemplate(minSdk, buildApi);
        if ((status == null || status.isOK()) && this.mChooseProject && this.mValues.project == null) {
            status = new Status(4, "com.android.ide.eclipse.adt", "Please select an Android project.");
        }
        for (Parameter parameter : this.mShowingTemplate.getParameters()) {
            if (parameter.type == Parameter.Type.SEPARATOR) continue;
            IInputValidator validator = parameter.getValidator(this.mValues.project);
            if (validator != null) {
                ControlDecoration decoration = this.mDecorations.get(parameter.id);
                String value = parameter.value == null ? "" : parameter.value.toString();
                String error = validator.isValid(value);
                if (error != null) {
                    Status s = new Status(4, "com.android.ide.eclipse.adt", error);
                    if (decoration != null) {
                        this.updateDecorator(decoration, (IStatus)s, parameter.help);
                    }
                    if (status == null || status.isOK()) {
                        status = s;
                    }
                } else if (decoration != null) {
                    this.updateDecorator(decoration, null, parameter.help);
                }
            }
            if (status != null && !status.isOK() || !(parameter.control instanceof Combo)) continue;
            status = NewTemplatePage.validateCombo(status, parameter, minSdk, buildApi);
        }
        this.setPageComplete(status == null || status.getSeverity() != 4);
        if (status != null) {
            this.setMessage(status.getMessage(), status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    static IStatus validateCombo(IStatus status, Parameter parameter, int minSdk, int buildApi) {
        Combo combo = (Combo)parameter.control;
        int index = combo.getSelectionIndex();
        return NewTemplatePage.validateCombo(status, parameter, index, minSdk, buildApi);
    }

    static IStatus validateCombo(IStatus status, Parameter parameter, int index, int minSdk, int buildApi) {
        Integer requiredBuildApi;
        Integer requiredMinSdk;
        Combo combo = (Combo)parameter.control;
        Integer[] optionIds = (Integer[])combo.getData("minApi");
        if (index != -1 && index < optionIds.length && (requiredMinSdk = optionIds[index]) > minSdk) {
            status = new Status(4, "com.android.ide.eclipse.adt", String.format("%1$s \"%2$s\" requires a minimum SDK version of at least %3$d, and the current min version is %4$d", parameter.name, combo.getItems()[index], requiredMinSdk, minSdk));
        }
        optionIds = (Integer[])combo.getData("minBuildApi");
        if (index != -1 && index < optionIds.length && (requiredBuildApi = optionIds[index]) > buildApi) {
            status = new Status(4, "com.android.ide.eclipse.adt", String.format("%1$s \"%2$s\"  requires a build target API version of at least %3$d, and the current version is %4$d", parameter.name, combo.getItems()[index], requiredBuildApi, buildApi));
        }
        return status;
    }

    private int getMinSdk() {
        return this.mChooseProject ? this.mValues.getMinSdk() : this.mCustomMinSdk;
    }

    private int getBuildApi() {
        return this.mChooseProject ? this.mValues.getBuildApi() : this.mCustomBuildApi;
    }

    private void updateDecorator(ControlDecoration decorator, IStatus status, String help) {
        if (help != null && !help.isEmpty()) {
            int severity;
            decorator.setDescriptionText(status != null ? status.getMessage() : help);
            int n = severity = status != null ? status.getSeverity() : 0;
            String id = severity == 4 ? "DEC_ERROR" : (severity == 2 ? "DEC_WARNING" : "DEC_INFORMATION");
            FieldDecoration errorFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration(id);
            decorator.setImage(errorFieldIndicator.getImage());
        } else if (status == null || status.isOK()) {
            decorator.hide();
        } else {
            decorator.show();
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source instanceof Text) {
            Text text = (Text)source;
            this.editParameter((Control)text, text.getText().trim());
        }
        this.validatePage();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mProjectButton) {
            this.mValues.project = this.mProjectButton.getSelectedProject();
        } else if (source instanceof Combo) {
            Combo combo = (Combo)source;
            String[] optionIds = (String[])combo.getData("id");
            int index = combo.getSelectionIndex();
            if (index != -1 && index < optionIds.length) {
                String optionId = optionIds[index];
                this.editParameter((Control)combo, optionId);
                TemplateMetadata template = this.mValues.getTemplateHandler().getTemplate();
                if (template != null) {
                    this.setPreview(template.getThumbnailPath());
                }
            }
        } else if (source instanceof Button) {
            Button button = (Button)source;
            Parameter parameter = (Parameter)button.getData();
            if (parameter.type == Parameter.Type.BOOLEAN) {
                this.editParameter((Control)button, button.getSelection());
                TemplateMetadata template = this.mValues.getTemplateHandler().getTemplate();
                if (template != null) {
                    this.setPreview(template.getThumbnailPath());
                }
            } else {
                String activity = this.chooseActivity();
                if (activity != null) {
                    this.setValue(parameter, activity);
                }
            }
        }
        this.validatePage();
    }

    private String chooseActivity() {
        SelectionDialog dialog;
        block9: {
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            IProject project = this.mValues.project;
            IJavaProject javaProject = BaseProjectHelper.getJavaProject(project);
            IType activityType = null;
            if (javaProject != null) {
                activityType = javaProject.findType("android.app.Activity");
            }
            if (activityType == null) {
                IJavaProject[] projects;
                IJavaProject[] iJavaProjectArray = projects = BaseProjectHelper.getAndroidProjects(null);
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject p = iJavaProjectArray[n2];
                    activityType = p.findType("android.app.Activity");
                    if (activityType != null) break;
                    ++n2;
                }
            }
            if (activityType != null) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                ITypeHierarchy hierarchy = activityType.newTypeHierarchy((IProgressMonitor)monitor);
                IType[] classes = hierarchy.getAllSubtypes(activityType);
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])classes, (int)1);
            }
            Shell parent = AdtPlugin.getShell();
            dialog = JavaUI.createTypeDialog((Shell)parent, (IRunnableContext)new ProgressMonitorDialog(parent), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"?", (TypeSelectionExtension)new TypeSelectionExtension(){

                public ITypeInfoFilterExtension getFilterExtension() {
                    return new ITypeInfoFilterExtension(){

                        public boolean select(ITypeInfoRequestor typeInfoRequestor) {
                            int modifiers = typeInfoRequestor.getModifiers();
                            return Flags.isPublic((int)modifiers) && !Flags.isInterface((int)modifiers) && !Flags.isEnum((int)modifiers);
                        }
                    };
                }
            });
            dialog.setTitle("Choose Activity Class");
            dialog.setMessage("Select an Activity class (? = any character, * = any string):");
            if (dialog.open() != 1) break block9;
            return null;
        }
        try {
            Object[] types = dialog.getResult();
            if (types != null && types.length > 0) {
                return ((IType)types[0]).getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return null;
    }

    private void editParameter(Control control, Object value) {
        Parameter parameter = NewTemplatePage.getParameter(control);
        if (parameter != null) {
            String id = parameter.id;
            parameter.value = value;
            parameter.edited = value != null && !value.toString().isEmpty();
            this.mValues.parameters.put(id, value);
            List<Parameter> parameters = this.mShowingTemplate.getParameters();
            for (Parameter p : parameters) {
                if (p == parameter || p.suggest == null || p.edited || p.type == Parameter.Type.SEPARATOR || !p.suggest.contains(id)) continue;
                try {
                    String updated;
                    if (this.mEvaluator == null) {
                        this.mEvaluator = new StringEvaluator();
                    }
                    if ((updated = this.mEvaluator.evaluate(p.suggest, parameters)) == null || updated.equals(p.value)) continue;
                    this.setValue(p, updated);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private void setValue(Parameter p, String value) {
        p.value = value;
        this.mValues.parameters.put(p.id, value);
        boolean prevIgnore = this.mIgnore;
        try {
            this.mIgnore = true;
            if (p.control instanceof Text) {
                ((Text)p.control).setText(value);
            } else if (!(p.control instanceof Button) && !(p.control instanceof Combo) && p.control != null) assert (false) : p.control;
        }
        finally {
            this.mIgnore = prevIgnore;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void focusGained(FocusEvent e) {
        ControlDecoration decoration;
        Control control;
        Parameter parameter;
        Object source = e.getSource();
        String tip = "";
        if (source instanceof Control && (parameter = NewTemplatePage.getParameter(control = (Control)source)) != null && (decoration = this.mDecorations.get(parameter.id)) != null) {
            tip = decoration.getDescriptionText();
        }
        this.mTipLabel.setText(tip);
        this.mHelpIcon.setVisible(tip.length() > 0);
    }

    public void focusLost(FocusEvent e) {
        this.mTipLabel.setText("");
        this.mHelpIcon.setVisible(false);
    }
}

