/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.io;

import com.android.ide.eclipse.adt.io.IFileWrapper;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.IAbstractResource;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IFolderWrapper
implements IAbstractFolder {
    private final IFolder mFolder;
    private final IContainer mContainer;

    public IFolderWrapper(IFolder folder) {
        this.mFolder = folder;
        this.mContainer = this.mFolder;
    }

    public IFolderWrapper(IContainer container) {
        this.mFolder = container instanceof IFolder ? (IFolder)container : null;
        this.mContainer = container;
    }

    public String getName() {
        return this.mContainer.getName();
    }

    public boolean exists() {
        return this.mContainer.exists();
    }

    public boolean delete() {
        try {
            this.mContainer.delete(true, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IAbstractResource[] listMembers() {
        try {
            IResource[] members = this.mContainer.members();
            int count = members.length;
            IAbstractResource[] afiles = new IAbstractResource[count];
            int i = 0;
            while (i < count) {
                IResource f = members[i];
                afiles[i] = f instanceof IFile ? new IFileWrapper((IFile)f) : new IFolderWrapper((IContainer)f);
                ++i;
            }
            return afiles;
        }
        catch (CoreException coreException) {
            return new IAbstractResource[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasFile(String name) {
        try {
            IResource[] files;
            IResource[] iResourceArray = files = this.mContainer.members();
            int n = files.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource file = iResourceArray[n2];
                if (name.equals(file.getName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public IAbstractFile getFile(String name) {
        if (this.mFolder != null) {
            IFile file = this.mFolder.getFile(name);
            return new IFileWrapper(file);
        }
        IFile file = this.mContainer.getFile((IPath)new Path(name));
        return new IFileWrapper(file);
    }

    public IFolder getIFolder() {
        return this.mFolder;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IFolderWrapper) {
            return this.mFolder.equals((Object)((IFolderWrapper)obj).mFolder);
        }
        if (obj instanceof IFolder) {
            return this.mFolder.equals(obj);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.mContainer.hashCode();
    }

    public IAbstractFolder getFolder(String name) {
        if (this.mFolder != null) {
            IFolder folder = this.mFolder.getFolder(name);
            return new IFolderWrapper(folder);
        }
        IFolder folder = this.mContainer.getFolder((IPath)new Path(name));
        return new IFolderWrapper(folder);
    }

    public String getOsLocation() {
        return this.mContainer.getLocation().toOSString();
    }

    public String[] list(IAbstractFolder.FilenameFilter filter) {
        try {
            IResource[] members = this.mContainer.members();
            if (members.length > 0) {
                ArrayList<String> list = new ArrayList<String>();
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    if (filter.accept((IAbstractFolder)this, res.getName())) {
                        list.add(res.getName());
                    }
                    ++n2;
                }
                return list.toArray(new String[list.size()]);
            }
        }
        catch (CoreException coreException) {}
        return new String[0];
    }

    public IAbstractFolder getParentFolder() {
        IContainer p = this.mContainer.getParent();
        if (p != null) {
            return new IFolderWrapper(p);
        }
        return null;
    }

    public String toString() {
        return this.mFolder.toString();
    }
}

