/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.wizards.actions.NewProjectAction;
import java.net.URL;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.part.IntroPart;

public class AdtIntro
extends IntroPart
implements IIntroPart {
    private static final int TEXT_WIDTH = 600;
    private FormToolkit mToolkit;
    private ScrolledForm mForm;
    private static final IHyperlinkListener sHyperLinkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            if (!(e.getHref() instanceof String)) {
                return;
            }
            String url = (String)e.getHref();
            if (url.isEmpty()) {
                return;
            }
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                IWebBrowser browser = support.getExternalBrowser();
                browser.openURL(new URL(url));
            }
            catch (Exception ex) {
                AdtPlugin.log((Throwable)ex, (String)"Error launching browser for URL: %1$s", (Object[])new Object[]{url});
            }
        }
    };

    public void standbyStateChanged(boolean standby) {
    }

    public void createPartControl(Composite parent) {
        this.mToolkit = new FormToolkit(parent.getDisplay());
        this.mForm = this.mToolkit.createScrolledForm(parent);
        this.mForm.setText("Welcome!");
        this.mToolkit.decorateFormHeading(this.mForm.getForm());
        this.mForm.getToolBarManager().update(true);
        GridLayout layout = new GridLayout(1, false);
        this.mForm.getBody().setLayout((Layout)layout);
        this.createText(this.mForm.getBody(), "The Android Developer Tools provide a first-class development environment for building Android apps. This integrated development environment is set up with the latest version of the Android platform and system image so you can immediately begin building apps and running them on the Android emulator.");
        Button newProject = this.mToolkit.createButton(this.mForm.getBody(), "New Android Application...", 8);
        newProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectAction npwAction = new NewProjectAction();
                npwAction.run(null);
                PlatformUI.getWorkbench().getIntroManager().closeIntro((IIntroPart)AdtIntro.this);
            }
        });
        Section section = this.mToolkit.createSection(this.mForm.getBody(), 528);
        section.setText("Tutorials");
        Composite c = this.mToolkit.createComposite((Composite)section);
        c.setLayout((Layout)new GridLayout(2, false));
        this.createHyperlink(c, "Build Your First App", "http://developer.android.com/training/basics/firstapp/index.html");
        this.createText(c, "If you're new to Android, follow this class to learn the fundamental Android APIs for creating a user interface that responds to input.");
        this.createHyperlink(c, "Design Your App", "http://developer.android.com/design/index.html");
        this.createText(c, "Before you begin developing your app, be sure you understand the design patterns that Android users expect from your app.");
        this.createHyperlink(c, "Test Your App", "http://developer.android.com/tools/testing/testing_android.html");
        this.createText(c, "The Android Framework provides tools that help you test every aspect of your app to be sure it behaves as expected under various conditions.");
        section.setClient((Control)c);
        this.mForm.reflow(true);
    }

    private void createText(Composite body, String text) {
        Label l = this.mToolkit.createLabel(body, text, 64);
        GridData gd = new GridData();
        gd.widthHint = 600;
        l.setLayoutData((Object)gd);
    }

    private void createHyperlink(Composite c, String text, String url) {
        Hyperlink link = this.mToolkit.createHyperlink(c, text, 64);
        link.setHref((Object)url);
        link.addHyperlinkListener(sHyperLinkListener);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
    }

    public void setFocus() {
        this.mForm.setFocus();
    }

    public void dispose() {
        if (this.mToolkit != null) {
            this.mToolkit.dispose();
            this.mToolkit = null;
        }
        super.dispose();
    }
}

