﻿
var cFos_object;
try {
   cFos_object = new ActiveXObject(ole_object);
}
catch(x) {
   alert("pref.js" + ole_object + "\n\n" + x.message + "\n\n" + ml.ole_error);
   window.close();
}

var ini = cFos_object.ini_file;

var buttons = new Array();
function button_obj(command, param_name, sval, rval) {
   this.command = command;
   this.param_name = param_name;
   this.sval = sval;
   this.rval = rval;
}

function button_val(command, name, val) {
   for (var i=0; i < buttons.length; ++i)
      if (name == buttons[i].param_name) {
         var save_cmd = " -save";
         if (command == "@set") save_cmd = ";@flush";
         var s = command + " " + buttons[i].param_name + " " + (val ? buttons[i].sval : buttons[i].rval) + save_cmd;
         cFos_object.spd_command(s);
         return;
      }
}

function set_b(command, name) {
   var el = get_element(name);
   el.src = "images/checkbox_on.png"
   el.alt = ml.yes;
   button_val(command, name, true);
}

function reset_b(command, name) {
   var el = get_element(name);
   el.src = "images/checkbox_off.png"
   el.alt = ml.no;
   button_val(command, name, false);
}

// function set_regid(val) {
//   var s = "@gset reg_id_default " + val + " -save";
//   cFos_object.spd_command(s);
//}

function get_val(name) {
   var s = cFos_object.spd_command("@set " + name);
   var m = s.match(/= *(.*)/);
   if (m == null) return "";
   s = btrim(m[1]);
   if (s == "inf") return "0";
   return String(parseInt(s / 1000));
}

function set_val(name, val) {
   if (val == 0) val = "inf";
   else val *= 1000;
   cFos_object.spd_command("@set " + name + " " + val);
}

function get_limits() {
   get_element("rx_limit").value = get_val("rx_limit");
   get_element("tx_limit").value = get_val("tx_limit");
   get_element("max_rx").innerHTML = get_val("maxrx");
   get_element("max_tx").innerHTML = get_val("maxtxraw");
}

function set_limits() {
   set_val("rx_limit", get_element("rx_limit").value);
   set_val("tx_limit", get_element("tx_limit").value);
   get_limits();
}

function browse_for_file() {
   var f = cFos_object.open_file_dialog("*.txt\0*.txt\0*.*\0*.*\0", 0);
   if (f != "") get_element("blocklist").value = f;
   ini.open("user.ini", "iplist");
   var old = ini.value("ipfilter");
   if (old != f) {
      ini.value("ipfilter") = f;
      ini.flush();
      cFos_object.spd_command("reload -iplist");
   }
}

function get_param(command, name) {
   var p = cFos_object.spd_command(command + " " + name);
   var m = p.match(/= *(.*)/);
   return m != null ? m[1] : "0";
}

function get_global_param(name) {
   var p = cFos_object.spd_command("@gset " + name);
   var m = p.match(/= *(.*)/);
   return m != null ? m[1] : "0";
}

function tabSelect(name) {
  $('.tab_a').removeClass('tab_a').addClass('tab');
  $('#tab_'+name).removeClass('tab').addClass('tab_a');
  $('.tab_a').removeClass('hover');
  $('.tab_box').hide();
  $('#'+name).show();
}

function dialog() {
   var exp_rwin_allowed = true;
   if (cFos_object.spd_command("@gset expand_rwin").toLowerCase().indexOf("unknown variable") == 0) exp_rwin_allowed = false;

   do_resize();
   // nocfos_start
   // varreg_start
   buttons.push(new button_obj("@gset", "reg_id_default", 3, 2));
   buttons.push(new button_obj("@gset", "net_talk_default", 1, 0));
   buttons.push(new button_obj("@set", "reg_id", 3, 2));
   buttons.push(new button_obj("@set", "net_talk", 1, 0));
   // varreg_end
   // nocfos_end
   buttons.push(new button_obj("@gset", "vari_fixed_default", 0, 1));
   buttons.push(new button_obj("@set", "vari_fixed", 0, 1));
   if (exp_rwin_allowed) buttons.push(new button_obj("@gset", "expand_rwin", 1, 0));
   else $("#rwin_exp_dlg").hide();
   buttons.push(new button_obj("@gset", "l7_detect", 1, 0));
   buttons.push(new button_obj("@gset", "latency", 1, 2));
   buttons.push(new button_obj("@gset", "avoid_loss", 1, 0));
   buttons.push(new button_obj("@gset", "handle_mss", 1, 0));
   buttons.push(new button_obj("@gset", "strict_rtp_check", 1, 0));
   buttons.push(new button_obj("@gset", "firewall", 1, 0));

   for (var i=0;i < buttons.length; ++i) {
      var id = buttons[i].param_name;
      var cmd = buttons[i].command;
      get_element(id).set = "set_b('" + cmd + "', '" + id + "');";
      get_element(id).reset = "reset_b('" + cmd + "', '" + id + "');";
      init_checkbox(id, get_param(cmd, id) == buttons[i].sval);
   }
   if (cFos_object.spd_command("@ports").match("no ports currently open.")) {
     $('#no_port').toggle();
     $('#port').toggle();
   }
   if (get_val("maxrx") == "") get_element("limit_dlg").style.display = "none";
   else get_limits();
   get_element("blocklist").value = ini.query("user.ini", "iplist", "ipfilter");
}
