
var cFos_object;
try {
   cFos_object = new ActiveXObject(ole_object);
}
catch(x) {
   var m = new ml_object;
   alert(ole_object + "\n\n" + x.message + "\n\n" + m.ole_error);
   window.close();
}

var ini_file = cFos_object.ini_file;

var prio1_section = prog_prio1_section;
var prio2_section = prog_prio2_section;
var prio3_section = prog_prio3_section;
var prio4_section = prog_prio4_section;
var prio5_section = prog_prio5_section;

var freeze = false;
var current_prio = -1;
var sort_num = -1;
var ascending = true;
var cmode = "";   // "tcp" or "udp"

var skey = new Array('p', 'l', 'o', 'g', '7', 't', 'r', 'T', 'R', 'd', 'c');
var prio_text = ["", "lowest", "low", "default", "high", "higher"];

var sorter_html = "";

function set_sort(num) {
   if (num == sort_num) ascending = !ascending;
   else {
      sort_num = num;
      ascending = true;
   }
   for (var i=0; i < 11; ++i) {
      var el = get_element("s"+i);
      if (num == i) el.className = ascending ? "c_set_up" : "c_set_down";
      else el.className = "c_not_set";
   }
   sorter_html = get_element("sorters").rows.item(0).outerHTML;
   if (freeze) refresh();
}

function set_cur_prio(val) {
   current_prio = val;
   $('#r1name').text(prio_text[val]);
}

function prio_setup(idx) {
   var prio;
   try {
      var r = get_element("sorters").rows.item(idx+1);
      get_element("local_addr").innerHTML = r.cells.item(1).innerHTML;
      get_element("local_addr_off").innerHTML = r.cells.item(1).innerHTML;
      get_element("remote_addr").innerHTML = r.cells.item(2).innerHTML;
      get_element("remote_addr_off").innerHTML = r.cells.item(2).innerHTML;
      var prot = r.cells.item(4).innerHTML;
      get_element("prot").innerHTML = prot;
      get_element("prot_off").innerHTML = prot;
      get_element("prot2").innerHTML = prot;
      var program = r.cells.item(3).innerHTML;
      get_element("program").innerHTML = program;
      get_element("program_off").innerHTML = program;
      get_element("program2").innerHTML = program;
      cmode = r.cells.item(0).innerHTML;
      var prio_val = r.cells.item(10).innerHTML.toLowerCase();
   }
   catch(err) { return; }
   if (prio_val.indexOf('*') != -1) {
      $('#settings_frame_off').show();
      return;
   }
   for (prio=0; prio < prio_text.length; ++prio) if (prio_text[prio] == prio_val) break;
   if (prio > 5) return;   // unknown prio, like 'working'
   $('#settings_frame').show();
   resizeDivs();
   current_prio = prio;
   init_radio_button("r1", current_prio, true);

   read_all_prog_sections();
   var sel = get_element("cat");
   sel.options.length = 0;
   sel.options[sel.options.length] = new Option("---", "");
   for (var i in filters) sel.options[sel.options.length] = new Option(translate_filter(i), i);
   var pi = prio_items[program];
   if (pi) {
      get_element("desc").value = pi.desc;
      get_element("cat").value = pi.filter;
   }
}

function read_protocol_settings() {
   prio_items = { };
   prio1_section = prot_prio1_section;
   prio2_section = prot_prio2_section;
   prio3_section = prot_prio3_section;
   prio4_section = prot_prio4_section;
   prio5_section = prot_prio5_section;
   read_section(def_ini_name, prio5_section, 5);
   read_section(def_ini_name, prio4_section, 4);
   read_section(def_ini_name, prio3_section, 3);
   read_section(def_ini_name, prio2_section, 2);
   read_section(def_ini_name, prio1_section, 1);
   read_section(ini_name, prio5_section, 5);
   read_section(ini_name, prio4_section, 4);
   read_section(ini_name, prio3_section, 3);
   read_section(ini_name, prio2_section, 2);
   read_section(ini_name, prio1_section, 1);
   if (object_empty(filters)) filters[other_name] = true;
}

function close_prio_box() {
   $('#settings_frame').hide();
   $('#settings_frame_off').hide();
   get_element("cat").style.backgroundColor = "#ffffff";
   get_element("desc").style.borderColor = "#abadb3 #dbdfe6 #e3e9ef #e2e3ea";
}

function do_apply(spd_cmd) {
   spd_cmd += " " + (current_prio == -1 ? "none" : prio_text[current_prio]);
   cFos_object.spd_command(spd_cmd);
   close_prio_box();
}

function apply_prioritization_off() {
   var r = document.getElementsByName("ptype_off");
   var val = "";
   for (var i=0; i < r.length; ++i) if (r[i].checked) val = r[i].value;

   var spd_cmd = "prioritize ";
   current_prio = -1;
   if (val == "con") do_apply(spd_cmd + cmode + " " + get_element("local_addr_off").innerHTML + " " + get_element("remote_addr_off").innerHTML);
   else if (val == "prot") do_apply(spd_cmd + "prot " + get_element("prot_off").innerHTML);
   else if (val == "prog") do_apply(spd_cmd + "prog " + get_element("program_off").innerHTML);
}

function apply_prioritization() {
   get_element("cat").style.backgroundColor = "#ffffff";
   get_element("desc").style.borderColor = "#abadb3 #dbdfe6 #e3e9ef #e2e3ea";

   var r = document.getElementsByName("ptype");
   var val = "";
   for (var i=0; i < r.length; ++i) if (r[i].checked) val = r[i].value;

   var spd_cmd = "prioritize ";
   if (val == "con") do_apply(spd_cmd + cmode + " " + get_element("local_addr").innerHTML + " " + get_element("remote_addr").innerHTML);
   else if (val == "prot") do_apply(spd_cmd + "prot " + get_element("prot").innerHTML);
   else if (val == "prog") do_apply(spd_cmd + "prog " + get_element("program").innerHTML);
   else if (val == "prot_perm") {
      read_protocol_settings();
      var pi = prio_items[get_element("prot").innerHTML.toUpperCase()];
      pi.prio = current_prio;
      pi.ini_name = ini_name;
      save_prio_settings();
      ini_file.flush();
      cFos_object.action("spd reload");
      close_prio_box();
   }
   else if (val == "prog_perm") {
      if (!get_element("cat").value) {
         get_element("cat").style.backgroundColor = "red";
         return;
      }
      var desc = btrim(get_element("desc").value);
      if (desc == "") {
         get_element("desc").style.borderColor = "red";
         return;
      }
      var sel = get_element("program").innerHTML;
      var pi = prio_items[sel];
      if (!pi) {
         // try to fix uppercase/lowercase problems
         sel = sel.toLowerCase();
         pi = prio_items[sel];
         if (!pi) {
            for (var i in prio_items) {
               if (i.toLowerCase() == sel) {
                  sel = i.toLowerCase();
                  pi = prio_items[sel];
                  break;
               }
            }
         }
      }
      if (pi) {
         pi.prio = current_prio;
         pi.ini_name = ini_name;
      }
      else {
         var filter = get_element("cat").value;
         prio_items[sel] = new prio_obj(filter, desc, current_prio, ini_name);
      }
      save_prio_settings();
      ini_file.flush();
      cFos_object.action("spd reload");
      close_prio_box();
   }
}

function refresh() {
   if (freeze) return;
   var s = "@connections -raw -cps -vol -class";
   if (sort_num != -1) s += " -sort:" + skey[sort_num] + (ascending ? "" : "-");
   s = cFos_object.spd_command(s);

   if (!sorter_html) sorter_html = get_element("sorter_body").innerHTML;
   var h = sorter_html;
   var lines = s.split('\n');
   for (var i=0; i < lines.length; ++i) {
      var l = lines[i].replace(/^\s+|\s+$/g, "");
      if (!l) continue;
      h += '<tr class="list" onclick="prio_setup('+i+')"><td class="entry">' + l.replace(/\s+/g, '</td><td class="entry">') + '</td></tr>';
   }
   get_element("sorters").outerHTML =
      '<table id="sorters" cellpadding="0" cellspacing="0"><tbody id="sorter_body">' + h + '</tbody></table>';
   if ( $('#sorters').width() > $(window).width()-24)
      window.resizeBy($('#sorters').width()-$(window).width() + 24,0);

//alert(get_element("sorters").outerHTML);
   setTimeout("refresh()", 1000);
}

function toggle_freeze() {
   freeze = !freeze;
   if (!freeze) {
      $('#continue_button').hide();
      $('#freeze_button').show();
      refresh();
   }  else {
      $('#freeze_button').hide();
      $('#continue_button').show();
   }
}

function init_console() {
   refresh();
}
