
var ml = new ml_object;

var dlg_mouse_down = false;

var IE_m = window.navigator.appVersion.match(/MSIE (\d)/);
var IEstrict = IE_m != null && Number(IE_m[1]) >= 6;

function _tofixed(v, w, n) {
   var s = parseInt(v) + ".";
   var t = String(parseInt(w));
   while (t.length < n) t = "0" + t;
   return s + t;
}

function os_version() {
   if (IE_m == null) return 0;
   var m = navigator.appVersion.match(/Windows NT (\d+)\.(\d+)/);
   if (m == null) return 0;
   return Number(m[1])*100 + Number(m[2]);
}

function do_resize(_mx, _my) {
   try {
      var mx = _mx ? _mx : 1024;
      var w = document.body.offsetWidth;
      if (w > mx) window.resizeBy(mx-w, 0);
      if (_my && IEstrict) {
         var h = document.documentElement.offsetHeight;
         if (h > _my) window.resizeBy(0, _my-h);
      }
   }
   catch(x) { }
}

function get_element(n) {
   return document.getElementById(n);
}

var btrim_regexp = new RegExp("^\\s+|\\s+$", "g");

function btrim(s) {
   return s.replace(btrim_regexp, "");
}

function object_empty(o) {
   for (var x in o) return false;
   return true;
}

function yesno_text(yes) { return yes ? ml.yes : ml.no; }

var br_info = new Object();

function br_to_html(cell_id, val_obj, idx) 
{
   var org = br_info[cell_id];
   var s = "", len = org._r.length;
   for (var i=0; i < len; ++i) {
      var r = org._r[i];
      s += org._s[i] + (r == "" ? idx+1 : val_obj[r]);
   }
   s += org._s[len];

   return s;
}

function eval_row(id, r) 
{
   var cnt = r.cells.length;
   br_info[id+"_cell_cnt"] = cnt;
   for (var i=0; i < cnt; ++i) 
   {
      var ci = (br_info[id+i] = new Object());
      ci._s = new Array();
      ci._r = new Array();
      var s = r.cells[i].innerHTML;

      while (1) 
      {
         var m = s.match(/@(@|\w+)/);

         if (m == null) break;

         ci._r[ci._r.length] = m[0] == "@@" ? "" : m[0].substr(1);
         ci._s[ci._s.length] = s.substr(0, m.index);
         s = s.substr(m.index + m[0].length);
      }

      ci._s[ci._s.length] = s;

   }
}

function fill_table(id, row_ofs, val_array) 
{
   var t = get_element(id);
   var num = val_array.length;
   if (num == 0) 
   {
      t.style.display = "none";
     //return;
   }

   t.style.display = "inline";
   if (br_info[id+"0"] == null) eval_row(id, t.rows.item(row_ofs));
   var i, cnt = br_info[id+"_cell_cnt"];
   var len = t.rows.length;
   for (i=row_ofs; i < num+row_ofs; ++i) 
   {
      var tr;
      if (i >= len) 
      {
         tr = t.insertRow();
         for (var j=0; j < cnt; ++j) 
         {
            var td = t.rows[row_ofs].cells[j].cloneNode(true);
            tr.appendChild(td);
         }
         ++len;
      }
      else 
         tr = t.rows[i];

      var val_obj = val_array[i-row_ofs];
      for (var j=0; j < cnt; ++j) 
	  tr.cells[j].innerHTML = br_to_html(id+j, val_obj, i-row_ofs);

      if (val_obj.className != null) tr.className = val_obj.className;
      tr.style.display = "inline";
      tr.rownum = i - row_ofs;
   }

   for (; i < len; ++i) 
	 t.rows[i].style.display = "none";

return;
   if (num == 0) 
   {
      var param = GameFirstII_APP.commandLine.match(/[\w!#$%&'*+-/=?^_`{}~\\:]+|\"[^\"]*\"/g);
      for (var i=0; i < param.length; ++i) 
      {
         if (param[i].charAt(0) == '"') param[i] = param[i].substr(1, param[i].length-2);
      }
      var homedir = param[0].substr(0, param[0].lastIndexOf('\\')+1);
      var el = document.getElementById("mybg");
      alert("1");
	//el.bgcolor = #070707;
      el.bgcolor = homedir + "slider/list_bg01.png";

   }
}

function delete_table_row(id, idx) {
   var t = get_element(id);
   for (var i=0; i < t.rows.length; ++i) {   // row 0 is backup row
      if (t.rows.item(i).rownum == idx) {
         if (t.rows.length > 1) t.deleteRow(i);
         else t.rows[i].style.display = "none";
         return;
      }
   }
}

function obj_elements_to_html(org, val_array, idx) {
   var s = org.innerHTML;
   s = s.replace(/##/g, idx+1);
   var obj = val_array[idx];
   for (var i in obj) s = s.replace(new RegExp("#"+i,"g"), obj[i]);
   return s;
}

function fill_table_row(id, row_ofs, col_ofs, val_array) {
   var t = get_element(id);
   var num = val_array.length;
   if (num == 0) {
      t.style.display = "none";
      //return;
   }
   t.style.display = "inline";
   var r = t.rows.item(row_ofs);
   var org = r.cells.item(col_ofs);
   for (var i=1; i < num; ++i) {
      var c = r.insertCell(col_ofs+i);
      c.innerHTML = obj_elements_to_html(org, val_array, i);
      if (org.name) c.name = org.name;
      if (val_array[i].className != null) c.className = val_array[i].className;
   }
   org.innerHTML = obj_elements_to_html(org, val_array, 0);
   if (val_array[0].className != null) org.className = val_array[0].className;
}

function set_hover_class(el, is_hover) {
   var h = el.hover_effect.split(",");
   if (is_hover) {
      if (h[2].charAt(0) != '-') el.className = h[2];
      else if (!el.checked) el.className = h[2].substr(1);
   }
   else {
      el.className = el.checked ? h[0] : h[1];
   }
}

function set_button(e, checked) {
   var c = e.checked;
   e.checked = checked;   // maybe boolean or string if specified in html. so we make a boolean here
   if (String(c) == String(checked)) return;
   if (e.hover_effect) set_hover_class(e, false);
   if (checked) {
      if (e.set) eval(e.set);
   }
   else {
      if (e.reset) eval(e.reset);
   }
}

var pseudo_ev_element;

function ev_set_button(el, checked) {
   pseudo_ev_element = el;
   set_button(el, checked);
   pseudo_ev_element = null;
}

function get_event_element(bubble_to_name) {
   if (pseudo_ev_element != null) return pseudo_ev_element;
   var ev = window.event ? window.event : parent.event;
   if (ev.type == "keyup") {
      var k = ev.keyCode;
      if (typeof(k) == "number") k = String.fromCharCode(k);
      if (k != ' ' && k != String.fromCharCode(13)) return null;
   }
   var el = ev.srcElement;
   if (bubble_to_name && el != null) {
      while (!el.name) {
         if (!el.parentNode || el.parentNode == el) break;
         el = el.parentNode;
      }
   }
   return el;
}

function checkbox_event() {
   var src = get_event_element();
   if (src == null) return;
   set_button(src, !src.checked);
}

function pushbutton_event() {
   var src = get_event_element();
   if (src == null) return;
   set_button(src, true);
}

function radio_button_event() {
   var src = get_event_element(true);
   if (src == null) return;
   var e = document.getElementsByName(src.name);
   for (var i=0; i < e.length; ++i) set_button(e[i], e[i] == src);
}

function handle_mouse_over() {
   var e = get_event_element();
   if (e == null) return;
   while (!e.mouse_over && !e.hover_effect) {
      if (!e.parentNode || e.parentNode == e) return;
      e = e.parentNode;
   }
   if (e.hover_effect) set_hover_class(e, true);
   if (e.mouse_over) eval(String(src.mouse_over));
}

function handle_mouse_out() {
   var e = get_event_element();
   if (e == null) return;
   while (!e.mouse_out && !e.hover_effect) {
      if (!e.parentNode || e.parentNode == e) return;
      e = e.parentNode;
   }
   if (e.hover_effect) set_hover_class(e, false);
   if (e.mouse_out) eval(String(src.mouse_out));
}

function init_checkbox(name, checked) {
   document.body.onmousedown = set_mouse_down;
   document.body.onmouseup = set_mouse_up;
   var e = get_element(name);
   if (!e) {
      alert("checkbox '"+name+"' not found.");
      return;
   }
   ev_set_button(e, checked);
   e.onclick = checkbox_event;
   e.ondblclick = checkbox_event;
   e.onmouseover = handle_mouse_over;
   e.onmouseout = handle_mouse_out;
}

function init_pushbutton(name) {
   document.body.onmousedown = set_mouse_down;
   document.body.onmouseup = set_mouse_up;
   var e = get_element(name);
   if (!e) {
      alert("pushbutton '"+name+"' not found.");
      return;
   }
   ev_set_button(e, false);
   e.onclick = pushbutton_event;
   e.ondblclick = pushbutton_event;
   e.onmouseover = handle_mouse_over;
   e.onmouseout = handle_mouse_out;
}

function cancel_dragdrop() {
   window.event.returnValue = false;
   window.event.cancelBubble = false;
}

function set_mouse_down() { dlg_mouse_down = true; }
function set_mouse_up() { dlg_mouse_down = false; }

function slider_track_mouse() {
   if (dlg_mouse_down) radio_button_event();
}

function init_radio_button(name, value, slider) {
   document.body.onmousedown = set_mouse_down;
   document.body.onmouseup = set_mouse_up;
   var e = document.getElementsByName(name);
   if (!e || !e.length || e.length == 0) {
      alert("radio button '"+name+"' not found.");
      return;
   }
   for (var i=0; i < e.length; ++i) {
      if (!e[i].name) e[i].name = e[i].id;
      ev_set_button(e[i], e[i].value == value);
      e[i].onclick = radio_button_event;
      e[i].ondblclick = radio_button_event;
      if (slider) {
         e[i].ondragstart = cancel_dragdrop;
         e[i].onmouseover = slider_track_mouse;
      }
      else {
         e[i].onmouseover = handle_mouse_over;
         e[i].onmouseout = handle_mouse_out;
      }
   }
}

function inject_button_events() {
   document.body.onmousedown = set_mouse_down;
   document.body.onmouseup = set_mouse_up;
   var e = document.getElementsByTagName("input");
   for (var i=0; i < e.length; ++i) {
      if (e[i].type == "radio") {
         e[i].onclick = radio_button_event;
         e[i].ondblclick = radio_button_event;
         e[i].onkeyup = radio_button_event;
      }
      else if (e[i].type == "checkbox") {
         e[i].onclick = checkbox_event;
         e[i].ondblclick = checkbox_event;
         e[i].onkeyup = checkbox_event;
      }
      else if (e[i].type == "button") {
         e[i].onclick = pushbutton_event;
         e[i].ondblclick = pushbutton_event;
         e[i].onkeyup = pushbutton_event;
      }
      e[i].onmouseover = handle_mouse_over;
      e[i].onmouseout = handle_mouse_out;
   }
}
