
var ini_name = "user.ini";
var def_ini_name = "settings.ini";

var other_name = "Other";

var prog_prio1_section = "lowestprogs";
var prog_prio2_section = "lowprogs";
var prog_prio3_section = "normalprogs";
var prog_prio4_section = "highprogs";
var prog_prio5_section = "higherprogs";

var prot_prio1_section = "lowestprots";
var prot_prio2_section = "lowprots";
var prot_prio3_section = "normalprots";
var prot_prio4_section = "highprots";
var prot_prio5_section = "higherprots";

function push(a, e) { a[a.length] = e; }

var ml = new ml_object();
var filter_trans = { "games": ml.games, "file sharing": ml.p2p, "p2p": ml.p2p, "voice over ip": ml.voip,
   "multimedia": ml.multimedia, "remote control": ml.remote_control, "other": ml.other, "clients": ml.client_prots,
   "servers": ml.server_prots, "special": ml.special };

function translate_filter(name) {
   return filter_trans[name.toLowerCase()] || name;
}

function prio_obj(filter, desc, prio, ini_name) {
   this.filter = filter;
   this.desc = desc;
   this.prio = prio;
   this.ini_name = ini_name;
   this.tx_limit = "-"
}

var filters = new Object();
var prio_items = new Object();
var deleted_settings_ini_prio_items = new Object();

var current_filter;
var modified = false;

function set_prio(key, idx, val, pname) {
   modified = true;
   if (val != 0) {
      if (prio_items[key].prio != val) prio_items[key].ini_name = ini_name;   // save in user.ini
      prio_items[key].prio = val;
      get_element("pname"+idx).innerHTML = pname;
      $('#b_prio_'+idx).attr('src', 'images/prio_'+val+'.png');
   }
   else {
      deleted_settings_ini_prio_items[key] = true;
      if (prio_items[key].tx_limit != "-") reset_limit(key,'prog',idx,'tx');
      delete prio_items[key];
      var t = get_element(prio_table_id);
//      t.deleteRow(idx);   // can't do that, idx is wrong on subsequent calls
      t.rows[idx].style.display = "none";
   }
}

function read_section(iname, sec_name, prio) {
   ini_file.open(iname, sec_name);
   var cnt = ini_file.length;
   for (var i=0; i < cnt; ++i) {
      var key = ini_file.key(i);
      var val = ini_file.value(key);
      var m = val.match(/\s*([\w\s]*)\s*,\s*(.*)\s*/);
      var filter = "", desc = "";
      if (m != null) {
         filter = m[1];
         desc = m[2];
      }
      if (filter.length == 0) filter = other_name;
      filters[filter] = true;
      prio_items[key] = new prio_obj(filter, desc, prio, iname);
   }
}

function save_section(name, prio) {
   ini_file.open(ini_name, name);
   ini_file.delete_section();
   for (var x in prio_items)
      if (prio_items[x].prio == prio && prio_items[x].ini_name == ini_name) ini_file.value(x) = prio_items[x].filter + ", " + prio_items[x].desc;
   ini_file.flush();
}

function save_prio_settings() {
   save_section(prio5_section, 5);
   save_section(prio4_section, 4);
   save_section(prio3_section, 3);
   save_section(prio2_section, 2);
   save_section(prio1_section, 1);
   for (var x in deleted_settings_ini_prio_items)
      if (prio_items[x] == null) {
         ini_file.del(def_ini_name, prio5_section, x);
         ini_file.del(def_ini_name, prio4_section, x);
         ini_file.del(def_ini_name, prio3_section, x);
         ini_file.del(def_ini_name, prio2_section, x);
         ini_file.del(def_ini_name, prio1_section, x);
      }
}

function set_limit(name, type, pos, direction) {
  var value = $('#tx_limit_'+pos).attr('value');
  var output = "";
  eval("var cur_limit = prio_items[\""+name+"\"]."+direction+"_limit;");
  if (value.match(/\b\d+%*\b/) != null) {
    if (value.indexOf("%") != -1) value = Math.min(100, parseInt(value.substr(0, value.indexOf("%")))) + "%";
    output = cFos_object.spd_command("@limit class c_"+type+"_"+name+" -speed "+value);
//    alert(output);
    if (cur_limit == "-") {
      output = cFos_object.spd_command("@limit filter -A -"+direction+" -"+type+" "+name+" -c c_"+type+"_"+name);
//      alert(output);
    }
    eval("prio_items[\""+name+"\"]."+direction+"_limit = \""+value+"\";");
    $('#b_tx_limit_'+pos).attr('src', 'images/tx_limit_on.png');
    $('#b_'+direction+'_limit_del_'+pos).removeAttr('disabled');
    } else  $('#tx_limit_'+pos).attr('value', cur_limit);
}

function reset_limit(name, type, pos, direction) {
  var output = cFos_object.spd_command("@limit class -D c_"+type+"_"+name);
//  alert(output);
  eval("prio_items[\""+name+"\"]."+direction+"_limit = \"-\";");
  $('#b_'+direction+'_limit_'+pos).attr('src', 'images/tx_limit_off.png');
  $('#tx_limit_'+pos).attr('value', '-');
  $('#b_'+direction+'_limit_del_'+pos).attr('disabled', 'disabled');
  $('#b_'+direction+'_limit_del_'+pos).removeClass('hover')
  $('#b_'+direction+'_limit_del_'+pos).parent().removeClass('div_hover')
}

function exit_dialog(save) {
   var mod = modified;
   modified = false;
   if (save) {
      if (mod) {
         save_prio_settings();
         ini_file.flush();
         cFos_object.action("spd reload");
      }
   }
   else window.location.reload();   // again calls exit_dialog through onunload
}

function load_table() {
   $('#loading').show();
   function do_load() {
      var a = [];
      for (var x in prio_items) {
         var pi = prio_items[x];
         if (pi.filter != current_filter) continue;
         var name;
         if (pi.desc.length != 0) {
            if (show_prio_id) name = pi.desc + " (" + x + ")";
            else name = pi.desc;
         }
         else name = x;
         a.push({
            name: name,
            key: x,
            prio: pi.prio,
            tx_limit: pi.tx_limit,
            prio_img: 'images/prio_'+pi.prio+'.png',
            tx_limit_img: pi.tx_limit != "-" ? "images/tx_limit_on.png" : "images/tx_limit_off.png"
         });
      }
      a.sort(function(l, r) {
         if (l.name < r.name) return -1;
         if (l.name > r.name) return 1;
         return 0;
      });
      fill_table(prio_table_id, 0, a);
      if (get_element("b0") != null) {
         var len = a.length;
         for (var i=0; i < len; ++i) init_pushbutton("b"+i);
      }
      $('button.norm_button').each(function() { buildButton($(this)); });
      $('button.tab_button').each(function() { buildButton($(this), "tab"); });
      $('button.del_button').each(function() { buildButton($(this), "del"); });
      $('.closebar').each(function() { buildCloseBar($(this)); });
      resizeTablebox();
      $('#loading').hide();
      $('.setting_box').hide();
      $('#settings_frame').hide();
   }
   window.setTimeout(do_load, 100);
}

function set_filter(filter) {
   var reload = current_filter != filter;
   current_filter = filter;
   cFos_object.param(filter_key) = current_filter;
   if (reload) load_table();
   $('.sub_a').removeClass('sub_a');
   $('li[id='+current_filter+']').addClass('sub_a');
   resizeDivs();
}

function restore_defaults(prog) {
   modified = false;
   cFos_object.restore_defaults(prog);
   cFos_object.action("spd reload");
   window.location.reload();
}

function read_all_prog_sections() {
   read_section(def_ini_name, prog_prio5_section, 5);
   read_section(def_ini_name, prog_prio4_section, 4);
   read_section(def_ini_name, prog_prio3_section, 3);
   read_section(def_ini_name, prog_prio2_section, 2);
   read_section(def_ini_name, prog_prio1_section, 1);
   read_section(ini_name, prog_prio5_section, 5);
   read_section(ini_name, prog_prio4_section, 4);
   read_section(ini_name, prog_prio3_section, 3);
   read_section(ini_name, prog_prio2_section, 2);
   read_section(ini_name, prog_prio1_section, 1);
   if (!filters.other_name) filters[other_name] = true;
}
