
var ml = new ml_object;

var dlg_mouse_down = false;

var IE_m = window.navigator.appVersion.match(/MSIE (\d)/);
var IEstrict = IE_m != null && Number(IE_m[1]) >= 6;

function _tofixed(v, w, n) {
   var s = parseInt(v) + ".";
   var t = String(parseInt(w));
   while (t.length < n) t = "0" + t;
   return s + t;
}

function os_version() {
   var m = navigator.userAgent.match(/Windows NT (\d+)\.(\d+)/);
   if (m == null) return 0;
   return Number(m[1])*100 + Number(m[2]);
}

function do_resize(_mx, _my) {
   try {
      var mx = _mx ? _mx : 820;
      var my = _my ? _my : 580;
      var w = document.body.offsetWidth;
      window.resizeBy(mx-w, 0);
      var h = document.documentElement.offsetHeight;
      window.resizeBy(0, my-h);
   }
   catch(x) { }
}

function get_element(n) {
   return document.getElementById(n);
}

var brim_regexp = new RegExp("^\\s+|\\s+$", "g");

function btrim(s) {
   return s.replace(brim_regexp, "");
}

function object_empty(o) {
   for (var x in o) return false;
   return true;
}

function yesno_text(yes) { return yes ? ml.yes : ml.no; }

var row_html = { };

function fill_table(id, row_ofs, val_array) {
   var t = get_element(id);
   if (!row_html[id]) {
      var h = "";
      for (var i=0; i < row_ofs; ++i) h += t.rows.item(i).outerHTML;
      var b = t.rows.item(row_ofs).outerHTML;
      var tab = t.outerHTML.match(/<table.*?>/i)[0];
      row_html[id] = { head: h, body: b, tag: tab };
   }
   var rh = row_html[id];
   var thtml = rh.tag + "<thead>" + rh.head + "</thead><tbody>";
   var b = rh.body;
   for (var i=0; i < val_array.length; ++i) {
      var obj = val_array[i];
      thtml += b.replace(/#(#|\w+)/g, function(sub, cap) {
         if (cap == '#') return i;
         return obj[cap];
      });
   }
   thtml += "</tbody></table>";
   t.outerHTML = thtml;
}

function make_submenu(val_array) {
  var num = val_array.length;
  if (val_array.length >= 1) {
    for (var i=0; i < num; ++i) {
      $('#sub').append('<li class="sub" id="'+val_array[i]["filter"]+'"><a href="javascript: set_filter(\''+val_array[i]["filter"]+'\')">'+val_array[i]["trans_filter"]+'</a></li>');
    }
  }
}

function set_hover_class(el, is_hover) {
   var h = el.hover_effect.split(",");
   if (is_hover) {
      if (h[2].charAt(0) != '-') el.className = h[2];
      else if (!el.checked) el.className = h[2].substr(1);
   }
   else {
      el.className = el.checked ? h[0] : h[1];
   }
}

function set_button(e, checked) {
   var c = e.checked;
   e.checked = checked;   // maybe boolean or string if specified in html. so we make a boolean here
   if (String(c) == String(checked)) return;
   if (e.hover_effect) set_hover_class(e, false);
   if (checked) {
      if (e.set) eval(e.set);
   }
   else {
      if (e.reset) eval(e.reset);
   }
}

var pseudo_ev_element;

function ev_set_button(el, checked) {
   pseudo_ev_element = el;
   set_button(el, checked);
   pseudo_ev_element = null;
}

function get_event_element(bubble_to_name) {
   if (pseudo_ev_element != null) return pseudo_ev_element;
   var ev = window.event ? window.event : parent.event;
   if (ev.type == "keyup") {
      var k = ev.keyCode;
      if (typeof(k) == "number") k = String.fromCharCode(k);
      if (k != ' ' && k != String.fromCharCode(13)) return null;
   }
   var el = ev.srcElement;
   if (bubble_to_name && el != null) {
      while (!el.name) {
         if (!el.parentNode || el.parentNode == el) break;
         el = el.parentNode;
      }
   }
   return el;
}

function checkbox_event() {
   var src = get_event_element();
   if (src == null) return;
   set_button(src, !src.checked);
}

function pushbutton_event() {
   var src = get_event_element();
   if (src == null) return;
   set_button(src, true);
}

function radio_button_event() {
   var src = get_event_element(true);
   if (src == null) return;
   var e = document.getElementsByName(src.name);
   for (var i=0; i < e.length; ++i) set_button(e[i], e[i] == src);
}

function handle_mouse_over() {
   var e = get_event_element();
   if (e == null) return;
   while (!e.mouse_over && !e.hover_effect) {
      if (!e.parentNode || e.parentNode == e) return;
      e = e.parentNode;
   }
   if (e.hover_effect) set_hover_class(e, true);
   if (e.mouse_over) eval(String(src.mouse_over));
}

function handle_mouse_out() {
   var e = get_event_element();
   if (e == null) return;
   while (!e.mouse_out && !e.hover_effect) {
      if (!e.parentNode || e.parentNode == e) return;
      e = e.parentNode;
   }
   if (e.hover_effect) set_hover_class(e, false);
   if (e.mouse_out) eval(String(src.mouse_out));
}

function init_checkbox(name, checked) {
   document.body.onmousedown = set_mouse_down;
   document.body.onmouseup = set_mouse_up;
   var e = get_element(name);
   if (!e) {
      alert("checkbox '"+name+"' not found.");
      return;
   }
   ev_set_button(e, checked);
   e.onclick = checkbox_event;
   e.ondblclick = checkbox_event;
   e.onmouseover = handle_mouse_over;
   e.onmouseout = handle_mouse_out;
}

function init_pushbutton(name) {
   document.body.onmousedown = set_mouse_down;
   document.body.onmouseup = set_mouse_up;
   var e = get_element(name);
   if (!e) {
      alert("pushbutton '"+name+"' not found.");
      return;
   }
   ev_set_button(e, false);
   e.onclick = pushbutton_event;
   e.ondblclick = pushbutton_event;
   e.onmouseover = handle_mouse_over;
   e.onmouseout = handle_mouse_out;
}

function cancel_dragdrop() {
   window.event.returnValue = false;
   window.event.cancelBubble = false;
}

function set_mouse_down() {
   // IE doesn't send mouseup after releasing the scrollbar of "tablebox"
   if (window.event.srcElement.id == "tablebox") return;
   dlg_mouse_down = true;
}
function set_mouse_up() {
   dlg_mouse_down = false;
}

function slider_track_mouse() {
   if (dlg_mouse_down) radio_button_event();
}

function init_radio_button(name, value, slider) {
   document.body.onmousedown = set_mouse_down;
   document.body.onmouseup = set_mouse_up;
   var e = document.getElementsByName(name);
   if (!e || !e.length || e.length == 0) {
      alert("radio button '"+name+"' not found.");
      return;
   }
   for (var i=0; i < e.length; ++i) {
      if (!e[i].name) e[i].name = e[i].id;
      ev_set_button(e[i], e[i].value == value);
      e[i].onclick = radio_button_event;
      e[i].ondblclick = radio_button_event;
      if (slider) {
         e[i].ondragstart = cancel_dragdrop;
         e[i].onmouseover = slider_track_mouse;
      }
      else {
         e[i].onmouseover = handle_mouse_over;
         e[i].onmouseout = handle_mouse_out;
      }
   }
}

function inject_button_events() {
   document.body.onmousedown = set_mouse_down;
   document.body.onmouseup = set_mouse_up;
   var e = document.getElementsByTagName("input");
   for (var i=0; i < e.length; ++i) {
      if (e[i].type == "radio") {
         e[i].onclick = radio_button_event;
         e[i].ondblclick = radio_button_event;
         e[i].onkeyup = radio_button_event;
      }
      else if (e[i].type == "checkbox") {
         e[i].onclick = checkbox_event;
         e[i].ondblclick = checkbox_event;
         e[i].onkeyup = checkbox_event;
      }
      else if (e[i].type == "button") {
         e[i].onclick = pushbutton_event;
         e[i].ondblclick = pushbutton_event;
         e[i].onkeyup = pushbutton_event;
      }
      e[i].onmouseover = handle_mouse_over;
      e[i].onmouseout = handle_mouse_out;
   }
}

function popup(section) {
  $('#'+section).toggle();
  $('#'+'cl'+section).toggle();
}
