﻿--~ Warcraft Plugin for Cyborg MMO7
--~ Filename: Localisation.lua
--~ Description: Localisation for Warcraft
--~ Copyright (C) 2012 Mad Catz Inc.
--~ Author: Christopher Hooks

--~ This program is free software; you can redistribute it and/or
--~ modify it under the terms of the GNU General Public License
--~ as published by the Free Software Foundation; either version 2
--~ of the License, or (at your option) any later version.

--~ This program is distributed in the hope that it will be useful,
--~ but WITHOUT ANY WARRANTY; without even the implied warranty of
--~ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--~ GNU General Public License for more details.

--~ You should have received a copy of the GNU General Public License
--~ along with this program; if not, write to the Free Software
--~ Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

local Modes = {
	["enUS"] = {
		"ALT-CTRL-E",
		"ALT-CTRL-F",
		"ALT-CTRL-[",
	},
	["frFR"] = {
		"ALT-CTRL-E",
		"ALT-CTRL-F",
		"ALT-CTRL-^",
	},
	["deDE"] = {
		"ALT-CTRL-E",
		"ALT-CTRL-F",
		"ALT-CTRL-ü",
	},
	["zhCN"] = {
		"ALT-CTRL-E",
		"ALT-CTRL-F",
		"ALT-CTRL-[",
	},
	["zhTW"] = {
		"ALT-CTRL-E",
		"ALT-CTRL-F",
		"ALT-CTRL-[",
	},
	["esES"] = {
		"ALT-CTRL-E",
		"ALT-CTRL-F",
		"ALT-CTRL-'",
	},
	["esMX"] = {
		"ALT-CTRL-E",
		"ALT-CTRL-F",
		"ALT-CTRL-'",
	},
}

local DefaultKeyBindings = {
	["enUS"] = {
		"ALT-CTRL-NUMPAD1",
		"ALT-CTRL-NUMPAD2",
		"ALT-CTRL-NUMPAD3",
		"ALT-CTRL-NUMPAD4",
		"ALT-CTRL-NUMPAD5",
		"ALT-CTRL-NUMPAD6",
		"ALT-CTRL-NUMPAD7",
		"ALT-CTRL-NUMPAD8",
		"ALT-CTRL-NUMPAD9",
		"ALT-CTRL-NUMPAD0",
		"ALT-CTRL-1",
		"ALT-CTRL-2",
		"ALT-CTRL-3",
		"ALT-CTRL-4",
		"ALT-CTRL-5",
		"ALT-CTRL-6",
		"ALT-CTRL-7",
		"ALT-CTRL-8",
		"ALT-CTRL-9",
		"ALT-CTRL-0",
		"ALT-CTRL-F1",
		"ALT-CTRL-F2",
		"ALT-CTRL-F3",
		"ALT-CTRL-F4",
		"ALT-CTRL-F5",
		"ALT-CTRL-F6",
		"ALT-CTRL-F7",
		"ALT-CTRL-F8",
		"ALT-CTRL-F9",
		"ALT-CTRL-F10",
		"ALT-CTRL-F11",
		"ALT-CTRL-F12",
		"ALT-CTRL--",
		"ALT-CTRL-H",
		"ALT-CTRL-A",
		"ALT-CTRL-B",
		"ALT-CTRL-C",
		"ALT-CTRL-D",
		"ALT-CTRL-END",
	},
	["frFR"] = {
		"ALT-CTRL-NUMPAD1",
		"ALT-CTRL-NUMPAD2",
		"ALT-CTRL-NUMPAD3",
		"ALT-CTRL-NUMPAD4",
		"ALT-CTRL-NUMPAD5",
		"ALT-CTRL-NUMPAD6",
		"ALT-CTRL-NUMPAD7",
		"ALT-CTRL-NUMPAD8",
		"ALT-CTRL-NUMPAD9",
		"ALT-CTRL-NUMPAD0",
		"ALT-CTRL-1",
		"ALT-CTRL-2",
		"ALT-CTRL-3",
		"ALT-CTRL-4",
		"ALT-CTRL-5",
		"ALT-CTRL-6",
		"ALT-CTRL-7",
		"ALT-CTRL-8",
		"ALT-CTRL-9",
		"ALT-CTRL-0",
		"ALT-CTRL-F1",
		"ALT-CTRL-F2",
		"ALT-CTRL-F3",
		"ALT-CTRL-F4",
		"ALT-CTRL-F5",
		"ALT-CTRL-F6",
		"ALT-CTRL-F7",
		"ALT-CTRL-F8",
		"ALT-CTRL-F9",
		"ALT-CTRL-F10",
		"ALT-CTRL-F11",
		"ALT-CTRL-F12",
		"ALT-CTRL-)",
		"ALT-CTRL-H",
		"ALT-CTRL-Q",
		"ALT-CTRL-B",
		"ALT-CTRL-C",
		"ALT-CTRL-D",
		"ALT-CTRL-END",
	},
	["deDE"] = {
		"ALT-CTRL-NUMPAD1",
		"ALT-CTRL-NUMPAD2",
		"ALT-CTRL-NUMPAD3",
		"ALT-CTRL-NUMPAD4",
		"ALT-CTRL-NUMPAD5",
		"ALT-CTRL-NUMPAD6",
		"ALT-CTRL-NUMPAD7",
		"ALT-CTRL-NUMPAD8",
		"ALT-CTRL-NUMPAD9",
		"ALT-CTRL-NUMPAD0",
		"ALT-CTRL-1",
		"ALT-CTRL-2",
		"ALT-CTRL-3",
		"ALT-CTRL-4",
		"ALT-CTRL-5",
		"ALT-CTRL-6",
		"ALT-CTRL-7",
		"ALT-CTRL-8",
		"ALT-CTRL-9",
		"ALT-CTRL-0",
		"ALT-CTRL-F1",
		"ALT-CTRL-F2",
		"ALT-CTRL-F3",
		"ALT-CTRL-F4",
		"ALT-CTRL-F5",
		"ALT-CTRL-F6",
		"ALT-CTRL-F7",
		"ALT-CTRL-F8",
		"ALT-CTRL-F9",
		"ALT-CTRL-F10",
		"ALT-CTRL-F11",
		"ALT-CTRL-F12",
		"ALT-CTRL-ß",
		"ALT-CTRL-H",
		"ALT-CTRL-A",
		"ALT-CTRL-B",
		"ALT-CTRL-C",
		"ALT-CTRL-D",
		"ALT-CTRL-END",
	},
	["zhCN"] = {
		"ALT-CTRL-NUMPAD1",
		"ALT-CTRL-NUMPAD2",
		"ALT-CTRL-NUMPAD3",
		"ALT-CTRL-NUMPAD4",
		"ALT-CTRL-NUMPAD5",
		"ALT-CTRL-NUMPAD6",
		"ALT-CTRL-NUMPAD7",
		"ALT-CTRL-NUMPAD8",
		"ALT-CTRL-NUMPAD9",
		"ALT-CTRL-NUMPAD0",
		"ALT-CTRL-1",
		"ALT-CTRL-2",
		"ALT-CTRL-3",
		"ALT-CTRL-4",
		"ALT-CTRL-5",
		"ALT-CTRL-6",
		"ALT-CTRL-7",
		"ALT-CTRL-8",
		"ALT-CTRL-9",
		"ALT-CTRL-0",
		"ALT-CTRL-F1",
		"ALT-CTRL-F2",
		"ALT-CTRL-F3",
		"ALT-CTRL-F4",
		"ALT-CTRL-F5",
		"ALT-CTRL-F6",
		"ALT-CTRL-F7",
		"ALT-CTRL-F8",
		"ALT-CTRL-F9",
		"ALT-CTRL-F10",
		"ALT-CTRL-F11",
		"ALT-CTRL-F12",
		"ALT-CTRL--",
		"ALT-CTRL-H",
		"ALT-CTRL-A",
		"ALT-CTRL-B",
		"ALT-CTRL-C",
		"ALT-CTRL-D",
		"ALT-CTRL-END",
	},
	["zhTW"] = {
		"ALT-CTRL-NUMPAD1",
		"ALT-CTRL-NUMPAD2",
		"ALT-CTRL-NUMPAD3",
		"ALT-CTRL-NUMPAD4",
		"ALT-CTRL-NUMPAD5",
		"ALT-CTRL-NUMPAD6",
		"ALT-CTRL-NUMPAD7",
		"ALT-CTRL-NUMPAD8",
		"ALT-CTRL-NUMPAD9",
		"ALT-CTRL-NUMPAD0",
		"ALT-CTRL-1",
		"ALT-CTRL-2",
		"ALT-CTRL-3",
		"ALT-CTRL-4",
		"ALT-CTRL-5",
		"ALT-CTRL-6",
		"ALT-CTRL-7",
		"ALT-CTRL-8",
		"ALT-CTRL-9",
		"ALT-CTRL-0",
		"ALT-CTRL-F1",
		"ALT-CTRL-F2",
		"ALT-CTRL-F3",
		"ALT-CTRL-F4",
		"ALT-CTRL-F5",
		"ALT-CTRL-F6",
		"ALT-CTRL-F7",
		"ALT-CTRL-F8",
		"ALT-CTRL-F9",
		"ALT-CTRL-F10",
		"ALT-CTRL-F11",
		"ALT-CTRL-F12",
		"ALT-CTRL--",
		"ALT-CTRL-H",
		"ALT-CTRL-A",
		"ALT-CTRL-B",
		"ALT-CTRL-C",
		"ALT-CTRL-D",
		"ALT-CTRL-END",
	},
	["esES"] = {
		"ALT-CTRL-NUMPAD1",
		"ALT-CTRL-NUMPAD2",
		"ALT-CTRL-NUMPAD3",
		"ALT-CTRL-NUMPAD4",
		"ALT-CTRL-NUMPAD5",
		"ALT-CTRL-NUMPAD6",
		"ALT-CTRL-NUMPAD7",
		"ALT-CTRL-NUMPAD8",
		"ALT-CTRL-NUMPAD9",
		"ALT-CTRL-NUMPAD0",
		"ALT-CTRL-1",
		"ALT-CTRL-2",
		"ALT-CTRL-3",
		"ALT-CTRL-4",
		"ALT-CTRL-5",
		"ALT-CTRL-6",
		"ALT-CTRL-7",
		"ALT-CTRL-8",
		"ALT-CTRL-9",
		"ALT-CTRL-0",
		"ALT-CTRL-F1",
		"ALT-CTRL-F2",
		"ALT-CTRL-F3",
		"ALT-CTRL-F4",
		"ALT-CTRL-F5",
		"ALT-CTRL-F6",
		"ALT-CTRL-F7",
		"ALT-CTRL-F8",
		"ALT-CTRL-F9",
		"ALT-CTRL-F10",
		"ALT-CTRL-F11",
		"ALT-CTRL-F12",
		"ALT-CTRL-'",
		"ALT-CTRL-H",
		"ALT-CTRL-A",
		"ALT-CTRL-B",
		"ALT-CTRL-C",
		"ALT-CTRL-D",
		"ALT-CTRL-END",
	},
	["esMX"] = {
		"ALT-CTRL-NUMPAD1",
		"ALT-CTRL-NUMPAD2",
		"ALT-CTRL-NUMPAD3",
		"ALT-CTRL-NUMPAD4",
		"ALT-CTRL-NUMPAD5",
		"ALT-CTRL-NUMPAD6",
		"ALT-CTRL-NUMPAD7",
		"ALT-CTRL-NUMPAD8",
		"ALT-CTRL-NUMPAD9",
		"ALT-CTRL-NUMPAD0",
		"ALT-CTRL-1",
		"ALT-CTRL-2",
		"ALT-CTRL-3",
		"ALT-CTRL-4",
		"ALT-CTRL-5",
		"ALT-CTRL-6",
		"ALT-CTRL-7",
		"ALT-CTRL-8",
		"ALT-CTRL-9",
		"ALT-CTRL-0",
		"ALT-CTRL-F1",
		"ALT-CTRL-F2",
		"ALT-CTRL-F3",
		"ALT-CTRL-F4",
		"ALT-CTRL-F5",
		"ALT-CTRL-F6",
		"ALT-CTRL-F7",
		"ALT-CTRL-F8",
		"ALT-CTRL-F9",
		"ALT-CTRL-F10",
		"ALT-CTRL-F11",
		"ALT-CTRL-F12",
		"ALT-CTRL-'",
		"ALT-CTRL-H",
		"ALT-CTRL-A",
		"ALT-CTRL-B",
		"ALT-CTRL-C",
		"ALT-CTRL-D",
		"ALT-CTRL-END",
	},
}

local StringTables = {
	["enUS"] = {
		CyborgMMO_BindingFrameExitButton="Close",
		CyborgMMO_BindingFrameHeaderText="Please press the appropriate button",
		CyborgMMO_CurrentBinding="Current Binding",
		CyborgMMO_OptionPageCyborgButtonTitle="Cyborg Button",
		CyborgMMO_OptionPageCyborgSizeSliderTitle="Cyborg Head Size",
		CyborgMMO_OptionPageMiniMapButtonTitle="MiniMap Button",
		CyborgMMO_OptionPagePerSpecBindingsTitle="Per-spec bindings",
		CyborgMMO_OptionPageRebindMouseRow10Name="Back Button",
		CyborgMMO_OptionPageRebindMouseRow11Name="Button 3",
		CyborgMMO_OptionPageRebindMouseRow12Name="Thumb Anticlockwise",
		CyborgMMO_OptionPageRebindMouseRow13Name="Thumb Clockwise",
		CyborgMMO_OptionPageRebindMouseRow1Name="Scroll Button",
		CyborgMMO_OptionPageRebindMouseRow2Name="Forwards Button",
		CyborgMMO_OptionPageRebindMouseRow3Name="Button 2",
		CyborgMMO_OptionPageRebindMouseRow4Name="Hat Top",
		CyborgMMO_OptionPageRebindMouseRow5Name="Precision Aim",
		CyborgMMO_OptionPageRebindMouseRow6Name="Hat Bottom",
		CyborgMMO_OptionPageRebindMouseRow7Name="Hat Left",
		CyborgMMO_OptionPageRebindMouseRow8Name="Hat Right",
		CyborgMMO_OptionPageRebindMouseRow9Name="Button 1",
		CyborgMMO_OptionPageRebindMouseRowAName="Back Button",
		CyborgMMO_OptionPageRebindMouseRowBName="Button 3",
		CyborgMMO_OptionPageRebindMouseRowCName="Thumb Anticlockwise",
		CyborgMMO_OptionPageRebindMouseRowDName="Thumb Clockwise",
		CyborgMMO_OptionPageTitle="Cyborg MMO7",
		CyborgMMO_OptionPagePluginSizeSliderTitle="Interface Window Size",
		CyborgMMO_OptionPageRebindMode1="Mode 1",
		CyborgMMO_OptionPageRebindMode2="Mode 2",
		CyborgMMO_OptionPageRebindMode3="Mode 3",
		CyborgMMO_OptionPageRebindTitle="Key bindings",
		CyborgMMO_ToolTipLine1="Warning! If your spell assignments are not working you may not have the correct profile assigned.",
		CyborgMMO_ToolTipLine2="To assign the correct profile:",
		CyborgMMO_ToolTipLine3="1) Click on the M.M.O.7 tray icon in the Windows system tray. ",
		CyborgMMO_ToolTipLine4="2) Locate the profile called MMO7_WoWAddon and left click it. ",
		CyborgMMO_ToolTipLine5="3) When the M.M.O.7 tray icon turns green, the profile is active. ",
		CyborgMMO_ToolTipLine6="Once the profile is active, reload WoW and press the Mode button on the M.M.O.7 to synchronise the device.",
	},
	["frFR"] = {
		CyborgMMO_OptionPageCyborgButtonTitle="Bouton Cyborg",
		CyborgMMO_OptionPageMiniMapButtonTitle="Bouton minimap",
		CyborgMMO_OptionPageTitle="Cyborg MMO7",
		CyborgMMO_OptionPageCyborgSizeSliderTitle="Dimension de la tête Cyborg",
		CyborgMMO_OptionPagePluginSizeSliderTitle="Dimension de la fenêtre d'interface",
	},
	["deDE"] = {
		CyborgMMO_OptionPageCyborgButtonTitle="Cyborg-Taste",
		CyborgMMO_OptionPageMiniMapButtonTitle="MiniMap-Taste",
		CyborgMMO_OptionPageTitle="Cyborg MMO7",
		CyborgMMO_OptionPageCyborgSizeSliderTitle="Größe des Cyborg-Kopfes",
		CyborgMMO_OptionPagePluginSizeSliderTitle="Größe des Schnittstellenfensters",
	},
	["zhCN"] = {
		CyborgMMO_OptionPageCyborgButtonTitle="Cyborg 按钮",
		CyborgMMO_OptionPageMiniMapButtonTitle="“迷你地图”按钮",
		CyborgMMO_OptionPageTitle="Cyborg MMO7",
		CyborgMMO_OptionPageCyborgSizeSliderTitle="Cyborg 标题大小",
		CyborgMMO_OptionPagePluginSizeSliderTitle="界面窗口大小",
	},
	["zhTW"] = {
		CyborgMMO_OptionPageCyborgButtonTitle="Cyborg 按鈕",
		CyborgMMO_OptionPageMiniMapButtonTitle="MiniMap 按鈕",
		CyborgMMO_OptionPageTitle="Cyborg MMO7",
		CyborgMMO_OptionPageCyborgSizeSliderTitle="Cyborg 頭大小",
		CyborgMMO_OptionPagePluginSizeSliderTitle="介面視窗大小",
	},
	["esES"] = {
		CyborgMMO_OptionPageCyborgButtonTitle="Botón Cyborg",
		CyborgMMO_OptionPageMiniMapButtonTitle="Botón Minimapa",
		CyborgMMO_OptionPageTitle="Cyborg MMO7",
		CyborgMMO_OptionPageCyborgSizeSliderTitle="Tamaño de la cabeza de Cyborg",
		CyborgMMO_OptionPagePluginSizeSliderTitle="Tamaño de la ventana de la interfaz",
	},
	["esMX"] = {
		CyborgMMO_OptionPageCyborgButtonTitle="Botón de Cyborg",
		CyborgMMO_OptionPageMiniMapButtonTitle="Botón de Minimapa",
		CyborgMMO_OptionPageTitle="Cyborg MMO7",
		CyborgMMO_OptionPageCyborgSizeSliderTitle="Tamaño de la cabeza de Cyborg",
		CyborgMMO_OptionPagePluginSizeSliderTitle="Tamaño de la ventana de interfaz",
	},
}

local locale = GetLocale()
-- fall back to english for missing translations
local default_locale = 'enUS'

CyborgMMO_Mode = Modes[locale] or Modes[default_locale]
CyborgMMO_StringTable = StringTables[locale] or StringTables[default_locale]

-- key bindings are saved and will be replaced by SavedVariables
CyborgMMO_DefaultKeyBindings = DefaultKeyBindings[locale] or DefaultKeyBindings[default_locale]
CyborgMMO_ProfileKeyBindings = {}
for k,v in pairs(CyborgMMO_DefaultKeyBindings) do
	CyborgMMO_ProfileKeyBindings[k] = v
end

if locale ~= default_locale then
	setmetatable(CyborgMMO_StringTable, {__index=StringTables[default_locale]})
end

