/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.renderer;

import enhancedcore.util.MathHelper;
import enhancedportals.client.renderer.BlockInterface;
import enhancedportals.lib.Textures;
import enhancedportals.portal.PortalTexture;
import enhancedportals.tileentity.TileEntityNetherPortal;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class TileEntityNetherPortalRenderer
extends TileEntitySpecialRenderer {
    private RenderBlocks renderBlocks;
    private BlockInterface portalBlock = new BlockInterface();

    public TileEntityNetherPortalRenderer() {
        this.renderBlocks = new RenderBlocks();
    }

    private void renderBlock(TileEntityNetherPortal portal) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int meta = portal.func_70322_n();
        this.renderBlocks.field_83026_h = this.portalBlock.maxX;
        this.renderBlocks.field_83021_g = this.portalBlock.minX;
        this.renderBlocks.field_83024_j = this.portalBlock.maxY;
        this.renderBlocks.field_83027_i = this.portalBlock.minY;
        this.renderBlocks.field_83022_l = this.portalBlock.maxZ;
        this.renderBlocks.field_83025_k = this.portalBlock.minZ;
        this.renderBlocks.field_78677_m = false;
        tessellator.func_78382_b();
        if (meta == 2 || meta == 3) {
            this.renderBlocks.func_78611_c(null, 0.0, 0.0, 0.0, this.portalBlock.getBlockTextureFromSide(2));
            this.renderBlocks.func_78622_d(null, 0.0, 0.0, 0.0, this.portalBlock.getBlockTextureFromSide(3));
        } else if (meta == 4 || meta == 5) {
            this.renderBlocks.func_78573_e(null, 0.0, 0.0, 0.0, this.portalBlock.getBlockTextureFromSide(2));
            this.renderBlocks.func_78605_f(null, 0.0, 0.0, 0.0, this.portalBlock.getBlockTextureFromSide(3));
        } else if (meta == 6 || meta == 7) {
            this.renderBlocks.func_78613_a(null, 0.0, 0.0, 0.0, this.portalBlock.getBlockTextureFromSide(0));
            this.renderBlocks.func_78617_b(null, 0.0, 0.0, 0.0, this.portalBlock.getBlockTextureFromSide(1));
        }
        tessellator.func_78381_a();
    }

    public void func_76894_a(TileEntity tile, double x, double y, double z, float f) {
        TileEntityNetherPortal portal = (TileEntityNetherPortal)tile;
        PortalTexture texture = Textures.getTexture(portal.texture);
        ItemStack stack = texture.getItemStack();
        if (stack.field_77993_c == Item.field_82792_bS.field_77779_bT) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_110628_a(TextureMap.field_110575_b);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        this.setupTexture(portal);
        this.setCubeBounds(portal);
        this.renderBlock(portal);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void setCubeBounds(TileEntityNetherPortal portal) {
        int meta = portal.func_70322_n();
        byte thickness = portal.thickness;
        float thick = 0.125f * (float)thickness;
        float thickA = MathHelper.clampFloat((float)(0.375f - thick), (float)0.0f, (float)1.0f);
        float thickB = MathHelper.clampFloat((float)(0.625f + thick), (float)0.0f, (float)1.0f);
        if (meta == 2 || meta == 3) {
            this.portalBlock.minX = 0.0;
            this.portalBlock.minY = 0.0;
            this.portalBlock.minZ = thickA;
            this.portalBlock.maxX = 1.0;
            this.portalBlock.maxY = 1.0;
            this.portalBlock.maxZ = thickB;
        } else if (meta == 4 || meta == 5) {
            this.portalBlock.minX = thickA;
            this.portalBlock.minY = 0.0;
            this.portalBlock.minZ = 0.0;
            this.portalBlock.maxX = thickB;
            this.portalBlock.maxY = 1.0;
            this.portalBlock.maxZ = 1.0;
        } else if (meta == 6 || meta == 7) {
            this.portalBlock.minX = 0.0;
            this.portalBlock.minY = thickA;
            this.portalBlock.minZ = 0.0;
            this.portalBlock.maxX = 1.0;
            this.portalBlock.maxY = thickB;
            this.portalBlock.maxZ = 1.0;
        }
    }

    private void setupTexture(TileEntityNetherPortal portal) {
        if (portal.texture.startsWith("B:")) {
            int id = Integer.parseInt(portal.texture.substring(2).split(":")[0]);
            this.portalBlock.baseBlock = Block.field_71973_m[id];
        } else {
            this.portalBlock.baseBlock = portal.texture.startsWith("L:") ? Block.field_71943_B : Block.field_72015_be;
        }
        this.portalBlock.texture = Textures.getTexture(portal.texture).getPortalTexture();
    }
}

