/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.computercraft.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import dan200.computer.api.IPeripheral;
import enhancedcore.computercraft.ComputerManager;
import enhancedportals.computercraft.SharedMethods;
import enhancedportals.network.packet.PacketDialDeviceUpdate;
import enhancedportals.network.packet.PacketDialRequest;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.tileentity.TileEntityDialDevice;
import enhancedportals.tileentity.TileEntityEnhancedPortals;
import net.minecraft.network.packet.Packet;

public class TileEntityDialDevice_cc
extends TileEntityDialDevice
implements IPeripheral {
    ComputerManager computerManager = new ComputerManager();

    public TileEntityDialDevice_cc() {
        this.addMethods();
    }

    private void addMethods() {
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                if (TileEntityDialDevice_cc.this.active) {
                    throw new Exception("Cannot dial when there's already an active connection.");
                }
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new Exception("Invalid arguments");
                }
                int dialNum = (int)Math.round(Double.parseDouble(arguments[0].toString()));
                if (TileEntityDialDevice_cc.this.destinationList.size() < dialNum || dialNum < 0) {
                    throw new Exception("Invalid destination ID");
                }
                if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    PacketDispatcher.sendPacketToServer((Packet)PacketEnhancedPortals.makePacket(new PacketDialRequest((TileEntityEnhancedPortals)TileEntityDialDevice_cc.this.field_70331_k.func_72796_p(TileEntityDialDevice_cc.this.field_70329_l, TileEntityDialDevice_cc.this.field_70330_m, TileEntityDialDevice_cc.this.field_70327_n), dialNum + "")));
                } else {
                    ((TileEntityDialDevice)TileEntityDialDevice_cc.this.field_70331_k.func_72796_p(TileEntityDialDevice_cc.this.field_70329_l, TileEntityDialDevice_cc.this.field_70330_m, TileEntityDialDevice_cc.this.field_70327_n)).processDiallingRequest(dialNum, null);
                }
                return null;
            }

            public String getMethodName() {
                return "dialStored";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                if (!TileEntityDialDevice_cc.this.active) {
                    throw new Exception("Cannot terminate an inactive connection");
                }
                if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    PacketDispatcher.sendPacketToServer((Packet)PacketEnhancedPortals.makePacket(new PacketDialRequest((TileEntityEnhancedPortals)TileEntityDialDevice_cc.this.field_70331_k.func_72796_p(TileEntityDialDevice_cc.this.field_70329_l, TileEntityDialDevice_cc.this.field_70330_m, TileEntityDialDevice_cc.this.field_70327_n), "0")));
                } else {
                    ((TileEntityDialDevice)TileEntityDialDevice_cc.this.field_70331_k.func_72796_p(TileEntityDialDevice_cc.this.field_70329_l, TileEntityDialDevice_cc.this.field_70330_m, TileEntityDialDevice_cc.this.field_70327_n)).processDiallingRequest(0, null);
                }
                return null;
            }

            public String getMethodName() {
                return "terminate";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new Exception("Invalid arguments");
                }
                int num = (int)Math.round(Double.parseDouble(arguments[0].toString()));
                if (num < 19 || num > 1201) {
                    throw new Exception("Must be between 19 and 1201.");
                }
                if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    ((TileEntityDialDevice)TileEntityDialDevice_cc.this.field_70331_k.func_72796_p((int)TileEntityDialDevice_cc.this.field_70329_l, (int)TileEntityDialDevice_cc.this.field_70330_m, (int)TileEntityDialDevice_cc.this.field_70327_n)).tickTimer = num;
                    PacketDispatcher.sendPacketToServer((Packet)PacketEnhancedPortals.makePacket(new PacketDialDeviceUpdate((TileEntityDialDevice)TileEntityDialDevice_cc.this.field_70331_k.func_72796_p(TileEntityDialDevice_cc.this.field_70329_l, TileEntityDialDevice_cc.this.field_70330_m, TileEntityDialDevice_cc.this.field_70327_n))));
                } else {
                    ((TileEntityDialDevice)TileEntityDialDevice_cc.this.field_70331_k.func_72796_p((int)TileEntityDialDevice_cc.this.field_70329_l, (int)TileEntityDialDevice_cc.this.field_70330_m, (int)TileEntityDialDevice_cc.this.field_70327_n)).tickTimer = num;
                }
                return null;
            }

            public String getMethodName() {
                return "setTimeoutTime";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                return new Object[]{TileEntityDialDevice_cc.this.active};
            }

            public String getMethodName() {
                return "isActive";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                return new Object[]{TileEntityDialDevice_cc.this.destinationList.size()};
            }

            public String getMethodName() {
                return "getDestinationCount";
            }
        });
        this.computerManager.registerMethod(SharedMethods.getGlyphs);
        this.computerManager.registerMethod(SharedMethods.getGlyph);
    }

    public void attach(IComputerAccess computer) {
        this.computerManager.addComputer(computer);
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        return this.computerManager.execute(computer, context, method, arguments);
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void detach(IComputerAccess computer) {
        this.computerManager.removeComputer(computer);
    }

    public String[] getMethodNames() {
        return this.computerManager.getAllMethodNames();
    }

    public String getType() {
        return "dialDevice";
    }
}

