/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.computercraft.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import dan200.computer.api.IPeripheral;
import enhancedcore.computercraft.ComputerManager;
import enhancedportals.computercraft.GlyphString;
import enhancedportals.computercraft.SharedMethods;
import enhancedportals.lib.Reference;
import enhancedportals.network.packet.PacketCreatePortal;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.network.packet.PacketPortalModifierUpdate;
import enhancedportals.portal.upgrades.Upgrade;
import enhancedportals.tileentity.TileEntityEnhancedPortals;
import enhancedportals.tileentity.TileEntityPortalModifier;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;

public class TileEntityPortalModifier_cc
extends TileEntityPortalModifier
implements IPeripheral {
    ComputerManager computerManager = new ComputerManager();

    public TileEntityPortalModifier_cc() {
        this.addMethods();
    }

    private void addMethods() {
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    PacketDispatcher.sendPacketToServer((Packet)PacketEnhancedPortals.makePacket(new PacketCreatePortal((TileEntityEnhancedPortals)TileEntityPortalModifier_cc.this.field_70331_k.func_72796_p(TileEntityPortalModifier_cc.this.field_70329_l, TileEntityPortalModifier_cc.this.field_70330_m, TileEntityPortalModifier_cc.this.field_70327_n), true)));
                } else {
                    TileEntityPortalModifier_cc.this.createPortal();
                }
                return null;
            }

            public String getMethodName() {
                return "createPortal";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    PacketDispatcher.sendPacketToServer((Packet)PacketEnhancedPortals.makePacket(new PacketCreatePortal((TileEntityEnhancedPortals)TileEntityPortalModifier_cc.this.field_70331_k.func_72796_p(TileEntityPortalModifier_cc.this.field_70329_l, TileEntityPortalModifier_cc.this.field_70330_m, TileEntityPortalModifier_cc.this.field_70327_n), false)));
                } else {
                    TileEntityPortalModifier_cc.this.removePortal();
                }
                return null;
            }

            public String getMethodName() {
                return "removePortal";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                return new Object[]{TileEntityPortalModifier_cc.this.texture.equals("") ? "C:5" : TileEntityPortalModifier_cc.this.texture};
            }

            public String getMethodName() {
                return "getTexture";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                HashMap<Integer, Integer> values = new HashMap<Integer, Integer>();
                int count = 1;
                block0: for (String str : TileEntityPortalModifier_cc.this.modifierNetwork.split(" ")) {
                    for (int i = 0; i < Reference.glyphItems.size(); ++i) {
                        if (!str.equals(Reference.glyphItems.get(i).func_77977_a().replace("item.", ""))) continue;
                        values.put(count, i);
                        ++count;
                        continue block0;
                    }
                }
                return new Object[]{values};
            }

            public String getMethodName() {
                return "getNetwork";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                if (TileEntityPortalModifier_cc.this.isRemotelyControlled()) {
                    throw new Exception("You must use setIdentifier()");
                }
                if (arguments[0] instanceof String) {
                    TileEntityPortalModifier_cc.this.modifierNetwork = GlyphString.getGlyphStringFromIdString(arguments[0].toString());
                    if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                        PacketDispatcher.sendPacketToServer((Packet)PacketEnhancedPortals.makePacket(new PacketPortalModifierUpdate((TileEntityPortalModifier)TileEntityPortalModifier_cc.this.field_70331_k.func_72796_p(TileEntityPortalModifier_cc.this.field_70329_l, TileEntityPortalModifier_cc.this.field_70330_m, TileEntityPortalModifier_cc.this.field_70327_n))));
                    }
                    return new Object[]{true};
                }
                throw new Exception("Invalid type");
            }

            public String getMethodName() {
                return "setNetwork";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                HashMap<Integer, Integer> values = new HashMap<Integer, Integer>();
                int count = 1;
                block0: for (String str : TileEntityPortalModifier_cc.this.dialDeviceNetwork.split(" ")) {
                    for (int i = 0; i < Reference.glyphItems.size(); ++i) {
                        if (!str.equals(Reference.glyphItems.get(i).func_77977_a().replace("item.", ""))) continue;
                        values.put(count, i);
                        ++count;
                        continue block0;
                    }
                }
                return new Object[]{values};
            }

            public String getMethodName() {
                return "getIdentifier";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                if (!TileEntityPortalModifier_cc.this.isRemotelyControlled()) {
                    throw new Exception("You must use setNetwork()");
                }
                if (arguments[0] instanceof String) {
                    TileEntityPortalModifier_cc.this.dialDeviceNetwork = GlyphString.getGlyphStringFromIdString(arguments[0].toString());
                    if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                        PacketDispatcher.sendPacketToServer((Packet)PacketEnhancedPortals.makePacket(new PacketPortalModifierUpdate((TileEntityPortalModifier)TileEntityPortalModifier_cc.this.field_70331_k.func_72796_p(TileEntityPortalModifier_cc.this.field_70329_l, TileEntityPortalModifier_cc.this.field_70330_m, TileEntityPortalModifier_cc.this.field_70327_n))));
                    }
                    return new Object[]{true};
                }
                throw new Exception("Invalid type");
            }

            public String getMethodName() {
                return "setIdentifier";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                return new Object[]{TileEntityPortalModifier_cc.this.thickness};
            }

            public String getMethodName() {
                return "getThickness";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                if (arguments[0] instanceof Double) {
                    double obj = Double.parseDouble(arguments[0].toString());
                    if (obj > 0.0 && obj < 5.0) {
                        TileEntityPortalModifier_cc.this.thickness = (byte)(obj - 1.0);
                        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                            PacketDispatcher.sendPacketToServer((Packet)PacketEnhancedPortals.makePacket(new PacketPortalModifierUpdate((TileEntityPortalModifier)TileEntityPortalModifier_cc.this.field_70331_k.func_72796_p(TileEntityPortalModifier_cc.this.field_70329_l, TileEntityPortalModifier_cc.this.field_70330_m, TileEntityPortalModifier_cc.this.field_70327_n))));
                        }
                        return new Object[]{true};
                    }
                    throw new Exception("Invalid integer. Must be within 0 and 5");
                }
                throw new Exception("Invalid type. Must be an integer between 0 and 5");
            }

            public String getMethodName() {
                return "setThickness";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                HashMap<Integer, Integer> test = new HashMap<Integer, Integer>();
                byte[] upgrades = TileEntityPortalModifier_cc.this.upgradeHandler.getInstalledUpgrades();
                for (int i = 0; i < TileEntityPortalModifier_cc.this.upgradeHandler.getInstalledUpgrades().length; ++i) {
                    test.put(i + 1, Integer.valueOf(upgrades[i]));
                }
                return new Object[]{test};
            }

            public String getMethodName() {
                return "getUpgrades";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new Exception("Invalid arguments.");
                }
                int num = (int)Math.round(Double.parseDouble(arguments[0].toString()));
                if (num < 0 || num >= Upgrade.getAllUpgrades().length) {
                    throw new Exception("Invalid arguments");
                }
                return new Object[]{Upgrade.getUpgrade(num).getItemStack().func_82833_r()};
            }

            public String getMethodName() {
                return "getUpgradeName";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                return new Object[]{TileEntityPortalModifier_cc.this.isActive()};
            }

            public String getMethodName() {
                return "getSelfActive";
            }
        });
        this.computerManager.registerMethod(new ComputerManager.IMethod(){

            public Object[] execute(IComputerAccess computer, ILuaContext context, Object[] arguments) throws Exception {
                return new Object[]{TileEntityPortalModifier_cc.this.isAnyActive()};
            }

            public String getMethodName() {
                return "getAnyActive";
            }
        });
        this.computerManager.registerMethod(SharedMethods.getGlyphs);
        this.computerManager.registerMethod(SharedMethods.getGlyph);
    }

    public void attach(IComputerAccess computer) {
        this.computerManager.addComputer(computer);
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        return this.computerManager.execute(computer, context, method, arguments);
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public boolean createPortal() {
        if (super.createPortal()) {
            this.computerManager.queueEvent("create_portal", null);
            return true;
        }
        return false;
    }

    @Override
    public boolean createPortal(ItemStack stack) {
        if (super.createPortal(stack)) {
            this.computerManager.queueEvent("create_portal", new Object[]{stack.func_77973_b().field_77779_bT});
            return true;
        }
        return false;
    }

    @Override
    public boolean createPortalFromDialDevice() {
        if (super.createPortalFromDialDevice()) {
            this.computerManager.queueEvent("create_portal", new Object[]{"basicDialDevice"});
            return true;
        }
        return false;
    }

    @Override
    public boolean createPortalFromDialDevice(String texture, byte thickness) {
        if (super.createPortalFromDialDevice(texture, thickness)) {
            this.computerManager.queueEvent("create_portal", new Object[]{"dialDevice", texture, thickness});
            return true;
        }
        return false;
    }

    public void detach(IComputerAccess computer) {
        this.computerManager.removeComputer(computer);
    }

    public String[] getMethodNames() {
        return this.computerManager.getAllMethodNames();
    }

    public String getType() {
        return "portalModifier";
    }

    @Override
    public boolean removePortal() {
        if (super.removePortal()) {
            this.computerManager.queueEvent("remove_portal", null);
            return true;
        }
        return false;
    }
}

