/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.lib;

import enhancedportals.lib.BlockIds;
import enhancedportals.lib.Settings;
import enhancedportals.portal.PortalTexture;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class Textures {
    public static Map<String, PortalTexture> portalTextureMap = new HashMap<String, PortalTexture>();

    public static int getDyeColour(ItemStack stack) {
        if (stack != null) {
            String name = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)stack));
            String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
            if (name.startsWith("dye")) {
                for (int i = 0; i < dyes.length; ++i) {
                    if (!name.equals(dyes[i])) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static ItemStack getItemStackFromTexture(PortalTexture texture) {
        ItemStack stack = null;
        if (texture.getID().startsWith("B:") || texture.getID().startsWith("I:") || texture.getID().startsWith("F:")) {
            return new ItemStack(Integer.parseInt(texture.getID().substring(2).split(":")[0]), 1, Integer.parseInt(texture.getID().substring(2).split(":")[1]));
        }
        if (texture.getID().startsWith("C:")) {
            return new ItemStack(BlockIds.DummyPortal, 1, Integer.parseInt(texture.getID().substring(2)));
        }
        return stack;
    }

    public static ItemStack getItemStackFromTexture(String texture) {
        return Textures.getItemStackFromTexture(Textures.getTexture(texture));
    }

    public static PortalTexture getTexture(String string) {
        if (portalTextureMap.containsKey(string)) {
            return portalTextureMap.get(string);
        }
        if (string.startsWith("B:") || string.startsWith("F:")) {
            return new PortalTexture(string);
        }
        return portalTextureMap.get("C:5");
    }

    public static PortalTexture getTextureFromItemStack(ItemStack stack) {
        return Textures.getTextureFromItemStack(stack, "NOTSET");
    }

    public static PortalTexture getTextureFromItemStack(ItemStack stack, String oldTexture) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77977_a().startsWith("tile.")) {
            if (Settings.isBlockExcluded(stack.field_77993_c)) {
                return null;
            }
            if (Textures.getTexture("B:" + stack.field_77993_c + ":" + stack.func_77960_j()).getID().equals(oldTexture)) {
                if (Textures.getTexture("B:" + stack.field_77993_c + ":" + stack.func_77960_j() + "_") != null) {
                    return Textures.getTexture("B:" + stack.field_77993_c + ":" + stack.func_77960_j() + "_");
                }
                return null;
            }
            return Textures.getTexture("B:" + stack.field_77993_c + ":" + stack.func_77960_j());
        }
        if (Textures.getDyeColour(stack) >= 0) {
            return Textures.getTexture("C:" + Textures.getDyeColour(stack));
        }
        if (portalTextureMap.containsKey("I:" + stack.field_77993_c + ":" + stack.func_77960_j())) {
            if (Textures.getTexture("I:" + stack.field_77993_c + ":" + stack.func_77960_j()).getID().equals(oldTexture)) {
                if (Textures.getTexture("I:" + stack.field_77993_c + ":" + stack.func_77960_j() + "_") != null) {
                    return Textures.getTexture("I:" + stack.field_77993_c + ":" + stack.func_77960_j() + "_");
                }
                return null;
            }
            return Textures.getTexture("I:" + stack.field_77993_c + ":" + stack.func_77960_j());
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
            return Textures.getTexture("F:" + stack.field_77993_c + ":" + stack.func_77960_j());
        }
        return null;
    }

    public static enum Colour {
        BLACK,
        RED,
        GREEN,
        BROWN,
        BLUE,
        PURPLE,
        CYAN,
        LIGHT_GRAY,
        GRAY,
        PINK,
        LIME,
        YELLOW,
        LIGHT_BLUE,
        MAGENTA,
        ORANGE,
        WHITE;


        public PortalTexture getPortalTexture() {
            return Textures.getTexture("C:" + this.ordinal());
        }
    }
}

