/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import enhancedcore.util.MathHelper;
import enhancedportals.block.BlockAutomaticDialler;
import enhancedportals.block.BlockDialDevice;
import enhancedportals.block.BlockDialDeviceBasic;
import enhancedportals.block.BlockDummyPortal;
import enhancedportals.block.BlockNetherPortal;
import enhancedportals.block.BlockObsidian;
import enhancedportals.block.BlockObsidianStairs;
import enhancedportals.block.BlockPortalModifier;
import enhancedportals.item.ItemEnhancedFlintSteel;
import enhancedportals.item.ItemMiscellaneous;
import enhancedportals.item.ItemNetworkCard;
import enhancedportals.item.ItemPortalModifierUpgrade;
import enhancedportals.lib.BlockIds;
import enhancedportals.lib.ItemIds;
import enhancedportals.lib.Settings;
import enhancedportals.portal.network.DialDeviceNetwork;
import enhancedportals.portal.network.ModifierNetwork;
import enhancedportals.tileentity.TileEntityAutomaticDialler;
import enhancedportals.tileentity.TileEntityDialDevice;
import enhancedportals.tileentity.TileEntityDialDeviceBasic;
import enhancedportals.tileentity.TileEntityNetherPortal;
import enhancedportals.tileentity.TileEntityPortalModifier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CommonProxy {
    public BlockNetherPortal blockNetherPortal;
    public BlockObsidian blockObsidian;
    public BlockObsidianStairs blockObsidianStairs;
    public BlockPortalModifier blockPortalModifier;
    public BlockDummyPortal blockDummyPortal;
    public BlockDialDevice blockDialDevice;
    public BlockDialDeviceBasic blockDialDeviceBasic;
    public BlockAutomaticDialler blockAutomaticDialler;
    public ItemPortalModifierUpgrade itemPortalModifierUpgrade;
    public ItemNetworkCard itemNetworkCard;
    public ItemEnhancedFlintSteel itemEnhancedFlintSteel;
    public ItemMiscellaneous itemMisc;
    public ModifierNetwork ModifierNetwork;
    public DialDeviceNetwork DialDeviceNetwork;
    public boolean isIdentifierTaken = false;

    public World getWorld(int dimension) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
    }

    public void loadBlocks() {
        if (Settings.AllowPortalModifiers) {
            this.blockPortalModifier = new BlockPortalModifier();
            GameRegistry.registerBlock((Block)this.blockPortalModifier, (String)"portalModifier");
        }
        if (Settings.AllowDialHomeDevices) {
            this.blockDialDevice = new BlockDialDevice();
            GameRegistry.registerBlock((Block)this.blockDialDevice, (String)"dialDevice");
            this.blockDialDeviceBasic = new BlockDialDeviceBasic();
            GameRegistry.registerBlock((Block)this.blockDialDeviceBasic, (String)"dialDeviceBasic");
            this.blockAutomaticDialler = new BlockAutomaticDialler();
            GameRegistry.registerBlock((Block)this.blockAutomaticDialler, (String)"automaticDialler");
        }
        if (Settings.AllowObsidianStairs) {
            this.blockObsidianStairs = new BlockObsidianStairs();
            GameRegistry.registerBlock((Block)this.blockObsidianStairs, (String)"stairsObsidian");
        }
        this.blockNetherPortal = new BlockNetherPortal();
        GameRegistry.registerBlock((Block)this.blockNetherPortal, (String)"portal");
        this.blockDummyPortal = new BlockDummyPortal();
        GameRegistry.registerBlock((Block)this.blockDummyPortal, (String)"dummyPortal");
    }

    public void loadItems() {
        if (Settings.AllowPortalModifiers) {
            this.itemPortalModifierUpgrade = new ItemPortalModifierUpgrade();
            GameRegistry.registerItem((Item)this.itemPortalModifierUpgrade, (String)"portalModifierUpgrade");
            this.itemMisc = new ItemMiscellaneous();
            GameRegistry.registerItem((Item)this.itemMisc, (String)"miscItems");
            this.itemNetworkCard = new ItemNetworkCard();
            GameRegistry.registerItem((Item)this.itemNetworkCard, (String)"networkCard");
        }
        if (Settings.AllowFlintSteel) {
            this.itemEnhancedFlintSteel = new ItemEnhancedFlintSteel();
            GameRegistry.registerItem((Item)this.itemEnhancedFlintSteel, (String)"flintAndSteel");
        }
    }

    public void loadRecipes() {
        ItemStack enderPearl = new ItemStack(Item.field_77730_bn);
        if (Settings.AlternateCraftingRecipe) {
            enderPearl = new ItemStack(Block.field_72014_bd);
        }
        if (!Settings.DisableModifierRecipe && Settings.AllowPortalModifiers) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this.itemMisc, 1, 0), new Object[]{"NDN", " P ", "N N", Character.valueOf('N'), Item.field_77733_bq, Character.valueOf('D'), "dyePurple", Character.valueOf('P'), Item.field_77759_aK}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this.itemMisc, 1, 0), new Object[]{"N N", " P ", "NDN", Character.valueOf('N'), Item.field_77733_bq, Character.valueOf('D'), "dyePurple", Character.valueOf('P'), Item.field_77759_aK}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this.itemMisc, 1, 0), new Object[]{"N N", "DP ", "N N", Character.valueOf('N'), Item.field_77733_bq, Character.valueOf('D'), "dyePurple", Character.valueOf('P'), Item.field_77759_aK}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this.itemMisc, 1, 0), new Object[]{"N N", " PD", "N N", Character.valueOf('N'), Item.field_77733_bq, Character.valueOf('D'), "dyePurple", Character.valueOf('P'), Item.field_77759_aK}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this.itemNetworkCard), new Object[]{"IDI", " P ", "I I", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('D'), "dyeBlue", Character.valueOf('P'), Item.field_77759_aK}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this.itemNetworkCard), new Object[]{"I I", "DP ", "I I", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('D'), "dyeBlue", Character.valueOf('P'), Item.field_77759_aK}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this.itemNetworkCard), new Object[]{"I I", " PD", "I I", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('D'), "dyeBlue", Character.valueOf('P'), Item.field_77759_aK}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this.itemNetworkCard), new Object[]{"I I", " P ", "IDI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('D'), "dyeBlue", Character.valueOf('P'), Item.field_77759_aK}));
        }
        if (Settings.AllowFlintSteel) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemEnhancedFlintSteel), (Object[])new Object[]{Item.field_77709_i, Item.field_77751_aT, Item.field_77751_aT});
        }
        if (!Settings.DisableModifierRecipe && Settings.AllowPortalModifiers) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemPortalModifierUpgrade, 1, 0), (Object[])new Object[]{new ItemStack((Item)this.itemMisc, 1, 0), Item.field_77767_aC, Item.field_77722_bw});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemPortalModifierUpgrade, 1, 1), (Object[])new Object[]{new ItemStack((Item)this.itemMisc, 1, 0), Item.field_77767_aC, Block.field_71960_R});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)this.itemPortalModifierUpgrade, 1, 2), (Object[])new Object[]{"IEI", "GUG", "IRI", Character.valueOf('U'), new ItemStack((Item)this.itemMisc, 1, 0), Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), Item.field_77717_p, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('E'), enderPearl});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemPortalModifierUpgrade, 1, 2), (Object[])new Object[]{new ItemStack((Item)this.itemPortalModifierUpgrade, 1, 3)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemPortalModifierUpgrade, 1, 4), (Object[])new Object[]{new ItemStack((Item)this.itemMisc, 1, 0), Block.field_82510_ck, Item.field_77676_L});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemPortalModifierUpgrade, 1, 5), (Object[])new Object[]{new ItemStack((Item)this.itemMisc, 1, 0), Block.field_72014_bd, Block.field_72033_bA, Block.field_94339_ct});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemPortalModifierUpgrade, 1, 6), (Object[])new Object[]{new ItemStack((Item)this.itemMisc, 1, 0), Block.field_72083_ai, Block.field_72105_ah, Item.field_77702_n, Item.field_77702_n, Item.field_77817_bH, Item.field_77817_bH});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemPortalModifierUpgrade, 1, 7), (Object[])new Object[]{new ItemStack((Item)this.itemMisc, 1, 0), Item.field_77702_n, Item.field_77767_aC, enderPearl});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemPortalModifierUpgrade, 1, 8), (Object[])new Object[]{new ItemStack((Item)this.itemMisc, 1, 0), Item.field_77767_aC, Item.field_77767_aC, enderPearl});
        }
        if (Settings.AllowObsidianStairs) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockObsidianStairs, 4), (Object[])new Object[]{"O  ", "OO ", "OOO", Character.valueOf('O'), Block.field_72089_ap});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockObsidianStairs, 4), (Object[])new Object[]{"OOO", " OO", "  O", Character.valueOf('O'), Block.field_72089_ap});
        }
        if (!Settings.DisableModifierRecipe && Settings.AllowPortalModifiers) {
            ItemStack flintSteel = Settings.AllowFlintSteel ? new ItemStack((Item)this.itemEnhancedFlintSteel) : new ItemStack(Item.field_77709_i);
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockPortalModifier), (Object[])new Object[]{"OFO", "DIE", "ORO", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('F'), flintSteel, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('E'), enderPearl, Character.valueOf('R'), Item.field_77767_aC});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockPortalModifier), (Object[])new Object[]{"OFO", "EID", "ORO", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('F'), flintSteel, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('E'), enderPearl, Character.valueOf('R'), Item.field_77767_aC});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockPortalModifier), (Object[])new Object[]{"ORO", "DIE", "OFO", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('F'), flintSteel, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('E'), enderPearl, Character.valueOf('R'), Item.field_77767_aC});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockPortalModifier), (Object[])new Object[]{"ORO", "EID", "OFO", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('F'), flintSteel, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('E'), enderPearl, Character.valueOf('R'), Item.field_77767_aC});
        }
        if (!Settings.DisableDDRecipe && Settings.AllowDialHomeDevices) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockDialDeviceBasic), (Object[])new Object[]{"SES", "IDI", "SRS", Character.valueOf('S'), Block.field_71981_t, Character.valueOf('E'), enderPearl, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockDialDeviceBasic), (Object[])new Object[]{"SRS", "IDI", "SES", Character.valueOf('S'), Block.field_71981_t, Character.valueOf('E'), enderPearl, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockDialDevice), (Object[])new Object[]{"OMO", "DED", "ORO", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('E'), enderPearl, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('M'), Item.field_77817_bH, Character.valueOf('R'), Item.field_77767_aC});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockDialDevice), (Object[])new Object[]{"ORO", "DED", "OMO", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('E'), enderPearl, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('M'), Item.field_77817_bH, Character.valueOf('R'), Item.field_77767_aC});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockAutomaticDialler), (Object[])new Object[]{"SOS", "IRI", "SOS", Character.valueOf('S'), Block.field_71981_t, Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC});
        }
    }

    public void loadSettings(Configuration config) {
        Settings.config = config;
        BlockIds.ObsidianStairs = config.getBlock("ObsidianStairs", BlockIds.ObsidianStairs).getInt();
        BlockIds.NetherPortal = config.getBlock("NetherPortal", BlockIds.NetherPortal).getInt();
        BlockIds.PortalModifier = config.getBlock("PortalModifier", BlockIds.PortalModifier).getInt();
        BlockIds.DialDevice = config.getBlock("DialDevice", BlockIds.DialDevice).getInt();
        BlockIds.DialDeviceBasic = config.getBlock("BasicDialDevice", BlockIds.DialDeviceBasic).getInt();
        BlockIds.AutomaticDialler = config.getBlock("AutomaticDialler", BlockIds.AutomaticDialler).getInt();
        BlockIds.DummyPortal = config.getBlock("DummyPortal", BlockIds.DummyPortal).getInt();
        ItemIds.PortalModifierUpgrade = config.getItem("PortalModifierUpgrade", ItemIds.PortalModifierUpgrade).getInt();
        ItemIds.NetworkCard = config.getItem("NetworkCard", ItemIds.NetworkCard).getInt();
        ItemIds.MiscellaneousItems = config.getItem("MiscItems", ItemIds.MiscellaneousItems).getInt();
        ItemIds.EnhancedFlintAndSteel = config.getItem("UpgradedFlintAndSteel", ItemIds.EnhancedFlintAndSteel).getInt();
        Settings.AllowDialHomeDevices = config.get("Settings", "AllowDialDevices", Settings.AllowDialHomeDevices).getBoolean(Settings.AllowDialHomeDevices);
        Settings.AllowPortalColours = config.get("Settings", "AllowPortalColours", Settings.AllowPortalColours).getBoolean(Settings.AllowPortalColours);
        Settings.AllowPortalModifiers = config.get("Settings", "AllowPortalModifiers", Settings.AllowPortalModifiers).getBoolean(Settings.AllowPortalModifiers);
        Settings.AllowFlintSteel = config.get("Settings", "AllowUpgradedFlintAndSteel", Settings.AllowFlintSteel).getBoolean(Settings.AllowFlintSteel);
        Settings.AllowObsidianStairs = config.get("Settings", "AllowObsidianStairs", Settings.AllowObsidianStairs).getBoolean(Settings.AllowObsidianStairs);
        Settings.DisableDDRecipe = config.get("Settings", "DisableDialDeviceRecipe", Settings.DisableDDRecipe).getBoolean(Settings.DisableDDRecipe);
        Settings.DisableModifierRecipe = config.get("Settings", "DisableModifierRecipe", Settings.DisableModifierRecipe).getBoolean(Settings.DisableModifierRecipe);
        Settings.RenderPortalEffect = config.get("Effects", "RenderPortalEffect", Settings.RenderPortalEffect, "Renders the swirly effect when you're inside a portal").getBoolean(Settings.RenderPortalEffect);
        Settings.AdventureModeLimitation = config.get("Settings", "RestrictAdventurePlayers", Settings.AdventureModeLimitation, "Stops players in Adventure mode from using certain blocks").getBoolean(Settings.AdventureModeLimitation);
        Settings.AlternateCraftingRecipe = config.get("Settings", "AlternateCraftingRecipes", Settings.AlternateCraftingRecipe, "Replaces items you cannot get in Peaceful with ones you can").getBoolean(Settings.AlternateCraftingRecipe);
        Settings.RequireFancyGraphicsForParticles = config.get("Effects", "RequireFancyGraphicsForNewParticles", Settings.RequireFancyGraphicsForParticles).getBoolean(Settings.RequireFancyGraphicsForParticles);
        Settings.UseNewParticleEffects = config.get("Effects", "UseNewParticleEffects", Settings.UseNewParticleEffects).getBoolean(Settings.UseNewParticleEffects);
        Settings.SoundLevel = MathHelper.clampInt((int)config.get("Effects", "SoundLevel", 100, "Percentage chance of sounds to play (per block). 0 = disabled, 100 = vanilla").getInt(), (int)0, (int)100);
        Settings.ParticleLevel = MathHelper.clampInt((int)config.get("Effects", "ParticleLevel", 100, "Percentage chance of particles to spawn. 0 = disabled, 100 = vanilla").getInt(), (int)0, (int)100);
        Settings.PigmenLevel = MathHelper.clampInt((int)config.get("Settings", "PigmenLevel", 100, "Percentage chance of pigmen to spawn. 0 = disabled, 100 = vanilla").getInt(), (int)0, (int)100);
        Settings.MinimumPortalSize = config.get("Control", "MinimumPortalSize", Settings.MinimumPortalSize).getInt();
        Settings.MaximumPortalSize = config.get("Control", "MaximumPortalSize", Settings.MaximumPortalSize).getInt();
        Settings.ExcludedBlockList = Settings.addToList(Settings.ExcludedBlockList, config.get("Blocks", "ExcludedTextureBlocks", "", "These blocks are excluded from being used as portal textures. Seperate IDs by a single space").getString());
        Settings.BorderBlocks = Settings.addToList(Settings.BorderBlocks, config.get("Blocks", "BorderBlocks", "", "These blocks will be valid for portal frames. Seperate IDs by a single space").getString());
        Settings.ExcludedBlockList = Settings.addToList(Settings.ExcludedBlockList, config.get("Blocks", "DestroyBlocks", "18 30 31 32 37 38 39 40 78 106 131 132 141 142", "These blocks will get removed when creating a portal. Seperate IDs by a single space").getString());
        Settings.NetherFrameUpgrade = Settings.addToList(Settings.NetherFrameUpgrade, config.get("Blocks", "NetherFrameUpgrade", "", "Any block IDs listed here will replace the ones in the Nether Frame upgrade. Seperate IDs by a single space").getString());
        Settings.ResourceFrameUpgrade = Settings.addToList(Settings.ResourceFrameUpgrade, config.get("Blocks", "ResourceFrameUpgrade", "", "Any block IDs listed here will replace the ones in the Resourceful Frame upgrade. Seperate IDs by a single space").getString());
        config.save();
    }

    public void loadTileEntities() {
        GameRegistry.registerTileEntity(TileEntityNetherPortal.class, (String)"EPNPortal");
        GameRegistry.registerTileEntity(TileEntityPortalModifier.class, (String)"EPPModifier");
        GameRegistry.registerTileEntity(TileEntityDialDevice.class, (String)"EPDDevice");
        GameRegistry.registerTileEntity(TileEntityDialDeviceBasic.class, (String)"EPDDBasic");
        GameRegistry.registerTileEntity(TileEntityAutomaticDialler.class, (String)"EPADialler");
    }

    public void registerIcons(TextureStitchEvent.Pre event) {
    }
}

