/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network.packet;

import com.google.common.primitives.Bytes;
import enhancedportals.network.packet.PacketAutomaticDiallerUpdate;
import enhancedportals.network.packet.PacketBasicDialDeviceUpdate;
import enhancedportals.network.packet.PacketCreatePortal;
import enhancedportals.network.packet.PacketDialDeviceUpdate;
import enhancedportals.network.packet.PacketDialEntry;
import enhancedportals.network.packet.PacketDialRequest;
import enhancedportals.network.packet.PacketGui;
import enhancedportals.network.packet.PacketMisc;
import enhancedportals.network.packet.PacketNetherPortalUpdate;
import enhancedportals.network.packet.PacketPortalModifierUpdate;
import enhancedportals.network.packet.PacketPortalModifierUpgrade;
import enhancedportals.network.packet.PacketRedstoneControl;
import enhancedportals.network.packet.PacketRequestData;
import enhancedportals.network.packet.PacketThickness;
import enhancedportals.network.packet.PacketUpgrade;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import org.bouncycastle.util.Arrays;

public abstract class PacketEnhancedPortals {
    private Type type;

    public static Packet250CustomPayload makePacket(PacketEnhancedPortals packet) {
        byte[] packetData = packet.generatePacket(new Object[0]);
        return new Packet250CustomPayload("EP2", Bytes.concat((byte[][])new byte[][]{{packet.getID()}, packetData}));
    }

    public static PacketEnhancedPortals readPacket(INetworkManager network, byte[] payload) {
        try {
            byte type = payload[0];
            Type eType = Type.values()[type];
            byte[] data = Arrays.copyOfRange((byte[])payload, (int)1, (int)payload.length);
            return eType.make().consumePacket(new DataInputStream(new ByteArrayInputStream(data)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PacketEnhancedPortals() {
        for (Type t : Type.values()) {
            if (t.packetType != this.getClass()) continue;
            this.type = t;
            break;
        }
        if (this.type == null) {
            throw new RuntimeException("Can not create an unregistered packet!");
        }
    }

    public abstract PacketEnhancedPortals consumePacket(DataInputStream var1) throws IOException;

    public abstract void execute(INetworkManager var1, EntityPlayer var2);

    public abstract byte[] generatePacket(Object ... var1);

    public byte getID() {
        return (byte)this.type.ordinal();
    }

    static enum Type {
        AUTOMATIC_DIALLER_UPDATE(PacketAutomaticDiallerUpdate.class),
        BASIC_DIAL_DEVICE_UPDATE(PacketBasicDialDeviceUpdate.class),
        BASIC_DIAL_REQUEST(PacketDialRequest.class),
        DIAL_DEVICE_UPDATE(PacketDialDeviceUpdate.class),
        DIAL_ENTRY_ADD(PacketDialEntry.class),
        GUI(PacketGui.class),
        MISC(PacketMisc.class),
        NETHER_PORTAL_UPDATE(PacketNetherPortalUpdate.class),
        PORTAL_MODIFIER_UPDATE(PacketPortalModifierUpdate.class),
        PORTAL_MODIFIER_UPGRADE(PacketPortalModifierUpgrade.class),
        REQUEST_DATA(PacketRequestData.class),
        CREATE_PORTAL(PacketCreatePortal.class),
        UPGRADE(PacketUpgrade.class),
        THICKNESS(PacketThickness.class),
        REDSTONE(PacketRedstoneControl.class);

        private Class<? extends PacketEnhancedPortals> packetType;

        private Type(Class<? extends PacketEnhancedPortals> clas) {
            this.packetType = clas;
        }

        PacketEnhancedPortals make() {
            try {
                return this.packetType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

