/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network.packet;

import enhancedcore.packet.PacketHelper;
import enhancedcore.world.BlockPosition;
import enhancedcore.world.WorldHelper;
import enhancedportals.lib.BlockIds;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.tileentity.TileEntityPortalModifier;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;

public class PacketRedstoneControl
extends PacketEnhancedPortals {
    int dimension;
    BlockPosition position;
    byte redstone;

    public PacketRedstoneControl() {
    }

    public PacketRedstoneControl(TileEntityPortalModifier modifier) {
        this.position = modifier.getBlockPosition();
        this.dimension = modifier.field_70331_k.field_73011_w.field_76574_g;
        this.redstone = modifier.redstoneSetting;
    }

    @Override
    public PacketEnhancedPortals consumePacket(DataInputStream stream) throws IOException {
        this.position = BlockPosition.getBlockPosition((DataInputStream)stream);
        this.dimension = stream.readInt();
        this.redstone = stream.readByte();
        return this;
    }

    @Override
    public void execute(INetworkManager network, EntityPlayer player) {
        if (WorldHelper.getBlockId((int)this.dimension, (BlockPosition)this.position) == BlockIds.PortalModifier && WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position) instanceof TileEntityPortalModifier) {
            TileEntityPortalModifier modifier = (TileEntityPortalModifier)WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position);
            modifier.redstoneSetting = this.redstone;
        }
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        return PacketHelper.getByteArray((Object[])new Object[]{this.position, this.dimension, this.redstone});
    }
}

