/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network.packet;

import enhancedcore.packet.PacketHelper;
import enhancedcore.world.BlockPosition;
import enhancedcore.world.WorldHelper;
import enhancedportals.lib.BlockIds;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.network.packet.PacketPortalModifierUpgrade;
import enhancedportals.portal.upgrades.Upgrade;
import enhancedportals.tileentity.TileEntityPortalModifier;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;

public class PacketUpgrade
extends PacketEnhancedPortals {
    int dimension;
    BlockPosition position;
    byte type;
    byte upgrade;

    public PacketUpgrade() {
    }

    public PacketUpgrade(TileEntityPortalModifier modifier, byte t, byte u) {
        this.position = modifier.getBlockPosition();
        this.dimension = modifier.field_70331_k.field_73011_w.field_76574_g;
        this.type = t;
        this.upgrade = u;
    }

    @Override
    public PacketEnhancedPortals consumePacket(DataInputStream stream) throws IOException {
        this.position = BlockPosition.getBlockPosition((DataInputStream)stream);
        this.dimension = stream.readInt();
        this.type = stream.readByte();
        this.upgrade = stream.readByte();
        return this;
    }

    @Override
    public void execute(INetworkManager network, EntityPlayer player) {
        if (WorldHelper.getBlockId((int)this.dimension, (BlockPosition)this.position) == BlockIds.PortalModifier && WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position) instanceof TileEntityPortalModifier) {
            TileEntityPortalModifier modifier = (TileEntityPortalModifier)WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position);
            if (this.type == 0) {
                if (modifier.upgradeHandler.addUpgrade(this.upgrade, (TileEntity)modifier) && !WorldHelper.getWorld((int)this.dimension).field_72995_K) {
                    // empty if block
                }
            } else if (this.type == 1 && modifier.upgradeHandler.removeUpgrade(this.upgrade, (TileEntity)modifier) && !WorldHelper.getWorld((int)this.dimension).field_72995_K) {
                EntityItem entity = new EntityItem(WorldHelper.getWorld((int)this.dimension), (double)this.position.getX() + 0.5, (double)this.position.getY() + 0.5, (double)this.position.getZ() + 0.5, Upgrade.getUpgrade(this.upgrade).getItemStack());
                WorldHelper.getWorld((int)this.dimension).func_72838_d((Entity)entity);
                PacketHelper.sendPacketToAllAround((TileEntity)modifier, (Packet)PacketEnhancedPortals.makePacket(new PacketPortalModifierUpgrade(modifier)));
            }
        }
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        return PacketHelper.getByteArray((Object[])new Object[]{this.position, this.dimension, this.type, this.upgrade});
    }
}

