/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal;

import enhancedportals.lib.Textures;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PortalTexture {
    private String ID;
    private Icon portalTexture;
    private boolean forceBlockSheet;

    public static Icon getDefaultPortalTexture() {
        return Textures.getTexture("").getPortalTexture();
    }

    public PortalTexture(String id) {
        this.ID = id;
        this.portalTexture = null;
        this.forceBlockSheet = false;
    }

    public PortalTexture(String id, Icon portaltexture) {
        this.ID = id;
        this.portalTexture = portaltexture;
        this.forceBlockSheet = false;
    }

    public PortalTexture(String id, Icon portaltexture, boolean blockSheet) {
        this.ID = id;
        this.portalTexture = portaltexture;
        this.forceBlockSheet = blockSheet;
    }

    public boolean getBlockSheet() {
        return this.forceBlockSheet;
    }

    public String getID() {
        return this.ID;
    }

    public ItemStack getItemStack() {
        return Textures.getItemStackFromTexture(this);
    }

    public Icon getPortalTexture() {
        if (this.ID.startsWith("B:") && this.portalTexture == null) {
            int id = Integer.parseInt(this.ID.substring(2).split(":")[0]);
            int meta = Integer.parseInt(this.ID.substring(2).split(":")[1]);
            return this.getPortalTexture(id, meta);
        }
        if (this.ID.startsWith("F:") && this.portalTexture == null) {
            return this.getPortalTexture(this.ID.substring(2));
        }
        if (this.portalTexture != null) {
            return this.portalTexture;
        }
        return PortalTexture.getDefaultPortalTexture();
    }

    public Icon getPortalTexture(Object ... objects) {
        if (objects.length == 1 && objects[0] instanceof String) {
            String str = objects[0].toString();
            ItemStack stack = new ItemStack(Integer.parseInt(str.split(":")[0]), 1, Integer.parseInt(str.split(":")[1]));
            if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                Icon icon = fluid.getFluid().getStillIcon();
                if (icon != null) {
                    return icon;
                }
                return Block.field_71973_m[fluid.getFluid().getBlockID()].func_71858_a(0, 0);
            }
        } else if (objects.length == 2 && objects[0] instanceof Integer && objects[1] instanceof Integer) {
            int id = Integer.parseInt(objects[0].toString());
            int side = 2;
            int meta = Integer.parseInt(objects[1].toString());
            return Block.field_71973_m[id].func_71858_a(side, meta);
        }
        return PortalTexture.getDefaultPortalTexture();
    }
}

