/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal.teleportation;

import cpw.mods.fml.common.registry.GameRegistry;
import enhancedcore.world.WorldPosition;
import enhancedportals.EnhancedPortals;
import enhancedportals.lib.BlockIds;
import enhancedportals.lib.Reference;
import enhancedportals.lib.Settings;
import enhancedportals.portal.Portal;
import enhancedportals.tileentity.TileEntityPortalModifier;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet41EntityEffect;
import net.minecraft.network.packet.Packet43Experience;
import net.minecraft.network.packet.Packet9Respawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;

public class TeleportManager {
    public static boolean canEntityTravel(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.field_71088_bW == 0;
    }

    private static Entity handleMomentum(Entity entity, float newYaw, boolean keepMomentum) {
        if (!keepMomentum) {
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
        } else {
            float rotationYaw = (float)(Math.atan2(entity.field_70159_w, entity.field_70179_y) * 180.0 / Math.PI);
            double cos = Math.cos(Math.toRadians(-rotationYaw));
            double sin = Math.sin(Math.toRadians(-rotationYaw));
            double tempXmotion = cos * entity.field_70159_w - sin * entity.field_70179_y;
            double tempZmotion = sin * entity.field_70159_w + cos * entity.field_70179_y;
            entity.field_70159_w = tempXmotion;
            entity.field_70179_y = tempZmotion;
            cos = Math.cos(Math.toRadians(newYaw));
            sin = Math.sin(Math.toRadians(newYaw));
            tempXmotion = cos * entity.field_70159_w - sin * entity.field_70179_y;
            tempZmotion = sin * entity.field_70159_w + cos * entity.field_70179_y;
            entity.field_70159_w = tempXmotion;
            entity.field_70179_y = tempZmotion;
        }
        return entity;
    }

    private static EntityPlayerMP handlePlayerRespawn(Entity entity, EntityPlayerMP player, WorldServer world, boolean dimensionalTeleport) {
        player.func_71053_j();
        if (dimensionalTeleport) {
            player.field_71093_bK = world.field_73011_w.field_76574_g;
            player.field_71135_a.func_72567_b((Packet)new Packet9Respawn(player.field_71093_bK, (byte)player.field_70170_p.field_73013_u, world.func_72912_H().func_76067_t(), world.func_72800_K(), player.field_71134_c.func_73081_b()));
            ((WorldServer)entity.field_70170_p).func_73040_p().func_72695_c(player);
        }
        return player;
    }

    private static Entity recreateEntity(Entity entity, World world) {
        if (!(entity instanceof EntityPlayer)) {
            NBTTagCompound nbt = new NBTTagCompound();
            entity.field_70128_L = false;
            entity.field_70153_n = null;
            entity.func_70039_c(nbt);
            entity.field_70128_L = true;
            entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)world);
            if (entity == null) {
                return null;
            }
        }
        world.func_72838_d(entity);
        entity.func_70029_a(world);
        return entity;
    }

    private static void removeEntityFromWorld(World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71053_j();
            world.field_73010_i.remove(player);
            world.func_72854_c();
            int chunkX = entity.field_70176_ah;
            int chunkZ = entity.field_70164_aj;
            if (entity.field_70175_ag && world.func_72863_F().func_73149_a(chunkX, chunkZ)) {
                world.func_72964_e(chunkX, chunkZ).func_76622_b(entity);
                world.func_72964_e((int)chunkX, (int)chunkZ).field_76643_l = true;
            }
            world.field_72996_f.remove(entity);
        }
        entity.field_70128_L = false;
    }

    public static void setCanEntityTravel(Entity entity, boolean state) {
        entity.field_71088_bW = state ? 0 : (entity instanceof EntityMinecart || entity instanceof EntityBoat ? 10 : entity.func_82147_ab());
    }

    private static void syncPlayer(EntityPlayerMP player, WorldServer world) {
        player.field_71134_c.func_73080_a(world);
        player.field_71133_b.func_71203_ab().func_72354_b(player, world);
        player.field_71133_b.func_71203_ab().func_72385_f(player);
        for (PotionEffect effect : player.func_70651_bq()) {
            player.field_71135_a.func_72567_b((Packet)new Packet41EntityEffect(player.field_70157_k, effect));
        }
        player.field_71135_a.func_72567_b((Packet)new Packet43Experience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        GameRegistry.onPlayerChangedDimension((EntityPlayer)player);
    }

    public static boolean teleportEntity(Entity entity, WorldPosition teleportData, TileEntityPortalModifier originModifier, boolean keepVelocity, boolean supressMessages) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        World world = EnhancedPortals.proxy.getWorld(teleportData.getDimension());
        ((WorldServer)world).field_73059_b.func_73158_c(teleportData.getX() >> 4, teleportData.getZ() >> 4);
        TileEntityPortalModifier outModifier = (TileEntityPortalModifier)teleportData.getTileEntity();
        if (outModifier == null) {
            EnhancedPortals.proxy.ModifierNetwork.removeFromAllNetworks(teleportData);
            return false;
        }
        int outModifierMeta = world.func_72805_g(outModifier.field_70329_l, outModifier.field_70330_m, outModifier.field_70327_n);
        WorldPosition outModifierOffset = teleportData.getOffset(ForgeDirection.getOrientation((int)outModifierMeta));
        boolean teleportEntity = false;
        if (outModifierOffset.isAirBlock()) {
            if (new Portal(outModifier).createPortal(outModifier.customBorderBlocks())) {
                teleportEntity = true;
            } else if (!supressMessages && entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_71035_c("A portal could not be created at the exit location.");
            } else {
                Reference.log.log(Level.INFO, String.format("A portal could not be created at %s, %s, %s.", outModifierOffset.getX(), outModifierOffset.getY(), outModifierOffset.getZ()));
            }
        } else if (outModifierOffset.getBlockId() == BlockIds.NetherPortal) {
            teleportEntity = true;
        }
        if (teleportEntity) {
            if (entity instanceof EntityArrow) {
                outModifierOffset = outModifierOffset.getOffset(ForgeDirection.getOrientation((int)outModifierMeta));
            }
            if (outModifierMeta == 0) {
                outModifierOffset = outModifierOffset.below();
            }
            TeleportManager.teleportEntity((WorldServer)world, entity, teleportData, outModifierOffset, keepVelocity, outModifierMeta);
        }
        return teleportEntity;
    }

    private static Entity teleportEntity(WorldServer world, Entity entity, WorldPosition teleportData, WorldPosition teleportDataOffset, boolean keepVelocity, int metaDirection) {
        EntityPlayerMP player;
        if (!Settings.AllowTeleporting || !TeleportManager.canEntityTravel(entity)) {
            return entity;
        }
        boolean dimensionalTeleport = entity.field_70170_p.field_73011_w.field_76574_g != world.field_73011_w.field_76574_g;
        float rotationYaw = 0.0f;
        Entity mountedEntity = null;
        if (entity.field_70154_o != null) {
            mountedEntity = TeleportManager.teleportEntity(world, entity.field_70154_o, teleportData, teleportDataOffset, keepVelocity, metaDirection);
            entity.func_70078_a(null);
        }
        rotationYaw = teleportDataOffset.getMetadata() == 4 || teleportDataOffset.getMetadata() == 5 ? (!teleportDataOffset.getOffset(ForgeDirection.EAST).isAirBlock() ? 90.0f : -90.0f) : (teleportDataOffset.getMetadata() == 2 || teleportDataOffset.getMetadata() == 3 ? (teleportDataOffset.getOffset(ForgeDirection.NORTH).isAirBlock() ? 180.0f : 0.0f) : entity.field_70177_z);
        entity.field_70170_p.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            TeleportManager.handlePlayerRespawn(entity, player, world, dimensionalTeleport);
        }
        if (dimensionalTeleport) {
            TeleportManager.removeEntityFromWorld(entity.field_70170_p, entity);
        }
        TeleportManager.handleMomentum(entity, rotationYaw, keepVelocity);
        entity.func_70012_b((double)teleportDataOffset.getX() + 0.5, (double)teleportDataOffset.getY(), (double)teleportDataOffset.getZ() + 0.5, rotationYaw, entity.field_70125_A);
        world.field_73059_b.func_73158_c(teleportData.getX() >> 4, teleportData.getZ() >> 4);
        if (dimensionalTeleport && (entity = TeleportManager.recreateEntity(entity, (World)world)) == null) {
            return null;
        }
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            if (dimensionalTeleport) {
                player.field_71133_b.func_71203_ab().func_72375_a(player, world);
            }
            player.field_71135_a.func_72569_a((double)teleportDataOffset.getX() + 0.5, (double)teleportDataOffset.getY(), (double)teleportDataOffset.getZ() + 0.5, rotationYaw, entity.field_70125_A);
        }
        world.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP && dimensionalTeleport) {
            player = (EntityPlayerMP)entity;
            TeleportManager.syncPlayer(player, world);
        }
        entity.func_70012_b((double)teleportDataOffset.getX() + 0.5, (double)teleportDataOffset.getY(), (double)teleportDataOffset.getZ() + 0.5, rotationYaw, entity.field_70125_A);
        if (mountedEntity != null) {
            entity.func_70078_a(mountedEntity);
        }
        TeleportManager.setCanEntityTravel(entity, false);
        return entity;
    }
}

