/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal.upgrades;

import enhancedportals.lib.Reference;
import enhancedportals.portal.upgrades.modifier.UpgradeAdvancedDimensional;
import enhancedportals.portal.upgrades.modifier.UpgradeCamouflage;
import enhancedportals.portal.upgrades.modifier.UpgradeDialDevice;
import enhancedportals.portal.upgrades.modifier.UpgradeDimensional;
import enhancedportals.portal.upgrades.modifier.UpgradeMomentum;
import enhancedportals.portal.upgrades.modifier.UpgradeNetherFrame;
import enhancedportals.portal.upgrades.modifier.UpgradeParticles;
import enhancedportals.portal.upgrades.modifier.UpgradeResourceFrame;
import enhancedportals.portal.upgrades.modifier.UpgradeSounds;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public abstract class Upgrade {
    private Type type;

    public static Upgrade[] getAllUpgrades() {
        Upgrade[] upgrades = new Upgrade[Type.values().length];
        for (int i = 0; i < upgrades.length; ++i) {
            upgrades[i] = Upgrade.getUpgrade(i);
        }
        return upgrades;
    }

    public static Upgrade getUpgrade(int ID) {
        if (ID >= 0 && ID < Type.values().length) {
            return Type.values()[ID].make();
        }
        return null;
    }

    public static String[] getUpgradeNames() {
        String[] str = new String[Type.values().length];
        for (int i = 0; i < str.length; ++i) {
            str[i] = Upgrade.getUpgrade(i).getName();
        }
        return str;
    }

    public Upgrade() {
        for (Type t : Type.values()) {
            if (t.upgradeType != this.getClass()) continue;
            this.type = t;
            break;
        }
        if (this.type == null) {
            throw new RuntimeException("Can not create an upgrade of an unregistered type.");
        }
    }

    public ItemStack getDisplayItemStack() {
        return null;
    }

    public ItemStack getItemStack() {
        return null;
    }

    public String getName() {
        return null;
    }

    public Upgrade getNewInstance() {
        return this.type.make();
    }

    public List<String> getText(boolean includeTitle) {
        return null;
    }

    public byte getUpgradeID() {
        return (byte)this.type.ordinal();
    }

    public boolean onActivated(TileEntity tileEntity) {
        return false;
    }

    public boolean onDeactivated(TileEntity tileEntity) {
        return false;
    }

    static enum Type {
        PARTICLES(UpgradeParticles.class),
        SOUNDS(UpgradeSounds.class),
        DIMENSIONAL(UpgradeDimensional.class),
        ADVANCED_DIMENSIONAL(UpgradeAdvancedDimensional.class),
        MOMENTUM(UpgradeMomentum.class),
        NETHER_FRAME(UpgradeNetherFrame.class),
        RESOURCE_FRAME(UpgradeResourceFrame.class),
        CAMOUFLAGE(UpgradeCamouflage.class),
        DIAL_DEVICE(UpgradeDialDevice.class);

        private Class<? extends Upgrade> upgradeType;

        private Type(Class<? extends Upgrade> type) {
            this.upgradeType = type;
        }

        Upgrade make() {
            try {
                return this.upgradeType.newInstance();
            }
            catch (Exception e) {
                Reference.log.log(Level.SEVERE, "Something went wrong when constructing the upgrade. Cannot continue.");
                throw new RuntimeException(e);
            }
        }
    }
}

