/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal.upgrades;

import enhancedportals.portal.upgrades.Upgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class UpgradeHandler {
    private List<Upgrade> upgradeList = new ArrayList<Upgrade>();
    private int maximumUpgrades;

    public UpgradeHandler() {
        this.maximumUpgrades = 5;
    }

    public UpgradeHandler(int maxUpgrades) {
        this.maximumUpgrades = maxUpgrades;
    }

    public boolean addUpgrade(byte ID, TileEntity tileEntity) {
        return this.addUpgrade(Upgrade.getUpgrade(ID), tileEntity);
    }

    public boolean addUpgrade(Upgrade upgrade, TileEntity tileEntity) {
        if (!this.hasUpgrade(upgrade) && !this.isUpgradeLimitReached()) {
            if (tileEntity != null) {
                if (upgrade.onActivated(tileEntity)) {
                    this.upgradeList.add(upgrade);
                }
            } else {
                this.upgradeList.add(upgrade);
            }
            return true;
        }
        return false;
    }

    public boolean addUpgradeNoActivate(byte ID, TileEntity tileEntity) {
        Upgrade upgrade = Upgrade.getUpgrade(ID);
        if (!this.hasUpgrade(upgrade) && !this.isUpgradeLimitReached()) {
            this.upgradeList.add(upgrade);
            return true;
        }
        return false;
    }

    public void addUpgradesFromByteArray(byte[] upgrades, TileEntity tileEntity) {
        if (upgrades != null) {
            for (byte b : upgrades) {
                this.addUpgrade(b, tileEntity);
            }
        }
    }

    public byte[] getInstalledUpgrades() {
        byte[] installedUpgrades = new byte[this.upgradeList.size()];
        for (int i = 0; i < installedUpgrades.length; ++i) {
            installedUpgrades[i] = this.upgradeList.get(i).getUpgradeID();
        }
        return installedUpgrades;
    }

    public int getMaximumUpgrades() {
        return this.maximumUpgrades;
    }

    public Upgrade getUpgrade(int i) {
        return this.upgradeList.get(i);
    }

    public List<Upgrade> getUpgrades() {
        return this.upgradeList;
    }

    public boolean hasUpgrade(byte ID) {
        return this.hasUpgrade(Upgrade.getUpgrade(ID));
    }

    public boolean hasUpgrade(Upgrade upgrade) {
        for (Upgrade u : this.upgradeList) {
            if (u.getUpgradeID() != upgrade.getUpgradeID()) continue;
            return true;
        }
        return false;
    }

    public boolean isUpgradeLimitReached() {
        return this.maximumUpgrades == this.upgradeList.size();
    }

    public boolean removeUpgrade(byte ID, TileEntity tileEntity) {
        return this.removeUpgrade(Upgrade.getUpgrade(ID), tileEntity);
    }

    public boolean removeUpgrade(Upgrade upgrade, TileEntity tileEntity) {
        block4: {
            block3: {
                if (!this.hasUpgrade(upgrade)) {
                    return false;
                }
                if (tileEntity == null) break block3;
                if (!upgrade.onDeactivated(tileEntity)) break block4;
                for (int i = 0; i < this.upgradeList.size(); ++i) {
                    if (this.upgradeList.get(i).getUpgradeID() != upgrade.getUpgradeID()) continue;
                    this.upgradeList.remove(i);
                }
                break block4;
            }
            for (int i = 0; i < this.upgradeList.size(); ++i) {
                if (this.upgradeList.get(i).getUpgradeID() != upgrade.getUpgradeID()) continue;
                this.upgradeList.remove(i);
            }
        }
        return !this.hasUpgrade(upgrade);
    }
}

