/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tileentity;

import cpw.mods.fml.common.network.PacketDispatcher;
import enhancedcore.world.BlockPosition;
import enhancedcore.world.WorldHelper;
import enhancedcore.world.WorldPosition;
import enhancedportals.EnhancedPortals;
import enhancedportals.lib.Reference;
import enhancedportals.lib.Strings;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.network.packet.PacketRequestData;
import enhancedportals.tileentity.TileEntityEnhancedPortals;
import enhancedportals.tileentity.TileEntityPortalModifier;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public class TileEntityDialDeviceBase
extends TileEntityEnhancedPortals {
    public boolean active = false;
    protected BlockPosition modifierLocation;
    protected String dialledNetwork;
    protected ForgeChunkManager.Ticket chunkTicket;
    protected final int TICK_DELAY = 50;
    protected int timer;
    protected int ticksToGo;

    protected BlockPosition findPortalModifier() {
        if (this.modifierLocation != null) {
            if (WorldHelper.getTileEntity((World)this.field_70331_k, (BlockPosition)this.modifierLocation) instanceof TileEntityPortalModifier) {
                return this.modifierLocation;
            }
            this.modifierLocation = null;
        }
        for (int i = -5; i < 6; ++i) {
            for (int j = -5; j < 6; ++j) {
                for (int k = -5; k < 6; ++k) {
                    TileEntityPortalModifier modifier;
                    if (!this.field_70331_k.func_72927_d(this.field_70329_l + i, this.field_70330_m + k, this.field_70327_n + j) || !(this.field_70331_k.func_72796_p(this.field_70329_l + i, this.field_70330_m + k, this.field_70327_n + j) instanceof TileEntityPortalModifier) || (modifier = (TileEntityPortalModifier)this.field_70331_k.func_72796_p(this.field_70329_l + i, this.field_70330_m + k, this.field_70327_n + j)) == null || !modifier.isRemotelyControlled() || modifier.isAnyActive()) continue;
                    this.modifierLocation = new WorldPosition(this.field_70329_l + i, this.field_70330_m + k, this.field_70327_n + j, this.field_70331_k);
                }
            }
        }
        return this.modifierLocation;
    }

    protected int getBlockID() {
        return 0;
    }

    public void func_70313_j() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        super.func_70313_j();
    }

    protected void loadChunk() {
        if (this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)EnhancedPortals.instance, (World)this.field_70331_k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (this.chunkTicket == null) {
            Reference.log.log(Level.WARNING, String.format("The Dialling Device at %s, %s, %s may not automatically close the portals due to no chunkloaders available.", new Object[0]));
            return;
        }
        this.chunkTicket.getModData().func_74768_a("dialX", this.field_70329_l);
        this.chunkTicket.getModData().func_74768_a("dialY", this.field_70330_m);
        this.chunkTicket.getModData().func_74768_a("dialZ", this.field_70327_n);
        this.chunkTicket.getModData().func_74768_a("modifierX", this.modifierLocation.getX());
        this.chunkTicket.getModData().func_74768_a("modifierY", this.modifierLocation.getY());
        this.chunkTicket.getModData().func_74768_a("modifierZ", this.modifierLocation.getZ());
        this.loadChunk(this.chunkTicket);
    }

    public void loadChunk(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        if (this.chunkTicket.getModData().func_74764_b("modifierX")) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.chunkTicket.getModData().func_74762_e("modifierX") >> 4, this.chunkTicket.getModData().func_74762_e("modifierZ") >> 4));
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70329_l >> 4, this.field_70327_n >> 4));
    }

    protected void processDiallingRequest(String network, EntityPlayer player, String texture, int thickness, int tickTimer) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.active) {
            this.ticksToGo = 0;
            this.scheduledBlockUpdate();
            return;
        }
        this.modifierLocation = this.findPortalModifier();
        if (this.modifierLocation == null) {
            this.sendChatToPlayer(Strings.ChatNoModifiers.toString(), player);
            return;
        }
        TileEntityPortalModifier entryModifier = (TileEntityPortalModifier)WorldHelper.getTileEntity((World)this.field_70331_k, (BlockPosition)this.modifierLocation);
        TileEntityPortalModifier exitModifier = null;
        if (entryModifier.dialDeviceNetwork.equals(network)) {
            this.sendChatToPlayer(Strings.ChatInvalidDestination.toString(), player);
            return;
        }
        if (EnhancedPortals.proxy.DialDeviceNetwork.hasNetwork(network)) {
            if (EnhancedPortals.proxy.DialDeviceNetwork.getNetwork(network).isEmpty()) {
                EnhancedPortals.proxy.DialDeviceNetwork.removeNetwork(network);
                this.sendChatToPlayer(Strings.ChatNoConnection.toString(), player);
                return;
            }
            WorldPosition exitLocation = EnhancedPortals.proxy.DialDeviceNetwork.getNetwork(network).get(0);
            ((WorldServer)WorldHelper.getWorld((int)exitLocation.getDimension())).func_72863_F().func_73158_c(exitLocation.getX() >> 4, exitLocation.getZ() >> 4);
            exitModifier = (TileEntityPortalModifier)exitLocation.getTileEntity();
            if (exitModifier == null) {
                Reference.log.log(Level.WARNING, "This is unexpected. Tried to dial a network but could not find an exit location!");
                return;
            }
            if (exitModifier.isActive()) {
                this.sendChatToPlayer(Strings.ChatDialActivePortal.toString(), player);
                return;
            }
            boolean createdEntryPortal = false;
            boolean createdExitPortal = false;
            if (texture == null && thickness == -1) {
                createdEntryPortal = entryModifier.createPortalFromDialDevice();
                createdExitPortal = exitModifier.createPortalFromDialDevice();
            } else {
                createdEntryPortal = entryModifier.createPortalFromDialDevice(texture, (byte)thickness);
                createdExitPortal = exitModifier.createPortalFromDialDevice(texture, (byte)thickness);
            }
            if (!createdEntryPortal || !createdExitPortal) {
                entryModifier.removePortal();
                exitModifier.removePortal();
                this.sendChatToPlayer(Strings.ChatNoConnection.toString(), player);
            } else {
                this.dialledNetwork = network;
                entryModifier.tempDialDeviceNetwork = network;
                exitModifier.tempDialDeviceNetwork = entryModifier.dialDeviceNetwork;
                this.active = true;
                this.ticksToGo = tickTimer == -1 ? 760 : tickTimer;
                this.loadChunk();
                this.sendUpdatePacket();
                this.sendChatToPlayer(Strings.ChatDialSuccess.toString(), player);
                if (this.ticksToGo / 20 > 0) {
                    this.field_70331_k.func_72836_a(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID(), 50);
                    this.sendChatToPlayer(String.format(Strings.ChatDialSuccess2.toString(), this.ticksToGo / 20), player);
                }
            }
        } else {
            this.sendChatToPlayer(Strings.ChatNoConnection.toString(), player);
        }
    }

    public void scheduledBlockUpdate() {
        if (!this.active || this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.modifierLocation == null || !(WorldHelper.getTileEntity((World)this.field_70331_k, (BlockPosition)this.modifierLocation) instanceof TileEntityPortalModifier)) {
            this.unloadChunk();
            this.sendUpdatePacket();
            List<WorldPosition> positionList = EnhancedPortals.proxy.DialDeviceNetwork.getNetwork(this.dialledNetwork);
            WorldPosition exitLocation = null;
            if (!positionList.isEmpty()) {
                exitLocation = positionList.get(0);
            }
            if (exitLocation != null) {
                ((WorldServer)WorldHelper.getWorld((int)exitLocation.getDimension())).func_72863_F().func_73158_c(exitLocation.getX() >> 4, exitLocation.getZ() >> 4);
                TileEntityPortalModifier exitModifier = (TileEntityPortalModifier)exitLocation.getTileEntity();
                if (exitModifier != null) {
                    exitModifier.removePortal();
                    exitModifier.tempDialDeviceNetwork = "";
                }
            }
            this.active = false;
            return;
        }
        TileEntityPortalModifier modifier = (TileEntityPortalModifier)WorldHelper.getTileEntity((World)this.field_70331_k, (BlockPosition)this.modifierLocation);
        List<WorldPosition> positionList = EnhancedPortals.proxy.DialDeviceNetwork.getNetwork(this.dialledNetwork);
        WorldPosition exitLocation = null;
        if (!positionList.isEmpty()) {
            exitLocation = positionList.get(0);
        }
        if (exitLocation == null) {
            this.active = false;
            return;
        }
        ((WorldServer)WorldHelper.getWorld((int)exitLocation.getDimension())).func_72863_F().func_73158_c(exitLocation.getX() >> 4, exitLocation.getZ() >> 4);
        TileEntityPortalModifier exitModifier = (TileEntityPortalModifier)exitLocation.getTileEntity();
        if (exitModifier == null) {
            this.ticksToGo = 0;
        }
        if (this.ticksToGo > 0) {
            int time = 50;
            this.ticksToGo -= 50;
            if (!modifier.isAnyActive() || !exitModifier.isAnyActive()) {
                this.ticksToGo = 0;
                time = 0;
            }
            this.field_70331_k.func_72836_a(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID(), time);
        } else if (this.ticksToGo <= 0) {
            modifier.removePortal();
            modifier.tempDialDeviceNetwork = "";
            if (exitModifier != null) {
                exitModifier.removePortal();
                exitModifier.tempDialDeviceNetwork = "";
            }
            this.active = false;
            this.unloadChunk();
            this.sendUpdatePacket();
        }
    }

    protected void sendChatToPlayer(String str, EntityPlayer player) {
        if (player != null) {
            player.func_71035_c(str);
        } else {
            Reference.log.log(Level.INFO, str);
        }
    }

    protected void sendUpdatePacket() {
    }

    protected void unloadChunk() {
        if (this.chunkTicket == null) {
            return;
        }
        if (this.chunkTicket.getModData().func_74764_b("modifierX")) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.chunkTicket.getModData().func_74762_e("modifierX") >> 4, this.chunkTicket.getModData().func_74762_e("modifierZ") >> 4));
        }
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70329_l >> 4, this.field_70327_n >> 4));
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k.field_72995_K) {
            PacketDispatcher.sendPacketToServer((Packet)PacketEnhancedPortals.makePacket(new PacketRequestData(this)));
        }
    }
}

